/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.diff.DiffSupport;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.diff.impl.splitter.Transformation;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TableDiffDividerDrawUtil {
    public static void paintPolygons(@NotNull Graphics2D gg, int width, @NotNull DiffSupport editor1, @NotNull DiffSupport editor2, @NotNull DividerPaintable paintable) {
        if (gg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintPolygons"));
        }
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintPolygons"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintPolygons"));
        }
        if (paintable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintable", "com/intellij/database/diff/TableDiffDividerDrawUtil", "paintPolygons"));
        }
        List<DividerPolygon> polygons = TableDiffDividerDrawUtil.createVisiblePolygons(editor1, editor2, paintable);
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)gg);
        for (DividerPolygon polygon : polygons) {
            polygon.paint(gg, width);
        }
        config.restore();
    }

    @NotNull
    public static List<DividerPolygon> createVisiblePolygons(@NotNull DiffSupport editor1, @NotNull DiffSupport editor2, @NotNull DividerPaintable paintable) {
        if (editor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/database/diff/TableDiffDividerDrawUtil", "createVisiblePolygons"));
        }
        if (editor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/database/diff/TableDiffDividerDrawUtil", "createVisiblePolygons"));
        }
        if (paintable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintable", "com/intellij/database/diff/TableDiffDividerDrawUtil", "createVisiblePolygons"));
        }
        final ArrayList<DividerPolygon> polygons = new ArrayList<DividerPolygon>();
        final Transformation[] transformations = new Transformation[]{TableDiffDividerDrawUtil.getTransformation(editor1), TableDiffDividerDrawUtil.getTransformation(editor2)};
        final LineRange leftInterval = TableDiffDividerDrawUtil.getVisibleInterval(editor1);
        final LineRange rightInterval = TableDiffDividerDrawUtil.getVisibleInterval(editor2);
        paintable.process(new DividerPaintable.Handler(){

            @Override
            public boolean process(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Color color) {
                if (color == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/database/diff/TableDiffDividerDrawUtil$1", "process"));
                }
                if (leftInterval.start > endLine1 && rightInterval.start > endLine2) {
                    return true;
                }
                if (leftInterval.end < startLine1 && rightInterval.end < startLine2) {
                    return false;
                }
                polygons.add(TableDiffDividerDrawUtil.createPolygon(transformations, startLine1, endLine1, startLine2, endLine2, color));
                return true;
            }
        });
        ArrayList<DividerPolygon> arrayList = polygons;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffDividerDrawUtil", "createVisiblePolygons"));
        }
        return arrayList;
    }

    @NotNull
    private static Transformation getTransformation(final @NotNull DiffSupport editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/diff/TableDiffDividerDrawUtil", "getTransformation"));
        }
        Transformation transformation = new Transformation(){

            public int transform(int line) {
                int yOffset = editor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)line, (int)0)).y;
                int headerOffset = editor.getHeaderOffset();
                return yOffset - editor.getScrollingModel().getVerticalScrollOffset() + headerOffset;
            }
        };
        if (transformation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffDividerDrawUtil", "getTransformation"));
        }
        return transformation;
    }

    @NotNull
    private static DividerPolygon createPolygon(@NotNull Transformation[] transformations, int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Color color) {
        if (transformations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformations", "com/intellij/database/diff/TableDiffDividerDrawUtil", "createPolygon"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/database/diff/TableDiffDividerDrawUtil", "createPolygon"));
        }
        int start1 = transformations[0].transform(startLine1);
        int end1 = transformations[0].transform(endLine1);
        int start2 = transformations[1].transform(startLine2);
        int end2 = transformations[1].transform(endLine2);
        DividerPolygon dividerPolygon = new DividerPolygon(start1, start2, end1, end2, color);
        if (dividerPolygon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffDividerDrawUtil", "createPolygon"));
        }
        return dividerPolygon;
    }

    @NotNull
    private static LineRange getVisibleInterval(DiffSupport editor) {
        Rectangle area = editor.getScrollingModel().getVisibleArea();
        LogicalPosition position1 = editor.xyToLogicalPosition(new Point(0, area.y));
        LogicalPosition position2 = editor.xyToLogicalPosition(new Point(0, area.y + area.height));
        LineRange lineRange = new LineRange(position1.line, position2.line);
        if (lineRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffDividerDrawUtil", "getVisibleInterval"));
        }
        return lineRange;
    }

    private static class DividerPolygon {
        private final int myStart1;
        private final int myStart2;
        private final int myEnd1;
        private final int myEnd2;
        @NotNull
        private final Color myColor;

        public DividerPolygon(int start1, int start2, int end1, int end2, @NotNull Color color) {
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/database/diff/TableDiffDividerDrawUtil$DividerPolygon", "<init>"));
            }
            this.myStart1 = start1;
            this.myStart2 = start2;
            this.myEnd1 = end1;
            this.myEnd2 = end2;
            this.myColor = color;
        }

        public void paint(Graphics2D g, int width) {
            int startY1 = this.myStart1;
            int endY1 = this.myEnd1;
            int startY2 = this.myStart2;
            int endY2 = this.myEnd2;
            if (endY1 - startY1 < 2) {
                endY1 = startY1 + 1;
            }
            if (endY2 - startY2 < 2) {
                endY2 = startY2 + 1;
            }
            DiffDrawUtil.drawCurveTrapezium((Graphics2D)g, (int)0, (int)width, (int)startY1, (int)endY1, (int)startY2, (int)endY2, (Color)this.myColor, null);
        }

        public String toString() {
            return "<" + this.myStart1 + ", " + this.myEnd1 + " : " + this.myStart2 + ", " + this.myEnd2 + "> " + this.myColor;
        }
    }

    public static interface DividerPaintable {
        public void process(@NotNull Handler var1);

        public static abstract class Handler {
            public abstract boolean process(int var1, int var2, int var3, int var4, @NotNull Color var5);
        }
    }
}

