/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DefaultValuesExtractor;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.FormatBasedExtractor;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.util.CharOut;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumpRequest
extends DataRequest.IsolatedQueryRequest {
    @NotNull
    private final DataExtractor myExtractor;
    @NotNull
    private final DatabaseDialectEx myDialect;
    @NotNull
    private final CharOut myOutput;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    @Nullable
    private final ModelIndexSet<DataConsumer.Column> mySelectedColumns;
    @Nullable
    private final String myName;
    protected DataConsumer.Column[] myColumns;
    private int myFirstRowNum;
    private DataExtractor.Extraction myExtraction;

    protected DumpRequest(@NotNull DataRequest.Owner owner, @NotNull DataRequest.TxMarker txMarker, @NotNull String query, @NotNull DataRequest.Constraints constraints, @Nullable ModelIndexSet<DataConsumer.Column> columns, @NotNull DataExtractor extractor, @NotNull DatabaseDialectEx dialect, @NotNull CharOut output, @Nullable String name) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/dump/DumpRequest", "<init>"));
        }
        if (txMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "txMarker", "com/intellij/database/dump/DumpRequest", "<init>"));
        }
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/dump/DumpRequest", "<init>"));
        }
        if (constraints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraints", "com/intellij/database/dump/DumpRequest", "<init>"));
        }
        if (extractor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractor", "com/intellij/database/dump/DumpRequest", "<init>"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dump/DumpRequest", "<init>"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/database/dump/DumpRequest", "<init>"));
        }
        super(owner, txMarker, query, constraints, null);
        this.mySelectedColumns = columns;
        this.myExtractor = extractor;
        this.myDialect = dialect;
        this.myOutput = output;
        this.myName = name;
        this.myProgressIndicator = (ProgressIndicator)ObjectUtils.chooseNotNull((Object)ProgressManager.getInstance().getProgressIndicator(), (Object)new EmptyProgressIndicator());
    }

    @Override
    public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column[] columns, int firstRowNum) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dump/DumpRequest", "setColumns"));
        }
        AbstractQueryLanguageConsole.LOG.assertTrue(resultSetIndex == this.constraints.resultSetNumber);
        this.myColumns = columns;
        this.myFirstRowNum = firstRowNum;
        this.myExtraction = this.myExtractor.startExtraction(this.myOutput, this.myDialect, false, ContainerUtil.list((Object[])columns), this.mySelectedColumns != null ? this.mySelectedColumns.asArray() : ArrayUtil.EMPTY_INT_ARRAY);
        this.myProgressIndicator.setText(this.getSavingText());
    }

    @Override
    public void addRows(@NotNull DataRequest.Context context, @NotNull List<DataConsumer.Row> rows) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dump/DumpRequest", "addRows"));
        }
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/dump/DumpRequest", "addRows"));
        }
        this.myProgressIndicator.checkCanceled();
        if (rows.isEmpty()) {
            return;
        }
        int maxRow = rows.get((int)(rows.size() - 1)).rowNum;
        if (rows.get((int)0).rowNum > this.myFirstRowNum && this.myExtractor instanceof DefaultValuesExtractor && !(this.myExtractor instanceof FormatBasedExtractor)) {
            this.myOutput.append(((DefaultValuesExtractor)this.myExtractor).getLineSeparator());
        }
        this.myExtraction.addData(rows);
        this.myProgressIndicator.setText(this.getSavingText() + " " + maxRow + " rows / " + ExtractorsUtil.getPresentableSize(this.myOutput.length()) + " chars loaded");
    }

    @NotNull
    private String getSavingText() {
        String string = "Saving" + (this.myName == null ? "" : String.format(" \"%s\"", this.myName)) + "...";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/DumpRequest", "getSavingText"));
        }
        return string;
    }

    @Override
    public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dump/DumpRequest", "afterLastRowAdded"));
        }
        this.myExtraction.complete();
    }
}

