/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump.dbdump;

import com.intellij.database.dump.dbdump.DbDumpUtil;
import com.intellij.database.dump.dbdump.DumpCommandLineLexeme;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DumpContextDescriptor {
    private final Set<Object> mySet;
    private final List<DumpCommandLineLexeme> myLexemes;
    private final Operation myOperation;
    private final long myNoNamedCount;

    public DumpContextDescriptor(@NotNull List<DumpCommandLineLexeme> lexemeList, @NotNull Operation operation) {
        if (lexemeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemeList", "com/intellij/database/dump/dbdump/DumpContextDescriptor", "<init>"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/database/dump/dbdump/DumpContextDescriptor", "<init>"));
        }
        this.mySet = ContainerUtil.newHashSet();
        this.myOperation = operation;
        this.myLexemes = lexemeList.stream().filter(DumpCommandLineLexeme::isArgument).collect(Collectors.toList());
        this.myNoNamedCount = lexemeList.stream().filter(DumpCommandLineLexeme::isParameter).count();
    }

    public long getNoNamedCount() {
        return this.myNoNamedCount;
    }

    public boolean contains(@NotNull String[] strings) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/database/dump/dbdump/DumpContextDescriptor", "contains"));
        }
        return ContainerUtil.find(this.myLexemes, DbDumpUtil.lexemeFinder(strings)) != null;
    }

    public boolean contains(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/dump/dbdump/DumpContextDescriptor", "contains"));
        }
        return ContainerUtil.find(this.myLexemes, DbDumpUtil.lexemeFinder(s)) != null;
    }

    public int getLexemeIndex(@NotNull String[] strings) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/database/dump/dbdump/DumpContextDescriptor", "getLexemeIndex"));
        }
        int idx = Integer.MIN_VALUE;
        for (String string : strings) {
            int current = this.getLexemeIndex(string);
            idx = Math.max(idx, current);
        }
        return Math.max(idx, -1);
    }

    public int getLexemeIndex(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/dump/dbdump/DumpContextDescriptor", "getLexemeIndex"));
        }
        return ContainerUtil.lastIndexOf(this.myLexemes, DbDumpUtil.lexemeFinder(s));
    }

    public boolean checkedOut(@NotNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dump/dbdump/DumpContextDescriptor", "checkedOut"));
        }
        boolean result2 = this.mySet.contains(object);
        this.mySet.add(object);
        return result2;
    }

    public boolean isComponentChanged() {
        return this.myOperation.isComponentChanged();
    }

    public static enum Operation {
        UNKNOWN(false),
        COMPONENT_CHANGED(true),
        TEXT_CHANGED(false);

        private final boolean myComponentChanged;

        private Operation(boolean changed) {
            this.myComponentChanged = changed;
        }

        public boolean isComponentChanged() {
            return this.myComponentChanged;
        }
    }
}

