/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.database.DataBus;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.actions.SynchronizeSchemaAction;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.RunSqlScriptAction;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTracker;
import com.intellij.database.dataSource.srcStorage.DbSrcFileStatus;
import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseTableFileEditor;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicScriptable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.actions.ChooseSchemaAction;
import com.intellij.database.scripting.CustomScriptingOptions;
import com.intellij.database.scripting.ScriptingFactory;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.TransitionalScriptingFactoryKt;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.sql.SqlFileType;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentMap;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

public class DatabaseEditorHelper
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(DatabaseEditorHelper.class);
    private static final String DDL_EDITOR_DISPLAY_NAME = "DDL";
    private static final Key<Object> DB_EDITOR_LISTENER_INSTALLED = Key.create((String)"DB_EDITOR_LISTENER_INSTALLED");
    private static final Key<Boolean> FILE_CONTENT_LOADED = Key.create((String)"DBE_CONTENT_LOADED");

    public static void installEditorFactoryListener(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/DatabaseEditorHelper", "installEditorFactoryListener"));
        }
        if (project.getUserData(DB_EDITOR_LISTENER_INSTALLED) != null) {
            return;
        }
        project.putUserData(DB_EDITOR_LISTENER_INSTALLED, (Object)Boolean.TRUE);
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        FileEditorManagerListener listener = new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/editor/DatabaseEditorHelper$1", "fileOpened"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/DatabaseEditorHelper$1", "fileOpened"));
                }
                if (DbImplUtil.isDatabaseVirtualFile(file)) {
                    DatabaseEditorHelper.configureToolbar(file, source);
                    DatabaseEditorHelper.setDdlEditorsDisplayName(file, source);
                } else {
                    DatabaseEditorHelper.restoreAttachedConsole(source.getProject(), file);
                }
            }
        };
        project.getMessageBus().connect((Disposable)project).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)listener);
        for (VirtualFile virtualFile : fileEditorManager.getOpenFiles()) {
            listener.fileOpened(fileEditorManager, virtualFile);
        }
        DataBus.addRootAuditor(project, new DataAuditor.Adapter(){
            final ConcurrentMap<DataRequest.Context, String> myReportedQueries = ContainerUtil.createConcurrentWeakMap();

            @Override
            public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/editor/DatabaseEditorHelper$2", "jobSubmitted"));
                }
                if (producer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/editor/DatabaseEditorHelper$2", "jobSubmitted"));
                }
                this.updateToolbars(request);
            }

            @Override
            public void jobFinished(@NotNull DataRequest request, @NotNull DataProducer producer) {
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/editor/DatabaseEditorHelper$2", "jobFinished"));
                }
                if (producer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/editor/DatabaseEditorHelper$2", "jobFinished"));
                }
                this.updateToolbars(request);
            }

            void updateToolbars(@NotNull DataRequest request) {
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/editor/DatabaseEditorHelper$2", "updateToolbars"));
                }
                if (request.owner instanceof DataGrid || request.owner instanceof AbstractQueryLanguageConsole) {
                    UIUtil.invokeLaterIfNeeded(() -> ActionToolbarImpl.updateAllToolbarsImmediately());
                }
            }

            @Override
            public void print(@NotNull DataRequest.Context context, @Nullable String message) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/editor/DatabaseEditorHelper$2", "print"));
                }
                if (context.request.owner instanceof JdbcConsole) {
                    return;
                }
                if (StringUtil.isEmptyOrSpaces((String)message)) {
                    return;
                }
                DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification(message, MessageType.INFO).notify(project);
            }

            @Override
            public void warn(@NotNull DataRequest.Context context, @Nullable String message) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/editor/DatabaseEditorHelper$2", "warn"));
                }
                if (context.request.owner instanceof JdbcConsole) {
                    return;
                }
                if (StringUtil.isEmptyOrSpaces((String)message)) {
                    return;
                }
                DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification(message, MessageType.WARNING).notify(project);
            }

            @Override
            public void error(@NotNull DataRequest.Context context, @Nullable String message, @Nullable Throwable th) {
                String content;
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/editor/DatabaseEditorHelper$2", "error"));
                }
                if (context.request.owner instanceof JdbcConsole) {
                    return;
                }
                String query = StringUtil.nullize((String)StringUtil.trim((String)context.getQuery()));
                if (query != null && Comparing.equal((String)query, (String)this.myReportedQueries.put(context, query))) {
                    query = null;
                }
                if (StringUtil.isEmptyOrSpaces((String)(content = (query == null ? "" : query + "\n") + (message == null ? "" : message) + (th == null ? "" : ExceptionUtil.getUserStackTrace((Throwable)th, (Logger)AbstractQueryLanguageConsole.LOG))))) {
                    content = "<missing error message>";
                }
                DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification(content, MessageType.ERROR).notify(project);
            }
        }, (Disposable)project);
    }

    private static void restoreAttachedConsole(@NotNull Project project, @NotNull VirtualFile file) {
        DbDataSource dataSource;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/DatabaseEditorHelper", "restoreAttachedConsole"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/DatabaseEditorHelper", "restoreAttachedConsole"));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return;
        }
        JdbcConsole existing = JdbcConsoleProvider.getAttachedConsole(project, file);
        if (existing != null) {
            DatabaseEditorHelper.configureAttachedConsoleToolbar(project, existing, file);
            return;
        }
        String dataSourceId = JdbcConsoleProvider.getAttachedDataSourceId(file);
        DbDataSource dbDataSource = dataSource = dataSourceId == null ? null : DbPsiFacade.getInstance((Project)project).findDataSource(dataSourceId);
        if (dataSource == null || !DbImplUtil.canConnectTo((DbElement)dataSource)) {
            return;
        }
        JdbcConsole jdbcConsole = null;
        for (JdbcConsole console : JdbcConsole.getActiveConsoles(project)) {
            if (console.getDataSource() != dataSource.getDelegate()) continue;
            jdbcConsole = console;
            break;
        }
        if (jdbcConsole == null) {
            jdbcConsole = JdbcConsole.newConsole(project).fromDataSource((DatabaseSystem)dataSource).buildAndShow(false);
        }
        JdbcConsoleProvider.attachConsole(project, jdbcConsole, file);
    }

    public static void configureAttachedConsoleToolbar(@NotNull Project project, @Nullable JdbcConsole console, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/DatabaseEditorHelper", "configureAttachedConsoleToolbar"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/DatabaseEditorHelper", "configureAttachedConsoleToolbar"));
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        for (FileEditor fileEditor : fileEditorManager.getAllEditors(file)) {
            EditorEx editor = EditorUtil.getEditorEx((FileEditor)fileEditor);
            if (editor == null) continue;
            if (console == null) {
                editor.setPermanentHeaderComponent(null);
                editor.setHeaderComponent(null);
                editor.setBackgroundColor(null);
                continue;
            }
            console.buildConsoleHeaderComponent((Editor)editor);
        }
    }

    public static void configureConsole(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        JdbcConsole console;
        LocalDataSource dataSource;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/DatabaseEditorHelper", "configureConsole"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/editor/DatabaseEditorHelper", "configureConsole"));
        }
        Project project = source.getProject();
        DbDataSource dbDataSource = DbConsoleRootType.getDataSource(project, file);
        DatabaseSystem delegate = dbDataSource == null ? null : dbDataSource.getDelegate();
        LocalDataSource localDataSource = dataSource = delegate instanceof LocalDataSource ? (LocalDataSource)delegate : null;
        if (dataSource == null) {
            return;
        }
        if (FileIndexFacade.getInstance((Project)project).isUnderIgnored(file)) {
            LOG.warn(file.getPresentableUrl() + " is under ignored root, console not initialized");
            return;
        }
        JdbcConsole existing = JdbcConsole.getConsole(source.getProject(), file);
        if (existing != null) {
            console = existing;
        } else {
            console = JdbcConsole.newConsole(project).forFile(file).fromDataSource((DatabaseSystem)dataSource).buildAndShow(false);
            ChooseSchemaAction.scheduleSavedSchemaSwitch(console);
        }
        for (FileEditor fileEditor : source.getAllEditors(file)) {
            EditorEx editor = EditorUtil.getEditorEx((FileEditor)fileEditor);
            if (editor == null || editor.getPermanentHeaderComponent() != null) continue;
            console.buildConsoleHeaderComponent((Editor)editor);
        }
    }

    public static void disposeConsoleIfSafe(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/DatabaseEditorHelper", "disposeConsoleIfSafe"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/editor/DatabaseEditorHelper", "disposeConsoleIfSafe"));
        }
        if (!source.getProject().isOpen()) {
            return;
        }
        if (source.getAllEditors(file).length > 0) {
            return;
        }
        JdbcConsole console = JdbcConsole.getConsole(source.getProject(), file);
        if (console == null) {
            return;
        }
        if (console.isToolWindowContentPresent()) {
            return;
        }
        for (VirtualFile openFile : source.getOpenFiles()) {
            if (JdbcConsoleProvider.getAttachedConsole(source.getProject(), openFile) != console) continue;
            return;
        }
        Disposer.dispose((Disposable)console);
    }

    private static void configureToolbar(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/DatabaseEditorHelper", "configureToolbar"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/editor/DatabaseEditorHelper", "configureToolbar"));
        }
        boolean fileContentLoaded = Boolean.TRUE.equals(FILE_CONTENT_LOADED.get((UserDataHolder)file));
        for (FileEditor fileEditor : source.getAllEditors(file)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            Editor editor = ((TextEditor)fileEditor).getEditor();
            DatabaseEditorHelper.configureToolbar(source.getProject(), file, editor);
            if (!(file instanceof DatabaseElementVirtualFileImpl)) continue;
            DatabaseEditorHelper.processLoading(fileContentLoaded, fileEditor, (DatabaseElementVirtualFileImpl)file);
        }
    }

    private static void processLoading(boolean fileContentLoaded, FileEditor fileEditor, final DatabaseElementVirtualFileImpl vf) {
        JComponent editorComponent = fileEditor.getComponent();
        if (editorComponent instanceof JBLoadingPanel && vf.isBusy()) {
            ((JBLoadingPanel)editorComponent).startLoading();
        }
        if (!fileContentLoaded && !vf.isBusy()) {
            new UiNotifyConnector.Once((Component)editorComponent, (Activatable)new Activatable.Adapter(){

                public void showNotify() {
                    if (!vf.isBusy() && !Boolean.TRUE.equals(FILE_CONTENT_LOADED.get((UserDataHolder)vf))) {
                        FILE_CONTENT_LOADED.set((UserDataHolder)vf, (Object)Boolean.TRUE);
                        DatabaseEditorHelper.scheduleReload(vf);
                    }
                }
            });
        }
    }

    private static void setDdlEditorsDisplayName(@NotNull VirtualFile file, @NotNull FileEditorManager fem) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/DatabaseEditorHelper", "setDdlEditorsDisplayName"));
        }
        if (fem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fem", "com/intellij/database/editor/DatabaseEditorHelper", "setDdlEditorsDisplayName"));
        }
        for (EditorWithProviderComposite composite : ((FileEditorManagerEx)fem).getSplitters().findEditorComposites(file)) {
            for (FileEditor editor : composite.getEditors()) {
                if (!(editor instanceof TextEditor)) continue;
                composite.setDisplayName(editor, DDL_EDITOR_DISPLAY_NAME);
            }
        }
    }

    public static boolean isTableDataAvailable(@Nullable DbElement element) {
        return element != null && DbImplUtil.isDataTable(element.getKind()) && DbImplUtil.canConnectTo((DbElement)element.getDataSource());
    }

    public static boolean isDefinitionAvailable(@Nullable DbElement element) {
        return element instanceof DbTable && element.getKind() == ObjectKind.TABLE ? DbImplUtil.canConnectTo(element) : DatabaseEditorHelper.hasNewCodegen(element) || DatabaseEditorHelper.isRawDefinitionAvailable(element);
    }

    public static boolean isRawDefinitionAvailable(@Nullable DbElement element) {
        if (element == null || !DbImplUtil.canConnectTo(element)) {
            return false;
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(element);
        ObjectKind kind = element.getKind();
        if (kind == ObjectKind.PACKAGE || kind == ObjectKind.BODY || element.getDbParent() instanceof DbPackage) {
            return dialect.supportsPackageDefinition();
        }
        if (kind == ObjectKind.ROUTINE) {
            return dialect.supportsProcedureDefinition();
        }
        if (element instanceof DbTable) {
            boolean system = ((DbTable)element).isSystem();
            if (kind == ObjectKind.VIEW) {
                return system ? dialect.supportsSystemViewDefinition() : dialect.supportsViewDefinition();
            }
            if (kind == ObjectKind.SEQUENCE) {
                return dialect.supportsSequenceDefinition();
            }
            if (kind == ObjectKind.SYNONYM) {
                return dialect.supportsSynonymDefinition();
            }
            if (kind == ObjectKind.TABLE) {
                return dialect.supportsTableDefinition();
            }
        }
        return false;
    }

    @NotNull
    public static StringBuilder generateDefinition(@NotNull DbElement element, @NotNull StringBuilder sb) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/editor/DatabaseEditorHelper", "generateDefinition"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/editor/DatabaseEditorHelper", "generateDefinition"));
        }
        if (element.getDelegate() instanceof BasicElement) {
            BasicElement e = (BasicElement)element.getDelegate();
            CharSequence def = DatabaseEditorHelper.generateDefinitionUsingScriptingService(e);
            sb.append(def);
        } else {
            DdlBuilder builder = new DdlBuilder(sb).configureFor(element);
            builder.element((DasObject)element);
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseEditorHelper", "generateDefinition"));
        }
        return stringBuilder;
    }

    public static boolean hasNewCodegen(@Nullable DbElement element) {
        if (element == null) {
            return false;
        }
        Rdbms rdbms = DbImplUtil.getRdbms(DbImplUtil.getDatabaseDialect(element));
        return TransitionalScriptingFactoryKt.isModernCodeGenerator(rdbms) && element.getDelegate() instanceof BasicScriptable;
    }

    @NotNull
    public static CharSequence generateDefinitionUsingScriptingService(@NotNull BasicElement element) {
        String src;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/editor/DatabaseEditorHelper", "generateDefinitionUsingScriptingService"));
        }
        if (element instanceof BasicScriptable) {
            BasicModel model = element.getModel();
            BasicDatabase database = ModelFun.getDatabase(element);
            if (model == null) {
                if ("-- no model" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseEditorHelper", "generateDefinitionUsingScriptingService"));
                }
                return "-- no model";
            }
            if (database == null) {
                if ("-- no database" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseEditorHelper", "generateDefinitionUsingScriptingService"));
                }
                return "-- no database";
            }
            ScriptingFactory scriptingFactory = (ScriptingFactory)ServiceManager.getService(ScriptingFactory.class);
            ScriptingService scriptingService = scriptingFactory.createScriptingService(model, database);
            scriptingService.setOptions(new CustomScriptingOptions(Collections.emptyMap()));
            if (element instanceof BasicSchema) {
                BasicSchema schema = (BasicSchema)element;
                scriptingService.makeScript(ScriptingTask.CREATE_EXACT, schema);
            } else {
                BasicScriptable object = (BasicScriptable)element;
                scriptingService.makeScript(ScriptingTask.CREATE_EXACT, Collections.singleton(object), true);
            }
            src = scriptingService.getScriptText();
        } else {
            src = "-- No script for element: " + element.toString();
        }
        if (src.length() == 0) {
            src = "-- No source text available";
        }
        String string = src;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseEditorHelper", "generateDefinitionUsingScriptingService"));
        }
        return string;
    }

    @NotNull
    public static StringBuilder loadOrGenerateDefinition(@NotNull DbElement element, @NotNull StringBuilder sb) {
        DdlBuilder builder;
        block7: {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/editor/DatabaseEditorHelper", "loadOrGenerateDefinition"));
            }
            if (sb == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/editor/DatabaseEditorHelper", "loadOrGenerateDefinition"));
            }
            int length = sb.length();
            DatabaseEditorHelper.loadDefinition(element, sb);
            if (length == sb.length()) break block7;
            StringBuilder stringBuilder = sb;
            if (stringBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseEditorHelper", "loadOrGenerateDefinition"));
            }
            return stringBuilder;
        }
        try {
            builder = new DdlBuilder(sb).configureFor(element).comment("definition is not available or empty\n");
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            builder = new DdlBuilder(sb).configureFor(element).comment("Failed to load definition\n").comment(ExceptionUtil.getNonEmptyMessage((Throwable)e, (String)"") + "\n");
        }
        builder.comment("auto-generated definition\n");
        StringBuilder stringBuilder = DatabaseEditorHelper.generateDefinition(element, sb);
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseEditorHelper", "loadOrGenerateDefinition"));
        }
        return stringBuilder;
    }

    @NotNull
    public static StringBuilder loadDefinition(@NotNull DbElement element, @NotNull StringBuilder sb) throws Exception {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/editor/DatabaseEditorHelper", "loadDefinition"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/editor/DatabaseEditorHelper", "loadDefinition"));
        }
        StringBuilder stringBuilder = DatabaseEditorHelper.loadDefinition(ConnectionProvider.forElement(element), element, sb);
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseEditorHelper", "loadDefinition"));
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static StringBuilder loadDefinition(@NotNull ConnectionProvider provider, @NotNull DbElement element, @NotNull StringBuilder sb) throws Exception {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/editor/DatabaseEditorHelper", "loadDefinition"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/editor/DatabaseEditorHelper", "loadDefinition"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/editor/DatabaseEditorHelper", "loadDefinition"));
        }
        if (!provider.acquire()) {
            Exception exception = provider.getLastException();
            if (exception != null) {
                throw exception;
            }
            StringBuilder stringBuilder = sb;
            StringBuilder stringBuilder2 = stringBuilder;
            if (stringBuilder2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseEditorHelper", "loadDefinition"));
            }
            return stringBuilder2;
        }
        DatabaseEditorHelper.setCurrentSchemaSafe(element, provider.getConnection());
        StringBuilder stringBuilder = DatabaseEditorHelper.loadDefinitionImpl(provider, element, sb);
        StringBuilder stringBuilder3 = stringBuilder;
        if (stringBuilder3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseEditorHelper", "loadDefinition"));
        }
        return stringBuilder3;
        finally {
            provider.release();
        }
    }

    public static void setCurrentSchemaSafe(@NotNull DbElement element, @NotNull DatabaseConnection connection) {
        String statement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/editor/DatabaseEditorHelper", "setCurrentSchemaSafe"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/editor/DatabaseEditorHelper", "setCurrentSchemaSafe"));
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(element);
        SearchPath searchPath = SearchPath.of(ObjectPath.of((DasObject)DbImplUtil.getSearchPathObject(element)));
        String string = statement = searchPath == null ? null : dialect.sqlSetSearchPath((DatabaseSystem)element.getDataSource(), searchPath);
        if (statement == null) {
            return;
        }
        Statement st = null;
        try {
            st = connection.createStatement();
            st.execute(statement);
        }
        catch (Exception e) {
            DataSourceUiUtil.LOG.warn(statement, (Throwable)e);
        }
        JdbcUtil.closeStatementSafe((Statement)st);
    }

    @NotNull
    private static StringBuilder loadDefinitionImpl(@NotNull ConnectionProvider provider, DbElement element, @NotNull StringBuilder sb) throws Exception {
        DbPackage pkg;
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/editor/DatabaseEditorHelper", "loadDefinitionImpl"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/editor/DatabaseEditorHelper", "loadDefinitionImpl"));
        }
        ObjectKind kind = element.getKind();
        Object object = pkg = kind == ObjectKind.PACKAGE || kind == ObjectKind.BODY || element.getDbParent() instanceof DbPackage ? (DbPackage)DasUtil.getParentOfClass((DasObject)element, DbPackage.class, (boolean)false) : null;
        if (pkg != null) {
            DbImplUtil.tryLoadPackageDefinition(provider, pkg, kind == ObjectKind.PACKAGE, sb);
        } else if (element instanceof DbRoutine) {
            DbImplUtil.tryLoadProcedureDefinition(provider, (DbRoutine)element, sb);
        } else if (element instanceof DbTable) {
            if (kind == ObjectKind.TABLE) {
                DbImplUtil.tryLoadTableDefinition(provider, (DbTable)element, sb);
            } else if (kind == ObjectKind.VIEW) {
                DbImplUtil.tryLoadViewDefinition(provider, (DbTable)element, sb);
            } else if (kind == ObjectKind.SEQUENCE) {
                DbImplUtil.tryLoadSequenceDefinition(provider, (DbTable)element, sb);
            } else if (kind == ObjectKind.SYNONYM) {
                DbImplUtil.tryLoadSynonymDefinition(provider, (DbTable)element, sb);
            }
        } else {
            throw new IllegalArgumentException("unknown element: " + element);
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseEditorHelper", "loadDefinitionImpl"));
        }
        return stringBuilder;
    }

    public static CompletionStage<Void> scheduleReload(@NotNull DatabaseElementVirtualFileImpl virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/editor/DatabaseEditorHelper", "scheduleReload"));
        }
        virtualFile.setBusy(true);
        Project project = virtualFile.getProject();
        Runnable runnable = () -> {
            if (virtualFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/editor/DatabaseEditorHelper", "lambda$scheduleReload$3"));
            }
            if (project.isDisposed()) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            try {
                DbElement element = virtualFile.findElement();
                if (element == null) {
                    sb.append("-- invalid target");
                } else {
                    DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(element);
                    Rdbms rdbms = DbImplUtil.getRdbms(dialect);
                    if (!TransitionalScriptingFactoryKt.isModernCodeGenerator(rdbms) && DatabaseEditorHelper.isRawDefinitionAvailable(element)) {
                        DatabaseEditorHelper.loadOrGenerateDefinition(element, sb);
                    } else {
                        sb.append("-- auto-generated definition\n");
                        DatabaseEditorHelper.generateDefinition(element, sb);
                    }
                    if (sb.length() == 0) {
                        sb.append("-- definition is not available or empty");
                    }
                }
            }
            catch (Exception e) {
                String trace = ExceptionUtil.getUserStackTrace((Throwable)e, (Logger)DataSourceUiUtil.LOG);
                for (String s : trace.split("\n")) {
                    sb.append("-- ").append(s).append("\n");
                }
            }
            finally {
                String content = StringUtil.convertLineSeparators((String)sb.toString());
                virtualFile.setContent(content);
                virtualFile.setBusy(false);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (virtualFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/editor/DatabaseEditorHelper", "lambda$null$2"));
                }
                if (project.isDisposed()) {
                    return;
                }
                if (!virtualFile.isValid()) {
                    return;
                }
                Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)virtualFile);
                if (document == null) {
                    return;
                }
                Runnable docUpdateRunnable = () -> {
                    boolean reformatOnPaste;
                    if (virtualFile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/editor/DatabaseEditorHelper", "lambda$null$0"));
                    }
                    PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
                    DbElement element = virtualFile.findElement();
                    DasNamespace object = element == null ? null : DbImplUtil.getSearchPathObject(DbImplUtil.getDatabaseDialect(element), (DasObject)element);
                    DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)file, (Object)ContainerUtil.createMaybeSingletonList((Object)object));
                    document.setText((CharSequence)virtualFile.getContent());
                    boolean bl = reformatOnPaste = CodeInsightSettings.getInstance().REFORMAT_ON_PASTE == 4;
                    if (file != null && reformatOnPaste) {
                        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file);
                    }
                };
                boolean writable = virtualFile.isWritable();
                try {
                    virtualFile.setWritableInner(true);
                    document.setReadOnly(false);
                    WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                        if (document.getTextLength() == 0) {
                            DocumentReference reference = DocumentReferenceManager.getInstance().create(document);
                            UndoManager.getInstance((Project)project).nonundoableActionPerformed(reference, false);
                        }
                        docUpdateRunnable.run();
                    });
                    virtualFile.setWritableInner(writable);
                    document.setReadOnly(!writable);
                }
                catch (Throwable throwable) {
                    virtualFile.setWritableInner(writable);
                    document.setReadOnly(!writable);
                    throw throwable;
                }
                DatabaseEditorHelper.setVisualProgress(virtualFile.getProject(), virtualFile, false);
            });
        };
        CompletableFuture<Void> res = new CompletableFuture<Void>();
        StartupManager.getInstance((Project)virtualFile.getProject()).runWhenProjectIsInitialized(() -> {
            if (virtualFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/editor/DatabaseEditorHelper", "lambda$scheduleReload$6"));
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (virtualFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/editor/DatabaseEditorHelper", "lambda$null$4"));
                }
                if (project.isDisposed()) {
                    res.cancel(true);
                    return;
                }
                DatabaseEditorHelper.setVisualProgress(project, virtualFile, true);
            });
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    runnable.run();
                }
                finally {
                    res.complete(null);
                }
            });
        });
        return res;
    }

    private static void setVisualProgress(@NotNull Project project, @NotNull VirtualFile file, boolean flag) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/DatabaseEditorHelper", "setVisualProgress"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/DatabaseEditorHelper", "setVisualProgress"));
        }
        for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getAllEditors(file)) {
            JComponent editorComponent;
            if (!(fileEditor instanceof TextEditor) || !((editorComponent = fileEditor.getComponent()) instanceof JBLoadingPanel)) continue;
            JBLoadingPanel component = (JBLoadingPanel)editorComponent;
            if (flag) {
                component.startLoading();
                continue;
            }
            component.stopLoading();
        }
    }

    private static void configureToolbar(@NotNull Project project, final @NotNull VirtualFile virtualFile, @NotNull Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/DatabaseEditorHelper", "configureToolbar"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/editor/DatabaseEditorHelper", "configureToolbar"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/editor/DatabaseEditorHelper", "configureToolbar"));
        }
        if (((EditorEx)editor).getPermanentHeaderComponent() != null) {
            return;
        }
        DefaultActionGroup group2 = new DefaultActionGroup();
        RunSqlScriptAction runAction = new RunSqlScriptAction(){

            @Override
            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/editor/DatabaseEditorHelper$4", "update"));
                }
                Project project = e.getProject();
                LocalDataSource localDataSource = this.getLocalDataSource(project);
                e.getPresentation().setEnabledAndVisible(!(e.getData(PlatformDataKeys.FILE_EDITOR) instanceof DatabaseTableFileEditor) && localDataSource != null);
            }

            @Nullable
            private LocalDataSource getLocalDataSource(Project project) {
                DbDataSource dataSource = project == null ? null : DbImplUtil.findDataSource(project, virtualFile);
                return dataSource == null ? null : (LocalDataSource)ObjectUtils.tryCast((Object)dataSource.getDelegate(), LocalDataSource.class);
            }

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/editor/DatabaseEditorHelper$4", "actionPerformed"));
                }
                Project project = e.getProject();
                LocalDataSource source = this.getLocalDataSource(project);
                if (project == null || source == null) {
                    return;
                }
                RunSqlScriptAction.perform(project, "Run Script", (JBIterable<VirtualFile>)JBIterable.of((Object)virtualFile), Collections.singletonList(source));
            }
        };
        ActionUtil.copyFrom((AnAction)runAction, (String)"Jdbc.RunSqlScript");
        runAction.registerCustomShortcutSet(editor.getComponent(), null);
        group2.add((AnAction)runAction);
        if (virtualFile instanceof DatabaseElementVirtualFileImpl) {
            DatabaseEditorHelper.addSpecificActions(editor, group2, (DatabaseElementVirtualFileImpl)virtualFile);
        } else if (DbSrcUtils.isDbSrcFile(virtualFile)) {
            DatabaseEditorHelper.addSpecificActions(editor, group2, virtualFile);
        }
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar actionToolbar = actionManager.createActionToolbar("unknown", (ActionGroup)group2, true);
        actionToolbar.setTargetComponent(editor.getContentComponent());
        JComponent component = actionToolbar.getComponent();
        EditorHeaderComponent headerComponent = new EditorHeaderComponent();
        headerComponent.add((Component)component, "West");
        ((EditorEx)editor).setPermanentHeaderComponent((JComponent)headerComponent);
        editor.setHeaderComponent((JComponent)headerComponent);
        DatabaseEditorHelper.updateToolbarColor(project, virtualFile, (JComponent)headerComponent);
    }

    private static void addSpecificActions(@NotNull Editor editor, DefaultActionGroup group2, final DatabaseElementVirtualFileImpl file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/editor/DatabaseEditorHelper", "addSpecificActions"));
        }
        group2.addSeparator();
        RefreshAction reloadAction = new RefreshAction("Reload", "", PlatformIcons.SYNCHRONIZE_ICON){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/editor/DatabaseEditorHelper$5", "update"));
                }
                e.getPresentation().setEnabled(!file.isBusy());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/editor/DatabaseEditorHelper$5", "actionPerformed"));
                }
                DatabaseEditorHelper.scheduleReload(file);
            }
        };
        reloadAction.registerShortcutOn(editor.getComponent());
        group2.add((AnAction)reloadAction);
    }

    private static void addSpecificActions(@NotNull Editor editor, DefaultActionGroup group2, final VirtualFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/editor/DatabaseEditorHelper", "addSpecificActions"));
        }
        RefreshAction reloadAction = new RefreshAction("Reload", "", PlatformIcons.SYNCHRONIZE_ICON){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/editor/DatabaseEditorHelper$6", "update"));
                }
                DbElement element = this.getElement(e);
                LocalDataSource dataSource = element == null ? null : (LocalDataSource)ObjectUtils.tryCast((Object)element.getDataSource().getDelegate(), LocalDataSource.class);
                e.getPresentation().setEnabled(e.getProject() != null && dataSource != null && !dataSource.isInBatch());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/editor/DatabaseEditorHelper$6", "actionPerformed"));
                }
                DbElement element = this.getElement(e);
                if (element == null) {
                    return;
                }
                SynchronizeSchemaAction.refresh(e.getProject(), (JBIterable<DbElement>)JBIterable.of((Object)element));
            }

            @Nullable
            private DbElement getElement(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/editor/DatabaseEditorHelper$6", "getElement"));
                }
                Project project = e.getProject();
                return project == null ? null : DbSrcUtils.findDbElement(project, file.getPath(), DbElement.class, true);
            }
        };
        reloadAction.registerShortcutOn(editor.getComponent());
        DumbAwareAction revertAction = new DumbAwareAction(){

            public void update(AnActionEvent e) {
                FileStatus status = DbSrcFileStatus.getInstance().getStatus(file).getStatus();
                e.getPresentation().setEnabled(status != null && status != FileStatus.NOT_CHANGED);
            }

            public void actionPerformed(AnActionEvent e) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        DbSrcUtils.removeFromStorage((Iterable<VirtualFile>)JBIterable.of((Object)file), true);
                    }
                    catch (IOException ex) {
                        DatabaseNotifications.REFACTORING_GROUP.createNotification("Failed to revert " + file.getUrl(), MessageType.INFO).notify(e.getProject());
                    }
                });
            }
        };
        ActionUtil.copyFrom((AnAction)revertAction, (String)"ChangesView.Revert");
        DumbAwareAction diffAction = new DumbAwareAction(){

            public void update(AnActionEvent e) {
                FileStatus status = DbSrcFileStatus.getInstance().getStatus(file).getStatus();
                e.getPresentation().setEnabled(status != null && status != FileStatus.NOT_CHANGED);
            }

            public void actionPerformed(AnActionEvent e) {
                Change change = DbSrcChangesTracker.getChange(file);
                if (change == null) {
                    return;
                }
                ShowDiffAction.showDiffForChange((Project)e.getProject(), (Iterable)JBIterable.of((Object)change));
            }

            protected void setShortcutSet(ShortcutSet shortcutSet) {
            }
        };
        ActionUtil.copyFrom((AnAction)diffAction, (String)"ChangesView.Diff");
        group2.add((AnAction)reloadAction);
        group2.add((AnAction)revertAction);
        group2.add((AnAction)diffAction);
    }

    public static void openConsoleFile(@Nullable DbElement element) {
        DatabaseEditorHelper.openConsoleFile(element, false);
    }

    public static void openConsoleFile(@Nullable DbElement element, boolean newInstance) {
        LocalDataSource dataSource;
        LocalDataSource localDataSource = dataSource = element == null ? null : DbImplUtil.getLocalDataSource((DatabaseSystem)element.getDataSource());
        if (dataSource == null) {
            return;
        }
        DasNamespace context = element instanceof DbDataSource ? ((DbDataSource)element).getModel().getCurrentRootNamespace() : (DasNamespace)DasUtil.getParentOfClass((DasObject)element, DasNamespace.class, (boolean)false);
        DatabaseEditorHelper.openConsoleFile(element.getProject(), (DatabaseSystem)dataSource, context, newInstance);
    }

    public static void openConsoleFile(@NotNull Project project, @NotNull DatabaseSystem dataSource, @Nullable DasNamespace schema, boolean newInstance) {
        VirtualFile file;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/DatabaseEditorHelper", "openConsoleFile"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/editor/DatabaseEditorHelper", "openConsoleFile"));
        }
        VirtualFile virtualFile = file = newInstance ? DatabaseEditorHelper.createNewConsoleVirtualFile(dataSource) : DatabaseEditorHelper.getConsoleVirtualFile(dataSource);
        if (file == null) {
            return;
        }
        DatabaseEditorHelper.openConsoleForFile(project, schema, file);
    }

    public static void openConsoleForFile(@NotNull Project project, @Nullable DasNamespace schema, VirtualFile file) {
        List<DasNamespace> namespaces;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/DatabaseEditorHelper", "openConsoleForFile"));
        }
        FileEditorManager.getInstance((Project)project).openFile(file, true);
        if (schema == null) {
            return;
        }
        JdbcConsole console = JdbcConsole.getConsole(project, file);
        DatabaseDialectEx dialect = console == null ? null : DbImplUtil.getDatabaseDialect(console);
        SearchPath searchPath = DbImplUtil.getAutoSwitchPath(dialect, SearchPath.of(namespaces = Collections.singletonList(schema = console == null ? schema : DbImplUtil.getSearchPathObject(dialect, (DasObject)schema))));
        if (searchPath != null) {
            if (console != null) {
                console.switchSchema(searchPath, false);
            } else {
                ChooseSchemaAction.setSelectedSearchPath(file, searchPath);
            }
        }
        DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)PsiManager.getInstance((Project)project).findFile(file), namespaces);
    }

    @Nullable
    public static VirtualFile getConsoleVirtualFile(@NotNull DatabaseSystem dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/editor/DatabaseEditorHelper", "getConsoleVirtualFile"));
        }
        return ConsoleHistoryController.getContentFile((ConsoleRootType)DbConsoleRootType.getInstance(), (String)dataSource.getUniqueId(), (ScratchFileService.Option)ScratchFileService.Option.create_if_missing);
    }

    @Nullable
    public static VirtualFile findExistingConsoleVirtualFile(@NotNull DatabaseSystem dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/editor/DatabaseEditorHelper", "findExistingConsoleVirtualFile"));
        }
        return ConsoleHistoryController.getContentFile((ConsoleRootType)DbConsoleRootType.getInstance(), (String)dataSource.getUniqueId(), (ScratchFileService.Option)ScratchFileService.Option.existing_only);
    }

    @Nullable
    public static VirtualFile createNewConsoleVirtualFile(@NotNull DatabaseSystem dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/editor/DatabaseEditorHelper", "createNewConsoleVirtualFile"));
        }
        return ConsoleHistoryController.getContentFile((ConsoleRootType)DbConsoleRootType.getInstance(), (String)dataSource.getUniqueId(), (ScratchFileService.Option)ScratchFileService.Option.create_new_always);
    }

    public static void updateToolbarColor(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable JComponent headerComponent) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/DatabaseEditorHelper", "updateToolbarColor"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/editor/DatabaseEditorHelper", "updateToolbarColor"));
        }
        if (headerComponent == null) {
            return;
        }
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(DataManager.getInstance().getDataContext((Component)headerComponent));
        DatabaseGridDataHookUp hookup = DbConsoleRootType.isConsoleFile(virtualFile) ? DataGridUtil.getDatabaseHookUp(dataGrid) : null;
        DasTable table = hookup == null ? null : hookup.getDatabaseTable();
        VirtualFile adjustedFile = table instanceof DbElement ? (VirtualFile)ObjectUtils.notNull((Object)DbImplUtil.findVirtualFile((DbElement)table, false), (Object)virtualFile) : virtualFile;
        DatabaseColorManager.LocalColors state = (DatabaseColorManager.LocalColors)DatabaseColorManager.getLocalColorManager(project).getState();
        Color color = state.useColors ? DatabaseColorManager.getColor(project, adjustedFile, true) : null;
        Color toolbarColor = state.useInToolbars ? color : null;
        headerComponent.setBackground(toolbarColor);
        for (Component c2 : (JBTreeTraverser)UIUtil.uiTraverser((Component)headerComponent).filter(c -> c instanceof ActionToolbar)) {
            c2.setBackground(toolbarColor);
        }
        Color editorColor = state.useInEditor ? color : null;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext((Component)headerComponent));
        if (editor instanceof EditorEx) {
            Language lang = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)((EditorEx)editor).getVirtualFile());
            if (lang != null && lang.getAssociatedFileType() == SqlFileType.INSTANCE) {
                ((EditorEx)editor).setBackgroundColor(editorColor);
            }
        } else if (dataGrid != null) {
            dataGrid.getScrollPane().setBackground(editorColor);
            dataGrid.getColorsScheme().setDefaultBackground(editorColor);
        }
    }

    @Nullable
    public static List<DasNamespace> getSearchPath(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/database/editor/DatabaseEditorHelper", "getSearchPath"));
        }
        List res = (List)DatabaseDataKeys.SEARCH_PATH_KEY.get((UserDataHolder)psiFile);
        if (res != null && res.stream().allMatch(e -> !(e instanceof PsiElement) || ((PsiElement)e).isValid())) {
            return res;
        }
        return DatabaseEditorHelper.initSearchPath(psiFile);
    }

    @Nullable
    public static DasNamespace getForcedContext(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/database/editor/DatabaseEditorHelper", "getForcedContext"));
        }
        return (DasNamespace)ContainerUtil.getFirstItem(DatabaseEditorHelper.getSearchPath(psiFile));
    }

    @Nullable
    public static List<DasNamespace> dbSrcSearchPath(@NotNull Project project, @Nullable VirtualFile vfile, boolean schema) {
        DbSrcPath path;
        DbDataSource dataSource;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/DatabaseEditorHelper", "dbSrcSearchPath"));
        }
        String dataSourceId = vfile == null ? null : DbSrcUtils.getDataSource(vfile);
        DbDataSource dbDataSource = dataSource = dataSourceId == null ? null : DbPsiFacade.getInstance((Project)project).findDataSource(dataSourceId);
        if (dataSource != null && (path = DbSrcUtils.getFullPath(vfile.getPath())) != null) {
            int sz = path.size();
            for (int i2 = 0; i2 < sz; ++i2) {
                ObjectKind nsKind;
                int idx = sz - i2 - 1;
                String kind = path.kind(idx);
                if (ObjectKind.DATABASE.code().equals(kind)) {
                    nsKind = ObjectKind.DATABASE;
                } else {
                    if (!ObjectKind.SCHEMA.code().equals(kind)) continue;
                    nsKind = ObjectKind.SCHEMA;
                }
                List nsPath = JBIterable.from(path.names()).take(idx + 1).toList();
                DasNamespace searchPathObject = DbImplUtil.getSearchPathObject(DbImplUtil.getDatabaseDialect((DbElement)dataSource), (DasObject)DatabaseEditorHelper.findNamespace(project, (DatabaseSystem)dataSource, new ObjectPath(nsKind, nsPath)));
                return ContainerUtil.createMaybeSingletonList((Object)searchPathObject);
            }
        }
        return null;
    }

    @Nullable
    public static List<DasNamespace> initSearchPath(@NotNull PsiFile psiFile) {
        DbDataSource forcedDataSource;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/database/editor/DatabaseEditorHelper", "initSearchPath"));
        }
        VirtualFile vfile = psiFile.getVirtualFile();
        Project project = psiFile.getProject();
        if (DbSrcUtils.isDbSrcFile(vfile)) {
            List<DasNamespace> path = DatabaseEditorHelper.dbSrcSearchPath(project, vfile, false);
            DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, path);
            return path;
        }
        JdbcConsole console = JdbcConsole.findConsole(project, vfile);
        DbDataSource dbDataSource = forcedDataSource = console != null ? DbImplUtil.getDbDataSource(project, (DatabaseSystem)console.getTarget()) : null;
        if (forcedDataSource != null) {
            SearchPath path = console.getSearchPath();
            List<Object> schemaNames = path == null ? Collections.emptyList() : path.elements;
            List forcedNamespaces = JBIterable.from(schemaNames).transform(p -> DatabaseEditorHelper.findNamespace(forcedDataSource.getProject(), (DatabaseSystem)forcedDataSource, p)).toList();
            DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, (Object)forcedNamespaces);
            return forcedNamespaces;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            List forcedNamespaces = (List)DatabaseDataKeys.SEARCH_PATH_KEY.get((UserDataHolder)vfile);
            DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, (Object)forcedNamespaces);
            return forcedNamespaces;
        }
        DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, null);
        return null;
    }

    @Nullable
    public static DasNamespace findNamespace(@NotNull Project project, @NotNull DatabaseSystem databaseSystem, @Nullable ObjectPath objectPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/DatabaseEditorHelper", "findNamespace"));
        }
        if (databaseSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseSystem", "com/intellij/database/editor/DatabaseEditorHelper", "findNamespace"));
        }
        DatabaseElementVirtualFileImpl file = DatabaseElementVirtualFileImpl.findFile(project, databaseSystem, objectPath);
        return file == null ? null : (DasNamespace)ObjectUtils.tryCast((Object)file.findElement(), DasNamespace.class);
    }
}

