/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.HtmlValuesExtractor;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.TranspositionAwareDefaultExtractor;
import com.intellij.database.util.CharOut;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DisplayHtmlValuesExtractor
extends HtmlValuesExtractor {
    private static final String VALUE_SECTION_OPEN = "<div style='margin:2px 10px 2px 10px'><pre style='margin: 0'><code>";
    private static final String VALUE_SECTION_CLOSE = "</code></pre></div>";
    protected final String myHex;
    private final String myBorder;
    private final int myTableWidth;

    public DisplayHtmlValuesExtractor(@NotNull Color background, @NotNull ObjectFormatter converter) {
        if (background == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "background", "com/intellij/database/extractors/DisplayHtmlValuesExtractor", "<init>"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "com/intellij/database/extractors/DisplayHtmlValuesExtractor", "<init>"));
        }
        this(background, converter, 100);
    }

    public DisplayHtmlValuesExtractor(@NotNull Color background, @NotNull ObjectFormatter converter, int tableWidth) {
        if (background == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "background", "com/intellij/database/extractors/DisplayHtmlValuesExtractor", "<init>"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "com/intellij/database/extractors/DisplayHtmlValuesExtractor", "<init>"));
        }
        super(converter);
        this.myHex = GuiUtils.colorToHex((Color)background);
        Color borderColor = UIUtil.isUnderDarcula() ? ColorUtil.brighter((Color)background, (int)1) : ColorUtil.darker((Color)background, (int)1);
        this.myBorder = GuiUtils.colorToHex((Color)borderColor);
        this.myTableWidth = tableWidth;
        this.setIncludeColumnNames(true);
    }

    @Override
    @NotNull
    public String getDataPrefix() {
        String string = String.format("<div style='margin-top: 2px;'><div style='background-color: #%s'><table border=0 width='%s%%' cellpadding=0 cellspacing=1>", this.myBorder, this.myTableWidth);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DisplayHtmlValuesExtractor", "getDataPrefix"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDataSuffix() {
        if ("</table></div></div>" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DisplayHtmlValuesExtractor", "getDataSuffix"));
        }
        return "</table></div></div>";
    }

    @Override
    @NotNull
    public String getLinePrefix() {
        if ("<tr align=left>" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DisplayHtmlValuesExtractor", "getLinePrefix"));
        }
        return "<tr align=left>";
    }

    @Override
    @NotNull
    public String getValuePrefix() {
        String string = "<td align=left style='background-color: #" + this.myHex + "'>" + VALUE_SECTION_OPEN;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DisplayHtmlValuesExtractor", "getValuePrefix"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getValueSuffix() {
        if ("</code></pre></div></td>" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DisplayHtmlValuesExtractor", "getValueSuffix"));
        }
        return "</code></pre></div></td>";
    }

    @Override
    public String getLineSeparator() {
        return "";
    }

    @Override
    @NotNull
    public String getColumnName(DataConsumer.Column column) {
        String string = "<th align=left style='background-color: #" + this.myHex + "'>" + VALUE_SECTION_OPEN + this.getName(column) + VALUE_SECTION_CLOSE + "</th>";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DisplayHtmlValuesExtractor", "getColumnName"));
        }
        return string;
    }

    @NotNull
    protected String getName(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/extractors/DisplayHtmlValuesExtractor", "getName"));
        }
        String string = column.name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DisplayHtmlValuesExtractor", "getName"));
        }
        return string;
    }

    @Override
    protected TranspositionAwareDefaultExtractor.TranspositionAwareExtractionBase startExtraction(CharOut out, DatabaseDialectEx dialect, boolean forceSkipHeader, boolean transposedMode, List<DataConsumer.Column> allColumns, int ... selectedColumns) {
        return new MyExtraction(out, dialect, forceSkipHeader, transposedMode, allColumns, selectedColumns);
    }

    @NotNull
    public static String getHeader() {
        if ("<html><body>" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DisplayHtmlValuesExtractor", "getHeader"));
        }
        return "<html><body>";
    }

    @NotNull
    public static String getTail() {
        if ("</body></html>" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DisplayHtmlValuesExtractor", "getTail"));
        }
        return "</body></html>";
    }

    private class MyExtraction
    extends TranspositionAwareDefaultExtractor.TranspositionAwareExtractionBase {
        public MyExtraction(CharOut output, DatabaseDialectEx dialect, boolean forceSkipHeader, boolean transpose, List<DataConsumer.Column> allColumns, int[] selectedColumnIndices) {
            super(DisplayHtmlValuesExtractor.this, output, dialect, forceSkipHeader, transpose, allColumns, selectedColumnIndices);
        }

        @Override
        protected void doAppendHeader(boolean appendNewLine) {
            this.myOutput.append(DisplayHtmlValuesExtractor.this.getDataPrefix());
            super.doAppendHeader(appendNewLine);
        }

        @Override
        protected void doAppendFooter() {
            this.myOutput.append(DisplayHtmlValuesExtractor.this.getDataSuffix());
        }
    }
}

