/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.BaseIntrospectionFunctions;
import com.intellij.database.introspection.BaseIntrospector;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.queryRewriting.CommonPreprocessor;
import com.intellij.database.queryRewriting.Evaluator;
import com.intellij.database.queryRewriting.MapEvaluator;
import com.intellij.database.util.Case;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PairConsumer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBQueryRunner;
import org.jetbrains.dekaf.core.DBSession;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.InSession;
import org.jetbrains.dekaf.core.InSessionNoResult;
import org.jetbrains.dekaf.core.InTransaction;
import org.jetbrains.dekaf.core.InTransactionNoResult;
import org.jetbrains.dekaf.sql.SqlQuery;
import org.jetbrains.dekaf.util.StringOperator;
import org.jetbrains.dekaf.util.Version;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u0006*\b\b\u0003\u0010\u0007*\u00020\u00062\u00020\b:\u0006\u0098\u0001\u0099\u0001\u009a\u0001B9\b\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00030\f\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020\u0015H\u0016J\u0016\u0010Z\u001a\u00028\u00002\u0006\u00101\u001a\u00020\u0002H\u0083\b\u00a2\u0006\u0002\u0010[J\r\u0010\\\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u00103J\b\u0010]\u001a\u00020XH\u0016J9\u0010^\u001a\u0002H_\"\u0004\b\u0004\u0010_2#\b\u0004\u0010`\u001a\u001d\u0012\u0013\u0012\u00110b\u00a2\u0006\f\bc\u0012\b\bd\u0012\u0004\b\b(e\u0012\u0004\u0012\u0002H_0aH\u0084\b\u00a2\u0006\u0002\u0010fJ3\u0010^\u001a\u00020X2#\b\u0004\u0010`\u001a\u001d\u0012\u0013\u0012\u00110b\u00a2\u0006\f\bc\u0012\b\bd\u0012\u0004\b\b(e\u0012\u0004\u0012\u00020X0aH\u0085\b\u00a2\u0006\u0002\bgJ9\u0010h\u001a\u0002H_\"\u0004\b\u0004\u0010_2#\b\u0004\u0010`\u001a\u001d\u0012\u0013\u0012\u00110i\u00a2\u0006\f\bc\u0012\b\bd\u0012\u0004\b\b(j\u0012\u0004\u0012\u0002H_0aH\u0084\b\u00a2\u0006\u0002\u0010fJ3\u0010h\u001a\u00020X2#\b\u0004\u0010`\u001a\u001d\u0012\u0013\u0012\u00110i\u00a2\u0006\f\bc\u0012\b\bd\u0012\u0004\b\b(j\u0012\u0004\u0012\u00020X0aH\u0085\b\u00a2\u0006\u0002\bkJ\u0012\u0010l\u001a\u00020X2\b\u00101\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010m\u001a\u00020XH\u0014J\b\u0010n\u001a\u00020XH\u0014J!\u0010o\u001a\u00020X2\u0012\u0010p\u001a\n\u0012\u0006\b\u0001\u0012\u00020r0q\"\u00020rH\u0016\u00a2\u0006\u0002\u0010sJ \u0010t\u001a\u00020X2\u0006\u0010j\u001a\u00020i2\u000e\u0010p\u001a\n\u0012\u0004\u0012\u00020r\u0018\u00010uH$J9\u0010v\u001a\u00020X2\u0006\u0010w\u001a\u00020r2\u0006\u0010x\u001a\u00020*2\u0006\u0010y\u001a\u00020z2\u0012\u0010{\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0q\"\u00020#H\u0016\u00a2\u0006\u0002\u0010|J\b\u0010}\u001a\u00020XH\u0016J\u0010\u0010~\u001a\u00020X2\u0006\u0010j\u001a\u00020iH$J\b\u0010\u007f\u001a\u00020XH\u0016J\u0010\u0010\u007f\u001a\u00020X2\u0006\u0010j\u001a\u00020iH\u0014J\u0018\u0010\u0080\u0001\u001a\u00020*2\u0007\u0010\u0081\u0001\u001a\u00028\u0002H\u0014\u00a2\u0006\u0003\u0010\u0082\u0001J\u0011\u0010\u0083\u0001\u001a\u00020*2\u0006\u00101\u001a\u00020\u0002H\u0014J1\u0010\u0084\u0001\u001a\u0003H\u0085\u0001\"\u0005\b\u0004\u0010\u0085\u00012\u0007\u0010\u0086\u0001\u001a\u00020i2\u000f\u0010\u0087\u0001\u001a\n\u0012\u0005\u0012\u0003H\u0085\u00010\u0088\u0001H\u0004\u00a2\u0006\u0003\u0010\u0089\u0001J(\u0010\u0084\u0001\u001a\u0003H\u0085\u0001\"\u0005\b\u0004\u0010\u0085\u00012\u000f\u0010\u0087\u0001\u001a\n\u0012\u0005\u0012\u0003H\u0085\u00010\u0088\u0001H\u0004\u00a2\u0006\u0003\u0010\u008a\u0001J\t\u0010\u008b\u0001\u001a\u00020XH\u0004J\u0012\u0010\u008c\u0001\u001a\u00020X2\u0007\u0010\u008d\u0001\u001a\u00020\u0004H\u0004J\u001c\u0010\u008e\u0001\u001a\u00020X2\u0006\u0010d\u001a\u00020#2\t\u0010\u008f\u0001\u001a\u0004\u0018\u00010QH\u0004J\u0012\u0010\u0090\u0001\u001a\u00020X2\u0007\u0010\u0091\u0001\u001a\u00020#H\u0004J\u001b\u0010\u0092\u0001\u001a\u00020X2\u0007\u0010\u0093\u0001\u001a\u00020#2\u0007\u0010\u0091\u0001\u001a\u00020#H\u0004J\u0018\u0010\u0094\u0001\u001a\u00020*2\u0007\u0010\u0081\u0001\u001a\u00028\u0002H\u0014\u00a2\u0006\u0003\u0010\u0082\u0001J\u001c\u0010\u0095\u0001\u001a\u00020X2\u0010\b\u0004\u0010\u0096\u0001\u001a\t\u0012\u0004\u0012\u00020X0\u0097\u0001H\u0084\bR\u0014\u0010\u0010\u001a\u00020\u00118DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R(\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015@BX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR$\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u001b@BX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R&\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020*8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010.R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00030\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010.R\u0014\u00101\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u001c\u00104\u001a\u0004\u0018\u000105X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u0014\u0010:\u001a\u00020*X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010,R*\u0010<\u001a\u0004\u0018\u00018\u00002\b\u0010\u0014\u001a\u0004\u0018\u00018\u0000@BX\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010@\u001a\u0004\b=\u00103\"\u0004\b>\u0010?R\u001a\u0010A\u001a\u00020BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u0010\u0010G\u001a\u00020H8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010I\u001a\u0004\u0018\u00010JX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\u001c\u0010O\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020Q0P8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010SR$\u0010T\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u001b@BX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bU\u0010\u001e\"\u0004\bV\u0010 \u00a8\u0006\u009b\u0001"}, d2={"Lcom/intellij/database/introspection/BaseIntrospector;", "MM", "Lcom/intellij/database/model/basic/BasicModModel;", "MR", "Lcom/intellij/database/model/basic/BasicModRoot;", "S", "Lcom/intellij/database/model/basic/BasicSchema;", "MS", "Lcom/intellij/database/introspection/DBIntrospector;", "rdbms", "Lorg/jetbrains/dekaf/Rdbms;", "modModelClass", "Ljava/lang/Class;", "modRootClass", "modSchemaClass", "(Lorg/jetbrains/dekaf/Rdbms;Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;)V", "dbConnectionInfo", "Lorg/jetbrains/dekaf/core/ConnectionInfo;", "getDbConnectionInfo", "()Lorg/jetbrains/dekaf/core/ConnectionInfo;", "<set-?>", "Lorg/jetbrains/dekaf/core/DBFacade;", "dbFacade", "getDbFacade", "()Lorg/jetbrains/dekaf/core/DBFacade;", "setDbFacade", "(Lorg/jetbrains/dekaf/core/DBFacade;)V", "Lorg/jetbrains/dekaf/util/Version;", "driverVersion", "getDriverVersion", "()Lorg/jetbrains/dekaf/util/Version;", "setDriverVersion", "(Lorg/jetbrains/dekaf/util/Version;)V", "errorSink", "Lcom/intellij/util/PairConsumer;", "", "", "getErrorSink", "()Lcom/intellij/util/PairConsumer;", "setErrorSink", "(Lcom/intellij/util/PairConsumer;)V", "initialized", "", "getInitialized", "()Z", "getModModelClass", "()Ljava/lang/Class;", "getModRootClass", "getModSchemaClass", "model", "getModel", "()Lcom/intellij/database/model/basic/BasicModModel;", "modelFactory", "Lcom/intellij/database/model/impl/ModelFactory;", "getModelFactory$database_introspection", "()Lcom/intellij/database/model/impl/ModelFactory;", "setModelFactory$database_introspection", "(Lcom/intellij/database/model/impl/ModelFactory;)V", "myConsiderSystemSchemasReinstrospection", "getMyConsiderSystemSchemasReinstrospection", "myModel", "getMyModel", "setMyModel", "(Lcom/intellij/database/model/basic/BasicModModel;)V", "Lcom/intellij/database/model/basic/BasicModModel;", "options", "Lcom/intellij/database/introspection/DBIntrospectionOptions;", "getOptions", "()Lcom/intellij/database/introspection/DBIntrospectionOptions;", "setOptions", "(Lcom/intellij/database/introspection/DBIntrospectionOptions;)V", "preprocessor", "Lcom/intellij/database/queryRewriting/CommonPreprocessor;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getProgressIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "setProgressIndicator", "(Lcom/intellij/openapi/progress/ProgressIndicator;)V", "queryParameters", "", "", "getRdbms", "()Lorg/jetbrains/dekaf/Rdbms;", "serverVersion", "getServerVersion", "setServerVersion", "attachToDB", "", "db", "castModel", "(Lcom/intellij/database/model/basic/BasicModModel;)Lcom/intellij/database/model/basic/BasicModModel;", "createNewModel", "detachFromDB", "inSession", "T", "block", "Lkotlin/Function1;", "Lorg/jetbrains/dekaf/core/DBSession;", "Lkotlin/ParameterName;", "name", "session", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "inSessionUnit", "inTransaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "tran", "inTransactionUnit", "init", "initConnectionRelatedState", "initModelRelatedState", "introspectAuto", "namespaces", "", "Lcom/intellij/database/model/basic/BasicNamespace;", "([Lcom/intellij/database/model/basic/BasicNamespace;)V", "introspectAutoInTran", "", "introspectFragment", "namespace", "withSources", "objectKind", "Lcom/intellij/database/model/ObjectKind;", "objectNames", "(Lcom/intellij/database/model/basic/BasicNamespace;ZLcom/intellij/database/model/ObjectKind;[Ljava/lang/String;)V", "introspectNamespaces", "introspectNamespacesInTran", "introspectSessionState", "isPossibleToIntrospectSchemaIncrementally", "schema", "(Lcom/intellij/database/model/basic/BasicSchema;)Z", "modelCanBeAccepted", "performQuery", "R", "transaction", "query", "Lorg/jetbrains/dekaf/sql/SqlQuery;", "(Lorg/jetbrains/dekaf/core/DBTransaction;Lorg/jetbrains/dekaf/sql/SqlQuery;)Ljava/lang/Object;", "(Lorg/jetbrains/dekaf/sql/SqlQuery;)Ljava/lang/Object;", "postIntrospectionProcess", "postIntrospectionProcessWithModel", "root", "setQueryParameter", "value", "updateDetails", "details", "updateStatus", "status", "whetherSourcesActual", "writeSources", "r", "Lkotlin/Function0;", "AbstractRetriever", "DatabaseRetriever", "SchemaRetriever", "database-introspection"})
public abstract class BaseIntrospector<MM extends BasicModModel, MR extends BasicModRoot, S extends BasicSchema, MS extends BasicSchema>
implements DBIntrospector {
    @Nullable
    private ModelFactory modelFactory;
    @NotNull
    private PairConsumer<String, Throwable> errorSink;
    private final boolean myConsiderSystemSchemasReinstrospection;
    @Nullable
    private MM myModel;
    @NotNull
    private DBIntrospectionOptions options;
    @Nullable
    private ProgressIndicator progressIndicator;
    @Nullable
    private DBFacade dbFacade;
    @NotNull
    private Version serverVersion;
    @NotNull
    private Version driverVersion;
    @JvmField
    @NotNull
    protected final Map<String, Object> queryParameters;
    @JvmField
    @NotNull
    protected final CommonPreprocessor preprocessor;
    @NotNull
    private final Rdbms rdbms;
    @NotNull
    private final Class<MM> modModelClass;
    @NotNull
    private final Class<MR> modRootClass;
    @NotNull
    private final Class<MS> modSchemaClass;

    @Nullable
    public final ModelFactory getModelFactory$database_introspection() {
        return this.modelFactory;
    }

    public final void setModelFactory$database_introspection(@Nullable ModelFactory modelFactory) {
        this.modelFactory = modelFactory;
    }

    @Override
    @NotNull
    public PairConsumer<String, Throwable> getErrorSink() {
        return this.errorSink;
    }

    @Override
    public void setErrorSink(@NotNull PairConsumer<String, Throwable> pairConsumer) {
        Intrinsics.checkParameterIsNotNull(pairConsumer, (String)"<set-?>");
        this.errorSink = pairConsumer;
    }

    protected final boolean getMyConsiderSystemSchemasReinstrospection() {
        return this.myConsiderSystemSchemasReinstrospection;
    }

    @Nullable
    protected final MM getMyModel() {
        return this.myModel;
    }

    private final void setMyModel(MM MM) {
        this.myModel = MM;
    }

    @Override
    @NotNull
    public final DBIntrospectionOptions getOptions() {
        return this.options;
    }

    @Override
    public final void setOptions(@NotNull DBIntrospectionOptions dBIntrospectionOptions) {
        Intrinsics.checkParameterIsNotNull((Object)dBIntrospectionOptions, (String)"<set-?>");
        this.options = dBIntrospectionOptions;
    }

    @Override
    @Nullable
    public final ProgressIndicator getProgressIndicator() {
        return this.progressIndicator;
    }

    @Override
    public final void setProgressIndicator(@Nullable ProgressIndicator progressIndicator) {
        this.progressIndicator = progressIndicator;
    }

    @Nullable
    protected final DBFacade getDbFacade() {
        return this.dbFacade;
    }

    private final void setDbFacade(DBFacade dBFacade) {
        this.dbFacade = dBFacade;
    }

    @NotNull
    protected final Version getServerVersion() {
        return this.serverVersion;
    }

    private final void setServerVersion(Version version) {
        this.serverVersion = version;
    }

    @NotNull
    protected final Version getDriverVersion() {
        return this.driverVersion;
    }

    private final void setDriverVersion(Version version) {
        this.driverVersion = version;
    }

    protected final boolean getInitialized() {
        return this.myModel != null && this.dbFacade != null;
    }

    @Override
    public void init(@Nullable BasicModModel model) {
        if (this.myModel != null) {
            throw (Throwable)new IllegalStateException(this.getClass().getSimpleName() + " is already initialized");
        }
        if (model != null && this.modelCanBeAccepted(model)) {
            BaseIntrospector baseIntrospector = this;
            BaseIntrospector baseIntrospector2 = this;
            BasicModModel basicModModel = model;
            baseIntrospector2.myModel = basicModModel;
        } else {
            this.myModel = this.createNewModel();
        }
        this.initModelRelatedState();
    }

    private final MM castModel(BasicModModel model) {
        BasicModModel basicModModel = model;
        if (basicModModel == null) {
            throw new TypeCastException("null cannot be cast to non-null type MM");
        }
        return (MM)basicModModel;
    }

    protected boolean modelCanBeAccepted(@NotNull BasicModModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        return this.modModelClass.isAssignableFrom(model.getClass());
    }

    protected void initModelRelatedState() {
    }

    protected void initConnectionRelatedState() {
    }

    @NotNull
    protected MM createNewModel() {
        Object object = this.modelFactory;
        if (object == null || (object = (BasicModModel)((ModelFactory)object).createModel(this.rdbms, this.modModelClass)) == null) {
            throw (Throwable)new IllegalStateException("Model Factory is not specified");
        }
        return (MM)object;
    }

    @NotNull
    public MM getModel() {
        MM MM;
        if (this.myModel != null) {
            MM = this.myModel;
            if (MM == null) {
                Intrinsics.throwNpe();
            }
        } else {
            throw (Throwable)new IllegalStateException("The introspector is not initialized yet: model is not created");
        }
        return MM;
    }

    @Override
    public void attachToDB(@NotNull DBFacade db) {
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        boolean bl = Intrinsics.areEqual((Object)db.rdbms(), (Object)this.rdbms);
        if (_Assertions.ENABLED && !bl) {
            String string = this.getClass().getSimpleName() + " expects a connection to " + this.rdbms + " but got to " + db.rdbms() + " that is not good";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (this.dbFacade != null) {
            this.detachFromDB();
        }
        this.dbFacade = db;
        ConnectionInfo connectionInfo = db.getConnectionInfo();
        Version version = connectionInfo.serverVersion;
        Intrinsics.checkExpressionValueIsNotNull((Object)version, (String)"connectionInfo.serverVersion");
        this.serverVersion = version;
        Version version2 = connectionInfo.driverVersion;
        Intrinsics.checkExpressionValueIsNotNull((Object)version2, (String)"connectionInfo.driverVersion");
        this.driverVersion = version2;
        this.initConnectionRelatedState();
    }

    @Override
    public void detachFromDB() {
        this.dbFacade = null;
        Version version = Version.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)version, (String)"Version.ZERO");
        this.serverVersion = version;
        Version version2 = Version.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)version2, (String)"Version.ZERO");
        this.driverVersion = version2;
    }

    @NotNull
    protected final ConnectionInfo getDbConnectionInfo() {
        DBFacade dBFacade = this.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf = dBFacade;
        ConnectionInfo connectionInfo = dbf.getConnectionInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)connectionInfo, (String)"dbf.connectionInfo");
        return connectionInfo;
    }

    protected final <T> T inSession(@NotNull Function1<? super DBSession, ? extends T> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        DBFacade dBFacade = this.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf = dBFacade;
        Object result2 = dbf.inSession(new InSession<T>(block){
            final /* synthetic */ Function1 $block;

            public final T run(@NotNull DBSession session) {
                Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
                DBSession dBSession = session;
                Intrinsics.checkExpressionValueIsNotNull((Object)dBSession, (String)"session");
                return (T)this.$block.invoke((Object)dBSession);
            }
            {
                this.$block = function1;
            }
        });
        return (T)result2;
    }

    @JvmName(name="inSessionUnit")
    protected final void inSessionUnit(@NotNull Function1<? super DBSession, Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        DBFacade dBFacade = this.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf = dBFacade;
        dbf.inSession(new InSessionNoResult(block){
            final /* synthetic */ Function1 $block;

            public final void run(@NotNull DBSession session) {
                Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
                DBSession dBSession = session;
                Intrinsics.checkExpressionValueIsNotNull((Object)dBSession, (String)"session");
                this.$block.invoke((Object)dBSession);
            }
            {
                this.$block = function1;
            }
        });
    }

    protected final <T> T inTransaction(@NotNull Function1<? super DBTransaction, ? extends T> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        DBFacade dBFacade = this.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf = dBFacade;
        Object result2 = dbf.inTransaction(new InTransaction<T>(block){
            final /* synthetic */ Function1 $block;

            public final T run(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                DBTransaction dBTransaction = tran;
                Intrinsics.checkExpressionValueIsNotNull((Object)dBTransaction, (String)"tran");
                return (T)this.$block.invoke((Object)dBTransaction);
            }
            {
                this.$block = function1;
            }
        });
        return (T)result2;
    }

    @JvmName(name="inTransactionUnit")
    protected final void inTransactionUnit(@NotNull Function1<? super DBTransaction, Unit> block) {
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        DBFacade dBFacade = this.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf = dBFacade;
        dbf.inTransaction(new InTransactionNoResult(block){
            final /* synthetic */ Function1 $block;

            public final void run(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                DBTransaction dBTransaction = tran;
                Intrinsics.checkExpressionValueIsNotNull((Object)dBTransaction, (String)"tran");
                this.$block.invoke((Object)dBTransaction);
            }
            {
                this.$block = function1;
            }
        });
    }

    protected final void setQueryParameter(@NotNull String name, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (value != null) {
            Map<String, Object> map = this.queryParameters;
            Object object = value;
            map.put(name, object);
        } else {
            this.queryParameters.remove(name);
        }
    }

    protected final <R> R performQuery(@NotNull SqlQuery<R> query) {
        Intrinsics.checkParameterIsNotNull(query, (String)"query");
        SqlQuery preprocessedQuery = query.rewrite((StringOperator)this.preprocessor);
        BaseIntrospector this_$iv = this;
        DBFacade dBFacade = this_$iv.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf$iv = dBFacade;
        Object result$iv = dbf$iv.inTransaction(new InTransaction<R>(this, preprocessedQuery){
            final /* synthetic */ BaseIntrospector this$0;
            final /* synthetic */ SqlQuery $preprocessedQuery$inlined;
            {
                this.this$0 = baseIntrospector;
                this.$preprocessedQuery$inlined = sqlQuery;
            }

            public final R run(DBTransaction tran) {
                DBTransaction dBTransaction = tran;
                Intrinsics.checkExpressionValueIsNotNull((Object)dBTransaction, (String)"tran");
                DBTransaction tran2 = dBTransaction;
                Object[] objectArray = this.this$0.preprocessor.getBindableParameters();
                return (R)tran2.query(this.$preprocessedQuery$inlined).withParams(Arrays.copyOf(objectArray, objectArray.length)).run();
            }
        });
        return (R)result$iv;
    }

    protected final <R> R performQuery(@NotNull DBTransaction transaction, @NotNull SqlQuery<R> query) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull(query, (String)"query");
        SqlQuery preprocessedQuery = query.rewrite((StringOperator)this.preprocessor);
        Object[] objectArray = this.preprocessor.getBindableParameters();
        return (R)transaction.query(preprocessedQuery).withParams(Arrays.copyOf(objectArray, objectArray.length)).run();
    }

    protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull S schema) {
        Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
        return schema.getIntrospectionTimestamp() != null && (Intrinsics.areEqual((Object)((Object)this.options.getSources()), (Object)((Object)DBIntrospectionOptions.SourceLoading.NO_SOURCES)) || this.whetherSourcesActual(schema));
    }

    protected boolean whetherSourcesActual(@NotNull S schema) {
        Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
        Date date = schema.getIntrospectionTimestamp();
        return Intrinsics.areEqual((Object)this.getModel().getSchemaSourcesVersion((BasicSchema)schema), (Object)(date != null ? Long.valueOf(date.getTime()) : null));
    }

    @Override
    public void introspectAuto(BasicNamespace ... namespaces) {
        Intrinsics.checkParameterIsNotNull((Object)namespaces, (String)"namespaces");
        if (!this.getInitialized()) {
            throw (Throwable)new IllegalStateException("Introspector is not initialized yet.");
        }
        int n = ((Object[])namespaces).length;
        ArrayList<BasicNamespace> theNamespaces = new ArrayList<BasicNamespace>(n);
        if (n > 0) {
            for (int j = 0; j < namespaces.length; ++j) {
                boolean bl;
                BasicNamespace ns = namespaces[j];
                boolean bl2 = bl = ns.getModel() == this.getModel();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Namespaces must be from this model";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                theNamespaces.add(ns);
            }
        }
        BaseIntrospector this_$iv = this;
        DBFacade dBFacade = this_$iv.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf$iv = dBFacade;
        dbf$iv.inTransaction(new InTransactionNoResult(this, theNamespaces){
            final /* synthetic */ BaseIntrospector this$0;
            final /* synthetic */ ArrayList $theNamespaces$inlined;
            {
                this.this$0 = baseIntrospector;
                this.$theNamespaces$inlined = arrayList;
            }

            public final void run(DBTransaction tran) {
                DBTransaction dBTransaction = tran;
                Intrinsics.checkExpressionValueIsNotNull((Object)dBTransaction, (String)"tran");
                DBTransaction tran2 = dBTransaction;
                this.this$0.introspectAutoInTran(tran2, this.$theNamespaces$inlined);
            }
        });
    }

    protected abstract void introspectAutoInTran(@NotNull DBTransaction var1, @Nullable Collection<? extends BasicNamespace> var2);

    @Override
    public void introspectNamespaces() {
        if (!this.getInitialized()) {
            throw (Throwable)new IllegalStateException("Introspector is not initialized yet.");
        }
        BaseIntrospector this_$iv = this;
        DBFacade dBFacade = this_$iv.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf$iv = dBFacade;
        dbf$iv.inTransaction(new InTransactionNoResult(this){
            final /* synthetic */ BaseIntrospector this$0;
            {
                this.this$0 = baseIntrospector;
            }

            public final void run(DBTransaction tran) {
                DBTransaction dBTransaction = tran;
                Intrinsics.checkExpressionValueIsNotNull((Object)dBTransaction, (String)"tran");
                DBTransaction it = dBTransaction;
                this.this$0.introspectNamespacesInTran(it);
            }
        });
    }

    protected abstract void introspectNamespacesInTran(@NotNull DBTransaction var1);

    @Override
    public void introspectSessionState() {
        if (!this.getInitialized()) {
            throw (Throwable)new IllegalStateException("Introspector is not initialized yet.");
        }
        BaseIntrospector this_$iv = this;
        DBFacade dBFacade = this_$iv.dbFacade;
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf$iv = dBFacade;
        dbf$iv.inTransaction(new InTransactionNoResult(this){
            final /* synthetic */ BaseIntrospector this$0;
            {
                this.this$0 = baseIntrospector;
            }

            public final void run(DBTransaction tran) {
                DBTransaction dBTransaction = tran;
                Intrinsics.checkExpressionValueIsNotNull((Object)dBTransaction, (String)"tran");
                DBTransaction it = dBTransaction;
                this.this$0.introspectSessionState(it);
            }
        });
    }

    protected void introspectSessionState(@NotNull DBTransaction tran) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
    }

    @Override
    public void introspectFragment(@NotNull BasicNamespace namespace, boolean withSources, @NotNull ObjectKind objectKind, String ... objectNames) {
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)objectKind, (String)"objectKind");
        Intrinsics.checkParameterIsNotNull((Object)objectNames, (String)"objectNames");
    }

    protected final void postIntrospectionProcess() {
        this.getModel().modify(BasicModRoot.class, (ModelModifier<BasicModRoot>)new ModelModifier<BasicModRoot>(this){
            final /* synthetic */ BaseIntrospector this$0;

            public final void perform(BasicModRoot r) {
                BasicModRoot basicModRoot = r;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicModRoot, (String)"r");
                this.this$0.postIntrospectionProcessWithModel(basicModRoot);
            }
            {
                this.this$0 = baseIntrospector;
            }
        });
    }

    protected final void postIntrospectionProcessWithModel(@NotNull BasicModRoot root2) {
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        for (BasicModSchema basicModSchema : root2.getAllSchemas()) {
            BaseIntrospectionFunctions.derefAll(basicModSchema);
        }
    }

    protected final void updateStatus(@NotNull String status, @NotNull String details) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
            Intrinsics.checkParameterIsNotNull((Object)details, (String)"details");
            ProgressIndicator progressIndicator = this.progressIndicator;
            if (progressIndicator != null) {
                progressIndicator.checkCanceled();
            }
            ProgressIndicator progressIndicator2 = this.progressIndicator;
            if (progressIndicator2 != null) {
                progressIndicator2.setText(status);
            }
            ProgressIndicator progressIndicator3 = this.progressIndicator;
            if (progressIndicator3 == null) break block2;
            progressIndicator3.setText2(StringUtil.capitalize((String)Case.LOWER.apply(details)));
        }
    }

    protected final void updateDetails(@NotNull String details) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)details, (String)"details");
            ProgressIndicator progressIndicator = this.progressIndicator;
            if (progressIndicator != null) {
                progressIndicator.checkCanceled();
            }
            ProgressIndicator progressIndicator2 = this.progressIndicator;
            if (progressIndicator2 == null) break block1;
            progressIndicator2.setText2(StringUtil.capitalize((String)Case.LOWER.apply(details)));
        }
    }

    protected final void writeSources(@NotNull Function0<Unit> r) {
        Intrinsics.checkParameterIsNotNull(r, (String)"r");
        this.getModel().writeSources(new Runnable(r){
            final /* synthetic */ Function0 $r;

            public final void run() {
                this.$r.invoke();
            }
            {
                this.$r = function0;
            }
        });
    }

    @NotNull
    public final Rdbms getRdbms() {
        return this.rdbms;
    }

    @NotNull
    protected final Class<MM> getModModelClass() {
        return this.modModelClass;
    }

    @NotNull
    protected final Class<MR> getModRootClass() {
        return this.modRootClass;
    }

    @NotNull
    protected final Class<MS> getModSchemaClass() {
        return this.modSchemaClass;
    }

    protected BaseIntrospector(@NotNull Rdbms rdbms, @NotNull Class<MM> modModelClass, @NotNull Class<MR> modRootClass, @NotNull Class<MS> modSchemaClass) {
        Intrinsics.checkParameterIsNotNull((Object)rdbms, (String)"rdbms");
        Intrinsics.checkParameterIsNotNull(modModelClass, (String)"modModelClass");
        Intrinsics.checkParameterIsNotNull(modRootClass, (String)"modRootClass");
        Intrinsics.checkParameterIsNotNull(modSchemaClass, (String)"modSchemaClass");
        this.rdbms = rdbms;
        this.modModelClass = modModelClass;
        this.modRootClass = modRootClass;
        this.modSchemaClass = modSchemaClass;
        this.errorSink = errorSink.1.INSTANCE;
        Version version = Version.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)version, (String)"Version.ZERO");
        this.serverVersion = version;
        Version version2 = Version.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)version2, (String)"Version.ZERO");
        this.driverVersion = version2;
        this.queryParameters = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        this.preprocessor = new CommonPreprocessor(true, new MapEvaluator(this.queryParameters));
        this.dbFacade = this.dbFacade;
        this.options = BaseIntrospectionFunctions.DEFAULT_OPTIONS;
        Version version3 = Version.ZERO;
        if (version3 == null) {
            Intrinsics.throwNpe();
        }
        this.serverVersion = version3;
        Version version4 = Version.ZERO;
        if (version4 == null) {
            Intrinsics.throwNpe();
        }
        this.driverVersion = version4;
        this.myConsiderSystemSchemasReinstrospection = BaseIntrospectionFunctions.stringToBoolean(System.getProperty("dbe.always.reintrospect.system.schemas"));
    }

    public static final /* synthetic */ void access$setDbFacade$p(BaseIntrospector $this, @Nullable DBFacade dBFacade) {
        $this.dbFacade = dBFacade;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u00a4\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001b\u001a\u00020\u0011H\u0016J\u001f\u0010\u001c\u001a\u00020\u001d2\u0014\b\u0004\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u001d0\u001fH\u0084\bJ\b\u0010 \u001a\u00020\u001dH\u0016J!\u0010!\u001a\u0002H\"\"\u0004\b\u0004\u0010\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\"0$H\u0004\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020\u001dH\u0014J\b\u0010'\u001a\u00020\u001dH&J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u0011H\u0014J\u001a\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u00112\b\u0010,\u001a\u0004\u0018\u00010\u0012H\u0004R\u0016\u0010\u0005\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR<\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010@BX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006-"}, d2={"Lcom/intellij/database/introspection/BaseIntrospector$AbstractRetriever;", "Lcom/intellij/database/queryRewriting/Evaluator;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "(Lcom/intellij/database/introspection/BaseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;)V", "model", "getModel", "()Lcom/intellij/database/model/basic/BasicModModel;", "Lcom/intellij/database/model/basic/BasicModModel;", "<set-?>", "Lcom/intellij/database/queryRewriting/CommonPreprocessor;", "preprocessor", "getPreprocessor", "()Lcom/intellij/database/queryRewriting/CommonPreprocessor;", "setPreprocessor", "(Lcom/intellij/database/queryRewriting/CommonPreprocessor;)V", "", "", "", "queryParameters", "getQueryParameters", "()Ljava/util/Map;", "setQueryParameters", "(Ljava/util/Map;)V", "getTransaction", "()Lorg/jetbrains/dekaf/core/DBTransaction;", "evaluate", "expression", "inModel", "", "modifier", "Lkotlin/Function1;", "init", "performQuery", "R", "query", "Lorg/jetbrains/dekaf/sql/SqlQuery;", "(Lorg/jetbrains/dekaf/sql/SqlQuery;)Ljava/lang/Object;", "prepareParameters", "process", "reportRetrieving", "what", "setQueryParameter", "name", "value", "database-introspection"})
    protected abstract class AbstractRetriever
    implements Evaluator {
        @NotNull
        private final MM model;
        @NotNull
        private Map<String, Object> queryParameters;
        @NotNull
        private CommonPreprocessor preprocessor;
        @NotNull
        private final DBTransaction transaction;

        @NotNull
        protected final MM getModel() {
            return this.model;
        }

        @NotNull
        protected final Map<String, Object> getQueryParameters() {
            Map<String, Object> map = this.queryParameters;
            if (map == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"queryParameters");
            }
            return map;
        }

        private final void setQueryParameters(Map<String, Object> map) {
            this.queryParameters = map;
        }

        @NotNull
        protected final CommonPreprocessor getPreprocessor() {
            CommonPreprocessor commonPreprocessor = this.preprocessor;
            if (commonPreprocessor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"preprocessor");
            }
            return commonPreprocessor;
        }

        private final void setPreprocessor(CommonPreprocessor commonPreprocessor) {
            this.preprocessor = commonPreprocessor;
        }

        public void init() {
            this.queryParameters = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
            this.preprocessor = new CommonPreprocessor(true, this);
            Map<String, Object> map = this.queryParameters;
            if (map == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"queryParameters");
            }
            map.putAll(BaseIntrospector.this.queryParameters);
            this.prepareParameters();
        }

        protected void prepareParameters() {
        }

        protected final void inModel(@NotNull Function1<? super MR, Unit> modifier) {
            Intrinsics.checkParameterIsNotNull(modifier, (String)"modifier");
            this.model.modify(BaseIntrospector.this.modRootClass, new ModelModifier<MR>(modifier){
                final /* synthetic */ Function1 $modifier;

                public final void perform(MR root2) {
                    MR MR = root2;
                    Intrinsics.checkExpressionValueIsNotNull(MR, (String)"root");
                    this.$modifier.invoke(MR);
                }
                {
                    this.$modifier = function1;
                }
            });
        }

        public abstract void process();

        protected final void setQueryParameter(@NotNull String name, @Nullable Object value) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            if (value != null) {
                Map<String, Object> map = this.queryParameters;
                if (map == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"queryParameters");
                }
                map.put(name, value);
            } else {
                Map<String, Object> map = this.queryParameters;
                if (map == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"queryParameters");
                }
                map.remove(name);
            }
        }

        @Override
        @Nullable
        public Object evaluate(@NotNull String expression) {
            Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
            Map<String, Object> map = this.queryParameters;
            if (map == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"queryParameters");
            }
            return map.get(expression);
        }

        protected final <R> R performQuery(@NotNull SqlQuery<R> query) {
            Intrinsics.checkParameterIsNotNull(query, (String)"query");
            CommonPreprocessor commonPreprocessor = this.preprocessor;
            if (commonPreprocessor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"preprocessor");
            }
            SqlQuery preprocessedQuery = query.rewrite((StringOperator)commonPreprocessor);
            DBQueryRunner dBQueryRunner = this.transaction.query(preprocessedQuery);
            CommonPreprocessor commonPreprocessor2 = this.preprocessor;
            if (commonPreprocessor2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"preprocessor");
            }
            Object[] objectArray = commonPreprocessor2.getBindableParameters();
            return (R)dBQueryRunner.withParams(Arrays.copyOf(objectArray, objectArray.length)).run();
        }

        protected void reportRetrieving(@NotNull String what) {
            Intrinsics.checkParameterIsNotNull((Object)what, (String)"what");
            BaseIntrospector.this.updateStatus("Introspecting database", what);
        }

        @NotNull
        protected final DBTransaction getTransaction() {
            return this.transaction;
        }

        public AbstractRetriever(DBTransaction transaction) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            this.transaction = transaction;
            this.model = BaseIntrospector.this.getModel();
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00a4\u0004\u0018\u00002\u001e0\u0001R\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0002B\u000f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/introspection/BaseIntrospector$DatabaseRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector$AbstractRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "(Lcom/intellij/database/introspection/BaseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;)V", "database-introspection"})
    protected abstract class DatabaseRetriever
    extends AbstractRetriever {
        protected DatabaseRetriever(DBTransaction transaction) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            super(transaction);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00a4\u0004\u0018\u00002\u001e0\u0001R\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010/\u001a\u000200H\u0014J\b\u00101\u001a\u000200H\u0014J\b\u00102\u001a\u000200H\u0014J\b\u00103\u001a\u000200H\u0014J\u001f\u00104\u001a\u0002002\u0014\b\u0004\u00105\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00020006H\u0084\bJ\b\u00107\u001a\u000200H\u0014J\b\u00108\u001a\u000200H\u0016J\u0006\u00109\u001a\u000200J\u0006\u0010:\u001a\u000200J\b\u0010;\u001a\u000200H\u0014J\b\u0010<\u001a\u000200H\u0014J\u0010\u0010=\u001a\u0002002\u0006\u0010>\u001a\u00020?H\u0015J\u0010\u0010=\u001a\u0002002\u0006\u0010@\u001a\u00020AH\u0005R\u001a\u0010\n\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0018\u001a\u00020\u0019X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u0019X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0016\u0010\u0005\u001a\u00028\u0002X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010%\u001a\u0004\b#\u0010$R\u001a\u0010&\u001a\u00020\u0019X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001b\"\u0004\b(\u0010\u001dR\u001a\u0010)\u001a\u00020*X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u0006B"}, d2={"Lcom/intellij/database/introspection/BaseIntrospector$SchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector$AbstractRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schema", "(Lcom/intellij/database/introspection/BaseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/basic/BasicSchema;)V", "mode", "Lcom/intellij/database/introspection/IntrospectionMode;", "(Lcom/intellij/database/introspection/BaseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/basic/BasicSchema;Lcom/intellij/database/introspection/IntrospectionMode;)V", "fragmentKind", "Lcom/intellij/database/model/ObjectKind;", "getFragmentKind", "()Lcom/intellij/database/model/ObjectKind;", "setFragmentKind", "(Lcom/intellij/database/model/ObjectKind;)V", "fragmentNames", "", "", "getFragmentNames", "()[Ljava/lang/String;", "setFragmentNames", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "fromTimestamp", "Ljava/sql/Timestamp;", "getFromTimestamp", "()Ljava/sql/Timestamp;", "setFromTimestamp", "(Ljava/sql/Timestamp;)V", "introspectionBeginTimestamp", "getIntrospectionBeginTimestamp", "setIntrospectionBeginTimestamp", "getMode", "()Lcom/intellij/database/introspection/IntrospectionMode;", "getSchema", "()Lcom/intellij/database/model/basic/BasicSchema;", "Lcom/intellij/database/model/basic/BasicSchema;", "sourcesSince", "getSourcesSince", "setSourcesSince", "withSources", "", "getWithSources", "()Z", "setWithSources", "(Z)V", "analyzeBriefInfo", "", "analyzeCurrentContent", "clearSchema", "finishSchema", "inSchema", "modifier", "Lkotlin/Function1;", "prepareParameters", "process", "processMainPhase", "processPreliminaryPhase", "retrieveMainContent", "retrieveMajorNames", "work", "runnable", "Ljava/lang/Runnable;", "block", "Lorg/jetbrains/dekaf/core/InTransactionNoResult;", "database-introspection"})
    protected abstract class SchemaRetriever
    extends AbstractRetriever {
        @NotNull
        private final S schema;
        @NotNull
        private final IntrospectionMode mode;
        private boolean withSources;
        @NotNull
        private ObjectKind fragmentKind;
        @NotNull
        private String[] fragmentNames;
        @NotNull
        private Timestamp fromTimestamp;
        @NotNull
        private Timestamp sourcesSince;
        @Nullable
        private Timestamp introspectionBeginTimestamp;
        final /* synthetic */ BaseIntrospector this$0;

        @NotNull
        protected final S getSchema() {
            return this.schema;
        }

        @NotNull
        protected final IntrospectionMode getMode() {
            return this.mode;
        }

        protected final boolean getWithSources() {
            return this.withSources;
        }

        protected final void setWithSources(boolean bl) {
            this.withSources = bl;
        }

        @NotNull
        protected final ObjectKind getFragmentKind() {
            return this.fragmentKind;
        }

        protected final void setFragmentKind(@NotNull ObjectKind objectKind) {
            Intrinsics.checkParameterIsNotNull((Object)objectKind, (String)"<set-?>");
            this.fragmentKind = objectKind;
        }

        @NotNull
        protected final String[] getFragmentNames() {
            return this.fragmentNames;
        }

        protected final void setFragmentNames(@NotNull String[] stringArray) {
            Intrinsics.checkParameterIsNotNull((Object)stringArray, (String)"<set-?>");
            this.fragmentNames = stringArray;
        }

        @NotNull
        protected final Timestamp getFromTimestamp() {
            return this.fromTimestamp;
        }

        protected final void setFromTimestamp(@NotNull Timestamp timestamp) {
            Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"<set-?>");
            this.fromTimestamp = timestamp;
        }

        @NotNull
        protected final Timestamp getSourcesSince() {
            return this.sourcesSince;
        }

        protected final void setSourcesSince(@NotNull Timestamp timestamp) {
            Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"<set-?>");
            this.sourcesSince = timestamp;
        }

        @Nullable
        protected final Timestamp getIntrospectionBeginTimestamp() {
            return this.introspectionBeginTimestamp;
        }

        protected final void setIntrospectionBeginTimestamp(@Nullable Timestamp timestamp) {
            this.introspectionBeginTimestamp = timestamp;
        }

        @Override
        protected void prepareParameters() {
            super.prepareParameters();
            this.getQueryParameters().putAll(this.this$0.queryParameters);
            this.setQueryParameter("SCHEMA_NAME", this.schema instanceof BasicNamedElement ? this.schema.getRealName() : null);
            this.setQueryParameter("SCHEMA_ID", this.schema instanceof BasicIdentifiedElement && ((BasicIdentifiedElement)this.schema).getObjectId() != Long.MIN_VALUE ? Long.valueOf(((BasicIdentifiedElement)this.schema).getObjectId()) : null);
            String string = this.mode.code;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mode.code");
            this.setQueryParameter(string, Boolean.TRUE);
            this.setQueryParameter("SINCE", this.fromTimestamp);
        }

        protected final void inSchema(@NotNull Function1<? super MS, Unit> modifier) {
            Intrinsics.checkParameterIsNotNull(modifier, (String)"modifier");
            this.getModel().modify((BasicElement)this.schema, this.this$0.modSchemaClass, new ModelModifier<MS>(modifier){
                final /* synthetic */ Function1 $modifier;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    this.$modifier.invoke(MS);
                }
                {
                    this.$modifier = function1;
                }
            });
        }

        @Override
        public void process() {
            this.processPreliminaryPhase();
            this.processMainPhase();
        }

        public final void processPreliminaryPhase() {
            if (this.mode.fragment) {
                return;
            }
            this.analyzeBriefInfo();
            if (this.mode.increment) {
                this.analyzeCurrentContent();
            } else {
                this.clearSchema();
                this.retrieveMajorNames();
            }
        }

        public final void processMainPhase() {
            this.retrieveMainContent();
            this.finishSchema();
        }

        @Deprecated(message="use inModel,inSchema instead", replaceWith=@ReplaceWith(imports={}, expression="inSchema"))
        protected void work(@NotNull Runnable runnable) {
            Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
            this.getModel().modify(BasicModRoot.class, (ModelModifier<BasicModRoot>)new ModelModifier<BasicModRoot>(runnable){
                final /* synthetic */ Runnable $runnable;

                public final void perform(BasicModRoot r) {
                    this.$runnable.run();
                }
                {
                    this.$runnable = runnable;
                }
            });
        }

        @Deprecated(message="use inModel,inSchema instead", replaceWith=@ReplaceWith(imports={}, expression="inSchema"))
        protected final void work(@NotNull InTransactionNoResult block) {
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            this.getModel().modify(BasicModRoot.class, (ModelModifier<BasicModRoot>)new ModelModifier<BasicModRoot>(this, block){
                final /* synthetic */ SchemaRetriever this$0;
                final /* synthetic */ InTransactionNoResult $block;

                public final void perform(BasicModRoot r) {
                    this.$block.run(this.this$0.getTransaction());
                }
                {
                    this.this$0 = schemaRetriever;
                    this.$block = inTransactionNoResult;
                }
            });
        }

        protected void analyzeBriefInfo() {
        }

        protected void analyzeCurrentContent() {
        }

        protected void retrieveMajorNames() {
        }

        protected void retrieveMainContent() {
        }

        protected void finishSchema() {
            if (this.withSources) {
                Timestamp timestamp = this.introspectionBeginTimestamp;
                this.getModel().setSchemaSourcesVersion((BasicSchema)this.schema, timestamp != null ? Long.valueOf(timestamp.getTime()) : Long.valueOf(0L));
            }
        }

        protected void clearSchema() {
            this.getModel().modify((BasicElement)((BasicElement)this.schema), BasicModSchema.class, clearSchema.1.INSTANCE);
            this.getModel().setSchemaSourcesVersion((BasicSchema)this.schema, null);
        }

        public SchemaRetriever(@NotNull DBTransaction transaction, S schema) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            this($outer, transaction, (BasicSchema)schema, schema.hasChildren() && $outer.isPossibleToIntrospectSchemaIncrementally(schema) ? IntrospectionMode.INCREMENT : IntrospectionMode.FULL);
        }

        /*
         * WARNING - Possible parameter corruption
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public SchemaRetriever(@NotNull DBTransaction transaction, @NotNull S schema, IntrospectionMode mode) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
            super(transaction);
            this.this$0 = $outer;
            v0 = ObjectKind.NONE;
            if (v0 == null) {
                Intrinsics.throwNpe();
            }
            this.fragmentKind = v0;
            var7_5 = this;
            var8_6 = new String[]{};
            var7_5.fragmentNames = var8_6;
            this.fromTimestamp = BaseIntrospectionFunctions.AGES_AGO;
            this.sourcesSince = BaseIntrospectionFunctions.AGES_AGO;
            this.schema = schema;
            this.mode = mode;
            this.withSources = $outer.getOptions().getSources().compareTo((Enum)DBIntrospectionOptions.SourceLoading.USER_SOURCES) >= 0;
            lastIntrospectionTimestamp = schema.getIntrospectionTimestamp();
            this.fromTimestamp = mode.increment != false && lastIntrospectionTimestamp != null ? new Timestamp(lastIntrospectionTimestamp.getTime()) : BaseIntrospectionFunctions.AGES_AGO;
            existentSourcesVersion = this.getModel().getSchemaSourcesVersion((BasicSchema)schema);
            if (!mode.increment) ** GOTO lbl-1000
            v1 = existentSourcesVersion;
            if (v1 == null) {
                v1 = 0L;
            }
            if (Intrinsics.compare((long)v1, (long)0) > 0) {
                v2 = existentSourcesVersion;
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"existentSourcesVersion!!");
                v3 = new Timestamp(v2);
            } else lbl-1000:
            // 2 sources

            {
                v3 = BaseIntrospectionFunctions.AGES_AGO;
            }
            this.sourcesSince = v3;
        }
    }
}

