/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.BaseIntrospectionFunctions;
import com.intellij.database.introspection.DBIntrospectionException;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.GenericIntrospectorHelper;
import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.introspection.jdbcMetadataWrappers.ClosableIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.introspection.jdbcMetadataWrappers.MetaDataUtil;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModLikeTable;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.model.properties.JdbcTableType;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBSession;

public class GenericIntrospector
implements DBIntrospector {
    private final Rdbms myRdbms;
    private DBFacade myFacade;
    private ProgressIndicator myIndicator;
    private ModelFactory myModelFactory;
    private PairConsumer<String, Throwable> myErrorSink;
    private String[] myTableTypes;
    private Set<ObjectKind> myTableKinds;
    private GenericIntrospectorHelper myHelper;
    private ConnectionInfo myInfo;
    @Nullable
    private SourceLoader mySrcLoader;
    private boolean myWithSources;
    public static final Map<Rdbms, PerObjectVersion> VERSIONS = new FactoryMap<Rdbms, PerObjectVersion>(){

        @Nullable
        protected PerObjectVersion create(Rdbms key) {
            return PerObjectVersion.DEFAULT.INSTANCE;
        }
    };

    public GenericIntrospector(@NotNull Rdbms rdbms) {
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/database/introspection/GenericIntrospector", "<init>"));
        }
        this.myIndicator = DumbProgressIndicator.INSTANCE;
        this.mySrcLoader = null;
        this.myWithSources = false;
        this.myRdbms = rdbms;
    }

    public void setModelFactory(ModelFactory modelFactory) {
        this.myModelFactory = modelFactory;
    }

    @Override
    public void init(@Nullable BasicModModel model) {
        if (this.myHelper != null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " already initialized");
        }
        Rdbms rdbms = this.myRdbms;
        BasicModModel theModel = this.createModelIfNotSuitable(rdbms, model);
        this.myHelper = new GenericIntrospectorHelper(theModel, rdbms);
    }

    @Override
    public void attachToDB(@NotNull DBFacade db) {
        if (db == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "db", "com/intellij/database/introspection/GenericIntrospector", "attachToDB"));
        }
        if (this.myFacade != null) {
            this.detachFromDB();
        }
        if (db.rdbms() != this.myRdbms) {
            throw new AssertionError((Object)("Database type changed while introspecting (" + this.myRdbms.code + " -> " + db.rdbms().code + ")"));
        }
        this.myFacade = db;
        this.myInfo = this.myFacade.getConnectionInfo();
        if (this.myWithSources) {
            for (SourceLoaderProvider provider : (SourceLoaderProvider[])SourceLoaderProvider.EP_NAME.getExtensions()) {
                this.mySrcLoader = provider.create(this.myFacade);
                if (this.mySrcLoader != null) break;
            }
        }
    }

    @Override
    public void detachFromDB() {
        this.myFacade = null;
        this.myInfo = null;
        this.mySrcLoader = null;
    }

    private BasicModModel createModelIfNotSuitable(@NotNull Rdbms rdbms, @Nullable BasicModModel model) {
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/database/introspection/GenericIntrospector", "createModelIfNotSuitable"));
        }
        if (model != null && model.getRdbms() == rdbms) {
            return model;
        }
        return this.myModelFactory.createModel(rdbms);
    }

    @Override
    public void setOptions(@NotNull DBIntrospectionOptions options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/introspection/GenericIntrospector", "setOptions"));
        }
        this.myWithSources = options.getSources() != DBIntrospectionOptions.SourceLoading.NO_SOURCES;
    }

    @Override
    @NotNull
    public DBIntrospectionOptions getOptions() {
        DBIntrospectionOptions dBIntrospectionOptions = BaseIntrospectionFunctions.DEFAULT_OPTIONS;
        if (dBIntrospectionOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/GenericIntrospector", "getOptions"));
        }
        return dBIntrospectionOptions;
    }

    @Override
    @NotNull
    public BasicModModel getModel() {
        BasicModModel basicModModel = this.myHelper.getModel();
        if (basicModModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/GenericIntrospector", "getModel"));
        }
        return basicModModel;
    }

    @Override
    public void setProgressIndicator(@Nullable ProgressIndicator indicator) {
        this.myIndicator = indicator != null ? indicator : DumbProgressIndicator.INSTANCE;
    }

    @Override
    @Nullable
    public ProgressIndicator getProgressIndicator() {
        return this.myIndicator;
    }

    @Override
    public void introspectAuto(BasicNamespace ... namespaces) {
        if (namespaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaces", "com/intellij/database/introspection/GenericIntrospector", "introspectAuto"));
        }
        if (this.myFacade == null) {
            throw new AssertionError((Object)"Not connected to database");
        }
        this.getModel().modify(BasicModRoot.class, root2 -> {
            if (namespaces == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaces", "com/intellij/database/introspection/GenericIntrospector", "lambda$introspectAuto$1"));
            }
            this.myFacade.inSession(s -> {
                if (namespaces == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaces", "com/intellij/database/introspection/GenericIntrospector", "lambda$null$0"));
                }
                DatabaseMetaDataWrapper meta = this.createMeta(s);
                this.myHelper.setCasing(meta.getCasing());
                if (namespaces.length == 0) {
                    this.introspectDatabaseList(meta);
                }
                this.introspectSchemas(meta, (JBIterable<BasicModSchema>)this.schemas(namespaces).filter(BasicNamespace::isVisible));
            });
        });
    }

    @Override
    public void introspectNamespaces() {
        if (this.myFacade == null) {
            throw new AssertionError((Object)"Not connected to database");
        }
        this.getModel().modify(BasicModRoot.class, root2 -> this.myFacade.inSession(s -> {
            DatabaseMetaDataWrapper meta = this.createMeta(s);
            this.myHelper.setCasing(meta.getCasing());
            this.introspectDatabaseList(meta);
        }));
    }

    @Override
    public void introspectDatabaseSchemas(BasicDatabase ... databases) {
        if (databases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databases", "com/intellij/database/introspection/GenericIntrospector", "introspectDatabaseSchemas"));
        }
        if (this.myFacade == null) {
            throw new AssertionError((Object)"Not connected to database");
        }
        this.getModel().modify(BasicModRoot.class, root2 -> {
            if (databases == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databases", "com/intellij/database/introspection/GenericIntrospector", "lambda$introspectDatabaseSchemas$5"));
            }
            this.myFacade.inSession(s -> {
                if (databases == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databases", "com/intellij/database/introspection/GenericIntrospector", "lambda$null$4"));
                }
                DatabaseMetaDataWrapper meta = this.createMeta(s);
                this.myHelper.setCasing(meta.getCasing());
                this.introspectSchemaList(meta, (JBIterable<BasicModDatabase>)JBIterable.of((Object[])databases).filter(BasicModDatabase.class));
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void introspectSchemas(@NotNull DatabaseMetaDataWrapper meta, @NotNull JBIterable<BasicModSchema> schemas) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/introspection/GenericIntrospector", "introspectSchemas"));
        }
        if (schemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemas", "com/intellij/database/introspection/GenericIntrospector", "introspectSchemas"));
        }
        try {
            this.myTableTypes = meta.getAllTableTypes();
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)"Failed to retrieve table types", (Object)e);
            this.myTableTypes = null;
        }
        this.myTableKinds = ArrayUtil.isEmpty((Object[])this.myTableTypes) ? null : JBIterable.of((Object[])this.myTableTypes).transform(x -> JdbcTableType.findByName(x).getKind()).toSet();
        MultiMap byCatalog = MultiMap.create();
        for (BasicModSchema schema : schemas) {
            byCatalog.putValue((Object)this.myHelper.getDatabase(schema), (Object)schema);
        }
        String catalog = null;
        try {
            catalog = meta.getConnection().getCatalog();
            this.introspectSchemasByCatalogs(meta, (MultiMap<BasicModNamespace, BasicModSchema>)byCatalog);
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)"Failed to get current catalog", (Object)e);
        }
        finally {
            JdbcUtil.setCatalogSafe((Connection)meta.getConnection(), (String)catalog);
        }
    }

    private void introspectSchemasByCatalogs(@NotNull DatabaseMetaDataWrapper meta, @NotNull MultiMap<BasicModNamespace, BasicModSchema> byCatalog) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/introspection/GenericIntrospector", "introspectSchemasByCatalogs"));
        }
        if (byCatalog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "byCatalog", "com/intellij/database/introspection/GenericIntrospector", "introspectSchemasByCatalogs"));
        }
        GenericIntrospector.forEachSchemaInCatalog(meta, byCatalog, s -> {
            if (meta == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/introspection/GenericIntrospector", "lambda$introspectSchemasByCatalogs$7"));
            }
            this.introspectTablesInSchema(meta, (BasicModSchema)s);
            this.introspectRoutinesInSchema(meta, (BasicModSchema)s);
            this.introspectTypesInSchema(meta, (BasicModSchema)s);
        });
        GenericIntrospector.forEachSchemaInCatalog(meta, byCatalog, s -> {
            if (meta == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/introspection/GenericIntrospector", "lambda$introspectSchemasByCatalogs$9"));
            }
            this.introspectColumnsInSchema(meta, (BasicModSchema)s);
            ModNamingFamily<BasicModNamedElement> tables = GenericIntrospectorLegacyModelUtils.familyOf(s, ObjectKind.TABLE);
            if (tables != null) {
                tables.forEach(t -> {
                    if (meta == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/introspection/GenericIntrospector", "lambda$null$8"));
                    }
                    this.introspectTableKeys(meta, (BasicModLikeTable)((Object)t));
                });
            }
            this.introspectPrototypesInSchema(meta, (BasicModSchema)s);
            this.introspectTypeAttributesInSchema(meta, (BasicModSchema)s);
        });
        GenericIntrospector.forEachSchemaInCatalog(meta, byCatalog, s -> {
            if (meta == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/introspection/GenericIntrospector", "lambda$introspectSchemasByCatalogs$12"));
            }
            ModNamingFamily<BasicModNamedElement> tables = GenericIntrospectorLegacyModelUtils.familyOf(s, ObjectKind.TABLE);
            if (tables != null) {
                tables.forEach(t -> {
                    if (meta == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/introspection/GenericIntrospector", "lambda$null$10"));
                    }
                    this.introspectTableForeignKeys(meta, (BasicModLikeTable)((Object)t));
                });
                tables.forEach(t -> {
                    if (meta == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/introspection/GenericIntrospector", "lambda$null$11"));
                    }
                    this.introspectTableIndices(meta, (BasicModLikeTable)((Object)t));
                });
            }
        });
        if (this.mySrcLoader != null) {
            this.getModel().writeSources(() -> {
                if (meta == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/introspection/GenericIntrospector", "lambda$introspectSchemasByCatalogs$14"));
                }
                if (byCatalog == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "byCatalog", "com/intellij/database/introspection/GenericIntrospector", "lambda$introspectSchemasByCatalogs$14"));
                }
                GenericIntrospector.forEachSchemaInCatalog(meta, byCatalog, s -> {
                    if (meta == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/introspection/GenericIntrospector", "lambda$null$13"));
                    }
                    this.myIndicator.checkCanceled();
                    this.myIndicator.setText("Sources in " + MetaDataUtil.qName(s));
                    this.mySrcLoader.loadSources((Iterable<BasicModSourceAware>)((JBTreeTraverser)DasUtil.dasTraverser().withRoot(s)).filter(BasicModSourceAware.class), meta.getConnection());
                });
            });
        }
    }

    private static void forEachCatalog(@NotNull DatabaseMetaDataWrapper meta, @NotNull MultiMap<BasicModNamespace, BasicModSchema> grouped, @NotNull Consumer<Iterable<BasicModSchema>> process) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/introspection/GenericIntrospector", "forEachCatalog"));
        }
        if (grouped == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grouped", "com/intellij/database/introspection/GenericIntrospector", "forEachCatalog"));
        }
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/database/introspection/GenericIntrospector", "forEachCatalog"));
        }
        for (Map.Entry entry : grouped.entrySet()) {
            JdbcUtil.setCatalogSafe((Connection)meta.getConnection(), entry.getKey() == null ? null : ((BasicModNamespace)entry.getKey()).getName());
            process.accept((Iterable<BasicModSchema>)entry.getValue());
        }
    }

    private static void forEachSchemaInCatalog(@NotNull DatabaseMetaDataWrapper meta, @NotNull MultiMap<BasicModNamespace, BasicModSchema> grouped, @NotNull Consumer<BasicModSchema> process) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/introspection/GenericIntrospector", "forEachSchemaInCatalog"));
        }
        if (grouped == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grouped", "com/intellij/database/introspection/GenericIntrospector", "forEachSchemaInCatalog"));
        }
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/database/introspection/GenericIntrospector", "forEachSchemaInCatalog"));
        }
        GenericIntrospector.forEachCatalog(meta, grouped, ss -> {
            if (process == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/database/introspection/GenericIntrospector", "lambda$forEachSchemaInCatalog$15"));
            }
            ss.forEach(process);
        });
    }

    private void introspectTablesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/introspection/GenericIntrospector", "introspectTablesInSchema"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/GenericIntrospector", "introspectTablesInSchema"));
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Table list in " + MetaDataUtil.qName(schema));
        JBIterable<ModFamily<? extends BasicModLikeTable>> families = this.getTableFamilies(schema);
        families.forEach(ModFamily::markChildrenAsSyncPending);
        try (ClosableIt<? extends DatabaseMetaDataWrapper.Table> tableIt = meta.tables(this.myHelper.asSchema(schema), null, this.myTableTypes);){
            for (DatabaseMetaDataWrapper.Table table : JBIterable.once(tableIt)) {
                this.myIndicator.checkCanceled();
                this.myHelper.createTable(schema, table);
            }
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)("Failed to retrieve tables in " + MetaDataUtil.qName(schema)), (Object)e);
        }
        families.forEach(GenericIntrospector::cleanupFamily);
    }

    @NotNull
    private JBIterable<ModFamily<? extends BasicModLikeTable>> getTableFamilies(@NotNull BasicModSchema schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/GenericIntrospector", "getTableFamilies"));
        }
        JBIterable kinds = JBIterable.from(ModelConsts.LIKE_TABLE_KINDS);
        if (this.myTableKinds != null) {
            kinds = kinds.filter(this.myTableKinds::contains);
        }
        JBIterable jBIterable = kinds.transform(k -> {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/GenericIntrospector", "lambda$getTableFamilies$16"));
            }
            return GenericIntrospectorLegacyModelUtils.familyOf(schema, k);
        }).filter(Conditions.notNull());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/GenericIntrospector", "getTableFamilies"));
        }
        return jBIterable;
    }

    private void introspectTableKeys(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModLikeTable table) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/introspection/GenericIntrospector", "introspectTableKeys"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/introspection/GenericIntrospector", "introspectTableKeys"));
        }
        if (table.getKind() != ObjectKind.TABLE) {
            return;
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Keys in " + MetaDataUtil.qName(table));
        ((ModFamily)table.getKeys()).markChildrenAsSyncPending();
        try (ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableKey, DatabaseMetaDataWrapper.TableKeyColumn> keyIt = meta.tableKeys(this.myHelper.asTable(table));){
            this.myHelper.createKeys(table, keyIt);
        }
        catch (Exception ex) {
            this.myErrorSink.consume((Object)MetaDataUtil.qName(table), (Object)ex);
        }
        GenericIntrospector.cleanupFamily((ModFamily)table.getKeys());
    }

    private void introspectTableForeignKeys(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModLikeTable table) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/introspection/GenericIntrospector", "introspectTableForeignKeys"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/introspection/GenericIntrospector", "introspectTableForeignKeys"));
        }
        if (table.getKind() != ObjectKind.TABLE) {
            return;
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Foreign keys in " + MetaDataUtil.qName(table));
        ((ModFamily)table.getForeignKeys()).markChildrenAsSyncPending();
        try (ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableFKey, DatabaseMetaDataWrapper.TableFKeyColumn> fkColumnIt = meta.tableFKeyColumns(this.myHelper.asTable(table));){
            this.myHelper.createForeignKeys(table, fkColumnIt);
        }
        catch (Exception ex) {
            this.myErrorSink.consume((Object)MetaDataUtil.qName(table), (Object)ex);
        }
        GenericIntrospector.cleanupFamily((ModFamily)table.getForeignKeys());
    }

    private void introspectTableIndices(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModLikeTable table) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/introspection/GenericIntrospector", "introspectTableIndices"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/introspection/GenericIntrospector", "introspectTableIndices"));
        }
        if (table.getKind() != ObjectKind.TABLE) {
            return;
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Indices in " + MetaDataUtil.qName(table));
        ((ModFamily)table.getIndices()).markChildrenAsSyncPending();
        try (ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableIndex, DatabaseMetaDataWrapper.TableIndexColumn> indexColumnIt = meta.tableIndexColumns(this.myHelper.asTable(table));){
            this.myHelper.createIndices(table, indexColumnIt);
        }
        catch (Exception ex) {
            this.myErrorSink.consume((Object)MetaDataUtil.qName(table), (Object)ex);
        }
        GenericIntrospector.cleanupFamily((ModFamily)table.getIndices());
    }

    private void introspectColumnsInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/introspection/GenericIntrospector", "introspectColumnsInSchema"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/GenericIntrospector", "introspectColumnsInSchema"));
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Table columns in " + MetaDataUtil.qName(schema));
        JBIterable tables = this.getTableFamilies(schema).flatten(s -> s).filter(BasicModLikeTable.class);
        HashMap name2Table = ContainerUtil.newHashMap();
        for (Object table : tables) {
            GenericIntrospector.markChildrenAsSyncPending(GenericIntrospectorLegacyModelUtils.familyOf((BasicModElement)table, ObjectKind.COLUMN));
            name2Table.put(table.getName(), table);
        }
        try {
            Object table;
            ClosableIt.GroupingIt<DatabaseMetaDataWrapper.Table, DatabaseMetaDataWrapper.TableColumn> columnIt = meta.tableColumns(this.myHelper.asSchema(schema), null, name2Table.keySet());
            table = null;
            try {
                for (DatabaseMetaDataWrapper.Table table2 : JBIterable.once(columnIt)) {
                    this.myIndicator.checkCanceled();
                    this.myHelper.createColumns((BasicModLikeTable)name2Table.get(table2.name), (Iterator<DatabaseMetaDataWrapper.TableColumn>)columnIt.groupIt());
                }
            }
            catch (Throwable throwable) {
                table = throwable;
                throw throwable;
            }
            finally {
                if (columnIt != null) {
                    if (table != null) {
                        try {
                            columnIt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)table).addSuppressed(throwable);
                        }
                    } else {
                        columnIt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)MetaDataUtil.qName(schema), (Object)e);
        }
        for (Object table : tables) {
            GenericIntrospector.cleanupFamily((ModFamily)table.familyOf(ObjectKind.COLUMN));
        }
    }

    private void introspectTypeAttributesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/introspection/GenericIntrospector", "introspectTypeAttributesInSchema"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/GenericIntrospector", "introspectTypeAttributesInSchema"));
        }
        this.myIndicator.checkCanceled();
        ModNamingFamily<Object> types = GenericIntrospectorLegacyModelUtils.familyOf(schema, ObjectKind.OBJECT_TYPE);
        if (types == null || types.isEmpty()) {
            return;
        }
        this.myIndicator.setText("Type attributes in " + MetaDataUtil.qName(schema));
        HashMap name2Type = ContainerUtil.newHashMap();
        for (Object type : types) {
            GenericIntrospector.markChildrenAsSyncPending(GenericIntrospectorLegacyModelUtils.familyOf((BasicModElement)type, ObjectKind.OBJECT_ATTRIBUTE));
            name2Type.put(type.getName(), type);
        }
        try {
            Object type;
            ClosableIt.GroupingIt<DatabaseMetaDataWrapper.UserDefinedType, DatabaseMetaDataWrapper.UserDefinedTypeAttribute> attrIt = meta.userDefinedTypeAttributes(this.myHelper.asSchema(schema), null, name2Type.keySet());
            type = null;
            try {
                for (DatabaseMetaDataWrapper.UserDefinedType type2 : JBIterable.once(attrIt)) {
                    this.myIndicator.checkCanceled();
                    this.myHelper.createUserDefinedTypeAttributes((BasicModElement)name2Type.get(type2.name), (Iterator<DatabaseMetaDataWrapper.UserDefinedTypeAttribute>)attrIt.groupIt());
                }
            }
            catch (Throwable throwable) {
                type = throwable;
                throw throwable;
            }
            finally {
                if (attrIt != null) {
                    if (type != null) {
                        try {
                            attrIt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)type).addSuppressed(throwable);
                        }
                    } else {
                        attrIt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)MetaDataUtil.qName(schema), (Object)e);
        }
        for (Object type : types) {
            GenericIntrospector.cleanupFamily((ModFamily)type.familyOf(ObjectKind.OBJECT_ATTRIBUTE));
        }
    }

    private void introspectPrototypesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/introspection/GenericIntrospector", "introspectPrototypesInSchema"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/GenericIntrospector", "introspectPrototypesInSchema"));
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Prototypes in " + MetaDataUtil.qName(schema));
        JBIterable<ModFamily<?>> routineFamilies = this.getRoutineFamilies(schema);
        JBIterable routines = routineFamilies.flatten(r -> r).filter(BasicModRoutine.class);
        GenericIntrospectorHelper.RoutineMap map = this.myHelper.createRoutineMap();
        for (Object routine2 : routines) {
            GenericIntrospector.markChildrenAsSyncPending(GenericIntrospectorLegacyModelUtils.familyOf((BasicModElement)routine2, ObjectKind.ARGUMENT));
            map.put((BasicModRoutine)routine2);
        }
        try {
            Object routine2;
            ClosableIt.GroupingIt<DatabaseMetaDataWrapper.Routine, DatabaseMetaDataWrapper.RoutineArgument> argumentIt = meta.routineArguments(this.myHelper.asSchema(schema), null, (Function<DatabaseMetaDataWrapper.Routine, DasRoutine.Kind>)((Function)map::guessType));
            routine2 = null;
            try {
                for (DatabaseMetaDataWrapper.Routine routine3 : JBIterable.once(argumentIt)) {
                    this.myIndicator.checkCanceled();
                    this.myHelper.createArguments(map.get(routine3), (Iterator<DatabaseMetaDataWrapper.RoutineArgument>)argumentIt.groupIt());
                }
            }
            catch (Throwable throwable) {
                routine2 = throwable;
                throw throwable;
            }
            finally {
                if (argumentIt != null) {
                    if (routine2 != null) {
                        try {
                            argumentIt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)routine2).addSuppressed(throwable);
                        }
                    } else {
                        argumentIt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)MetaDataUtil.qName(schema), (Object)e);
        }
        for (Object routine2 : routines) {
            GenericIntrospector.cleanupFamily(routine2.familyOf(ObjectKind.ARGUMENT));
        }
        routineFamilies.forEach(ModFamily::sort);
    }

    private void introspectRoutinesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/introspection/GenericIntrospector", "introspectRoutinesInSchema"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/GenericIntrospector", "introspectRoutinesInSchema"));
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Routine list in " + MetaDataUtil.qName(schema));
        JBIterable<ModFamily<?>> routineFamilies = this.getRoutineFamilies(schema);
        routineFamilies.forEach(ModFamily::markChildrenAsSyncPending);
        try (ClosableIt<DatabaseMetaDataWrapper.Routine> routineIt = meta.routines(this.myHelper.asSchema(schema), null, null);){
            for (DatabaseMetaDataWrapper.Routine routine2 : JBIterable.once(routineIt)) {
                this.myIndicator.checkCanceled();
                this.myHelper.createRoutine(schema, routine2);
            }
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)("Failed to retrieve routines in " + MetaDataUtil.qName(schema)), (Object)e);
        }
        routineFamilies.forEach(GenericIntrospector::cleanupFamily);
    }

    private void introspectAdditionalTypes(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/introspection/GenericIntrospector", "introspectAdditionalTypes"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/GenericIntrospector", "introspectAdditionalTypes"));
        }
        ObjectKind target = null;
        String scName = schema.getName();
        if (this.myHelper.getFamilyId().isSybase() && "dbo".equalsIgnoreCase(scName)) {
            target = ObjectKind.ALIAS_TYPE;
        }
        if (target != null) {
            try (ClosableIt<? extends DatabaseMetaDataWrapper.Type> typesIt = meta.types();){
                for (DatabaseMetaDataWrapper.Type type : JBIterable.once(typesIt)) {
                    this.myIndicator.checkCanceled();
                    this.myHelper.createType(schema, type, target);
                }
            }
            catch (SQLException e) {
                this.myErrorSink.consume((Object)("Failed to retrieve types in " + MetaDataUtil.qName(schema)), (Object)e);
            }
        }
    }

    private void introspectTypesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull BasicModSchema schema) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/introspection/GenericIntrospector", "introspectTypesInSchema"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/GenericIntrospector", "introspectTypesInSchema"));
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Types list in " + MetaDataUtil.qName(schema));
        JBIterable<ModFamily<?>> userDefinedTypeFamilies = this.getUserDefinedTypeFamilies(schema);
        userDefinedTypeFamilies.forEach(ModFamily::markChildrenAsSyncPending);
        try (ClosableIt<? extends DatabaseMetaDataWrapper.UserDefinedType> userDefinedTypesIt = meta.userDefinedTypes(this.myHelper.asSchema(schema), null);){
            for (DatabaseMetaDataWrapper.UserDefinedType userDefinedType : JBIterable.once(userDefinedTypesIt)) {
                this.myIndicator.checkCanceled();
                this.myHelper.createUserDefinedType(schema, userDefinedType);
            }
        }
        catch (SQLException e) {
            this.myErrorSink.consume((Object)("Failed to retrieve user types in " + MetaDataUtil.qName(schema)), (Object)e);
        }
        this.introspectAdditionalTypes(meta, schema);
        userDefinedTypeFamilies.forEach(GenericIntrospector::cleanupFamily);
    }

    private void introspectDatabaseList(@NotNull DatabaseMetaDataWrapper meta) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/introspection/GenericIntrospector", "introspectDatabaseList"));
        }
        Family<? extends BasicElement> databases = this.getModel().getRoot().familyOf(ObjectKind.DATABASE);
        if (databases != null) {
            try (ClosableIt<String> dbIt = meta.databases();){
                this.fillDatabases((Iterator<String>)((Object)dbIt));
            }
            catch (SQLException e) {
                throw new GenericIntrospectionException("Failed to retrieve databases", e);
            }
            this.introspectSchemaList(meta, (JBIterable<BasicModDatabase>)JBIterable.from(databases).filter(BasicModDatabase.class).filter(db -> db.isCurrent()));
        } else if (this.getModel().getRoot().familyOf(ObjectKind.SCHEMA) != null) {
            this.introspectSchemaList(meta, (JBIterable<BasicModDatabase>)JBIterable.empty());
        } else {
            throw new GenericIntrospectionException("Model does not contain database/schema namespace", null);
        }
    }

    private void introspectSchemaList(@NotNull DatabaseMetaDataWrapper meta, @NotNull JBIterable<BasicModDatabase> databases) {
        Throwable throwable;
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/introspection/GenericIntrospector", "introspectSchemaList"));
        }
        if (databases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databases", "com/intellij/database/introspection/GenericIntrospector", "introspectSchemaList"));
        }
        for (BasicModDatabase db : databases) {
            db.getSchemas().markChildrenAsSyncPending();
        }
        JBIterable dbs = databases.transform(DasUtil.TO_NAME);
        if (databases.isEmpty() && this.myHelper.isSchemaDbMode()) {
            try {
                throwable = null;
                try (ClosableIt<String> dbIt = meta.databases();){
                    dbs = JBIterable.from((Iterable)ContainerUtil.collect(dbIt));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                throw new GenericIntrospectionException("Failed to retrieve schemas", e);
            }
        }
        try {
            throwable = null;
            try (ClosableIt<DatabaseMetaDataWrapper.Schema> schemaIt = meta.schemas((JBIterable<String>)dbs);){
                this.fillSchemas((Iterator<DatabaseMetaDataWrapper.Schema>)((Object)schemaIt));
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (SQLException e) {
            throw new GenericIntrospectionException("Failed to retrieve schemas", e);
        }
        for (BasicModDatabase db : databases) {
            GenericIntrospector.cleanupFamily((ModFamily)((Object)db.getSchemas()));
        }
    }

    @Nullable
    private <T extends BasicNamespace> T getCurrentOrSole(@NotNull Iterable<? extends T> namespaces) {
        if (namespaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaces", "com/intellij/database/introspection/GenericIntrospector", "getCurrentOrSole"));
        }
        JBIterable nsp = JBIterable.from(namespaces);
        BasicNamespace current = (BasicNamespace)nsp.filter(this::isCurrent).first();
        if (current != null) {
            return (T)current;
        }
        if (nsp.size() == 1) {
            return (T)((BasicNamespace)nsp.first());
        }
        return null;
    }

    private void fillSchemas(Iterator<DatabaseMetaDataWrapper.Schema> schemaIt) {
        LinkedHashSet schemaFamilies = ContainerUtil.newLinkedHashSet();
        ModNamingFamily root2 = GenericIntrospectorLegacyModelUtils.familyOf((BasicModElement)((Object)this.getModel().getRoot()), ObjectKind.SCHEMA);
        if (root2 != null) {
            root2.markChildrenAsSyncPending();
            schemaFamilies.add(root2);
        }
        for (DatabaseMetaDataWrapper.Schema schema : JBIterable.once(schemaIt)) {
            if (root2 == null) {
                ModNamingFamily schemas;
                BasicModDatabase database = this.myHelper.createDatabase(schema.database);
                ModNamingFamily modNamingFamily = schemas = database == null ? null : GenericIntrospectorLegacyModelUtils.familyOf(database, ObjectKind.SCHEMA);
                if (schemas != null && schemaFamilies.add(schemas)) {
                    schemas.markChildrenAsSyncPending();
                }
            }
            this.myHelper.createSchema(schema);
        }
        for (ModNamingFamily schemas : schemaFamilies) {
            schemas.forEach(s -> s.setCurrent(false));
            boolean hasVisibleSc = !schemas.jbi().filter(BasicMateNamespace::isVisible).isEmpty();
            BasicModSchema curSc = (BasicModSchema)this.getCurrentOrSole(schemas);
            if (curSc != null) {
                if (!hasVisibleSc) {
                    curSc.setVisible(true);
                }
                curSc.setCurrent(true);
                continue;
            }
            if (!ApplicationManager.getApplication().isUnitTestMode() || !schemas.stream().noneMatch(BasicMateNamespace::isVisible)) continue;
            schemas.forEach(sc -> sc.setVisible(true));
        }
        schemaFamilies.forEach(GenericIntrospector::cleanupFamily);
    }

    private void fillDatabases(Iterator<String> dbIt) {
        ModNamingFamily root2 = GenericIntrospectorLegacyModelUtils.familyOf((BasicModElement)((Object)this.getModel().getRoot()), ObjectKind.DATABASE);
        if (root2 == null) {
            return;
        }
        root2.markChildrenAsSyncPending();
        for (String db : JBIterable.once(dbIt)) {
            this.myHelper.createDatabase(db);
        }
        JBIterable databases = JBIterable.from(root2).filter(BasicModMateDatabase.class);
        boolean hasVisibleDb = !databases.filter(BasicNamespace::isVisible).isEmpty();
        BasicModMateDatabase curDb = (BasicModMateDatabase)this.getCurrentOrSole((Iterable)databases);
        for (BasicModMateDatabase database : databases) {
            database.setCurrent(false);
        }
        if (curDb != null) {
            if (!hasVisibleDb) {
                curDb.setVisible(true);
            }
            curDb.setCurrent(true);
        }
        GenericIntrospector.cleanupFamily(root2);
    }

    private boolean isCurrent(@Nullable BasicNamespace nsp) {
        if (nsp instanceof BasicDatabase) {
            return this.isCurrent((BasicDatabase)nsp);
        }
        if (nsp instanceof BasicSchema) {
            return this.isCurrent((BasicSchema)nsp);
        }
        return false;
    }

    private boolean isCurrent(@Nullable BasicDatabase db) {
        if (db == null || this.myInfo == null) {
            return false;
        }
        return db.getName().equals(this.myInfo.databaseName);
    }

    private boolean isCurrent(@Nullable BasicSchema sc) {
        if (sc == null || this.myInfo == null) {
            return false;
        }
        return this.myHelper.isSchemaDbMode() ? sc.getName().equals(this.myInfo.databaseName) : sc.getName().equals(this.myInfo.schemaName) || sc.getName().equals(this.myInfo.userName);
    }

    @NotNull
    private DatabaseMetaDataWrapper createMeta(DBSession session) {
        DatabaseMetaDataWrapper databaseMetaDataWrapper;
        Connection connection = (Connection)session.getSpecificService(Connection.class, "jdbc-connection");
        if (connection == null) {
            throw new GenericIntrospectionException("Failed to get connection", null);
        }
        try {
            databaseMetaDataWrapper = DatabaseMetaDataWrapper.create(connection, connection.getMetaData(), this.myHelper.getFamilyId()).withErrorSink(this.myErrorSink);
        }
        catch (SQLException e) {
            throw new GenericIntrospectionException("Failed to retrieve meta data", e);
        }
        if (databaseMetaDataWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/GenericIntrospector", "createMeta"));
        }
        return databaseMetaDataWrapper;
    }

    @NotNull
    public JBIterable<BasicModSchema> schemas(BasicNamespace ... namespaces) {
        JBTreeTraverser traverser = this.getModel().traverser();
        if (namespaces != null && namespaces.length != 0) {
            traverser = (JBTreeTraverser)traverser.withRoots((Iterable)JBIterable.of((Object[])namespaces));
        }
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)traverser.expand(DasUtil.byKind((ObjectKind)ObjectKind.DATABASE))).filter(DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA))).filter(BasicModSchema.class);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/GenericIntrospector", "schemas"));
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<ModFamily<?>> getRoutineFamilies(@NotNull BasicModSchema schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/GenericIntrospector", "getRoutineFamilies"));
        }
        JBIterable routineFamilies = JBIterable.of((Object)schema.familyOf(ObjectKind.ROUTINE));
        ModFamily packages = schema.familyOf(ObjectKind.PACKAGE);
        if (packages != null) {
            JBIterable pkg = JBIterable.of((Object)packages);
            routineFamilies = routineFamilies.append((Iterable)pkg).append((Iterable)pkg.flatten(p -> p).transform(f -> f.familyOf(ObjectKind.ROUTINE)).filter(Conditions.notNull()));
        }
        JBIterable jBIterable = routineFamilies;
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/GenericIntrospector", "getRoutineFamilies"));
        }
        return jBIterable;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public JBIterable<ModFamily<?>> getUserDefinedTypeFamilies(@NotNull BasicModSchema schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/GenericIntrospector", "getUserDefinedTypeFamilies"));
        }
        @NotNull JBIterable transform = JBIterable.of((Object[])new ObjectKind[]{ObjectKind.ALIAS_TYPE, ObjectKind.COLLECTION_TYPE, ObjectKind.OBJECT_TYPE, ObjectKind.TABLE_TYPE}).transform(schema::familyOf);
        JBIterable jBIterable = transform.filter(Conditions.notNull());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/GenericIntrospector", "getUserDefinedTypeFamilies"));
        }
        return jBIterable;
    }

    private static void markChildrenAsSyncPending(@Nullable ModFamily f) {
        if (f == null) {
            return;
        }
        f.markChildrenAsSyncPending();
    }

    private static void cleanupFamily(@Nullable ModFamily f) {
        if (f == null) {
            return;
        }
        f.removeSyncPendingChildren();
        f.sort();
    }

    @Override
    public void introspectSessionState() {
    }

    @Override
    public void introspectFragment(@NotNull BasicNamespace namespace, boolean withSources, @NotNull ObjectKind objectKind, String ... objectNames) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/database/introspection/GenericIntrospector", "introspectFragment"));
        }
        if (objectKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectKind", "com/intellij/database/introspection/GenericIntrospector", "introspectFragment"));
        }
        if (objectNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectNames", "com/intellij/database/introspection/GenericIntrospector", "introspectFragment"));
        }
    }

    @Override
    @NotNull
    public PairConsumer<String, Throwable> getErrorSink() {
        PairConsumer<String, Throwable> pairConsumer = this.myErrorSink;
        if (pairConsumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/GenericIntrospector", "getErrorSink"));
        }
        return pairConsumer;
    }

    @Override
    public void setErrorSink(@NotNull PairConsumer<String, Throwable> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/introspection/GenericIntrospector", "setErrorSink"));
        }
        this.myErrorSink = consumer;
    }

    private static class GenericIntrospectionException
    extends DBIntrospectionException {
        public GenericIntrospectionException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static interface SourceLoader {
        public void loadSources(@NotNull Iterable<BasicModSourceAware> var1, @NotNull Connection var2);
    }

    public static interface SourceLoaderProvider {
        public static final ExtensionPointName<SourceLoaderProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.database.genericSourceLoaderProvider");

        @Nullable
        public SourceLoader create(@NotNull DBFacade var1);
    }
}

