/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.BaseIntrospectionFunctions;
import com.intellij.database.introspection.BaseIntrospector;
import com.intellij.database.introspection.BaseSingleDatabaseIntrospector;
import com.intellij.database.introspection.MysqlIntroQueries;
import com.intellij.database.introspection.MysqlIntrospector$SchemaRetriever$retrieve$;
import com.intellij.database.introspection.MysqlIntrospectorKt;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.mysql.MysqlModArgument;
import com.intellij.database.model.mysql.MysqlModForeignKey;
import com.intellij.database.model.mysql.MysqlModIndex;
import com.intellij.database.model.mysql.MysqlModKey;
import com.intellij.database.model.mysql.MysqlModLikeColumn;
import com.intellij.database.model.mysql.MysqlModLikeTable;
import com.intellij.database.model.mysql.MysqlModModel;
import com.intellij.database.model.mysql.MysqlModRoot;
import com.intellij.database.model.mysql.MysqlModRoutine;
import com.intellij.database.model.mysql.MysqlModSchema;
import com.intellij.database.model.mysql.MysqlModTable;
import com.intellij.database.model.mysql.MysqlModTableColumn;
import com.intellij.database.model.mysql.MysqlModTrigger;
import com.intellij.database.model.mysql.MysqlModView;
import com.intellij.database.model.mysql.MysqlSchema;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.database.scripting.CompositeText;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.StringKt;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBSession;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.InTransaction;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0001:\u0002\u001d\u001eB\u0005\u00a2\u0006\u0002\u0010\u0006J\u001b\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u001e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0004H\u0014J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J\b\u0010\u0019\u001a\u00020\bH\u0016J\u001f\u0010\u001a\u001a\u00020\b2\u0014\b\u0004\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u001cH\u0082\b\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/introspection/MysqlIntrospector;", "Lcom/intellij/database/introspection/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/model/mysql/MysqlModModel;", "Lcom/intellij/database/model/mysql/MysqlModRoot;", "Lcom/intellij/database/model/mysql/MysqlSchema;", "Lcom/intellij/database/model/mysql/MysqlModSchema;", "()V", "applySchemas", "", "schemaNames", "", "", "([Ljava/lang/String;)V", "introspectNamespacesInTran", "tran", "Lorg/jetbrains/dekaf/core/DBTransaction;", "introspectOneSchema", "schema", "introspectSchemasAuto", "schemas", "", "isPossibleToIntrospectSchemaIncrementally", "", "quote", "def", "retrieveAndApplySchemas", "workWithModel", "modifier", "Lkotlin/Function1;", "SchemaRetriever", "VERSION", "database-introspection"})
public final class MysqlIntrospector
extends BaseSingleDatabaseIntrospector<MysqlModModel, MysqlModRoot, MysqlSchema, MysqlModSchema> {
    @Override
    protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull MysqlSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        return false;
    }

    private final void workWithModel(Function1<? super MysqlModRoot, Unit> modifier) {
        ((MysqlModModel)this.getModel()).modify(MysqlModRoot.class, new ModelModifier<MysqlModRoot>(modifier){
            final /* synthetic */ Function1 $modifier;

            public final void perform(MysqlModRoot it) {
                MysqlModRoot mysqlModRoot = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)mysqlModRoot, (String)"it");
                this.$modifier.invoke((Object)mysqlModRoot);
            }
            {
                this.$modifier = function1;
            }
        });
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        String[] schemaNames = (String[])tran.query(MysqlIntroQueries.QUERIES.querySchemas).run();
        Intrinsics.checkExpressionValueIsNotNull((Object)schemaNames, (String)"schemaNames");
        this.applySchemas(schemaNames);
    }

    @Override
    public void retrieveAndApplySchemas() {
        MysqlIntrospector this_$iv = this;
        DBFacade dBFacade = BaseIntrospector.access$getDbFacade$p(this_$iv);
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf$iv = dBFacade;
        Object result$iv = dbf$iv.inTransaction((InTransaction)new InTransaction<String[]>(){

            public final String[] run(DBTransaction tran) {
                DBTransaction dBTransaction = tran;
                Intrinsics.checkExpressionValueIsNotNull((Object)dBTransaction, (String)"tran");
                DBTransaction tran2 = dBTransaction;
                Object object = tran2.query(MysqlIntroQueries.QUERIES.querySchemas).run();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"tran.query(QUERIES.querySchemas).run()");
                return (String[])object;
            }
        });
        String[] schemaNames = (String[])result$iv;
        this.applySchemas(schemaNames);
    }

    public final void applySchemas(@NotNull String[] schemaNames) {
        Intrinsics.checkParameterIsNotNull((Object)schemaNames, (String)"schemaNames");
        MysqlIntrospector this_$iv = this;
        ((MysqlModModel)this_$iv.getModel()).modify(MysqlModRoot.class, new ModelModifier<MysqlModRoot>(schemaNames){
            final /* synthetic */ String[] $schemaNames$inlined;
            {
                this.$schemaNames$inlined = stringArray;
            }

            public final void perform(MysqlModRoot it) {
                MysqlModRoot mysqlModRoot = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)mysqlModRoot, (String)"it");
                MysqlModRoot root2 = mysqlModRoot;
                NamingFamily schemas = root2.getSchemas();
                schemas.markChildrenAsSyncPending();
                boolean empty = schemas.isEmpty();
                int n = ((Object[])this.$schemaNames$inlined).length;
                for (int i2 = 0; i2 < n; ++i2) {
                    String name = this.$schemaNames$inlined[i2];
                    MysqlModSchema schema = (MysqlModSchema)schemas.createOrGet(name);
                    if (i2 != 0) continue;
                    schema.setCurrent(true);
                    if (!empty) continue;
                    schema.setVisible(true);
                }
                schemas.removeSyncPendingChildren();
            }
        });
    }

    @Override
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends MysqlSchema> schemas) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Intrinsics.checkParameterIsNotNull(schemas, (String)"schemas");
        for (MysqlSchema mysqlSchema : schemas) {
            this.introspectOneSchema(tran, mysqlSchema);
        }
    }

    private final void introspectOneSchema(DBTransaction tran, MysqlSchema schema) {
        SchemaRetriever retriever = new SchemaRetriever(tran, schema);
        retriever.init();
        retriever.retrieve$database_introspection();
    }

    private final String quote(String def) {
        String simpleEscaped = StringsKt.replace$default((String)def, (String)"'", (String)"''", (boolean)false, (int)4, null);
        return StringsKt.replace$default((String)StringsKt.replace$default((String)("'" + StringUtil.escapeStringCharacters((int)simpleEscaped.length(), (String)simpleEscaped, null, (boolean)true, (boolean)false, (StringBuilder)new StringBuilder()) + "'"), (String)"\u001a", (String)"\\Z", (boolean)false, (int)4, null), (String)"\u0000", (String)"\\0", (boolean)false, (int)4, null);
    }

    public MysqlIntrospector() {
        Rdbms rdbms = Mysql.RDBMS;
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"Mysql.RDBMS");
        super(rdbms, MysqlModModel.class, MysqlModRoot.class, MysqlModSchema.class);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0082\u0004\u0018\u00002\u001e0\u0001R\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0002B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0018\u0010\u0015\u001a\u00020\u00122\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0002J\r\u0010\u0019\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u001aJ\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a8\u0006'"}, d2={"Lcom/intellij/database/introspection/MysqlIntrospector$SchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector$SchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector;", "Lcom/intellij/database/model/mysql/MysqlModModel;", "Lcom/intellij/database/model/mysql/MysqlModRoot;", "Lcom/intellij/database/model/mysql/MysqlSchema;", "Lcom/intellij/database/model/mysql/MysqlModSchema;", "tran", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schema", "(Lcom/intellij/database/introspection/MysqlIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/mysql/MysqlSchema;)V", "asCascadeRule", "Lcom/intellij/database/model/properties/CascadeRule;", "s", "", "update", "", "progress", "", "what", "removeObsolete", "removeSyncPendingChildren", "family", "Lcom/intellij/database/model/families/ModNamingFamily;", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "retrieve", "retrieve$database_introspection", "retrieveColumns", "retrieveIndices", "retrieveRoutineParameters", "retrieveRoutineParametersFromInformationSchema", "retrieveRoutineParametersFromMetaData", "retrieveRoutineSources", "retrieveRoutines", "retrieveTableConstraints", "retrieveTables", "retrieveTriggerSources", "retrieveTriggers", "retrieveViewSources", "database-introspection"})
    private final class SchemaRetriever
    extends BaseIntrospector.SchemaRetriever {
        private final void progress(String what) {
            String mode = "completely";
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Introspecting schema %s (%s)";
            Object[] objectArray = new Object[]{((MysqlSchema)this.getSchema()).getName(), mode};
            MysqlIntrospector mysqlIntrospector = MysqlIntrospector.this;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            mysqlIntrospector.updateStatus(string3, what);
        }

        public final void retrieve$database_introspection() {
            SchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ SchemaRetriever this$0;
                {
                    this.this$0 = schemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MysqlModSchema schema2 = (MysqlModSchema)MS;
                    SchemaRetriever.access$retrieveTables(this.this$0, schema2);
                }
            });
            this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ SchemaRetriever this$0;
                {
                    this.this$0 = schemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MysqlModSchema schema2 = (MysqlModSchema)MS;
                    SchemaRetriever.access$retrieveColumns(this.this$0, schema2);
                }
            });
            if (StringsKt.equals((String)((MysqlSchema)this.getSchema()).getName(), (String)"information_schema", (boolean)true)) {
                return;
            }
            this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ SchemaRetriever this$0;
                {
                    this.this$0 = schemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MysqlModSchema schema2 = (MysqlModSchema)MS;
                    SchemaRetriever.access$retrieveIndices(this.this$0, schema2);
                }
            });
            this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ SchemaRetriever this$0;
                {
                    this.this$0 = schemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MysqlModSchema schema2 = (MysqlModSchema)MS;
                    SchemaRetriever.access$retrieveRoutines(this.this$0, schema2);
                }
            });
            this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ SchemaRetriever this$0;
                {
                    this.this$0 = schemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MysqlModSchema schema2 = (MysqlModSchema)MS;
                    SchemaRetriever.access$retrieveRoutineParameters(this.this$0, schema2);
                }
            });
            this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ SchemaRetriever this$0;
                {
                    this.this$0 = schemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MysqlModSchema schema2 = (MysqlModSchema)MS;
                    SchemaRetriever.access$retrieveTableConstraints(this.this$0, schema2);
                }
            });
            this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ SchemaRetriever this$0;
                {
                    this.this$0 = schemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MysqlModSchema schema2 = (MysqlModSchema)MS;
                    SchemaRetriever.access$retrieveTriggers(this.this$0, schema2);
                }
            });
            this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ SchemaRetriever this$0;
                {
                    this.this$0 = schemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MysqlModSchema schema2 = (MysqlModSchema)MS;
                    SchemaRetriever.access$removeObsolete(this.this$0, schema2);
                }
            });
            if (this.getWithSources()) {
                this_$iv = this;
                BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                    final /* synthetic */ SchemaRetriever this$0;
                    {
                        this.this$0 = schemaRetriever;
                    }

                    public final void perform(MS schema) {
                        MS MS = schema;
                        Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                        MysqlModSchema schema2 = (MysqlModSchema)MS;
                        MysqlIntrospector this_$iv = this.this$0.MysqlIntrospector.this;
                        this_$iv.getModel().writeSources(new Runnable(schema2, this){
                            final /* synthetic */ MysqlModSchema $schema$inlined;
                            final /* synthetic */ SchemaRetriever$retrieve$$inlined$inSchema$9 this$0;
                            {
                                this.$schema$inlined = mysqlModSchema;
                                this.this$0 = var2_2;
                            }

                            public final void run() {
                                SchemaRetriever.access$retrieveViewSources(this.this$0.this$0, this.$schema$inlined);
                                SchemaRetriever.access$retrieveRoutineSources(this.this$0.this$0, this.$schema$inlined);
                                SchemaRetriever.access$retrieveTriggerSources(this.this$0.this$0, this.$schema$inlined);
                            }
                        });
                    }
                });
            }
        }

        private final void retrieveTables(MysqlModSchema schema) {
            this.progress("tables and views");
            schema.getTables().markChildrenAsSyncPending();
            schema.getViews().markChildrenAsSyncPending();
            List ts2 = (List)this.getTransaction().query(MysqlIntroQueries.QUERIES.queryTablesAndViews).withParams(new Object[]{((MysqlSchema)this.getSchema()).getName()}).run();
            for (MysqlIntroQueries.Table t : ts2) {
                NamingFamily namingFamily;
                String type = t.table_type;
                boolean isView = StringUtil.contains((CharSequence)type, (CharSequence)"VIEW");
                if (isView) {
                    NamingFamily namingFamily2 = schema.getViews();
                    namingFamily = namingFamily2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily2, (String)"schema.views");
                } else {
                    NamingFamily namingFamily3 = schema.getTables();
                    namingFamily = namingFamily3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily3, (String)"schema.tables");
                }
                MysqlModLikeTable o = (MysqlModLikeTable)namingFamily.createOrGet(t.table_name);
                for (ModFamily modFamily : o.getFamilies()) {
                    modFamily.markChildrenAsSyncPending();
                }
                o.setSystem(StringUtil.containsIgnoreCase((String)type, (String)"SYSTEM"));
                o.setComment(StringKt.nullize$default((String)t.table_comment, (boolean)false, (int)1, null));
            }
            schema.getTables().removeSyncPendingChildren();
            schema.getViews().removeSyncPendingChildren();
            schema.getTables().sort();
            schema.getViews().sort();
        }

        private final void removeObsolete(MysqlModSchema schema) {
            NamingFamily namingFamily = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily, (String)"schema.tables");
            this.removeSyncPendingChildren((ModNamingFamily<? extends BasicModNamedElement>)namingFamily);
            NamingFamily namingFamily2 = schema.getViews();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily2, (String)"schema.views");
            this.removeSyncPendingChildren((ModNamingFamily<? extends BasicModNamedElement>)namingFamily2);
            NamingFamily namingFamily3 = schema.getRoutines();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily3, (String)"schema.routines");
            this.removeSyncPendingChildren((ModNamingFamily<? extends BasicModNamedElement>)namingFamily3);
        }

        private final void removeSyncPendingChildren(ModNamingFamily<? extends BasicModNamedElement> family) {
            for (BasicModNamedElement basicModNamedElement : family) {
                for (ModFamily<? extends BasicModElement> modFamily : basicModNamedElement.getFamilies()) {
                    modFamily.removeSyncPendingChildren();
                }
            }
        }

        private final void retrieveIndices(MysqlModSchema schema) {
            this.progress("indices");
            String schemaName = schema.getName();
            for (MysqlIntroQueries.Index i2 : (List)this.getTransaction().query(MysqlIntroQueries.QUERIES.queryIndices).withParams(new Object[]{schemaName, schemaName}).run()) {
                String[] colNames;
                MysqlModTable table;
                if ((MysqlModTable)schema.getTables().get(i2.table_name) == null) {
                    continue;
                }
                MysqlModIndex index = (MysqlModIndex)table.getIndices().createOrGet(i2.index_name);
                index.setUnique(!i2.non_unique);
                String[] stringArray = colNames = StringUtil.splitByLines((String)StringUtil.notNullize((String)i2.column_names));
                Intrinsics.checkExpressionValueIsNotNull((Object)colNames, (String)"colNames");
                index.setColNames(CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray, stringArray.length)));
            }
        }

        /*
         * Unable to fully structure code
         */
        private final CascadeRule asCascadeRule(String s, boolean update) {
            block7: {
                block6: {
                    v0 = var4_3 = s;
                    if (v0 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    v1 = v0.toLowerCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"(this as java.lang.String).toLowerCase()");
                    var3_4 = v1;
                    switch (var3_4.hashCode()) {
                        case 1357211269: {
                            if (!var3_4.equals("set null")) ** break;
                            break block6;
                        }
                        case -890131325: {
                            if (!var3_4.equals("set default")) ** break;
                            break;
                        }
                        case 554829492: {
                            if (!var3_4.equals("cascade")) ** break;
                            v2 = CascadeRule.cascade;
                            break block7;
                        }
                    }
                    v2 = CascadeRule.set_default;
                    break block7;
                }
                v2 = CascadeRule.set_null;
                break block7;
                v2 = CascadeRule.no_action;
            }
            return v2;
        }

        private final void retrieveTableConstraints(MysqlModSchema schema) {
            this.progress("table constraints");
            HashSet<MysqlModTable> affectedTables = new HashSet<MysqlModTable>();
            String schemaName = schema.getName();
            for (MysqlIntroQueries.Constraint constraint : (List)this.getTransaction().query(MysqlIntroQueries.QUERIES.queryConstraints).withParams(new Object[]{schemaName, schemaName, schemaName}).run()) {
                MysqlModTable table;
                if ((MysqlModTable)schema.getTables().get(constraint.table_name) == null) {
                    continue;
                }
                affectedTables.add(table);
                String[] columnNames = StringUtil.splitByLines((String)StringUtil.notNullize((String)constraint.column_names));
                String name = constraint.constraint_name;
                if (Intrinsics.areEqual((Object)constraint.constraint_type, (Object)"PRIMARY KEY")) {
                    MysqlModKey pk = (MysqlModKey)table.getKeys().createOrGet(name);
                    pk.setPrimary(true);
                    String[] stringArray = columnNames;
                    Intrinsics.checkExpressionValueIsNotNull((Object)columnNames, (String)"columnNames");
                    pk.setColNames(CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray, stringArray.length)));
                    pk.setNameSurrogate(Intrinsics.areEqual((Object)name, (Object)"PRIMARY"));
                    continue;
                }
                if (Intrinsics.areEqual((Object)constraint.constraint_type, (Object)"FOREIGN KEY")) {
                    String[] refColNames = StringUtil.splitByLines((String)StringUtil.notNullize((String)constraint.ref_column_names));
                    MysqlModForeignKey fk = (MysqlModForeignKey)table.getForeignKeys().createOrGet(name);
                    String[] stringArray = columnNames;
                    Intrinsics.checkExpressionValueIsNotNull((Object)columnNames, (String)"columnNames");
                    fk.setColNames(CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray, stringArray.length)));
                    fk.setRefSchemaName(constraint.referenced_table_schema);
                    fk.setRefTableName(constraint.referenced_table_name);
                    String[] stringArray2 = refColNames;
                    Intrinsics.checkExpressionValueIsNotNull((Object)refColNames, (String)"refColNames");
                    fk.setRefColNames(CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray2, stringArray2.length)));
                    String string = constraint.update_rule;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"c.update_rule");
                    fk.setOnUpdate(this.asCascadeRule(string, true));
                    String string2 = constraint.delete_rule;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"c.delete_rule");
                    fk.setOnDelete(this.asCascadeRule(string2, false));
                    continue;
                }
                if (!Intrinsics.areEqual((Object)constraint.constraint_type, (Object)"UNIQUE")) continue;
                MysqlModKey key = (MysqlModKey)table.getKeys().createOrGet(name);
                String[] stringArray = columnNames;
                Intrinsics.checkExpressionValueIsNotNull((Object)columnNames, (String)"columnNames");
                key.setColNames(CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray, stringArray.length)));
                MysqlModIndex index = (MysqlModIndex)table.getIndices().get(name);
                if (index == null) {
                    index = (MysqlModIndex)table.getIndices().createOrGet(name);
                    index.setUnique(true);
                    String[] stringArray3 = columnNames;
                    Intrinsics.checkExpressionValueIsNotNull((Object)columnNames, (String)"columnNames");
                    index.setColNames(CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray3, stringArray3.length)));
                }
                key.setUnderlyingIndexName(name);
            }
            for (BasicTable basicTable : affectedTables) {
                if (!(basicTable instanceof MysqlModTable)) continue;
                ((MysqlModTable)basicTable).getKeys().sort();
                ((MysqlModTable)basicTable).getForeignKeys().sort();
            }
        }

        private final void retrieveRoutines(MysqlModSchema schema) {
            this.progress("routines");
            schema.getRoutines().markChildrenAsSyncPending();
            for (MysqlIntroQueries.Routine r : (List)this.getTransaction().query(MysqlIntroQueries.QUERIES.queryRoutines).withParams(new Object[]{schema.getName()}).run()) {
                MysqlModRoutine routine2 = (MysqlModRoutine)schema.getRoutines().createOrGet(r.specific_name);
                for (ModFamily<? extends BasicModElement> modFamily : routine2.getFamilies()) {
                    modFamily.markChildrenAsSyncPending();
                }
                String string = r.routine_type;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"r.routine_type");
                DasRoutine.Kind kind = MysqlIntrospectorKt.access$getType(string);
                routine2.setRoutineKind(kind);
                if (Intrinsics.areEqual((Object)kind, (Object)DasRoutine.Kind.FUNCTION)) {
                    BasicModArgument returnArgument = routine2.createOrGetReturnArgument();
                    returnArgument.setDataType(DataTypeFactory.of(r.dtd_identifier));
                }
                routine2.setComment(StringKt.nullize$default((String)r.routine_comment, (boolean)false, (int)1, null));
            }
            schema.getRoutines().removeSyncPendingChildren();
        }

        private final void retrieveRoutineParameters(MysqlModSchema schema) {
            this.progress("routine parameters");
            String pte = (String)this.getTransaction().query(MysqlIntroQueries.QUERIES.parametersTableExists).run();
            if (pte != null) {
                this.retrieveRoutineParametersFromInformationSchema(schema);
            } else {
                this.retrieveRoutineParametersFromMetaData(schema);
            }
        }

        private final void retrieveRoutineParametersFromInformationSchema(MysqlModSchema schema) {
            for (MysqlIntroQueries.Parameter p : (List)this.getTransaction().query(MysqlIntroQueries.QUERIES.queryRoutineParams).withParams(new Object[]{schema.getName()}).run()) {
                MysqlModRoutine routine2 = (MysqlModRoutine)schema.getRoutines().createOrGet(p.specific_name);
                MysqlModArgument arg = (MysqlModArgument)routine2.getArguments().createOrGet(p.parameter_name);
                arg.setDataType(DataTypeFactory.of(p.dtd_identifier));
                String string = p.parameter_mode;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"p.parameter_mode");
                arg.setArgumentDirection(MysqlIntrospectorKt.access$getDirection(string));
            }
        }

        private final void retrieveRoutineParametersFromMetaData(MysqlModSchema schema) {
            if (!(this.getTransaction() instanceof DBSession)) {
                return;
            }
            Connection connection = (Connection)((DBSession)this.getTransaction()).getSpecificService(Connection.class, "jdbc-connection");
            if (connection == null) {
                return;
            }
            Connection connection2 = connection;
            try {
                DatabaseMetaData metaData = connection2.getMetaData();
                ResultSet c = metaData.getProcedureColumns(schema.getName(), null, null, null);
                while (c.next()) {
                    String name = c.getString("COLUMN_NAME");
                    if (StringUtil.isEmptyOrSpaces((String)name)) continue;
                    MysqlModRoutine routine2 = (MysqlModRoutine)schema.getRoutines().createOrGet(c.getString("PROCEDURE_NAME"));
                    MysqlModArgument arg = (MysqlModArgument)routine2.getArguments().createOrGet(name);
                    String typeName = c.getString("TYPE_NAME");
                    int precision = c.getInt("PRECISION");
                    int length = c.getInt("LENGTH");
                    int charOctetLength = c.getInt("CHAR_OCTET_LENGTH");
                    int size = charOctetLength <= 0 && precision <= 0 ? length : Math.max(charOctetLength, precision);
                    int scale = c.getInt("SCALE");
                    arg.setDataType(DataTypeFactory.of(null, typeName, size, scale, null, null, false, false));
                    arg.setArgumentDirection(MysqlIntrospectorKt.access$getDirection(c.getShort("COLUMN_TYPE")));
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        private final void retrieveColumns(MysqlModSchema schema) {
            this.progress("table columns");
            for (MysqlIntroQueries.Column c : (List)this.getTransaction().query(MysqlIntroQueries.QUERIES.queryColumns).withParams(new Object[]{schema.getName()}).run()) {
                MysqlModLikeTable table;
                String tableName = c.table_name;
                MysqlModTable mysqlModTable = (MysqlModTable)schema.getTables().get(tableName);
                if ((mysqlModTable != null ? (MysqlModLikeTable)mysqlModTable : (MysqlModLikeTable)schema.getViews().get(tableName)) == null) {
                    continue;
                }
                table = table;
                MysqlModLikeColumn column = (MysqlModLikeColumn)table.getColumns().createOrGet(c.column_name);
                column.setPosition(c.ordinal_position);
                column.setNotNull(Intrinsics.areEqual((Object)c.is_nullable, (Object)"YES") ^ true);
                DataType dataType = DataTypeFactory.of(c.column_type);
                column.setDataType(dataType);
                column.setComment(StringKt.nullize$default((String)c.column_comment, (boolean)false, (int)1, null));
                String def = c.column_default;
                if (def != null && column instanceof MysqlModTableColumn) {
                    boolean noQuote = StringsKt.equals((String)dataType.typeName, (String)"bit", (boolean)true);
                    if (!noQuote) {
                        noQuote = (StringsKt.startsWith$default((String)dataType.typeName, (String)"datetime", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)dataType.typeName, (String)"timestamp", (boolean)false, (int)2, null)) && StringsKt.startsWith$default((String)def, (String)"CURRENT_TIMESTAMP", (boolean)false, (int)2, null);
                    }
                    ((MysqlModTableColumn)column).setDefaultExpression(noQuote ? def : MysqlIntrospector.this.quote(def));
                }
                if (!StringsKt.equals((String)c.extra, (String)"auto_increment", (boolean)true) || !(column instanceof MysqlModTableColumn)) continue;
                ((MysqlModTableColumn)column).setSequenceIdentity(MysqlIntrospectorKt.access$getOurMysqlSequenceIdentity$p());
            }
            for (MysqlModTable table : schema.getTables()) {
                table.getColumns().removeSyncPendingChildren();
                table.getColumns().sort();
            }
            for (MysqlModView view2 : schema.getViews()) {
                view2.getColumns().removeSyncPendingChildren();
                view2.getColumns().sort();
            }
        }

        private final void retrieveViewSources(MysqlModSchema schema) {
            this.progress("view sources");
            for (MysqlIntroQueries.View t : (List)this.getTransaction().query(MysqlIntroQueries.QUERIES.queryViews).withParams(new Object[]{schema.getName()}).run()) {
                String viewText;
                if (StringKt.nullize((String)t.view_definition, (boolean)true) == null) {
                    continue;
                }
                MysqlModView view2 = (MysqlModView)schema.getViews().createOrGet(t.table_name);
                view2.setSourceText(BaseIntrospectionFunctions.toCompositeText(viewText, CompositeText.Kind.DECOMPILED_TEXT));
            }
        }

        private final void retrieveRoutineSources(MysqlModSchema schema) {
            this.progress("routine sources");
            for (MysqlIntroQueries.Routine r : (List)this.getTransaction().query(MysqlIntroQueries.QUERIES.queryRoutineSources).withParams(new Object[]{schema.getName()}).run()) {
                String routineText;
                if (StringKt.nullize((String)r.routine_definition, (boolean)true) == null) {
                    continue;
                }
                MysqlModRoutine routine2 = (MysqlModRoutine)schema.getRoutines().createOrGet(r.specific_name);
                routine2.setSourceText(BaseIntrospectionFunctions.toCompositeText(routineText, CompositeText.Kind.ORIGINAL_TEXT));
            }
        }

        private final void retrieveTriggerSources(MysqlModSchema schema) {
            this.progress("trigger sources");
            for (MysqlIntroQueries.Trigger t : (List)this.getTransaction().query(MysqlIntroQueries.QUERIES.queryTriggerSources).withParams(new Object[]{schema.getName()}).run()) {
                String triggerText;
                if (StringKt.nullize((String)t.action_statement, (boolean)true) == null) {
                    continue;
                }
                MysqlModTable table = (MysqlModTable)schema.getTables().createOrGet(t.event_object_table);
                MysqlModTrigger trigger2 = (MysqlModTrigger)table.getTriggers().createOrGet(t.trigger_name);
                trigger2.setSourceText(BaseIntrospectionFunctions.toCompositeText(triggerText, CompositeText.Kind.ORIGINAL_TEXT));
            }
        }

        private final void retrieveTriggers(MysqlModSchema schema) {
            this.progress("triggers");
            for (MysqlIntroQueries.Trigger t : (List)this.getTransaction().query(MysqlIntroQueries.QUERIES.queryTriggers).withParams(new Object[]{schema.getName()}).run()) {
                MysqlModTable table = (MysqlModTable)schema.getTables().createOrGet(t.event_object_table);
                MysqlModTrigger trigger2 = (MysqlModTrigger)table.getTriggers().createOrGet(t.trigger_name);
                trigger2.setTurn(StringsKt.equals((String)t.action_timing, (String)"before", (boolean)true) ? TrigTurn.BEFORE_ROW : TrigTurn.AFTER_ROW);
                String string = t.event_manipulation;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"t.event_manipulation");
                trigger2.setEvents(SetsKt.setOf((Object)((Object)MysqlIntrospectorKt.access$getEvent(string))));
            }
        }

        public SchemaRetriever(@NotNull DBTransaction tran, MysqlSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super((BaseIntrospector)MysqlIntrospector.this, tran, (BasicSchema)schema);
        }

        public static final /* synthetic */ void access$retrieveTables(SchemaRetriever $this, @NotNull MysqlModSchema schema) {
            $this.retrieveTables(schema);
        }

        public static final /* synthetic */ void access$retrieveColumns(SchemaRetriever $this, @NotNull MysqlModSchema schema) {
            $this.retrieveColumns(schema);
        }

        public static final /* synthetic */ void access$retrieveIndices(SchemaRetriever $this, @NotNull MysqlModSchema schema) {
            $this.retrieveIndices(schema);
        }

        public static final /* synthetic */ void access$retrieveRoutines(SchemaRetriever $this, @NotNull MysqlModSchema schema) {
            $this.retrieveRoutines(schema);
        }

        public static final /* synthetic */ void access$retrieveRoutineParameters(SchemaRetriever $this, @NotNull MysqlModSchema schema) {
            $this.retrieveRoutineParameters(schema);
        }

        public static final /* synthetic */ void access$retrieveTableConstraints(SchemaRetriever $this, @NotNull MysqlModSchema schema) {
            $this.retrieveTableConstraints(schema);
        }

        public static final /* synthetic */ void access$retrieveTriggers(SchemaRetriever $this, @NotNull MysqlModSchema schema) {
            $this.retrieveTriggers(schema);
        }

        public static final /* synthetic */ void access$removeObsolete(SchemaRetriever $this, @NotNull MysqlModSchema schema) {
            $this.removeObsolete(schema);
        }

        public static final /* synthetic */ void access$retrieveViewSources(SchemaRetriever $this, @NotNull MysqlModSchema schema) {
            $this.retrieveViewSources(schema);
        }

        public static final /* synthetic */ void access$retrieveRoutineSources(SchemaRetriever $this, @NotNull MysqlModSchema schema) {
            $this.retrieveRoutineSources(schema);
        }

        public static final /* synthetic */ void access$retrieveTriggerSources(SchemaRetriever $this, @NotNull MysqlModSchema schema) {
            $this.retrieveTriggerSources(schema);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/introspection/MysqlIntrospector$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "database-introspection"})
    public static final class VERSION
    extends PerObjectVersion {
        public static final VERSION INSTANCE;

        private VERSION() {
            INSTANCE = this;
        }

        static {
            new VERSION();
        }
    }
}

