/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.LongIdName;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.core.Layouts;
import org.jetbrains.dekaf.core.RowLayout;
import org.jetbrains.dekaf.sql.Scriptum;
import org.jetbrains.dekaf.sql.SqlQuery;

public final class PostgresIntroQueries {
    static final PostgresIntroQueries QUERIES = new PostgresIntroQueries();
    @NotNull
    private final Scriptum myScriptum = Scriptum.of(PostgresIntroQueries.class);
    final SqlQuery<List<LongIdName>> listDatabases = this.myScriptum.query("ListDatabases", Layouts.listOf((RowLayout)Layouts.structOf(LongIdName.class)));
    final SqlQuery<List<LongIdName>> listSchemas = this.myScriptum.query("ListSchemas", Layouts.listOf((RowLayout)Layouts.structOf(LongIdName.class)));
    final SqlQuery<CurrentSessionInfo> queryCurrentSessionInfo = this.myScriptum.query("QuerySessionCurrentInfo", Layouts.rowOf((RowLayout)Layouts.structOf(CurrentSessionInfo.class)));
    final SqlQuery<List<OneSchema>> retrieveSchemas = this.myScriptum.query("RetrieveSchemas", Layouts.listOf((RowLayout)Layouts.structOf(OneSchema.class)));
    final SqlQuery<Timestamp> now = this.myScriptum.query("Now", Layouts.singleOf(Timestamp.class));
    final SqlQuery<Long> countSchemaStateNumber = this.myScriptum.query("CountSchemaStateNumber", Layouts.singleOf(Long.class));
    final SqlQuery<long[]> listExistentClasses = this.myScriptum.query("ListExistentClasses", Layouts.columnOfLongs((int)10000));
    final SqlQuery<List<OneSequence>> retrieveSequences = this.myScriptum.query("RetrieveSequences", Layouts.listOf((RowLayout)Layouts.structOf(OneSequence.class)));
    final SqlQuery<List<OneDataType>> retrieveDataTypes = this.myScriptum.query("RetrieveDataTypes", Layouts.listOf((RowLayout)Layouts.structOf(OneDataType.class)));
    final SqlQuery<List<OneDataTypeCheck>> retrieveDataTypeChecks = this.myScriptum.query("RetrieveDataTypeChecks", Layouts.listOf((RowLayout)Layouts.structOf(OneDataTypeCheck.class)));
    final SqlQuery<List<OneTable>> retrieveTables = this.myScriptum.query("RetrieveTables", Layouts.listOf((RowLayout)Layouts.structOf(OneTable.class)));
    final SqlQuery<List<OneStructAttribute>> retrieveStructAttributes = this.myScriptum.query("RetrieveStructAttributes", Layouts.listOf((RowLayout)Layouts.structOf(OneStructAttribute.class)));
    final SqlQuery<Map<Long, String[]>> retrieveEnumLabels = this.myScriptum.query("RetrieveEnumLabels", Layouts.hashMapOf(Long.class, String[].class));
    final SqlQuery<List<OneColumn>> retrieveColumns = this.myScriptum.query("RetrieveColumns", Layouts.listOf((RowLayout)Layouts.structOf(OneColumn.class)));
    final SqlQuery<List<OneIndex>> retrieveIndices = this.myScriptum.query("RetrieveIndices", Layouts.listOf((RowLayout)Layouts.structOf(OneIndex.class)));
    final SqlQuery<List<OneConstraint>> retrieveConstraints = this.myScriptum.query("RetrieveConstraints", Layouts.listOf((RowLayout)Layouts.structOf(OneConstraint.class)));
    final SqlQuery<Map<Long, String>> retrieveUsedArgumentTypes = this.myScriptum.query("RetrieveUsedArgumentTypes", Layouts.hashMapOf(Long.class, String.class));
    final SqlQuery<List<OneRoutine>> retrieveRoutines = this.myScriptum.query("RetrieveRoutines", Layouts.listOf((RowLayout)Layouts.structOf(OneRoutine.class)));
    final SqlQuery<List<OneOperator>> retrieveOperators = this.myScriptum.query("RetrieveOperators", Layouts.listOf((RowLayout)Layouts.structOf(OneOperator.class)));
    final SqlQuery<List<OneRule>> retrieveRules = this.myScriptum.query("RetrieveRules", Layouts.listOf((RowLayout)Layouts.structOf(OneRule.class)));
    final SqlQuery<List<OneTrigger>> retrieveTriggers = this.myScriptum.query("RetrieveTriggers", Layouts.listOf((RowLayout)Layouts.structOf(OneTrigger.class)));
    final SqlQuery<List<OneDescription>> retrieveDescriptions = this.myScriptum.query("RetrieveDescriptions", Layouts.listOf((RowLayout)Layouts.structOf(OneDescription.class)));
    final SqlQuery<List<OneViewSource>> retrieveViewSources = this.myScriptum.query("RetrieveViewSources", Layouts.listOf((RowLayout)Layouts.structOf(OneViewSource.class)));
    final SqlQuery<List<OneRuleSource>> retrieveRuleSources = this.myScriptum.query("RetrieveRuleSources", Layouts.listOf((RowLayout)Layouts.structOf(OneRuleSource.class)));
    final SqlQuery<List<OneFunctionSource>> retrieveFunctionSources = this.myScriptum.query("RetrieveFunctionSources", Layouts.listOf((RowLayout)Layouts.structOf(OneFunctionSource.class)));

    static final class OneFunctionSource {
        long id;
        String arguments_def;
        String result_def;
        String source_text;

        OneFunctionSource() {
        }
    }

    static final class OneRuleSource {
        char table_kind;
        long table_id;
        long rule_id;
        String source_text;

        OneRuleSource() {
        }
    }

    static final class OneViewSource {
        char view_kind;
        long view_id;
        String source_text;

        OneViewSource() {
        }
    }

    static final class OneDescription {
        char table_kind;
        long table_id;
        short column_position;
        String description;

        OneDescription() {
        }
    }

    static final class OneTrigger {
        long table_id;
        long trigger_id;
        long trigger_state_number;
        String trigger_name;
        long function_id;
        byte bits;
        boolean is_deferrable;
        boolean is_init_deferred;
        char trigger_fire_mode;

        OneTrigger() {
        }
    }

    static final class OneRule {
        long table_id;
        long rule_id;
        long rule_state_number;
        String rule_name;
        char rule_event_code;
        char rule_fire_mode;
        boolean rule_is_instead;

        OneRule() {
        }
    }

    static final class OneOperator {
        long op_id;
        String op_name;
        char op_kind;
        long arg_left_type_id;
        long arg_right_type_id;
        long arg_result_type_id;
        String func_main;

        OneOperator() {
        }
    }

    static final class OneRoutine {
        String r_name;
        long r_id;
        long r_state_number;
        String lang;
        String[] arg_names;
        String[] arg_modes;
        long[] in_arg_types;
        long[] all_arg_types;
        String arg_defaults;
        long arg_variadic_id;
        long ret_type_id;
        boolean ret_set;
        boolean is_aggregate;
        boolean is_window;
        char volatile_kind;

        OneRoutine() {
        }
    }

    static final class OneConstraint {
        long table_id;
        long con_id;
        String con_name;
        char table_kind;
        char con_kind;
        String con_columns;
        long index_id;
        long ref_table_id;
        boolean is_deferrable;
        boolean is_init_deferred;
        char on_update;
        char on_delete;
        String con_expression;

        OneConstraint() {
        }
    }

    static final class OneIndex {
        long table_id;
        char table_kind;
        String index_name;
        long index_id;
        boolean is_unique;
        boolean is_primary;
        String column_positions;
        String column_operators;
        String column_options;
        String condition;
        String expressions;

        OneIndex() {
        }
    }

    static final class OneColumn {
        long table_id;
        short column_position;
        String column_name;
        long column_state_number;
        int type_mod;
        short dimensions_number;
        String type_spec;
        boolean mandatory;
        String sequence;
        String column_default_expression;
        boolean column_is_inherited;
        boolean column_is_dropped;

        OneColumn() {
        }
    }

    static final class OneStructAttribute {
        long type_id;
        short att_position;
        String att_name;
        String att_type;

        OneStructAttribute() {
        }
    }

    static final class OneTable {
        char table_kind;
        String table_name;
        long table_id;
        long table_state_number;
        boolean table_with_oids;
        long tablespace_id;
        String options;
        String ancestors;
        String successors;

        OneTable() {
        }
    }

    static final class OneDataTypeCheck {
        long type_id;
        long constraint_id;
        long constraint_state_number;
        String constraint_name;
        String predicate;

        OneDataTypeCheck() {
        }
    }

    static final class OneDataType {
        long type_id;
        long type_state_number;
        String type_name;
        char type_sub_kind;
        char type_category;
        Long class_id;
        long base_type_id;
        String type_def;
        String default_expression;
        boolean mandatory;

        OneDataType() {
        }
    }

    static final class OneSequence {
        long sequence_id;
        long sequence_state_number;
        String sequence_name;
        String sequence_params;

        OneSequence() {
        }
    }

    static final class OneSchema {
        String schema_name;
        long schema_id;
        long schema_state_number;
        String owner_name;
        String description;

        OneSchema() {
        }
    }

    static final class CurrentSessionInfo {
        String current_database;
        String current_schema;
        Timestamp current_timestamp;

        CurrentSessionInfo() {
        }
    }
}

