/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.BaseIntrospectionFunctions;
import com.intellij.database.introspection.PostgresIntrospectionException;
import com.intellij.database.introspection.PostgresIntrospector;
import com.intellij.database.introspection.PostgresIntrospectorKt;
import com.intellij.database.model.DataType;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.PositioningFamily;
import com.intellij.database.model.postgres.PostgresDatabase;
import com.intellij.database.model.postgres.PostgresIndex;
import com.intellij.database.model.postgres.PostgresModForeignKey;
import com.intellij.database.model.postgres.PostgresModLikeStoredTable;
import com.intellij.database.model.postgres.PostgresModMatView;
import com.intellij.database.model.postgres.PostgresModSchema;
import com.intellij.database.model.postgres.PostgresModSequence;
import com.intellij.database.model.postgres.PostgresModView;
import com.intellij.database.model.postgres.PostgresSchema;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.PostgresCheckOption;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.SimpleCompositeText;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import gnu.trove.TLongHashSet;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000\u00ea\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\u0017\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\tH\u0002\u001a\u0012\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010 H\u0002\u001a\u0012\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0019H\u0002\u001a\u001e\u0010*\u001a\u0004\u0018\u00010\u000e2\b\u0010+\u001a\u0004\u0018\u00010 2\b\u0010,\u001a\u0004\u0018\u00010\u000eH\u0002\u001a\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00100\u001a\u000201H\u0002\u001a\u0014\u00102\u001a\u0004\u0018\u00010 2\b\u0010&\u001a\u0004\u0018\u00010 H\u0002\u001a\u000e\u00103\u001a\u00020 2\u0006\u00104\u001a\u00020 \u001a\u001a\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010 2\u0006\u00108\u001a\u00020 H\u0002\u001a\u001d\u00109\u001a\b\u0012\u0004\u0012\u00020 0\u00152\b\u00107\u001a\u0004\u0018\u00010 H\u0002\u00a2\u0006\u0002\u0010:\u001a\u0018\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<2\b\u00107\u001a\u0004\u0018\u00010 H\u0002\u001a\u0018\u0010>\u001a\b\u0012\u0004\u0012\u00020=0.2\b\u00107\u001a\u0004\u0018\u00010 H\u0002\u001a0\u0010?\u001a\b\u0012\u0004\u0012\u00020 0<2\b\u0010@\u001a\u0004\u0018\u00010 2\u0006\u00108\u001a\u00020 2\u000e\u0010A\u001a\n\u0012\u0006\b\u0001\u0012\u00020C0BH\u0002\u001a7\u0010D\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020F2\"\u0010G\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020I0H0\u0015\"\n\u0012\u0006\b\u0001\u0012\u00020I0H\u00a2\u0006\u0002\u0010J\u001a!\u0010K\u001a\u00020\u00042\u0012\u0010L\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010 \u0018\u00010\u0015H\u0002\u00a2\u0006\u0002\u0010M\u001a\u0010\u0010N\u001a\u00020 2\u0006\u00107\u001a\u00020 H\u0002\u001a\u001c\u0010O\u001a\u00020\u001c*\u00020P2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020=H\u0002\u001a\u0016\u0010T\u001a\u00020\u001c*\u00020U2\b\u0010V\u001a\u0004\u0018\u00010 H\u0002\u001a\u0016\u0010T\u001a\u00020\u001c*\u00020W2\b\u0010V\u001a\u0004\u0018\u00010 H\u0002\u001a\"\u0010X\u001a\u0004\u0018\u00010R*\u00020Y2\u0006\u0010Z\u001a\u00020=2\n\b\u0002\u0010[\u001a\u0004\u0018\u00010\\H\u0002\u001a \u0010]\u001a\u0004\u0018\u00010^*\u00020_2\b\b\u0001\u0010`\u001a\u00020\t2\u0006\u0010a\u001a\u00020=H\u0002\u001a\f\u0010b\u001a\u00020 *\u00020 H\u0002\u001a\u0014\u0010c\u001a\u00020 *\u00020 2\u0006\u0010#\u001a\u00020\tH\u0002\u001a\f\u0010d\u001a\u00020 *\u00020 H\u0002\"\u0018\u0010\u0000\u001a\f0\u0001\u00a2\u0006\u0002\b\u0002\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0012\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"$\u0010\u0013\u001a\u00020\u0014*\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0016\u0018\u00010\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\"\u001a\u0010\u0013\u001a\u00020\u0014*\u0004\u0018\u00010\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u001a\u00a8\u0006e"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NO_CHARS", "", "POSITION_OF_OID", "", "POSITION_OF_XMIN", "REL_ANY", "", "REL_MAT_VIEW", "REL_TABLE", "REL_VIEW", "SEQUENCE_DEFAULT_MAX", "Ljava/math/BigInteger;", "SEQUENCE_PARAMS_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "goodNameTemplate", "length", "", "", "", "getLength", "([Ljava/lang/Object;)I", "", "([J)I", "assignSequenceParams", "", "sequence", "Lcom/intellij/database/model/postgres/PostgresModSequence;", "sequenceParams", "", "cascadeRule", "Lcom/intellij/database/model/properties/CascadeRule;", "c", "dataTypeOf", "Lcom/intellij/database/model/DataType;", "spec", "isNotEmpty", "", "array", "makeBigInteger", "stringValue", "implicitAssumption", "makeTrigEvents", "", "Lcom/intellij/database/model/properties/TrigEvent;", "bits", "", "normalizeDataTypeSpec", "normalizeDefaultExpression", "expression", "parseArrayOfPositions", "", "str", "what", "parseArrayOfStrings", "(Ljava/lang/String;)[Ljava/lang/String;", "parseListOfLongs", "", "", "parseSmallSetOfLongs", "peekColNames", "columnPositions", "columns", "Lcom/intellij/database/model/families/PositioningFamily;", "Lcom/intellij/database/model/basic/BasicColumn;", "removeDroppedChildren", "existentIds", "Lgnu/trove/TLongHashSet;", "families", "Lcom/intellij/database/model/families/ModIdentifyingFamily;", "Lcom/intellij/database/model/basic/BasicModIdentifiedElement;", "(Lgnu/trove/TLongHashSet;[Lcom/intellij/database/model/families/ModIdentifyingFamily;)V", "stringsToChars", "strings", "([Ljava/lang/String;)[C", "unescape", "applyReferencingInfo", "Lcom/intellij/database/model/postgres/PostgresModForeignKey;", "refTable", "Lcom/intellij/database/model/postgres/PostgresTable;", "indexId", "applySourceText", "Lcom/intellij/database/model/postgres/PostgresModMatView;", "sourceText", "Lcom/intellij/database/model/postgres/PostgresModView;", "findTableByObjectId", "Lcom/intellij/database/model/postgres/PostgresDatabase;", "id", "preferredSchema", "Lcom/intellij/database/model/postgres/PostgresSchema;", "getTableOrView", "Lcom/intellij/database/model/postgres/PostgresModLikeStoredTable;", "Lcom/intellij/database/model/postgres/PostgresModSchema;", "relKind", "tableId", "nameToScript", "removeSuffix", "unquoteSingleName", "database-introspection"})
public final class PostgresIntrospectorKt {
    private static final Logger LOG = Logger.getInstance(PostgresIntrospector.class);
    private static final short POSITION_OF_XMIN = -3;
    private static final short POSITION_OF_OID = -2;
    private static final char REL_TABLE = 'r';
    private static final char REL_MAT_VIEW = 'm';
    private static final char REL_VIEW = 'v';
    private static final char REL_ANY = '\u0000';
    private static final char[] NO_CHARS = new char[0];
    private static final Pattern SEQUENCE_PARAMS_PATTERN = Pattern.compile("\\((\\d+),(\\d+),(\\d+),(\\d+),([FfTt])\\)");
    private static final BigInteger SEQUENCE_DEFAULT_MAX = new BigInteger("9223372036854775807");
    private static final Pattern goodNameTemplate = Pattern.compile("^\\p{IsLowercase}[\\p{IsLowercase}0-9_]*$");

    private static final PostgresModLikeStoredTable getTableOrView(@NotNull PostgresModSchema $receiver, char relKind, long tableId) {
        PostgresModLikeStoredTable table;
        char c = relKind;
        switch (Character.toLowerCase(c)) {
            case 'r': {
                table = (PostgresModLikeStoredTable)$receiver.getTables().getByObjectId(tableId);
                break;
            }
            case 'm': {
                table = (PostgresModLikeStoredTable)$receiver.getMatViews().getByObjectId(tableId);
                break;
            }
            case 'v': {
                table = (PostgresModLikeStoredTable)$receiver.getViews().getByObjectId(tableId);
                break;
            }
            case '\u0000': {
                table = (PostgresModLikeStoredTable)$receiver.getTables().getByObjectId(tableId);
                if (table == null) {
                    table = (PostgresModLikeStoredTable)$receiver.getViews().getByObjectId(tableId);
                }
                if (table != null) break;
                table = (PostgresModLikeStoredTable)$receiver.getMatViews().getByObjectId(tableId);
                break;
            }
            default: {
                table = null;
            }
        }
        return table;
    }

    /*
     * WARNING - void declaration
     */
    public static final void removeDroppedChildren(@NotNull TLongHashSet existentIds, ModIdentifyingFamily<? extends BasicModIdentifiedElement> ... families) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)existentIds, (String)"existentIds");
        Intrinsics.checkParameterIsNotNull(families, (String)"families");
        ArrayList<BasicModIdentifiedElement> objectsToRemove = new ArrayList<BasicModIdentifiedElement>();
        for (n = 0; n < families.length; ++n) {
            ModIdentifyingFamily<? extends BasicModIdentifiedElement> family = families[n];
            for (BasicModIdentifiedElement basicModIdentifiedElement : family) {
                long id = basicModIdentifiedElement.getObjectId();
                if (existentIds.contains(id)) continue;
                objectsToRemove.add(basicModIdentifiedElement);
            }
        }
        IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)CollectionsKt.getIndices((Collection)objectsToRemove)));
        int family = intProgression.getFirst();
        n = intProgression.getLast();
        int n2 = intProgression.getStep();
        int n3 = family;
        int n4 = n;
        if (n2 > 0 ? n3 <= n4 : n3 >= n4) {
            while (true) {
                void i2;
                BasicModElement objectToRemove = (BasicModElement)objectsToRemove.get((int)i2);
                objectToRemove.drop();
                if (i2 == n) break;
                void var3_5 = i2 + n2;
            }
        }
    }

    private static final DataType dataTypeOf(String spec) {
        String string = PostgresIntrospectorKt.normalizeDataTypeSpec(spec);
        if (string == null) {
            DataType dataType = DataType.UNKNOWN;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataType.UNKNOWN");
            return dataType;
        }
        String s = string;
        DataType dataType = DataTypeFactory.of(s);
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(s)");
        return dataType;
    }

    private static final String normalizeDataTypeSpec(String spec) {
        if (spec == null) {
            return null;
        }
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)spec, (String)"character varying", (String)"varchar", (boolean)false, (int)4, null), (String)"character", (String)"char", (boolean)false, (int)4, null), (String)"char(1)", (String)"char", (boolean)false, (int)4, null), (String)"bit(1)", (String)"bit", (boolean)false, (int)4, null), (String)" without time zone", (String)"", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String normalizeDefaultExpression(@NotNull String expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        return StringsKt.replace$default((String)expression, (String)"::character varying", (String)"", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> peekColNames(String columnPositions, String what, PositioningFamily<? extends BasicColumn> columns) {
        short[] positions = PostgresIntrospectorKt.parseArrayOfPositions(columnPositions, what);
        int n = positions.length;
        ArrayList<String> names = new ArrayList<String>(n);
        int n2 = 0;
        int n3 = n - 1;
        if (n2 <= n3) {
            while (true) {
                void i2;
                short position;
                if ((position = positions[i2]) > 0) {
                    BasicColumn column = columns.getByNaturalPosition(position);
                    if (column != null) {
                        names.add(column.getName());
                    }
                } else if (position < 0) {
                    switch (position) {
                        case -3: {
                            names.add("xmin");
                            break;
                        }
                        case -2: {
                            names.add("oid");
                        }
                    }
                }
                if (i2 == n3) break;
                ++i2;
            }
        }
        return names;
    }

    /*
     * WARNING - void declaration
     */
    private static final short[] parseArrayOfPositions(String str, String what) {
        String[] s = PostgresIntrospectorKt.parseArrayOfStrings(str);
        int n = PostgresIntrospectorKt.getLength(s);
        if (n == 0) {
            return new short[0];
        }
        short[] positions = new short[n];
        try {
            int n2 = 0;
            int n3 = n - 1;
            if (n2 <= n3) {
                while (true) {
                    void i2;
                    positions[i2] = Short.parseShort(s[i2]);
                    if (i2 != n3) {
                        ++i2;
                        continue;
                    }
                    break;
                }
            }
        }
        catch (NumberFormatException nfe) {
            PostgresIntrospectionException postgresIntrospectionException;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Cannot parse %s: '%s'";
            Object[] objectArray = new Object[]{what, str};
            PostgresIntrospectionException postgresIntrospectionException2 = postgresIntrospectionException;
            PostgresIntrospectionException postgresIntrospectionException3 = postgresIntrospectionException;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            postgresIntrospectionException2(string3, nfe);
            throw (Throwable)postgresIntrospectionException3;
        }
        return positions;
    }

    /*
     * Unable to fully structure code
     */
    private static final char[] stringsToChars(String[] strings) {
        block4: {
            if (strings == null || PostgresIntrospectorKt.getLength(strings) == 0) {
                return PostgresIntrospectorKt.NO_CHARS;
            }
            n = PostgresIntrospectorKt.getLength(strings);
            chars = new char[n];
            var3_3 = 0;
            var4_4 = n - 1;
            if (var3_3 > var4_4) break block4;
            while (true) {
                s = strings[i];
                v0 = chars;
                v1 = i;
                if (s == null) ** GOTO lbl-1000
                var6_6 = s;
                var8_8 = v1;
                var7_7 = v0;
                var9_9 = var6_6.length() > 0;
                v0 = var7_7;
                v1 = var8_8;
                if (var9_9) {
                    v2 = s.charAt(0);
                } else lbl-1000:
                // 2 sources

                {
                    v2 = v0[v1] = '\u0000';
                }
                if (i == var4_4) break;
                ++i;
            }
        }
        return chars;
    }

    private static final Set<Long> parseSmallSetOfLongs(String str) {
        Set set;
        List<Long> list = PostgresIntrospectorKt.parseListOfLongs(str);
        switch (list.size()) {
            case 0: {
                set = SetsKt.emptySet();
                break;
            }
            case 1: {
                Set set2 = Collections.singleton(list.get(0));
                set = set2;
                Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"java.util.Collections.singleton(list.get(0))");
                break;
            }
            default: {
                set = new TreeSet(list);
            }
        }
        return set;
    }

    private static final List<Long> parseListOfLongs(String str) {
        List list;
        String[] strings = PostgresIntrospectorKt.parseArrayOfStrings(str);
        int n = PostgresIntrospectorKt.getLength(strings);
        if (n == 0) {
            return CollectionsKt.emptyList();
        }
        ArrayList<Long> list2 = new ArrayList<Long>(n);
        for (int j = 0; j < strings.length; ++j) {
            String string = strings[j];
            try {
                CharSequence charSequence = string;
                String string2 = charSequence;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String s = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                charSequence = s;
                if (charSequence.length() == 0) continue;
                long value = Long.parseLong(s);
                list2.add(value);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        switch (list2.size()) {
            case 0: {
                list = CollectionsKt.emptyList();
                break;
            }
            case 1: {
                List list3 = Collections.singletonList(list2.get(0));
                list = list3;
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"java.util.Collections.singletonList(list.get(0))");
                break;
            }
            default: {
                list = list2;
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String[] parseArrayOfStrings(String str) {
        List list;
        List list2;
        int len;
        String string = str;
        int n = len = string != null ? string.length() : 0;
        if (len == 0) {
            Intrinsics.checkExpressionValueIsNotNull((Object)ArrayUtil.EMPTY_STRING_ARRAY, (String)"ArrayUtil.EMPTY_STRING_ARRAY");
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if (len >= 2) {
            String string2 = str;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            if (string2.charAt(0) == '{' && str.charAt(len - 1) == '}') {
                void $receiver$iv$iv;
                List list3;
                Object iterator$iv;
                List list4;
                String string3 = str;
                int n2 = 1;
                int n3 = len - 1;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n2, n3);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                CharSequence charSequence = string5;
                String string6 = ",";
                string6 = new Regex(string6);
                n3 = 0;
                int n4 = 2;
                Object var7_23 = null;
                if ((n4 & 2) != 0) {
                    n3 = 0;
                }
                if (!(list4 = string6.split(charSequence, n3)).isEmpty()) {
                    iterator$iv = list4.listIterator(list4.size());
                    while (iterator$iv.hasPrevious()) {
                        String p1 = (String)iterator$iv.previous();
                        CharSequence charSequence2 = p1;
                        if (charSequence2.length() == 0) continue;
                        list3 = CollectionsKt.take((Iterable)list4, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list3 = CollectionsKt.emptyList();
                }
                Iterable iterable = list3;
                iterator$iv = iterable;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void p1;
                    String $i$f$dropLastWhile = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    String string7 = PostgresIntrospectorKt.unescape((String)p1);
                    collection.add(string7);
                }
                Collection collection = (List)destination$iv$iv;
                Collection thisCollection$iv = collection;
                String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
                if (stringArray != null) return stringArray;
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
        }
        String string8 = str;
        if (string8 == null) {
            Intrinsics.throwNpe();
        }
        CharSequence charSequence = string8;
        Object thisCollection$iv = " ";
        thisCollection$iv = new Regex((String)thisCollection$iv);
        int $i$f$toTypedArray = 0;
        int n5 = 2;
        Object item$iv$iv = null;
        if ((n5 & 2) != 0) {
            $i$f$toTypedArray = 0;
        }
        if (!(list2 = thisCollection$iv.split(charSequence, $i$f$toTypedArray)).isEmpty()) {
            ListIterator iterator$iv = list2.listIterator(list2.size());
            while (iterator$iv.hasPrevious()) {
                String p1 = (String)iterator$iv.previous();
                CharSequence charSequence3 = p1;
                if (charSequence3.length() == 0) continue;
                list = CollectionsKt.take((Iterable)list2, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection collection = list;
        Collection collection2 = collection;
        if (collection2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        thisCollection$iv = collection2;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray != null) return stringArray;
        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
    }

    private static final String unescape(String str) {
        int last = str.length() - 1;
        if (str.length() < 2 || str.charAt(0) != '\"' || str.charAt(last) != '\"') {
            return str;
        }
        StringBuilder unescaped = new StringBuilder(str.length() - 2);
        for (int i2 = 1; i2 < last; ++i2) {
            char c = str.charAt(i2);
            if (c == '/' && i2 + 1 < last) {
                ++i2;
            }
            unescaped.append(c);
        }
        String string = unescaped.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"unescaped.toString()");
        return string;
    }

    private static final Set<TrigEvent> makeTrigEvents(byte bits) {
        byte $receiver$iv;
        EnumSet<TrigEvent> events = EnumSet.noneOf(TrigEvent.class);
        byte by = bits;
        int that$iv = 4;
        byte $receiver$iv$iv = $receiver$iv;
        if ((Byte.toUnsignedInt($receiver$iv$iv) & that$iv) != 0) {
            events.add(TrigEvent.INSERT);
        }
        $receiver$iv = bits;
        that$iv = 8;
        $receiver$iv$iv = $receiver$iv;
        if ((Byte.toUnsignedInt($receiver$iv$iv) & that$iv) != 0) {
            events.add(TrigEvent.DELETE);
        }
        $receiver$iv = bits;
        that$iv = 16;
        $receiver$iv$iv = $receiver$iv;
        if ((Byte.toUnsignedInt($receiver$iv$iv) & that$iv) != 0) {
            events.add(TrigEvent.UPDATE);
        }
        EnumSet<TrigEvent> enumSet = events;
        Intrinsics.checkExpressionValueIsNotNull(enumSet, (String)"events");
        return enumSet;
    }

    private static final void assignSequenceParams(PostgresModSequence sequence, String sequenceParams) {
        Matcher m = SEQUENCE_PARAMS_PATTERN.matcher(sequenceParams);
        if (m.find()) {
            try {
                BigInteger next = PostgresIntrospectorKt.makeBigInteger(m.group(1), BigInteger.ONE);
                BigInteger min = PostgresIntrospectorKt.makeBigInteger(m.group(2), BigInteger.ONE);
                BigInteger max = PostgresIntrospectorKt.makeBigInteger(m.group(3), SEQUENCE_DEFAULT_MAX);
                BigInteger inc = PostgresIntrospectorKt.makeBigInteger(m.group(4), BigInteger.ONE);
                String string = m.group(5);
                Locale locale = Locale.ROOT;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
                Locale locale2 = locale;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase(locale2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
                boolean cycled = StringsKt.contains$default((CharSequence)string3, (CharSequence)"t", (boolean)false, (int)2, null);
                sequence.setSequenceIdentity(SequenceIdentity.of(min, next, inc, max));
                sequence.setCycled(cycled);
            }
            catch (Exception e) {
                LOG.info("Unexpected exception when assigning Postgres sequence parameters. The parameters string: " + sequenceParams + ". " + "Exception message: " + e.getMessage(), (Throwable)e);
            }
        } else {
            LOG.debug("Unexpected format of the Postgres sequence parameters string: " + sequenceParams);
        }
    }

    private static final BigInteger makeBigInteger(String stringValue, BigInteger implicitAssumption) {
        if (stringValue == null) {
            return null;
        }
        BigInteger value = new BigInteger(stringValue);
        return Intrinsics.areEqual((Object)value, (Object)implicitAssumption) ? null : value;
    }

    private static final void applySourceText(@NotNull PostgresModView $receiver, String sourceText) {
        CharSequence charSequence;
        if (sourceText == null || (charSequence = (CharSequence)sourceText).length() == 0) {
            $receiver.setSourceText(null);
            return;
        }
        String head = "CREATE VIEW " + PostgresIntrospectorKt.nameToScript($receiver.getName()) + " AS ";
        String string = sourceText;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String body = stringBuilder.append(PostgresIntrospectorKt.removeSuffix(string2, ';')).append('\n').toString();
        String withCO = Intrinsics.areEqual((Object)((Object)$receiver.getCheckOption()), (Object)((Object)PostgresCheckOption.NONE)) ^ true ? "WITH " + (Object)((Object)$receiver.getCheckOption()) + " CHECK OPTION" : "";
        $receiver.setSourceText(new SimpleCompositeText(head, CompositeText.Kind.FIXED_TEXT, body, CompositeText.Kind.ORIGINAL_TEXT, withCO, CompositeText.Kind.PLAIN_TEXT));
    }

    private static final void applySourceText(@NotNull PostgresModMatView $receiver, String sourceText) {
        CharSequence charSequence;
        if (sourceText == null || (charSequence = (CharSequence)sourceText).length() == 0) {
            $receiver.setSourceText(null);
            return;
        }
        String head = "CREATE MATERIALIZED VIEW " + PostgresIntrospectorKt.nameToScript($receiver.getName()) + " AS ";
        String string = sourceText;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String body = stringBuilder.append(PostgresIntrospectorKt.removeSuffix(string2, ';')).append('\n').toString();
        $receiver.setSourceText(new SimpleCompositeText(head, CompositeText.Kind.FIXED_TEXT, body, CompositeText.Kind.ORIGINAL_TEXT));
    }

    private static final String nameToScript(@NotNull String $receiver) {
        String string;
        CharSequence charSequence = $receiver;
        Pattern pattern = goodNameTemplate;
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"goodNameTemplate");
        if (BaseIntrospectionFunctions.matches(charSequence, pattern)) {
            string = $receiver;
        } else {
            char c = '\"';
            String string2 = StringsKt.replace$default((String)$receiver, (String)"\"", (String)"\"\"", (boolean)false, (int)4, null);
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = String.valueOf(c) + string2;
            string = stringBuilder.append(string3).append('\"').toString();
        }
        return string;
    }

    private static final CascadeRule cascadeRule(char c) {
        CascadeRule cascadeRule;
        switch (c) {
            case 'c': {
                cascadeRule = CascadeRule.cascade;
                break;
            }
            case 'd': {
                cascadeRule = CascadeRule.set_default;
                break;
            }
            case 'n': {
                cascadeRule = CascadeRule.set_null;
                break;
            }
            case 'r': {
                cascadeRule = CascadeRule.restrict;
                break;
            }
            default: {
                cascadeRule = CascadeRule.no_action;
            }
        }
        return cascadeRule;
    }

    private static final boolean isNotEmpty(long[] array) {
        long[] lArray;
        long[] lArray2;
        return array != null && !((lArray2 = (lArray = array)).length == 0);
    }

    private static final int getLength(@Nullable Object[] $receiver) {
        return $receiver != null ? $receiver.length : 0;
    }

    private static final int getLength(@Nullable long[] $receiver) {
        return $receiver != null ? $receiver.length : 0;
    }

    private static final String removeSuffix(@NotNull String $receiver, char c) {
        int n = $receiver.length();
        if (n > 0 || $receiver.charAt(n - 1) == c) {
            String string = $receiver;
            int n2 = 0;
            int n3 = n - 1;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n2, n3);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string3;
        }
        return $receiver;
    }

    private static final String unquoteSingleName(@NotNull String $receiver) {
        int n = $receiver.length();
        if (n >= 2 && $receiver.charAt(0) == '\"' && $receiver.charAt(n - 1) == '\"') {
            String string = $receiver;
            int n2 = 1;
            int n3 = n - 1;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n2, n3);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return StringsKt.replace$default((String)string3, (String)"\"\"", (String)"\"", (boolean)false, (int)4, null);
        }
        return $receiver;
    }

    private static final PostgresTable findTableByObjectId(@NotNull PostgresDatabase $receiver, long id, PostgresSchema preferredSchema) {
        PostgresTable table = null;
        if (preferredSchema != null) {
            table = (PostgresTable)preferredSchema.getTables().getByObjectId(id);
        }
        if (table == null) {
            table = (PostgresTable)$receiver.getSchemas().jbi().filter((Condition)new Condition<PostgresSchema>(preferredSchema){
                final /* synthetic */ PostgresSchema $preferredSchema;

                public final boolean value(PostgresSchema s) {
                    return Intrinsics.areEqual((Object)s, (Object)this.$preferredSchema) ^ true;
                }
                {
                    this.$preferredSchema = postgresSchema;
                }
            }).transform(new Function<E, T>(id){
                final /* synthetic */ long $id;

                @Nullable
                public final PostgresTable fun(PostgresSchema s) {
                    return (PostgresTable)s.getTables().getByObjectId(this.$id);
                }
                {
                    this.$id = l;
                }
            }).filter((Condition)findTableByObjectId.3.INSTANCE).first();
        }
        return table;
    }

    static /* bridge */ /* synthetic */ PostgresTable findTableByObjectId$default(PostgresDatabase postgresDatabase, long l, PostgresSchema postgresSchema, int n, Object object) {
        if ((n & 2) != 0) {
            postgresSchema = null;
        }
        return PostgresIntrospectorKt.findTableByObjectId(postgresDatabase, l, postgresSchema);
    }

    private static final void applyReferencingInfo(@NotNull PostgresModForeignKey $receiver, PostgresTable refTable, long indexId) {
        PostgresIndex refIndex = (PostgresIndex)refTable.getIndices().getByObjectId(indexId);
        $receiver.setRefTableName(refTable.getRealName());
        PostgresIndex postgresIndex = refIndex;
        $receiver.setRefKeyName(postgresIndex != null ? postgresIndex.getRealName() : null);
        Object object = refIndex;
        if (object == null || (object = object.getColNames()) == null) {
            object = CollectionsKt.emptyList();
        }
        $receiver.setRefColNames((List<String>)object);
    }

    public static final /* synthetic */ void access$assignSequenceParams(@NotNull PostgresModSequence sequence, @NotNull String sequenceParams) {
        PostgresIntrospectorKt.assignSequenceParams(sequence, sequenceParams);
    }

    @Nullable
    public static final /* synthetic */ String access$normalizeDataTypeSpec(@Nullable String spec) {
        return PostgresIntrospectorKt.normalizeDataTypeSpec(spec);
    }

    @NotNull
    public static final /* synthetic */ List access$parseListOfLongs(@Nullable String str) {
        return PostgresIntrospectorKt.parseListOfLongs(str);
    }

    @NotNull
    public static final /* synthetic */ Set access$parseSmallSetOfLongs(@Nullable String str) {
        return PostgresIntrospectorKt.parseSmallSetOfLongs(str);
    }

    @NotNull
    public static final /* synthetic */ char[] access$stringsToChars(@Nullable String[] strings) {
        return PostgresIntrospectorKt.stringsToChars(strings);
    }

    public static final /* synthetic */ boolean access$isNotEmpty(@Nullable long[] array) {
        return PostgresIntrospectorKt.isNotEmpty(array);
    }

    public static final /* synthetic */ int access$getLength$p(@Nullable Object[] $receiver) {
        return PostgresIntrospectorKt.getLength($receiver);
    }

    public static final /* synthetic */ int access$getLength$p(@Nullable long[] $receiver) {
        return PostgresIntrospectorKt.getLength($receiver);
    }

    @Nullable
    public static final /* synthetic */ PostgresModLikeStoredTable access$getTableOrView(@NotNull PostgresModSchema $receiver, char relKind, long tableId) {
        return PostgresIntrospectorKt.getTableOrView($receiver, relKind, tableId);
    }

    @NotNull
    public static final /* synthetic */ DataType access$dataTypeOf(@Nullable String spec) {
        return PostgresIntrospectorKt.dataTypeOf(spec);
    }

    @NotNull
    public static final /* synthetic */ String access$unquoteSingleName(@NotNull String $receiver) {
        return PostgresIntrospectorKt.unquoteSingleName($receiver);
    }

    @NotNull
    public static final /* synthetic */ List access$peekColNames(@Nullable String columnPositions, @NotNull String what, @NotNull PositioningFamily columns) {
        return PostgresIntrospectorKt.peekColNames(columnPositions, what, columns);
    }

    @Nullable
    public static final /* synthetic */ PostgresTable access$findTableByObjectId(@NotNull PostgresDatabase $receiver, long id, @Nullable PostgresSchema preferredSchema) {
        return PostgresIntrospectorKt.findTableByObjectId($receiver, id, preferredSchema);
    }

    public static final /* synthetic */ void access$applyReferencingInfo(@NotNull PostgresModForeignKey $receiver, @NotNull PostgresTable refTable, long indexId) {
        PostgresIntrospectorKt.applyReferencingInfo($receiver, refTable, indexId);
    }

    @NotNull
    public static final /* synthetic */ CascadeRule access$cascadeRule(char c) {
        return PostgresIntrospectorKt.cascadeRule(c);
    }

    @NotNull
    public static final /* synthetic */ Set access$makeTrigEvents(byte bits) {
        return PostgresIntrospectorKt.makeTrigEvents(bits);
    }

    public static final /* synthetic */ void access$applySourceText(@NotNull PostgresModMatView $receiver, @Nullable String sourceText) {
        PostgresIntrospectorKt.applySourceText($receiver, sourceText);
    }

    public static final /* synthetic */ void access$applySourceText(@NotNull PostgresModView $receiver, @Nullable String sourceText) {
        PostgresIntrospectorKt.applySourceText($receiver, sourceText);
    }
}

