/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import java.util.List;
import org.jetbrains.dekaf.core.Layouts;
import org.jetbrains.dekaf.core.RowLayout;
import org.jetbrains.dekaf.sql.Scriptum;
import org.jetbrains.dekaf.sql.SqlQuery;

public final class SqliteIntroQueries {
    static final SqliteIntroQueries QUERIES = new SqliteIntroQueries();
    private final Scriptum myScriptum = Scriptum.of(SqliteIntroQueries.class);
    final SqlQuery<List<SchemaInfo>> listSchemas = this.myScriptum.query("ListSchemas", Layouts.listOf((RowLayout)Layouts.structOf(SchemaInfo.class)));
    final SqlQuery<List<MajorInfo>> retrieveMajors = this.myScriptum.query("RetrieveMajors", Layouts.listOf((RowLayout)Layouts.structOf(MajorInfo.class)));
    final SqlQuery<List<MajorInfo>> retrieveTempMajors = this.myScriptum.query("RetrieveTempMajors", Layouts.listOf((RowLayout)Layouts.structOf(MajorInfo.class)));
    final SqlQuery<List<SourceInfo>> retrieveSources = this.myScriptum.query("RetrieveSources", Layouts.listOf((RowLayout)Layouts.structOf(SourceInfo.class)));
    final SqlQuery<List<SourceInfo>> retrieveTempSources = this.myScriptum.query("RetrieveTempSources", Layouts.listOf((RowLayout)Layouts.structOf(SourceInfo.class)));
    final SqlQuery<List<ColumnInfo>> listColumns = this.myScriptum.query("ListColumns", Layouts.listOf((RowLayout)Layouts.structOf(ColumnInfo.class)));
    final SqlQuery<List<IndexInfo>> listIndices = this.myScriptum.query("ListIndices", Layouts.listOf((RowLayout)Layouts.structOf(IndexInfo.class)));
    final SqlQuery<List<IndexColumnInfo>> listIndexColumns = this.myScriptum.query("listIndexColumns", Layouts.listOf((RowLayout)Layouts.structOf(IndexColumnInfo.class)));
    final SqlQuery<List<ForeignKeyInfo>> listForeignKeys = this.myScriptum.query("ListForeignKeys", Layouts.listOf((RowLayout)Layouts.structOf(ForeignKeyInfo.class)));

    public static String quote(String s) {
        return "\"" + s.replace("\"", "\"\"") + "\"";
    }

    static final class ForeignKeyInfo {
        Integer id;
        Integer seq;
        String table;
        String from;
        String to;
        String on_update;
        String on_delete;
        String match;

        ForeignKeyInfo() {
        }
    }

    static final class IndexColumnInfo {
        Integer seqno;
        Integer cid;
        String name;
        Integer desc;
        String coll;
        Integer key;

        IndexColumnInfo() {
        }
    }

    static final class IndexInfo {
        Integer seq;
        String name;
        Integer unique;
        String origin;
        Integer partial;

        IndexInfo() {
        }
    }

    static final class ColumnInfo {
        Integer cid;
        String name;
        String type;
        Integer notnull;
        String dflt_value;
        Integer pk;

        ColumnInfo() {
        }
    }

    static final class SourceInfo {
        String type;
        String name;
        String tbl_name;
        Integer rootpage;
        String sql;

        SourceInfo() {
        }
    }

    static final class MajorInfo {
        String type;
        String name;
        String tbl_name;
        Integer rootpage;

        MajorInfo() {
        }
    }

    static final class SchemaInfo {
        Integer seq;
        String name;
        String file;

        SchemaInfo() {
        }
    }
}

