/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection.jdbcMetadataWrappers;

import com.intellij.database.introspection.jdbcMetadataWrappers.ClosableIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.model.DasRoutine;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class SybaseRoutineIt
extends ClosableIt.DelegateMutableIt<DatabaseMetaDataWrapper.Table, DatabaseMetaDataWrapper.Routine> {
    private final DatabaseMetaDataWrapper.Schema mySchema;

    SybaseRoutineIt(@NotNull DatabaseMetaDataWrapper.Schema schema, Iterator<? extends DatabaseMetaDataWrapper.Table> it) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/jdbcMetadataWrappers/SybaseRoutineIt", "<init>"));
        }
        super(it);
        this.mySchema = schema;
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.Routine createStorage() {
        DatabaseMetaDataWrapper.Routine routine2 = new DatabaseMetaDataWrapper.Routine(this.mySchema, null, "");
        if (routine2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/jdbcMetadataWrappers/SybaseRoutineIt", "createStorage"));
        }
        return routine2;
    }

    public static boolean isSybTableName(String name, String type) {
        return !"SYSTEM TABLE".equals(type) || name.startsWith("sys");
    }

    @Override
    protected DatabaseMetaDataWrapper.Routine calcValue(DatabaseMetaDataWrapper.Table cur) {
        if (cur == null) {
            return (DatabaseMetaDataWrapper.Routine)this.skip();
        }
        DatabaseMetaDataWrapper.Routine res = (DatabaseMetaDataWrapper.Routine)this.getStorageToFill();
        res.name = cur.name;
        res.specificName = cur.name;
        res.kind = DasRoutine.Kind.FUNCTION;
        res.comment = cur.comment;
        return res;
    }
}

