/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection.jdbcMetadataWrappers;

import com.intellij.database.introspection.jdbcMetadataWrappers.ClosableIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.introspection.jdbcMetadataWrappers.MetaDataUtil;
import com.intellij.database.model.DasIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class TableIndexColumnIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.TableIndexColumn> {
    public static final Pattern COLUMN_SPLITTER_PATTERN = Pattern.compile("\\s*,\\s*");
    private final DatabaseMetaDataWrapper.TableIndexColumn myTemplate;
    private final DatabaseMetaDataWrapper.Table myTable;
    private String[] mySubColumns;
    private int mySubIdx;

    public TableIndexColumnIt(@NotNull ResultSet rs, @NotNull DatabaseMetaDataWrapper.Table table) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rs", "com/intellij/database/introspection/jdbcMetadataWrappers/TableIndexColumnIt", "<init>"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/introspection/jdbcMetadataWrappers/TableIndexColumnIt", "<init>"));
        }
        super(rs);
        this.mySubIdx = -1;
        this.myTable = table;
        this.myTemplate = this.createStorage();
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.TableIndexColumn createStorage() {
        DatabaseMetaDataWrapper.TableIndexColumn tableIndexColumn = new DatabaseMetaDataWrapper.TableIndexColumn(new DatabaseMetaDataWrapper.TableIndex(this.myTable, ""));
        if (tableIndexColumn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/jdbcMetadataWrappers/TableIndexColumnIt", "createStorage"));
        }
        return tableIndexColumn;
    }

    @Override
    protected DatabaseMetaDataWrapper.TableIndexColumn calcValue() throws SQLException {
        DatabaseMetaDataWrapper.TableIndexColumn res = (DatabaseMetaDataWrapper.TableIndexColumn)this.getStorageToFill();
        try {
            String table = this.myRs.getString("TABLE_NAME", 3);
            if (StringUtil.isEmpty((String)table)) {
                return (DatabaseMetaDataWrapper.TableIndexColumn)this.skip();
            }
            res.index.type = this.myRs.getShort("TYPE", 7);
            if (res.index.type == 0) {
                return (DatabaseMetaDataWrapper.TableIndexColumn)this.skip();
            }
            String cat = this.myRs.getString("TABLE_CAT", 1);
            String schema = StringUtil.notNullize((String)this.myRs.getString("TABLE_SCHEM", 2), (String)this.myTable.schema.schema);
            if (!Comparing.equal((String)schema, (String)this.myTable.schema.schema) || !Comparing.equal((String)table, (String)this.myTable.name)) {
                return (DatabaseMetaDataWrapper.TableIndexColumn)this.skip();
            }
            res.index.nonUnique = this.myRs.getBoolean("NON_UNIQUE", 4);
            res.index.name = this.myRs.getString("INDEX_NAME", 6);
            String ascOrDesc = this.myRs.getString("ASC_OR_DESC", 10);
            res.sorting = "a".equalsIgnoreCase(ascOrDesc) ? DasIndex.Sorting.ASCENDING : ("d".equalsIgnoreCase(ascOrDesc) ? DasIndex.Sorting.DESCENDING : DasIndex.Sorting.NONE);
            res.index.qualifier = this.myRs.getString("INDEX_QUALIFIER", 5);
            res.position = this.myRs.getShort("ORDINAL_POSITION", 8);
            res.name = this.myRs.getString("COLUMN_NAME", 9);
            String[] columnNames = COLUMN_SPLITTER_PATTERN.split(res.name, 0);
            if (columnNames.length > 1) {
                for (int i2 = 0; i2 < columnNames.length; ++i2) {
                    columnNames[i2] = StringUtil.unquoteString((String)columnNames[i2]);
                }
                this.myTemplate.assign(res);
                this.mySubColumns = columnNames;
                this.mySubIdx = 0;
                return (DatabaseMetaDataWrapper.TableIndexColumn)this.skip();
            }
            if (!StringUtil.isEmpty((String)res.name)) {
                res.name = StringUtil.unquoteString((String)res.name);
            }
        }
        catch (SQLException e) {
            this.onError(res, e);
            return (DatabaseMetaDataWrapper.TableIndexColumn)this.skip();
        }
        return res;
    }

    @Override
    protected DatabaseMetaDataWrapper.TableIndexColumn nextImpl() {
        if (this.mySubIdx != -1 && this.mySubColumns != null) {
            DatabaseMetaDataWrapper.TableIndexColumn res = (DatabaseMetaDataWrapper.TableIndexColumn)this.getStorageToFill();
            res.assign(this.myTemplate);
            res.name = this.mySubColumns[this.mySubIdx];
            ++this.mySubIdx;
            if (this.mySubIdx >= this.mySubColumns.length) {
                this.mySubIdx = -1;
                this.mySubColumns = null;
            }
            return res;
        }
        return (DatabaseMetaDataWrapper.TableIndexColumn)super.nextImpl();
    }

    @Override
    public void onError(DatabaseMetaDataWrapper.TableIndexColumn cur, SQLException e) {
        String title = cur == null ? null : MetaDataUtil.qName(cur.index.table.schema.database, cur.index.table.schema.schema, cur.index.table.name);
        this.addError(title, e);
    }

    public static class Grouping
    extends ClosableIt.GroupingItImpl<DatabaseMetaDataWrapper.TableIndex, DatabaseMetaDataWrapper.TableIndexColumn, DatabaseMetaDataWrapper.TableIndexColumn> {
        protected Grouping(@NotNull ClosableIt<DatabaseMetaDataWrapper.TableIndexColumn> delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/introspection/jdbcMetadataWrappers/TableIndexColumnIt$Grouping", "<init>"));
            }
            super(delegate);
        }

        @Override
        @NotNull
        protected ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableIndexColumn> createGroupIt(ClosableIt<DatabaseMetaDataWrapper.TableIndexColumn> it) {
            final String indexName = ((DatabaseMetaDataWrapper.TableIndexColumn)it.current()).index.name;
            ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableIndexColumn> groupIt = new ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableIndexColumn>(it){

                @Override
                protected boolean isInGroup(DatabaseMetaDataWrapper.TableIndexColumn item) {
                    return Comparing.equal((String)indexName, (String)item.index.name);
                }
            };
            if (groupIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/jdbcMetadataWrappers/TableIndexColumnIt$Grouping", "createGroupIt"));
            }
            return groupIt;
        }

        @Override
        protected DatabaseMetaDataWrapper.TableIndex getItem(ClosableIt<DatabaseMetaDataWrapper.TableIndexColumn> it) {
            return ((DatabaseMetaDataWrapper.TableIndexColumn)it.current()).index;
        }
    }
}

