/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection.jdbcMetadataWrappers;

import com.intellij.database.introspection.jdbcMetadataWrappers.ClosableIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class UserDefinedTypeIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.UserDefinedType> {
    private final DatabaseMetaDataWrapper.Schema mySchema;

    public UserDefinedTypeIt(@NotNull ResultSet rs, @NotNull DatabaseMetaDataWrapper.Schema schema) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rs", "com/intellij/database/introspection/jdbcMetadataWrappers/UserDefinedTypeIt", "<init>"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/jdbcMetadataWrappers/UserDefinedTypeIt", "<init>"));
        }
        super(rs);
        this.mySchema = schema;
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.UserDefinedType createStorage() {
        DatabaseMetaDataWrapper.UserDefinedType userDefinedType = new DatabaseMetaDataWrapper.UserDefinedType(this.mySchema);
        if (userDefinedType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/jdbcMetadataWrappers/UserDefinedTypeIt", "createStorage"));
        }
        return userDefinedType;
    }

    @Override
    protected DatabaseMetaDataWrapper.UserDefinedType calcValue() throws SQLException {
        DatabaseMetaDataWrapper.UserDefinedType res = (DatabaseMetaDataWrapper.UserDefinedType)this.getStorageToFill();
        try {
            String name = this.myRs.getString("TYPE_NAME", 3);
            if (StringUtil.isEmpty((String)name)) {
                return (DatabaseMetaDataWrapper.UserDefinedType)this.skip();
            }
            String cat = this.myRs.getString("TYPE_CAT", 1);
            String schema = StringUtil.notNullize((String)this.myRs.getString("TYPE_SCHEM", 2), (String)this.mySchema.schema);
            if (!Comparing.equal((String)schema, (String)this.mySchema.schema)) {
                return (DatabaseMetaDataWrapper.UserDefinedType)this.skip();
            }
            String cls = this.myRs.getString("CLASS_NAME", 4);
            String dt = this.myRs.getString("DATA_TYPE", 5);
            String bt = this.myRs.getString("BASE_TYPE", 7);
            res.name = name;
            res.comment = this.myRs.getString("REMARKS", 6);
        }
        catch (SQLException e) {
            this.onError(res, e);
            return (DatabaseMetaDataWrapper.UserDefinedType)this.skip();
        }
        return res;
    }
}

