/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BasicElement
extends BasicNode,
DasObject {
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.UNKNOWN_OBJECT;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicElement", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    default public BasicModel getModel() {
        BasicElement parent = this.getDbParent();
        return parent != null ? parent.getModel() : null;
    }

    @Nullable
    public BasicElement getDbParent();

    default public @Nullable Family<@NotNull ? extends BasicElement> getParentFamily() {
        return null;
    }

    default public int getPositionInFamily() {
        Family<@NotNull ? extends BasicElement> f = this.getParentFamily();
        if (f != null) {
            int index = f.indexOf(this);
            return index >= 0 ? index + 1 : Integer.MAX_VALUE;
        }
        return 0;
    }

    @NotNull
    default public String getDisplayOrder() {
        String string = this.calculateDisplayOrder();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicElement", "getDisplayOrder"));
        }
        return string;
    }

    @NotNull
    default public String calculateDisplayOrder() {
        String name = this.getName();
        String string = name.length() > 0 ? name : "\uffff";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicElement", "calculateDisplayOrder"));
        }
        return string;
    }

    @NotNull
    default public String identity() {
        String string = this.identity(true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicElement", "identity"));
        }
        return string;
    }

    @NotNull
    default public String identity(boolean includingSurrogate) {
        if (this instanceof BasicNamedElement) {
            String name;
            BasicNamedElement e = (BasicNamedElement)this;
            String string = name = includingSurrogate ? e.getRealName() : e.getNaturalName();
            if (name != null) {
                String string2 = name;
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicElement", "identity"));
                }
                return string2;
            }
        }
        String string = '#' + Integer.toString(this.getPositionInFamily());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicElement", "identity"));
        }
        return string;
    }

    @NotNull
    default public @NotNull List<@NotNull String> getDbPath() {
        ArrayList<@NotNull String> path = new ArrayList<String>(this instanceof BasicNamespace ? 2 : 4);
        BasicElement e = this;
        while (e != null) {
            path.add(0, e.identity());
            if (!((e = e.getDbParent()) instanceof BasicRoot)) continue;
            ArrayList<String> arrayList = path;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicElement", "getDbPath"));
            }
            return arrayList;
        }
        throw new IllegalStateException("No path from the root found because no root");
    }

    @NotNull
    public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies();

    @NotNull
    public @NotNull List<@NotNull ObjectKind> getFamilyKinds();

    public @Nullable Family<@NotNull ? extends BasicElement> familyOf(@NotNull ObjectKind var1);

    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.from(this.getFamilies()).flatten(f -> f);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicElement", "getDbChildren"));
        }
        return jBIterable;
    }

    @NotNull
    default public <C> @NotNull JBIterable<@NotNull C> getDbChildren(@NotNull Class<C> clazz, @Nullable ObjectKind kind) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/model/basic/BasicElement", "getDbChildren"));
        }
        if (kind != null && kind != ObjectKind.NONE) {
            JBIterable jBIterable = JBIterable.from(this.familyOf(kind)).filter(clazz);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicElement", "getDbChildren"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = this.getDbChildren().filter(clazz);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicElement", "getDbChildren"));
        }
        return jBIterable;
    }

    default public boolean hasChildren() {
        for (Family<? extends BasicElement> family : this.getFamilies()) {
            if (!family.hasChildren()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    default public <E extends BasicElement> E findChild(@NotNull ObjectKind kind, @NotNull String name, @NotNull Class<E> clazz) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/basic/BasicElement", "findChild"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/basic/BasicElement", "findChild"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/model/basic/BasicElement", "findChild"));
        }
        Family<? extends BasicElement> elements = this.familyOf(kind);
        if (elements == null) {
            return null;
        }
        if (!1.$assertionsDisabled && !(elements instanceof NamingFamily)) {
            throw new AssertionError((Object)"Attempted to find an element by name when the family is not naming");
        }
        Object element = ((NamingFamily)elements).get(name);
        if (element != null && clazz.isAssignableFrom(element.getClass())) {
            return element;
        }
        return null;
    }

    @Nullable
    default public <E extends BasicElement> E findChild(@NotNull Collection<ObjectKind> kinds, @NotNull String name, @NotNull Class<E> clazz) {
        if (kinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/database/model/basic/BasicElement", "findChild"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/basic/BasicElement", "findChild"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/model/basic/BasicElement", "findChild"));
        }
        for (ObjectKind kind : kinds) {
            E result2 = this.findChild(kind, name, clazz);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicElement", "getPropertyNames"));
        }
        return list;
    }

    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/basic/BasicElement", "exportProperties"));
        }
    }

    @NotNull
    default public Iterable<? extends BasicElement> getPredecessors() {
        Set set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicElement", "getPredecessors"));
        }
        return set;
    }

    @Override
    @NotNull
    default public Iterable<? extends BasicNode> getChildNodes() {
        List<? extends Family<? extends BasicElement>> list = this.getFamilies();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicElement", "getChildNodes"));
        }
        return list;
    }

    @Override
    @NotNull
    default public String getDisplayName() {
        String name = this.getName();
        String string = name == ModelConsts.NO_NAME ? this.getKind().code() + " " + this.identity() : name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicElement", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    default public String getName() {
        String string = ModelConsts.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicElement", "getName"));
        }
        return string;
    }

    @Nullable
    default public String getNaturalName() {
        return null;
    }

    @Nullable
    default public String getRealName() {
        return null;
    }

    @Nullable
    default public String getComment() {
        return null;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

