/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.impl.BaseModel;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.database.model.sybase.SybaseModArgument;
import com.intellij.database.model.sybase.SybaseModCheck;
import com.intellij.database.model.sybase.SybaseModDatabase;
import com.intellij.database.model.sybase.SybaseModDefType;
import com.intellij.database.model.sybase.SybaseModForeignKey;
import com.intellij.database.model.sybase.SybaseModFunction;
import com.intellij.database.model.sybase.SybaseModIndex;
import com.intellij.database.model.sybase.SybaseModKey;
import com.intellij.database.model.sybase.SybaseModLikeTable;
import com.intellij.database.model.sybase.SybaseModModel;
import com.intellij.database.model.sybase.SybaseModProcedure;
import com.intellij.database.model.sybase.SybaseModProcedureGroup;
import com.intellij.database.model.sybase.SybaseModRoot;
import com.intellij.database.model.sybase.SybaseModRoutine;
import com.intellij.database.model.sybase.SybaseModSchema;
import com.intellij.database.model.sybase.SybaseModTable;
import com.intellij.database.model.sybase.SybaseModTableColumn;
import com.intellij.database.model.sybase.SybaseModTrigger;
import com.intellij.database.model.sybase.SybaseModView;
import com.intellij.database.model.sybase.SybaseModViewColumn;
import com.intellij.database.model.sybase.SybaseRoot;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SybaseImplModel
extends BaseModel
implements SybaseModModel {
    private final Root myRoot = new Root();

    SybaseImplModel() {
    }

    @Override
    @NotNull
    public SybaseRoot getRoot() {
        Root root2 = this.myRoot;
        if (root2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel", "getRoot"));
        }
        return root2;
    }

    final class DefType
    extends BaseModel.BaseRegularElement
    implements SybaseModDefType {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;

        private DefType(BaseModel.BaseFamily<? extends DefType> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SybaseImplModel$DefType", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$DefType", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<DefType> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$DefType", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SybaseImplModel$DefType", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$DefType", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SybaseImplModel$DefType", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }
    }

    final class Trigger
    extends BaseModel.BaseRegularElement
    implements SybaseModTrigger {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private TrigTurn myTurn;
        @NotNull
        private Set<TrigEvent> myEvents;

        private Trigger(BaseModel.BaseFamily<? extends Trigger> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SybaseImplModel$Trigger", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myTurn = null;
            this.myEvents = Collections.emptySet();
        }

        @Override
        @NotNull
        public SybaseModLikeTable getLikeTable() {
            SybaseModLikeTable sybaseModLikeTable = (SybaseModLikeTable)((Object)this.myParentFamily.owner);
            if (sybaseModLikeTable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Trigger", "getLikeTable"));
            }
            return sybaseModLikeTable;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Trigger> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Trigger", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SybaseImplModel$Trigger", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Trigger", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SybaseImplModel$Trigger", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public TrigTurn getTurn() {
            return this.myTurn;
        }

        @Override
        public void setTurn(@Nullable TrigTurn turn) {
            if (BaseModel.eq((Object)this.myTurn, (Object)turn)) {
                return;
            }
            this.modifying();
            this.myTurn = turn;
        }

        @Override
        @NotNull
        public Set<TrigEvent> getEvents() {
            Set<TrigEvent> set = this.myEvents;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Trigger", "getEvents"));
            }
            return set;
        }

        @Override
        public void setEvents(@Nullable Set<TrigEvent> events) {
            ImmutableSet x;
            ImmutableSet immutableSet = x = events != null ? ImmutableSet.copyOf(events) : Collections.emptySet();
            if (x.isEmpty() && this.myEvents.isEmpty()) {
                return;
            }
            this.modifying();
            this.myEvents = x;
        }
    }

    final class Argument
    extends BaseModel.BaseRegularElement
    implements SybaseModArgument {
        private short myPosition;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DasArgument.Direction myArgumentDirection;
        @NotNull
        private DataType myDataType;
        @Nullable
        private String myDefaultExpression;

        private Argument(BaseModel.BaseFamily<? extends Argument> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SybaseImplModel$Argument", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myArgumentDirection = DasArgument.Direction.IN;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myDefaultExpression = null;
        }

        @Override
        @NotNull
        public SybaseModRoutine getRoutine() {
            SybaseModRoutine sybaseModRoutine = (SybaseModRoutine)((Object)this.myParentFamily.owner);
            if (sybaseModRoutine == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Argument", "getRoutine"));
            }
            return sybaseModRoutine;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<Argument> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Argument", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SybaseImplModel$Argument", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Argument", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SybaseImplModel$Argument", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DasArgument.Direction getArgumentDirection() {
            DasArgument.Direction direction = this.myArgumentDirection;
            if (direction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Argument", "getArgumentDirection"));
            }
            return direction;
        }

        @Override
        public void setArgumentDirection(@NotNull DasArgument.Direction argumentDirection) {
            if (argumentDirection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentDirection", "com/intellij/database/model/impl/SybaseImplModel$Argument", "setArgumentDirection"));
            }
            if (this.myArgumentDirection.equals((Object)argumentDirection)) {
                return;
            }
            this.modifying();
            this.myArgumentDirection = argumentDirection;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Argument", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/SybaseImplModel$Argument", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        @Nullable
        public String getDefaultExpression() {
            return this.myDefaultExpression;
        }

        @Override
        public void setDefaultExpression(@Nullable String defaultExpression) {
            if (BaseModel.eq(this.myDefaultExpression, defaultExpression)) {
                return;
            }
            this.modifying();
            this.myDefaultExpression = defaultExpression;
        }
    }

    final class Procedure
    extends BaseModel.BaseRegularElement
    implements SybaseModProcedure {
        private final Arguments myArguments;
        private short myPosition;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;

        private Procedure(BaseModel.BaseFamily<? extends Procedure> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SybaseImplModel$Procedure", "<init>"));
            }
            super(parentFamily);
            this.myArguments = new Arguments(this);
            this.myPosition = 0;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
        }

        @Override
        @NotNull
        public ProcedureGroup getProcedureGroup() {
            ProcedureGroup procedureGroup = (ProcedureGroup)this.myParentFamily.owner;
            if (procedureGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Procedure", "getProcedureGroup"));
            }
            return procedureGroup;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<Procedure> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Procedure", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @NotNull
        public Arguments getArguments() {
            Arguments arguments = this.myArguments;
            if (arguments == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Procedure", "getArguments"));
            }
            return arguments;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SybaseImplModel$Procedure", "familyOf"));
            }
            if (kind == ObjectKind.ARGUMENT) {
                return this.myArguments;
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Procedure", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SybaseImplModel$Procedure", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        private final class Arguments
        extends BaseModel.BasePositioningNamingFamily<Argument> {
            private Arguments(Procedure owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SybaseImplModel$Procedure$Arguments", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Argument instantiate() {
                return new Argument(this);
            }
        }
    }

    final class ProcedureGroup
    extends BaseModel.BaseRegularElement
    implements SybaseModProcedureGroup {
        private final Procedures myProcedures;
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        private int myStateNumber;

        private ProcedureGroup(BaseModel.BaseFamily<? extends ProcedureGroup> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SybaseImplModel$ProcedureGroup", "<init>"));
            }
            super(parentFamily);
            this.myProcedures = new Procedures(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myStateNumber = 0;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$ProcedureGroup", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<ProcedureGroup> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$ProcedureGroup", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Procedures getProcedures() {
            Procedures procedures = this.myProcedures;
            if (procedures == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$ProcedureGroup", "getProcedures"));
            }
            return procedures;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SybaseImplModel$ProcedureGroup", "familyOf"));
            }
            if (kind == ObjectKind.ROUTINE) {
                return this.myProcedures;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$ProcedureGroup", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SybaseImplModel$ProcedureGroup", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        public int getStateNumber() {
            return this.myStateNumber;
        }

        @Override
        public void setStateNumber(int stateNumber) {
            if (this.myStateNumber == stateNumber) {
                return;
            }
            this.modifying();
            this.myStateNumber = stateNumber;
        }

        private final class Procedures
        extends BaseModel.BasePositioningNamingFamily<Procedure> {
            private Procedures(ProcedureGroup owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SybaseImplModel$ProcedureGroup$Procedures", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Procedure instantiate() {
                return new Procedure(this);
            }
        }
    }

    final class Function
    extends BaseModel.BaseRegularElement
    implements SybaseModFunction {
        private final Arguments myArguments;
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        private int myStateNumber;

        private Function(BaseModel.BaseFamily<? extends Function> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SybaseImplModel$Function", "<init>"));
            }
            super(parentFamily);
            this.myArguments = new Arguments(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myStateNumber = 0;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Function", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Function> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Function", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Arguments getArguments() {
            Arguments arguments = this.myArguments;
            if (arguments == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Function", "getArguments"));
            }
            return arguments;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SybaseImplModel$Function", "familyOf"));
            }
            if (kind == ObjectKind.ARGUMENT) {
                return this.myArguments;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Function", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SybaseImplModel$Function", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        public int getStateNumber() {
            return this.myStateNumber;
        }

        @Override
        public void setStateNumber(int stateNumber) {
            if (this.myStateNumber == stateNumber) {
                return;
            }
            this.modifying();
            this.myStateNumber = stateNumber;
        }

        private final class Arguments
        extends BaseModel.BasePositioningNamingFamily<Argument> {
            private Arguments(Function owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SybaseImplModel$Function$Arguments", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Argument instantiate() {
                return new Argument(this);
            }
        }
    }

    final class Check
    extends BaseModel.BaseRegularElement
    implements SybaseModCheck {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<String> myColNames;
        private boolean myDeferrable;
        private boolean myInitiallyDeferred;
        @Nullable
        private String myPredicate;

        private Check(BaseModel.BaseFamily<? extends Check> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SybaseImplModel$Check", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myColNames = Collections.emptyList();
            this.myDeferrable = false;
            this.myInitiallyDeferred = false;
            this.myPredicate = null;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Check", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Check> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Check", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SybaseImplModel$Check", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Check", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SybaseImplModel$Check", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Check", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        public boolean isDeferrable() {
            return this.myDeferrable;
        }

        @Override
        public void setDeferrable(boolean deferrable) {
            if (this.myDeferrable == deferrable) {
                return;
            }
            this.modifying();
            this.myDeferrable = deferrable;
        }

        @Override
        public boolean isInitiallyDeferred() {
            return this.myInitiallyDeferred;
        }

        @Override
        public void setInitiallyDeferred(boolean initiallyDeferred) {
            if (this.myInitiallyDeferred == initiallyDeferred) {
                return;
            }
            this.modifying();
            this.myInitiallyDeferred = initiallyDeferred;
        }

        @Override
        @Nullable
        public String getPredicate() {
            return this.myPredicate;
        }

        @Override
        public void setPredicate(@Nullable String predicate) {
            if (BaseModel.eq(this.myPredicate, predicate)) {
                return;
            }
            this.modifying();
            this.myPredicate = predicate;
        }
    }

    final class ForeignKey
    extends BaseModel.BaseRegularElement
    implements SybaseModForeignKey {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<String> myColNames;
        private boolean myDeferrable;
        private boolean myInitiallyDeferred;
        @Nullable
        private String myRefSchemaName;
        @Nullable
        private String myRefTableName;
        @Nullable
        private String myRefKeyName;
        @NotNull
        private List<String> myRefColNames;
        @NotNull
        private CascadeRule myOnDelete;

        private ForeignKey(BaseModel.BaseFamily<? extends ForeignKey> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SybaseImplModel$ForeignKey", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myColNames = Collections.emptyList();
            this.myDeferrable = false;
            this.myInitiallyDeferred = false;
            this.myRefSchemaName = null;
            this.myRefTableName = null;
            this.myRefKeyName = null;
            this.myRefColNames = Collections.emptyList();
            this.myOnDelete = CascadeRule.no_action;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$ForeignKey", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<ForeignKey> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$ForeignKey", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SybaseImplModel$ForeignKey", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$ForeignKey", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SybaseImplModel$ForeignKey", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$ForeignKey", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        public boolean isDeferrable() {
            return this.myDeferrable;
        }

        @Override
        public void setDeferrable(boolean deferrable) {
            if (this.myDeferrable == deferrable) {
                return;
            }
            this.modifying();
            this.myDeferrable = deferrable;
        }

        @Override
        public boolean isInitiallyDeferred() {
            return this.myInitiallyDeferred;
        }

        @Override
        public void setInitiallyDeferred(boolean initiallyDeferred) {
            if (this.myInitiallyDeferred == initiallyDeferred) {
                return;
            }
            this.modifying();
            this.myInitiallyDeferred = initiallyDeferred;
        }

        @Override
        @Nullable
        public String getRefSchemaName() {
            return this.myRefSchemaName;
        }

        @Override
        public void setRefSchemaName(@Nullable String refSchemaName) {
            if (BaseModel.eq(this.myRefSchemaName, refSchemaName)) {
                return;
            }
            this.modifying();
            this.myRefSchemaName = refSchemaName;
        }

        @Override
        @Nullable
        public String getRefTableName() {
            return this.myRefTableName;
        }

        @Override
        public void setRefTableName(@Nullable String refTableName) {
            if (BaseModel.eq(this.myRefTableName, refTableName)) {
                return;
            }
            this.modifying();
            this.myRefTableName = refTableName;
        }

        @Override
        @Nullable
        public String getRefKeyName() {
            return this.myRefKeyName;
        }

        @Override
        public void setRefKeyName(@Nullable String refKeyName) {
            if (BaseModel.eq(this.myRefKeyName, refKeyName)) {
                return;
            }
            this.modifying();
            this.myRefKeyName = refKeyName;
        }

        @Override
        @NotNull
        public List<String> getRefColNames() {
            List<String> list = this.myRefColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$ForeignKey", "getRefColNames"));
            }
            return list;
        }

        @Override
        public void setRefColNames(@Nullable List<String> refColNames) {
            ImmutableList x;
            ImmutableList immutableList = x = refColNames != null ? ImmutableList.copyOf(refColNames) : Collections.emptyList();
            if (x.isEmpty() && this.myRefColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myRefColNames = x;
        }

        @Override
        @NotNull
        public CascadeRule getOnDelete() {
            CascadeRule cascadeRule = this.myOnDelete;
            if (cascadeRule == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$ForeignKey", "getOnDelete"));
            }
            return cascadeRule;
        }

        @Override
        public void setOnDelete(@NotNull CascadeRule onDelete) {
            if (onDelete == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onDelete", "com/intellij/database/model/impl/SybaseImplModel$ForeignKey", "setOnDelete"));
            }
            if (this.myOnDelete.equals((Object)onDelete)) {
                return;
            }
            this.modifying();
            this.myOnDelete = onDelete;
        }
    }

    final class Key
    extends BaseModel.BaseRegularElement
    implements SybaseModKey {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<String> myColNames;
        private boolean myDeferrable;
        private boolean myInitiallyDeferred;
        private boolean myPrimary;
        private short myUnderlyingIndexPosition;
        @Nullable
        private String myUnderlyingIndexName;

        private Key(BaseModel.BaseFamily<? extends Key> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SybaseImplModel$Key", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myColNames = Collections.emptyList();
            this.myDeferrable = false;
            this.myInitiallyDeferred = false;
            this.myPrimary = false;
            this.myUnderlyingIndexPosition = 0;
            this.myUnderlyingIndexName = null;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Key", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Key> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Key", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SybaseImplModel$Key", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Key", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SybaseImplModel$Key", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Key", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        public boolean isDeferrable() {
            return this.myDeferrable;
        }

        @Override
        public void setDeferrable(boolean deferrable) {
            if (this.myDeferrable == deferrable) {
                return;
            }
            this.modifying();
            this.myDeferrable = deferrable;
        }

        @Override
        public boolean isInitiallyDeferred() {
            return this.myInitiallyDeferred;
        }

        @Override
        public void setInitiallyDeferred(boolean initiallyDeferred) {
            if (this.myInitiallyDeferred == initiallyDeferred) {
                return;
            }
            this.modifying();
            this.myInitiallyDeferred = initiallyDeferred;
        }

        @Override
        public boolean isPrimary() {
            return this.myPrimary;
        }

        @Override
        public void setPrimary(boolean primary) {
            if (this.myPrimary == primary) {
                return;
            }
            this.modifying();
            this.myPrimary = primary;
        }

        @Override
        public short getUnderlyingIndexPosition() {
            return this.myUnderlyingIndexPosition;
        }

        @Override
        public void setUnderlyingIndexPosition(short underlyingIndexPosition) {
            if (this.myUnderlyingIndexPosition == underlyingIndexPosition) {
                return;
            }
            this.modifying();
            this.myUnderlyingIndexPosition = underlyingIndexPosition;
        }

        @Override
        @Nullable
        public String getUnderlyingIndexName() {
            return this.myUnderlyingIndexName;
        }

        @Override
        public void setUnderlyingIndexName(@Nullable String underlyingIndexName) {
            if (BaseModel.eq(this.myUnderlyingIndexName, underlyingIndexName)) {
                return;
            }
            this.modifying();
            this.myUnderlyingIndexName = underlyingIndexName;
        }
    }

    final class Index
    extends BaseModel.BaseRegularElement
    implements SybaseModIndex {
        private short myPosition;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<String> myColNames;
        @NotNull
        private Set<String> myReverseColNames;
        private boolean myClustering;
        private boolean myUnique;

        private Index(BaseModel.BaseFamily<? extends Index> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SybaseImplModel$Index", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myColNames = Collections.emptyList();
            this.myReverseColNames = Collections.emptySet();
            this.myClustering = false;
            this.myUnique = false;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Index", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<Index> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Index", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SybaseImplModel$Index", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Index", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SybaseImplModel$Index", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Index", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        @NotNull
        public Set<String> getReverseColNames() {
            Set<String> set = this.myReverseColNames;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Index", "getReverseColNames"));
            }
            return set;
        }

        @Override
        public void setReverseColNames(@Nullable Set<String> reverseColNames) {
            ImmutableSet x;
            ImmutableSet immutableSet = x = reverseColNames != null ? ImmutableSet.copyOf(reverseColNames) : Collections.emptySet();
            if (x.isEmpty() && this.myReverseColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myReverseColNames = x;
        }

        @Override
        public boolean isClustering() {
            return this.myClustering;
        }

        @Override
        public void setClustering(boolean clustering) {
            if (this.myClustering == clustering) {
                return;
            }
            this.modifying();
            this.myClustering = clustering;
        }

        @Override
        public boolean isUnique() {
            return this.myUnique;
        }

        @Override
        public void setUnique(boolean unique) {
            if (this.myUnique == unique) {
                return;
            }
            this.modifying();
            this.myUnique = unique;
        }
    }

    final class ViewColumn
    extends BaseModel.BaseRegularElement
    implements SybaseModViewColumn {
        private short myPosition;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DataType myDataType;
        private boolean myComputed;
        private boolean myNotNull;

        private ViewColumn(BaseModel.BaseFamily<? extends ViewColumn> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SybaseImplModel$ViewColumn", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myComputed = false;
            this.myNotNull = false;
        }

        @Override
        @NotNull
        public View getView() {
            View view2 = (View)this.myParentFamily.owner;
            if (view2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$ViewColumn", "getView"));
            }
            return view2;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<ViewColumn> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$ViewColumn", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SybaseImplModel$ViewColumn", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$ViewColumn", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SybaseImplModel$ViewColumn", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$ViewColumn", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/SybaseImplModel$ViewColumn", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        public boolean isComputed() {
            return this.myComputed;
        }

        @Override
        public void setComputed(boolean computed) {
            if (this.myComputed == computed) {
                return;
            }
            this.modifying();
            this.myComputed = computed;
        }

        @Override
        public boolean isNotNull() {
            return this.myNotNull;
        }

        @Override
        public void setNotNull(boolean notNull) {
            if (this.myNotNull == notNull) {
                return;
            }
            this.modifying();
            this.myNotNull = notNull;
        }
    }

    final class View
    extends BaseModel.BaseRegularElement
    implements SybaseModView {
        private final Columns myColumns;
        private final Triggers myTriggers;
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        private int myStateNumber;
        private boolean mySystem;

        private View(BaseModel.BaseFamily<? extends View> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SybaseImplModel$View", "<init>"));
            }
            super(parentFamily);
            this.myColumns = new Columns(this);
            this.myTriggers = new Triggers(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myStateNumber = 0;
            this.mySystem = false;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$View", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<View> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$View", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Columns getColumns() {
            Columns columns = this.myColumns;
            if (columns == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$View", "getColumns"));
            }
            return columns;
        }

        @Override
        @NotNull
        public Triggers getTriggers() {
            Triggers triggers = this.myTriggers;
            if (triggers == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$View", "getTriggers"));
            }
            return triggers;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SybaseImplModel$View", "familyOf"));
            }
            if (kind == ObjectKind.COLUMN) {
                return this.myColumns;
            }
            if (kind == ObjectKind.TRIGGER) {
                return this.myTriggers;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$View", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SybaseImplModel$View", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        public int getStateNumber() {
            return this.myStateNumber;
        }

        @Override
        public void setStateNumber(int stateNumber) {
            if (this.myStateNumber == stateNumber) {
                return;
            }
            this.modifying();
            this.myStateNumber = stateNumber;
        }

        @Override
        public boolean isSystem() {
            return this.mySystem;
        }

        @Override
        public void setSystem(boolean system) {
            if (this.mySystem == system) {
                return;
            }
            this.modifying();
            this.mySystem = system;
        }

        private final class Triggers
        extends BaseModel.BaseNamingIdentifyingFamily<Trigger> {
            private Triggers(View owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SybaseImplModel$View$Triggers", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Trigger instantiate() {
                return new Trigger(this);
            }
        }

        private final class Columns
        extends BaseModel.BasePositioningNamingFamily<ViewColumn> {
            private Columns(View owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SybaseImplModel$View$Columns", "<init>"));
                }
                super(owner);
            }

            @Override
            protected ViewColumn instantiate() {
                return new ViewColumn(this);
            }
        }
    }

    final class TableColumn
    extends BaseModel.BaseRegularElement
    implements SybaseModTableColumn {
        private short myPosition;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DataType myDataType;
        private boolean myComputed;
        private boolean myNotNull;
        @Nullable
        private SequenceIdentity mySequenceIdentity;
        @Nullable
        private String myDefaultExpression;

        private TableColumn(BaseModel.BaseFamily<? extends TableColumn> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SybaseImplModel$TableColumn", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myComputed = false;
            this.myNotNull = false;
            this.mySequenceIdentity = null;
            this.myDefaultExpression = null;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$TableColumn", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<TableColumn> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$TableColumn", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SybaseImplModel$TableColumn", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$TableColumn", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SybaseImplModel$TableColumn", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$TableColumn", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/SybaseImplModel$TableColumn", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        public boolean isComputed() {
            return this.myComputed;
        }

        @Override
        public void setComputed(boolean computed) {
            if (this.myComputed == computed) {
                return;
            }
            this.modifying();
            this.myComputed = computed;
        }

        @Override
        public boolean isNotNull() {
            return this.myNotNull;
        }

        @Override
        public void setNotNull(boolean notNull) {
            if (this.myNotNull == notNull) {
                return;
            }
            this.modifying();
            this.myNotNull = notNull;
        }

        @Override
        @Nullable
        public SequenceIdentity getSequenceIdentity() {
            return this.mySequenceIdentity;
        }

        @Override
        public void setSequenceIdentity(@Nullable SequenceIdentity sequenceIdentity) {
            if (BaseModel.eq(this.mySequenceIdentity, sequenceIdentity)) {
                return;
            }
            this.modifying();
            this.mySequenceIdentity = sequenceIdentity;
        }

        @Override
        @Nullable
        public String getDefaultExpression() {
            return this.myDefaultExpression;
        }

        @Override
        public void setDefaultExpression(@Nullable String defaultExpression) {
            if (BaseModel.eq(this.myDefaultExpression, defaultExpression)) {
                return;
            }
            this.modifying();
            this.myDefaultExpression = defaultExpression;
        }
    }

    final class Table
    extends BaseModel.BaseRegularElement
    implements SybaseModTable {
        private final Columns myColumns;
        private final Indices myIndices;
        private final Keys myKeys;
        private final ForeignKeys myForeignKeys;
        private final Checks myChecks;
        private final Triggers myTriggers;
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        private int myStateNumber;
        private boolean mySystem;

        private Table(BaseModel.BaseFamily<? extends Table> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SybaseImplModel$Table", "<init>"));
            }
            super(parentFamily);
            this.myColumns = new Columns(this);
            this.myIndices = new Indices(this);
            this.myKeys = new Keys(this);
            this.myForeignKeys = new ForeignKeys(this);
            this.myChecks = new Checks(this);
            this.myTriggers = new Triggers(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myStateNumber = 0;
            this.mySystem = false;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Table", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Table> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Table", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Columns getColumns() {
            Columns columns = this.myColumns;
            if (columns == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Table", "getColumns"));
            }
            return columns;
        }

        @Override
        @NotNull
        public Indices getIndices() {
            Indices indices = this.myIndices;
            if (indices == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Table", "getIndices"));
            }
            return indices;
        }

        @Override
        @NotNull
        public Keys getKeys() {
            Keys keys = this.myKeys;
            if (keys == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Table", "getKeys"));
            }
            return keys;
        }

        @Override
        @NotNull
        public ForeignKeys getForeignKeys() {
            ForeignKeys foreignKeys = this.myForeignKeys;
            if (foreignKeys == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Table", "getForeignKeys"));
            }
            return foreignKeys;
        }

        @Override
        @NotNull
        public Checks getChecks() {
            Checks checks = this.myChecks;
            if (checks == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Table", "getChecks"));
            }
            return checks;
        }

        @Override
        @NotNull
        public Triggers getTriggers() {
            Triggers triggers = this.myTriggers;
            if (triggers == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Table", "getTriggers"));
            }
            return triggers;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SybaseImplModel$Table", "familyOf"));
            }
            if (kind == ObjectKind.COLUMN) {
                return this.myColumns;
            }
            if (kind == ObjectKind.INDEX) {
                return this.myIndices;
            }
            if (kind == ObjectKind.KEY) {
                return this.myKeys;
            }
            if (kind == ObjectKind.FOREIGN_KEY) {
                return this.myForeignKeys;
            }
            if (kind == ObjectKind.CHECK) {
                return this.myChecks;
            }
            if (kind == ObjectKind.TRIGGER) {
                return this.myTriggers;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Table", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SybaseImplModel$Table", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        public int getStateNumber() {
            return this.myStateNumber;
        }

        @Override
        public void setStateNumber(int stateNumber) {
            if (this.myStateNumber == stateNumber) {
                return;
            }
            this.modifying();
            this.myStateNumber = stateNumber;
        }

        @Override
        public boolean isSystem() {
            return this.mySystem;
        }

        @Override
        public void setSystem(boolean system) {
            if (this.mySystem == system) {
                return;
            }
            this.modifying();
            this.mySystem = system;
        }

        private final class Triggers
        extends BaseModel.BaseNamingIdentifyingFamily<Trigger> {
            private Triggers(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SybaseImplModel$Table$Triggers", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Trigger instantiate() {
                return new Trigger(this);
            }
        }

        private final class Checks
        extends BaseModel.BaseNamingIdentifyingFamily<Check> {
            private Checks(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SybaseImplModel$Table$Checks", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Check instantiate() {
                return new Check(this);
            }
        }

        private final class ForeignKeys
        extends BaseModel.BaseNamingIdentifyingFamily<ForeignKey> {
            private ForeignKeys(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SybaseImplModel$Table$ForeignKeys", "<init>"));
                }
                super(owner);
            }

            @Override
            protected ForeignKey instantiate() {
                return new ForeignKey(this);
            }
        }

        private final class Keys
        extends BaseModel.BaseNamingIdentifyingFamily<Key> {
            private Keys(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SybaseImplModel$Table$Keys", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Key instantiate() {
                return new Key(this);
            }
        }

        private final class Indices
        extends BaseModel.BasePositioningNamingFamily<Index> {
            private Indices(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SybaseImplModel$Table$Indices", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Index instantiate() {
                return new Index(this);
            }
        }

        private final class Columns
        extends BaseModel.BasePositioningNamingFamily<TableColumn> {
            private Columns(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SybaseImplModel$Table$Columns", "<init>"));
                }
                super(owner);
            }

            @Override
            protected TableColumn instantiate() {
                return new TableColumn(this);
            }
        }
    }

    final class Schema
    extends BaseModel.BaseRegularElement
    implements SybaseModSchema {
        private final Tables myTables;
        private final Views myViews;
        private final Functions myFunctions;
        private final ProcedureGroups myProcedureGroups;
        private final DefTypes myDefTypes;
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private Date myIntrospectionTimestamp;
        private boolean myCurrent;
        private boolean myVisible;

        private Schema(BaseModel.BaseFamily<? extends Schema> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SybaseImplModel$Schema", "<init>"));
            }
            super(parentFamily);
            this.myTables = new Tables(this);
            this.myViews = new Views(this);
            this.myFunctions = new Functions(this);
            this.myProcedureGroups = new ProcedureGroups(this);
            this.myDefTypes = new DefTypes(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myIntrospectionTimestamp = null;
            this.myCurrent = false;
            this.myVisible = false;
        }

        @Override
        @NotNull
        public Database getDatabase() {
            Database database = (Database)this.myParentFamily.owner;
            if (database == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Schema", "getDatabase"));
            }
            return database;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Schema> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Schema", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Tables getTables() {
            Tables tables = this.myTables;
            if (tables == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Schema", "getTables"));
            }
            return tables;
        }

        @Override
        @NotNull
        public Views getViews() {
            Views views = this.myViews;
            if (views == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Schema", "getViews"));
            }
            return views;
        }

        @Override
        @NotNull
        public Functions getFunctions() {
            Functions functions = this.myFunctions;
            if (functions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Schema", "getFunctions"));
            }
            return functions;
        }

        @Override
        @NotNull
        public ProcedureGroups getProcedureGroups() {
            ProcedureGroups procedureGroups = this.myProcedureGroups;
            if (procedureGroups == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Schema", "getProcedureGroups"));
            }
            return procedureGroups;
        }

        @Override
        @NotNull
        public DefTypes getDefTypes() {
            DefTypes defTypes = this.myDefTypes;
            if (defTypes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Schema", "getDefTypes"));
            }
            return defTypes;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SybaseImplModel$Schema", "familyOf"));
            }
            if (kind == ObjectKind.TABLE) {
                return this.myTables;
            }
            if (kind == ObjectKind.VIEW) {
                return this.myViews;
            }
            if (kind == ObjectKind.ROUTINE) {
                return this.myFunctions;
            }
            if (kind == ObjectKind.PACKAGE) {
                return this.myProcedureGroups;
            }
            if (kind == ObjectKind.ALIAS_TYPE) {
                return this.myDefTypes;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Schema", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SybaseImplModel$Schema", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public Date getIntrospectionTimestamp() {
            return this.myIntrospectionTimestamp;
        }

        @Override
        public void setIntrospectionTimestamp(@Nullable Date introspectionTimestamp) {
            if (BaseModel.eq(this.myIntrospectionTimestamp, introspectionTimestamp)) {
                return;
            }
            this.modifying();
            this.myIntrospectionTimestamp = introspectionTimestamp;
        }

        @Override
        public boolean isCurrent() {
            return this.myCurrent;
        }

        @Override
        public void setCurrent(boolean current) {
            if (this.myCurrent == current) {
                return;
            }
            this.modifying();
            this.myCurrent = current;
        }

        @Override
        public boolean isVisible() {
            return this.myVisible;
        }

        @Override
        public void setVisible(boolean visible) {
            if (this.myVisible == visible) {
                return;
            }
            this.modifying();
            this.myVisible = visible;
        }

        private final class DefTypes
        extends BaseModel.BaseNamingIdentifyingFamily<DefType> {
            private DefTypes(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SybaseImplModel$Schema$DefTypes", "<init>"));
                }
                super(owner);
            }

            @Override
            protected DefType instantiate() {
                return new DefType(this);
            }
        }

        private final class ProcedureGroups
        extends BaseModel.BaseNamingIdentifyingFamily<ProcedureGroup> {
            private ProcedureGroups(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SybaseImplModel$Schema$ProcedureGroups", "<init>"));
                }
                super(owner);
            }

            @Override
            protected ProcedureGroup instantiate() {
                return new ProcedureGroup(this);
            }
        }

        private final class Functions
        extends BaseModel.BaseNamingIdentifyingFamily<Function> {
            private Functions(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SybaseImplModel$Schema$Functions", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Function instantiate() {
                return new Function(this);
            }
        }

        private final class Views
        extends BaseModel.BaseNamingIdentifyingFamily<View> {
            private Views(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SybaseImplModel$Schema$Views", "<init>"));
                }
                super(owner);
            }

            @Override
            protected View instantiate() {
                return new View(this);
            }
        }

        private final class Tables
        extends BaseModel.BaseNamingIdentifyingFamily<Table> {
            private Tables(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SybaseImplModel$Schema$Tables", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Table instantiate() {
                return new Table(this);
            }
        }
    }

    final class Database
    extends BaseModel.BaseRegularElement
    implements SybaseModDatabase {
        private final Schemas mySchemas;
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        private boolean myCurrent;
        private boolean myVisible;

        private Database(BaseModel.BaseFamily<? extends Database> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SybaseImplModel$Database", "<init>"));
            }
            super(parentFamily);
            this.mySchemas = new Schemas(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myCurrent = false;
            this.myVisible = false;
        }

        @Override
        @NotNull
        public Root getRoot() {
            Root root2 = (Root)this.myParentFamily.owner;
            if (root2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Database", "getRoot"));
            }
            return root2;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Database> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Database", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Schemas getSchemas() {
            Schemas schemas = this.mySchemas;
            if (schemas == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Database", "getSchemas"));
            }
            return schemas;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SybaseImplModel$Database", "familyOf"));
            }
            if (kind == ObjectKind.SCHEMA) {
                return this.mySchemas;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Database", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SybaseImplModel$Database", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        public boolean isCurrent() {
            return this.myCurrent;
        }

        @Override
        public void setCurrent(boolean current) {
            if (this.myCurrent == current) {
                return;
            }
            this.modifying();
            this.myCurrent = current;
        }

        @Override
        public boolean isVisible() {
            return this.myVisible;
        }

        @Override
        public void setVisible(boolean visible) {
            if (this.myVisible == visible) {
                return;
            }
            this.modifying();
            this.myVisible = visible;
        }

        private final class Schemas
        extends BaseModel.BaseNamingIdentifyingFamily<Schema> {
            private Schemas(Database owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SybaseImplModel$Database$Schemas", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Schema instantiate() {
                return new Schema(this);
            }
        }
    }

    final class Root
    extends BaseModel.BaseRoot
    implements SybaseModRoot {
        private final Databases myDatabases = new Databases(this);

        private Root() {
        }

        @Override
        @NotNull
        public Databases getDatabases() {
            Databases databases = this.myDatabases;
            if (databases == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SybaseImplModel$Root", "getDatabases"));
            }
            return databases;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SybaseImplModel$Root", "familyOf"));
            }
            if (kind == ObjectKind.DATABASE) {
                return this.myDatabases;
            }
            return null;
        }

        private final class Databases
        extends BaseModel.BaseNamingIdentifyingFamily<Database> {
            private Databases(Root owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SybaseImplModel$Root$Databases", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Database instantiate() {
                return new Database(this);
            }
        }
    }
}

