/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.oracle.OraSchema;
import com.intellij.database.model.oracle.OraTable;
import org.jetbrains.annotations.Nullable;

public interface OraMixinTableColumn
extends BasicColumn {
    @Override
    @Nullable
    default public SequenceIdentity getSequenceIdentity() {
        BasicLikeTable t = this.getTable();
        if (t == null || !(t instanceof OraTable)) {
            return null;
        }
        OraTable table = (OraTable)t;
        OraSchema schema = table.getSchema();
        if (schema == null) {
            return null;
        }
        long tableId = table.getObjectId();
        if (tableId <= 0L) {
            return null;
        }
        String sequenceName = "ISEQ$$_" + tableId;
        BasicSequence sequence = (BasicSequence)schema.getSequences().get(sequenceName);
        if (sequence == null) {
            return null;
        }
        return sequence.getSequenceIdentity();
    }
}

