/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.oracle.OraClusterIndex;
import com.intellij.database.model.oracle.OraModCluster;
import com.intellij.database.model.oracle.OraModInfraIndex;
import com.intellij.database.model.oracle.OraModSchema;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraModClusterIndex
extends OraClusterIndex,
OraModInfraIndex {
    @Override
    @NotNull
    public OraModCluster getCluster();

    @Override
    @NotNull
    default public OraModCluster getDbParent() {
        OraModCluster oraModCluster = this.getCluster();
        if (oraModCluster == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModClusterIndex", "getDbParent"));
        }
        return oraModCluster;
    }

    @Override
    @NotNull
    public ModSingletonFamily<? extends OraModClusterIndex> getParentFamily();

    @Override
    @NotNull
    default public OraModSchema getSchema() {
        OraModSchema oraModSchema = this.getCluster().getSchema();
        if (oraModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModClusterIndex", "getSchema"));
        }
        return oraModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModClusterIndex", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModClusterIndex", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setCreatedTimestamp(@Nullable Date var1);

    @Override
    public void setModifiedTimestamp(@Nullable Date var1);

    @Override
    public void setTablespaceName(@Nullable String var1);

    @Override
    public void setColNames(@NotNull List<String> var1);

    @Override
    default public void setColNames(String ... colNames) {
        this.setColNames(Arrays.asList(colNames));
    }

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/oracle/OraModClusterIndex", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String createdTimestamp = properties.get("CreatedTimestamp");
        String modifiedTimestamp = properties.get("ModifiedTimestamp");
        String tablespaceName = properties.get("TablespaceName");
        String colNames = properties.get("ColNames");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (createdTimestamp != null) {
            this.setCreatedTimestamp(PropertyConverter.importDate(createdTimestamp));
        }
        if (modifiedTimestamp != null) {
            this.setModifiedTimestamp(PropertyConverter.importDate(modifiedTimestamp));
        }
        if (tablespaceName != null) {
            this.setTablespaceName(PropertyConverter.importString(tablespaceName));
        }
        if (colNames != null) {
            this.setColNames(PropertyConverter.importListOfString(colNames));
        }
    }
}

