/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.postgres.PostgresRoutine;
import com.intellij.database.model.postgres.PostgresSchema;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresArgument
extends BasicArgument,
BasicArrangedElement,
BasicNamedElement,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.ARGUMENT;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresArgument", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public PostgresRoutine getRoutine();

    @Override
    @Nullable
    default public PostgresRoutine getDbParent() {
        return this.getRoutine();
    }

    @Nullable
    default public PostgresRoutine getMajorObject() {
        return this.getRoutine();
    }

    default public @Nullable PositioningNamingFamily<@NotNull ? extends PostgresArgument> getParentFamily() {
        return null;
    }

    @Nullable
    default public PostgresSchema getSchema() {
        PostgresRoutine routine2 = this.getRoutine();
        return routine2 != null ? routine2.getSchema() : null;
    }

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresArgument", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresArgument", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresArgument", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public short getPosition() {
        return 0;
    }

    @Override
    @NotNull
    default public String getName() {
        String string = ModelConsts.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresArgument", "getName"));
        }
        return string;
    }

    @Override
    default public boolean isNameSurrogate() {
        return false;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @NotNull
    default public DasArgument.Direction getArgumentDirection() {
        DasArgument.Direction direction = DasArgument.Direction.IN;
        if (direction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresArgument", "getArgumentDirection"));
        }
        return direction;
    }

    @Override
    @NotNull
    default public DataType getDataType() {
        DataType dataType = ModelConsts.NO_DATA_TYPE;
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresArgument", "getDataType"));
        }
        return dataType;
    }

    @Override
    @Nullable
    default public String getDefaultExpression() {
        return null;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        String defaultExpression;
        DataType dataType;
        DasArgument.Direction argumentDirection;
        String comment;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/postgres/PostgresArgument", "exportProperties"));
        }
        short position = this.getPosition();
        if (position != 0) {
            consumer.accept("Position", PropertyConverter.export(position));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((argumentDirection = this.getArgumentDirection()) != null && argumentDirection != DasArgument.Direction.IN) {
            consumer.accept("ArgumentDirection", PropertyConverter.export(argumentDirection));
        }
        if ((dataType = this.getDataType()) != null && dataType != ModelConsts.NO_DATA_TYPE) {
            consumer.accept("DataType", PropertyConverter.export(dataType));
        }
        if ((defaultExpression = this.getDefaultExpression()) != null) {
            consumer.accept("DefaultExpression", PropertyConverter.export(defaultExpression));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("Position", "Name", "NameSurrogate", "Comment", "ArgumentDirection", "DataType", "DefaultExpression");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresArgument", "getPropertyNames"));
        }
        return list;
    }
}

