/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.oracle;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.plan.AbstractPlanModelBuilder;
import com.intellij.database.plan.MetaNode;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraclePlanModelBuilder
extends AbstractPlanModelBuilder<MetaNode<MetaData>> {
    private static final Map<String, PlanModel.NodeType> TYPE_MAPPING = ContainerUtil.newHashMap();
    private static final Map<String, PlanModel.NodeType> STATEMENT_MAPPING = ContainerUtil.newHashMap();
    private static final Map<Pair<PlanModel.NodeType, String>, PlanModel.NodeType> SUB_MAPPING = ContainerUtil.newHashMap();
    private final String myStatement;
    @NotNull
    private final String myExplainTable;
    private MetaNode<MetaData> myPlan;

    public OraclePlanModelBuilder(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer, @NotNull String statement, @NotNull String explainTable) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/plan/oracle/OraclePlanModelBuilder", "<init>"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/plan/oracle/OraclePlanModelBuilder", "<init>"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/plan/oracle/OraclePlanModelBuilder", "<init>"));
        }
        if (explainTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explainTable", "com/intellij/database/plan/oracle/OraclePlanModelBuilder", "<init>"));
        }
        super(owner, consumer, EnumSet.of(PlanModel.Feature.STARTUP_COST));
        this.myStatement = statement;
        this.myExplainTable = explainTable;
    }

    @Nullable
    Integer getInteger(ResultSet resultSet, String col) throws SQLException {
        return resultSet.getObject(col) == null ? null : Integer.valueOf(resultSet.getInt(col));
    }

    @Nullable
    Long getLong(ResultSet resultSet, String col) throws SQLException {
        return resultSet.getObject(col) == null ? null : Long.valueOf(resultSet.getLong(col));
    }

    @Nullable
    BigDecimal getBig(ResultSet resultSet, String col) throws SQLException {
        return resultSet.getObject(col) == null ? null : resultSet.getBigDecimal(col);
    }

    private MetaNode<MetaData> getMetaPlan(@NotNull DatabaseConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/plan/oracle/OraclePlanModelBuilder", "getMetaPlan"));
        }
        final MultiMap childMap = MultiMap.createLinked();
        final Ref root2 = Ref.create();
        OraclePlanModelBuilder.useStatementWithPreserved(connection, new AbstractPlanModelBuilder.ResourceUser<Statement>(){

            @Override
            public void use(Statement statement) throws PlanRetrievalException, SQLException {
                String uuid = OraclePlanModelBuilder.randomShorterUUID();
                statement.execute("EXPLAIN PLAN SET STATEMENT_ID = '" + uuid + "' INTO \"" + OraclePlanModelBuilder.this.myExplainTable + "\" FOR " + OraclePlanModelBuilder.this.myStatement);
                statement.execute("SELECT OPERATION, OPTIONS, OBJECT_NAME, OBJECT_TYPE, ID, PARENT_ID, POSITION, COST, CARDINALITY, CPU_COST, IO_COST FROM \"" + OraclePlanModelBuilder.this.myExplainTable + "\" WHERE STATEMENT_ID = '" + uuid + "'");
                OraclePlanModelBuilder.useResults(statement, new AbstractPlanModelBuilder.ResourceUser<ResultSet>(){

                    @Override
                    public void use(ResultSet resultSet) throws PlanRetrievalException, SQLException {
                        if (resultSet == null) {
                            throw new PlanRetrievalException("No data returned for plan query");
                        }
                        while (resultSet.next()) {
                            MetaData nodeData = new MetaData(resultSet.getString("OPERATION"), resultSet.getString("OPTIONS"), resultSet.getString("OBJECT_NAME"), resultSet.getString("OBJECT_TYPE"), OraclePlanModelBuilder.this.getInteger(resultSet, "ID"), OraclePlanModelBuilder.this.getInteger(resultSet, "PARENT_ID"), OraclePlanModelBuilder.this.getInteger(resultSet, "POSITION"), OraclePlanModelBuilder.this.getBig(resultSet, "COST"), OraclePlanModelBuilder.this.getBig(resultSet, "CARDINALITY"), OraclePlanModelBuilder.this.getBig(resultSet, "CPU_COST"), OraclePlanModelBuilder.this.getBig(resultSet, "IO_COST"));
                            if (nodeData.parentId == null) {
                                root2.set((Object)nodeData);
                                continue;
                            }
                            childMap.putValue((Object)nodeData.parentId, (Object)nodeData);
                        }
                    }
                });
            }
        }, new AbstractPlanModelBuilder.StateSaver[0]);
        if (root2.get() == null) {
            throw new PlanRetrievalException("No root operation found");
        }
        return new Object(){

            public MetaNode<MetaData> fillChildren(MetaNode<MetaData> node) {
                for (MetaData data : childMap.get((Object)((MetaData)node.data).id)) {
                    node.children.add(this.fillChildren(new MetaNode<MetaData>(data)));
                }
                Collections.sort(node.children, (o1, o2) -> Comparing.compare((Comparable)((MetaData)o1.data).position, (Comparable)((MetaData)o2.data).position));
                return node;
            }
        }.fillChildren(new MetaNode<Object>(root2.get()));
    }

    private void parseModel(@NotNull MetaNode<MetaData> root2) throws PlanRetrievalException {
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/plan/oracle/OraclePlanModelBuilder", "parseModel"));
        }
        this.openNode();
        this.parseStatement(root2);
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
    }

    @Override
    @NotNull
    protected String dump() {
        String string = new Object(){
            StringBuilder dump = new StringBuilder();
            {
                this.visit(0, OraclePlanModelBuilder.this.myPlan);
            }

            private void visit(int lvl, MetaNode<MetaData> node) {
                for (int i2 = 0; i2 < lvl; ++i2) {
                    this.dump.append("  ");
                }
                this.dump.append(((MetaData)node.data).operation).append("\t").append(((MetaData)node.data).options).append("\t").append(((MetaData)node.data).objectName).append("\t").append(((MetaData)node.data).objectType).append("\t").append(((MetaData)node.data).cardinality).append("\t").append(((MetaData)node.data).cost).append("\t").append(((MetaData)node.data).cpuCost).append("\t").append(((MetaData)node.data).ioCost);
                this.dump.append("\n");
                for (MetaNode<MetaData> metaNode : node.children) {
                    this.visit(lvl + 1, metaNode);
                }
            }
        }.dump.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/oracle/OraclePlanModelBuilder", "dump"));
        }
        return string;
    }

    @Override
    public void processRaw(@NotNull DataRequest.Context context, @NotNull DatabaseConnection connection) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/plan/oracle/OraclePlanModelBuilder", "processRaw"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/plan/oracle/OraclePlanModelBuilder", "processRaw"));
        }
        this.myPlan = this.getMetaPlan(connection);
        this.showRaw();
        this.parseModel(this.myPlan);
        this.modelReady();
    }

    @Override
    @NotNull
    protected String parseRawDescription(@NotNull MetaNode<MetaData> element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/plan/oracle/OraclePlanModelBuilder", "parseRawDescription"));
        }
        String string = "cpu_cost = " + ((MetaData)element.data).cpuCost + ", io_cost = " + ((MetaData)element.data).ioCost;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/oracle/OraclePlanModelBuilder", "parseRawDescription"));
        }
        return string;
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull MetaNode<MetaData> element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/plan/oracle/OraclePlanModelBuilder", "parseAccessRelation"));
        }
        return ((MetaData)element.data).objectType != null && StringUtil.startsWithIgnoreCase((String)((MetaData)element.data).objectType, (String)"table") ? ((MetaData)element.data).objectName : null;
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull MetaNode<MetaData> element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/plan/oracle/OraclePlanModelBuilder", "parsePlanNumRows"));
        }
        return ((MetaData)element.data).cardinality;
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull MetaNode<MetaData> element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/plan/oracle/OraclePlanModelBuilder", "parseAccessIndex"));
        }
        return ((MetaData)element.data).objectType != null && StringUtil.startsWithIgnoreCase((String)((MetaData)element.data).objectType, (String)"index") ? ((MetaData)element.data).objectName : null;
    }

    @Override
    protected void parsePlan(@NotNull MetaNode<MetaData> element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/plan/oracle/OraclePlanModelBuilder", "parsePlan"));
        }
        this.openNode();
        this.parseSubPlans(element);
        PlanModel.NodeType nodeType = TYPE_MAPPING.get(((MetaData)element.data).operation);
        if (nodeType == null) {
            nodeType = PlanModel.NodeType.UNKNOWN;
        }
        nodeType = (PlanModel.NodeType)((Object)ObjectUtils.chooseNotNull((Object)((Object)SUB_MAPPING.get(Pair.create((Object)((Object)nodeType), (Object)((MetaData)element.data).options))), (Object)((Object)nodeType)));
        String title = StringUtil.notNullize((String)((MetaData)element.data).operation) + (StringUtil.isEmpty((String)((MetaData)element.data).options) ? "" : " " + ((MetaData)element.data).options);
        PlanModel.GenericNode node = this.createNode(element, nodeType, title);
        this.closeNode(node);
    }

    @Override
    protected void parseSubPlans(@NotNull MetaNode<MetaData> element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/plan/oracle/OraclePlanModelBuilder", "parseSubPlans"));
        }
        for (MetaNode<MetaData> metaNode : element.children) {
            this.parsePlan(metaNode);
        }
    }

    @Override
    protected void parseStatement(@NotNull MetaNode<MetaData> element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/plan/oracle/OraclePlanModelBuilder", "parseStatement"));
        }
        this.openNode();
        PlanModel.NodeType nodeType = STATEMENT_MAPPING.get(((MetaData)element.data).operation);
        if (nodeType == null) {
            nodeType = PlanModel.NodeType.STATEMENT;
        }
        PlanModel.GenericNode node = this.createNode(element, nodeType, nodeType == PlanModel.NodeType.STATEMENT ? ((MetaData)element.data).operation : null);
        this.parseSubPlans(element);
        this.closeNode(node);
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull MetaNode<MetaData> element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/plan/oracle/OraclePlanModelBuilder", "parseTotalCost"));
        }
        return ((MetaData)element.data).cost == null ? null : Double.valueOf(((MetaData)element.data).cost.doubleValue());
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull MetaNode<MetaData> element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/plan/oracle/OraclePlanModelBuilder", "parseStartupCost"));
        }
        return null;
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull MetaNode<MetaData> element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/plan/oracle/OraclePlanModelBuilder", "parseSubqueryCorrelated"));
        }
        return false;
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull MetaNode<MetaData> element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/plan/oracle/OraclePlanModelBuilder", "parseSubqueryScalar"));
        }
        return false;
    }

    static {
        TYPE_MAPPING.put("AND-EQUAL", PlanModel.NodeType.SET_OP);
        TYPE_MAPPING.put("BITMAP", PlanModel.NodeType.BITMAP_INDEX_SCAN);
        TYPE_MAPPING.put("CONNECT BY", PlanModel.NodeType.TRANSFORM);
        TYPE_MAPPING.put("CONCATENATION", PlanModel.NodeType.UNION_ALL);
        TYPE_MAPPING.put("COUNT", PlanModel.NodeType.TRANSFORM);
        TYPE_MAPPING.put("DOMAIN INDEX", PlanModel.NodeType.INDEX_SCAN);
        TYPE_MAPPING.put("FILTER", PlanModel.NodeType.FILTER);
        TYPE_MAPPING.put("FIRST ROW", PlanModel.NodeType.TRANSFORM);
        TYPE_MAPPING.put("FOR UPDATE", PlanModel.NodeType.LOCK_ROWS);
        TYPE_MAPPING.put("HASH", PlanModel.NodeType.GROUP_BY);
        TYPE_MAPPING.put("HASH JOIN", PlanModel.NodeType.HASH_JOIN);
        TYPE_MAPPING.put("INDEX", PlanModel.NodeType.INDEX_SCAN);
        TYPE_MAPPING.put("INLIST ITERATOR", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("INTERSECTION", PlanModel.NodeType.INTERSECT);
        TYPE_MAPPING.put("LOAD AS SELECT", PlanModel.NodeType.DIRECT_LOAD);
        TYPE_MAPPING.put("MERGE JOIN", PlanModel.NodeType.MERGE_JOIN);
        TYPE_MAPPING.put("MAT_VIEW REWRITE ACCESS", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("MINUS", PlanModel.NodeType.EXCEPT);
        TYPE_MAPPING.put("NESTED LOOPS", PlanModel.NodeType.NESTED_LOOPS);
        TYPE_MAPPING.put("PARTITION", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("PX ITERATOR", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("PX COORDINATOR", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("PX PARTITION", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("PX RECEIVE", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("PX SEND", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("REMOTE", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("SEQUENCE", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("SORT", PlanModel.NodeType.SORT);
        TYPE_MAPPING.put("TABLE ACCESS", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("TEMP TABLE TRANSFORMATION", PlanModel.NodeType.TEMPORARY);
        TYPE_MAPPING.put("UNION-ALL", PlanModel.NodeType.UNION_ALL);
        TYPE_MAPPING.put("UNION", PlanModel.NodeType.UNION);
        TYPE_MAPPING.put("VIEW", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("FAST DUAL", PlanModel.NodeType.VALUE);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.ACCESS), (Object)"FULL"), PlanModel.NodeType.SEQ_SCAN);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.ACCESS), (Object)"BY ROWID RANGE"), PlanModel.NodeType.ROWID_ACCESS);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.ACCESS), (Object)"SAMPLE BY ROWID RANGE"), PlanModel.NodeType.ROWID_ACCESS);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.ACCESS), (Object)"BY USER ROWID"), PlanModel.NodeType.ROWID_ACCESS);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.ACCESS), (Object)"BY INDEX ROWID"), PlanModel.NodeType.INDEX_SCAN);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.ACCESS), (Object)"BY GLOBAL INDEX ROWID"), PlanModel.NodeType.INDEX_SCAN);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.ACCESS), (Object)"BY LOCAL INDEX ROWID"), PlanModel.NodeType.INDEX_SCAN);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.INDEX_SCAN), (Object)"UNIQUE SCAN"), PlanModel.NodeType.UNIQUE_INDEX_SCAN);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.INDEX_SCAN), (Object)"FULL SCAN"), PlanModel.NodeType.FULL_INDEX_SCAN);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.INDEX_SCAN), (Object)"FULL SCAN DESCENDING"), PlanModel.NodeType.FULL_INDEX_SCAN);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.INDEX_SCAN), (Object)"FAST FULL SCAN"), PlanModel.NodeType.FULL_INDEX_SCAN);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.SORT), (Object)"UNIQUE"), PlanModel.NodeType.SORT_UNIQUE);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.SORT), (Object)"GROUP BY"), PlanModel.NodeType.GROUP_BY);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.SORT), (Object)"ORDER BY"), PlanModel.NodeType.ORDER_BY);
        SUB_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)((Object)PlanModel.NodeType.UNKNOWN), (Object)"SORT"), PlanModel.NodeType.SORT);
        STATEMENT_MAPPING.put("SELECT STATEMENT", PlanModel.NodeType.SELECT);
        STATEMENT_MAPPING.put("INSERT STATEMENT", PlanModel.NodeType.INSERT);
        STATEMENT_MAPPING.put("UPDATE STATEMENT", PlanModel.NodeType.UPDATE);
        STATEMENT_MAPPING.put("DELETE STATEMENT", PlanModel.NodeType.DELETE);
    }

    public static class MetaData {
        public final String operation;
        public final String options;
        public final String objectName;
        public final String objectType;
        public final Integer id;
        public final Integer parentId;
        public final Integer position;
        public final BigDecimal cardinality;
        public final BigDecimal cost;
        public final BigDecimal cpuCost;
        public final BigDecimal ioCost;

        private MetaData(String operation, String options, String objectName, String objectType, Integer id, Integer parentId, Integer position, BigDecimal cost, BigDecimal cardinality, BigDecimal cpuCost, BigDecimal ioCost) {
            this.operation = operation;
            this.options = options;
            this.objectName = objectName;
            this.objectType = objectType;
            this.id = id;
            this.parentId = parentId;
            this.position = position;
            this.cost = cost;
            this.cardinality = cardinality;
            this.cpuCost = cpuCost;
            this.ioCost = ioCost;
        }
    }
}

