/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbGoToSymbolProvider
implements GotoClassContributor {
    @NotNull
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        TreeSet result2 = ContainerUtil.newTreeSet();
        this.traverser(project).traverse().transform(DasUtil.TO_NAME).addAllTo((Collection)result2);
        result2.remove("");
        String[] stringArray = ArrayUtil.toStringArray((Collection)result2);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbGoToSymbolProvider", "getNames"));
        }
        return stringArray;
    }

    @NotNull
    protected JBTreeTraverser<DasObject> traverser(Project project) {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)DasUtil.dasTraverser().withRoots(this.getRoots(project));
        if (jBTreeTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbGoToSymbolProvider", "traverser"));
        }
        return jBTreeTraverser;
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
        ArrayList result2 = ContainerUtil.newArrayList();
        this.traverser(project).traverse().filter(Conditions.compose((Function)DasUtil.TO_NAME, (Condition)Conditions.is((Object)name))).addAllTo((Collection)result2);
        NavigationItem[] navigationItemArray = result2.toArray(new NavigationItem[result2.size()]);
        if (navigationItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbGoToSymbolProvider", "getItemsByName"));
        }
        return navigationItemArray;
    }

    @Nullable
    public String getQualifiedName(NavigationItem item) {
        if (item instanceof DbElement) {
            DbElement e = (DbElement)item;
            return e.getDataSource().getName() + "." + QNameUtil.getQualifiedName(e);
        }
        return null;
    }

    @Nullable
    public String getQualifiedNameSeparator() {
        return ".";
    }

    @NotNull
    protected List<DbDataSource> getRoots(Project project) {
        List list = DbPsiFacade.getInstance((Project)project).getDataSources();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbGoToSymbolProvider", "getRoots"));
        }
        return list;
    }
}

