/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DasCluster;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.postgres.PostgresDefType;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import icons.DatabaseIcons;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbPresentation {
    public static final String UNNAMED = "<unnamed>";
    private static final Map<ObjectKind, Icon> ourIcons = ContainerUtil.newConcurrentMap();

    @Nullable
    public static Icon getIcon(@Nullable ObjectKind kind) {
        return ourIcons.get(kind);
    }

    public static void registerIcon(ObjectKind kind, Icon icon) {
        ourIcons.put(kind, icon);
    }

    @Nullable
    public static Icon getIcon(@NotNull DasObject c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/database/psi/DbPresentation", "getIcon"));
        }
        ObjectKind kind = c.getKind();
        if (c instanceof PsiElement && !((PsiElement)c).isValid()) {
            return DbPresentation.getIcon(kind);
        }
        if (kind == ObjectKind.COLUMN && c instanceof DasColumn) {
            return DbPresentation.getColumnIcon((DasColumn)c);
        }
        if (kind == ObjectKind.KEY && c instanceof DasTableKey) {
            return ((DasTableKey)c).isPrimary() ? DatabaseIcons.GoldKey : DatabaseIcons.GoldKeyAlt;
        }
        if (kind == ObjectKind.INDEX && c instanceof DasIndex) {
            DasIndex index = (DasIndex)c;
            return index.isUnique() ? (index.isFunctionBased() ? DatabaseIcons.IndexUniqueFun : DatabaseIcons.IndexUnique) : (index.isFunctionBased() ? DatabaseIcons.IndexFun : DatabaseIcons.Index);
        }
        if (c instanceof DasRoutine) {
            DasRoutine.Kind k = ((DasRoutine)c).getRoutineKind();
            return k == DasRoutine.Kind.PROCEDURE ? DatabaseIcons.Procedure : (k == DasRoutine.Kind.FUNCTION ? DatabaseIcons.Function : DatabaseIcons.Routine);
        }
        if (kind == ObjectKind.CLUSTER) {
            DasCluster oc;
            ClusterType clusterType;
            if (c instanceof DasCluster && (clusterType = (oc = (DasCluster)c).getClusterType()) != null) {
                switch (clusterType) {
                    case INDEX: {
                        return DatabaseIcons.IndexCluster;
                    }
                    case HASH: {
                        return DatabaseIcons.HashCluster;
                    }
                }
            }
        } else if (kind == ObjectKind.OBJECT_TYPE) {
            Object d;
            Icon i2 = DbPresentation.getIcon(kind);
            if (c instanceof DbElement && (d = ((DbElement)c).getDelegate()) instanceof PostgresDefType) {
                PostgresDefType pgd = (PostgresDefType)d;
                switch (pgd.getSubKind()) {
                    case ENUM: {
                        i2 = AllIcons.Nodes.Enum;
                    }
                }
            }
            return i2;
        }
        return DbPresentation.getIcon(kind);
    }

    static Icon getColumnIcon(@NotNull DasColumn c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/database/psi/DbPresentation", "getColumnIcon"));
        }
        Set attrs = c.getTable().getColumnAttrs(c);
        boolean pinned = c.isNotNull();
        boolean inIndex = attrs.contains(DasColumn.Attribute.INDEX);
        boolean pk = attrs.contains(DasColumn.Attribute.PRIMARY_KEY);
        boolean fk = attrs.contains(DasColumn.Attribute.FOREIGN_KEY);
        if (pk && fk) {
            if (pinned) {
                return inIndex ? DatabaseIcons.ColGoldBlueKeyDotIndex : DatabaseIcons.ColGoldBlueKeyDot;
            }
            return inIndex ? DatabaseIcons.ColGoldBlueKeyIndex : DatabaseIcons.ColGoldBlueKey;
        }
        if (pk) {
            if (pinned) {
                return inIndex ? DatabaseIcons.ColGoldKeyDotIndex : DatabaseIcons.ColGoldKeyDot;
            }
            return inIndex ? DatabaseIcons.ColGoldKeyIndex : DatabaseIcons.ColGoldKey;
        }
        if (fk) {
            if (pinned) {
                return inIndex ? DatabaseIcons.ColBlueKeyDotIndex : DatabaseIcons.ColBlueKeyDot;
            }
            return inIndex ? DatabaseIcons.ColBlueKeyIndex : DatabaseIcons.ColBlueKey;
        }
        if (pinned) {
            return inIndex ? DatabaseIcons.ColDotIndex : DatabaseIcons.ColDot;
        }
        return inIndex ? DatabaseIcons.ColIndex : DatabaseIcons.Col;
    }

    @NotNull
    public static String getPresentableName(@NotNull DasObject o, boolean unnamed) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/psi/DbPresentation", "getPresentableName"));
        }
        Object d = o instanceof DbElement ? ((DbElement)o).getDelegate() : null;
        String name = d instanceof BasicNode ? ((BasicNode)d).getDisplayName() : o.getName();
        String string = StringUtil.isEmpty((String)name) && unnamed ? UNNAMED : name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbPresentation", "getPresentableName"));
        }
        return string;
    }

    public static boolean isUnnamed(@NotNull DasObject o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/psi/DbPresentation", "isUnnamed"));
        }
        if (StringUtil.isNotEmpty((String)o.getName())) {
            return false;
        }
        if (o.getKind() != ObjectKind.ROUTINE) {
            return true;
        }
        DasObject parent = o.getDbParent();
        return parent == null || parent.getKind() != ObjectKind.PACKAGE;
    }

    @NotNull
    public static String getPresentableName(@NotNull ObjectKind o, @NotNull DatabaseDialect dialect) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/psi/DbPresentation", "getPresentableName"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/psi/DbPresentation", "getPresentableName"));
        }
        String name = dialect.getNameForKind(o);
        String string = name == null ? DasUtil.NO_NAME : StringUtil.toLowerCase((String)name);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbPresentation", "getPresentableName"));
        }
        return string;
    }

    static {
        ourIcons.put(ObjectKind.DATABASE, DatabaseIcons.Database);
        ourIcons.put(ObjectKind.SCHEMA, DatabaseIcons.Schema);
        ourIcons.put(ObjectKind.SEQUENCE, DatabaseIcons.Sequence);
        ourIcons.put(ObjectKind.CLUSTER, DatabaseIcons.UnspecifiedCluster);
        ourIcons.put(ObjectKind.TABLE, DatabaseIcons.Table);
        ourIcons.put(ObjectKind.COLUMN, DatabaseIcons.Col);
        ourIcons.put(ObjectKind.INDEX, DatabaseIcons.Index);
        ourIcons.put(ObjectKind.KEY, DatabaseIcons.GoldKeyAlt);
        ourIcons.put(ObjectKind.FOREIGN_KEY, DatabaseIcons.BlueKey);
        ourIcons.put(ObjectKind.VIEW, DatabaseIcons.View);
        ourIcons.put(ObjectKind.MAT_VIEW, DatabaseIcons.MaterializedView);
        ourIcons.put(ObjectKind.CHECK, DatabaseIcons.CheckConstraint);
        ourIcons.put(ObjectKind.RULE, DatabaseIcons.Rule);
        ourIcons.put(ObjectKind.TRIGGER, DatabaseIcons.Trigger);
        ourIcons.put(ObjectKind.PACKAGE, DatabaseIcons.Package);
        ourIcons.put(ObjectKind.ALIAS_TYPE, DatabaseIcons.ObjecType);
        ourIcons.put(ObjectKind.TABLE_TYPE, DatabaseIcons.ObjecType);
        ourIcons.put(ObjectKind.OBJECT_TYPE, DatabaseIcons.ObjecType);
        ourIcons.put(ObjectKind.OBJECT_ATTRIBUTE, DatabaseIcons.ObjecTypeAttribute);
        ourIcons.put(ObjectKind.COLLECTION_TYPE, DatabaseIcons.CollectionType);
        ourIcons.put(ObjectKind.BODY, DatabaseIcons.Body);
        ourIcons.put(ObjectKind.ROUTINE, DatabaseIcons.Routine);
        ourIcons.put(ObjectKind.ARGUMENT, DatabaseIcons.Argument);
        ourIcons.put(ObjectKind.OPERATOR, DatabaseIcons.Operator);
        ourIcons.put(ObjectKind.VARIABLE, DatabaseIcons.Variable);
        ourIcons.put(ObjectKind.SYNONYM, DatabaseIcons.Synonym);
        ourIcons.put(ObjectKind.VIRTUAL_TABLE, DatabaseIcons.Table);
    }
}

