/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.database.DataBus;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.database.run.ConsoleDataAuditor;
import com.intellij.database.run.ConsoleDataConsumer;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.ui.ParametersPanel;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbUIUtil;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class AbstractQueryLanguageConsole<T>
implements DataProvider,
DataRequest.OwnerEx,
Disposable.Parent {
    public static final Logger LOG = Logger.getInstance((String)"com.intellij.database.run.AbstractQueryLanguageConsole");
    private static final Key<AbstractQueryLanguageConsole> QL_CONSOLE_KEY = Key.create((String)"QL_CONSOLE_KEY");
    public static final String ID_PARAMETERS = "Parameters";
    public static final String ID_CONSOLE = "Input";
    private final TraceableDisposable myTraceableDisposable;
    private final Content myContent;
    private final RunnerLayoutUi myUi;
    private final DataBus.Consuming myMessageBus;
    private final T myTarget;
    private final LanguageConsoleView myConsoleView;
    private final Alarm myAlarm;
    private final Alarm myUpdateAlarm;
    protected final ScriptModel.PStorage myPStorage;
    protected ParametersPanel myParamPanel;
    private Content myParamPanelContent;
    private boolean myDisposed;
    private final DataAuditor.BusyCounter myBusyCount;
    private final DataAuditor.ConsoleLogger myHistoryLogger;
    protected final ConsoleDataConsumer myDataConsumer;
    protected final ConsoleDataAuditor myDataAuditor;
    private final AtomicReference<DataRequest.TxMarker> myCurrentTx;
    private SyntaxHighlighter myHighlighter;

    public AbstractQueryLanguageConsole(@NotNull Project project, @NotNull DataBus.Consuming messageBus, @NotNull T target, @NotNull String title, @NotNull Language language) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/AbstractQueryLanguageConsole", "<init>"));
        }
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/database/run/AbstractQueryLanguageConsole", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/run/AbstractQueryLanguageConsole", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/run/AbstractQueryLanguageConsole", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/run/AbstractQueryLanguageConsole", "<init>"));
        }
        this((LanguageConsoleView)new LanguageConsoleImpl(project, title, language), messageBus, target);
    }

    public AbstractQueryLanguageConsole(@NotNull LanguageConsoleView languageConsole, @NotNull DataBus.Consuming messageBus, @NotNull T target) {
        if (languageConsole == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageConsole", "com/intellij/database/run/AbstractQueryLanguageConsole", "<init>"));
        }
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/database/run/AbstractQueryLanguageConsole", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/run/AbstractQueryLanguageConsole", "<init>"));
        }
        this.myTraceableDisposable = new TraceableDisposable(true);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.myPStorage = ScriptModel.PStorage.newStorage();
        this.myCurrentTx = new AtomicReference<DataRequest.TxMarker>(DataRequest.NONE);
        this.myMessageBus = messageBus.filterFor(this);
        this.myTarget = target;
        this.myConsoleView = languageConsole;
        this.myUi = RunnerLayoutUi.Factory.getInstance((Project)this.getProject()).create(this.getTitle(), this.getTitle(), this.getTitle(), (Disposable)this);
        this.myContent = ContentFactory.SERVICE.getInstance().createContent(this.getUi().getComponent(), this.getTitle(), false);
        this.myUi.getContentManager().addDataProvider((DataProvider)this);
        this.myContent.putUserData(QL_CONSOLE_KEY, (Object)this);
        ((ConsoleViewImpl)languageConsole).setEmulateCarriageReturn(false);
        this.myHistoryLogger = this.createHistoryLogger();
        this.myBusyCount = new DataAuditor.BusyCounter(this){

            @Override
            protected void update(int current) {
                DbUIUtil.invokeLaterIfNeeded(() -> {
                    if (!AbstractQueryLanguageConsole.this.isValid()) {
                        return;
                    }
                    AbstractQueryLanguageConsole.this.updatePendingRequestsEDT();
                });
            }
        };
        this.myDataConsumer = new ConsoleDataConsumer(this){

            @Override
            @NotNull
            protected PlaceInGrid getPlaceInGrid() {
                PlaceInGrid placeInGrid = AbstractQueryLanguageConsole.this.getResultPlaceInGrid();
                if (placeInGrid == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/AbstractQueryLanguageConsole$2", "getPlaceInGrid"));
                }
                return placeInGrid;
            }
        };
        this.myDataAuditor = new ConsoleDataAuditor(this){

            @Override
            public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/run/AbstractQueryLanguageConsole$3", "jobSubmitted"));
                }
                if (producer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/run/AbstractQueryLanguageConsole$3", "jobSubmitted"));
                }
                super.jobSubmitted(request, producer);
                if (request instanceof DataRequest.TxRequest || this.isLazySchemaSwitch(request)) {
                    return;
                }
                this.doShowConsole();
            }

            @Override
            public void requestStarted(@NotNull DataRequest.Context context) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/AbstractQueryLanguageConsole$3", "requestStarted"));
                }
                if (this.isLazySchemaSwitch(context.request)) {
                    this.doShowConsole();
                }
                super.requestStarted(context);
                AbstractQueryLanguageConsole.this.addRequestToHistory(context);
                DbUIUtil.invokeLaterIfNeeded(() -> {
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/AbstractQueryLanguageConsole$3", "lambda$requestStarted$0"));
                    }
                    if (!AbstractQueryLanguageConsole.this.isValid()) {
                        return;
                    }
                    AbstractQueryLanguageConsole.this.myDataConsumer.onRequestStartedEDT(context);
                });
                AbstractQueryLanguageConsole.this.myAlarm.addRequest(() -> {
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/AbstractQueryLanguageConsole$3", "lambda$requestStarted$1"));
                    }
                    if (!AbstractQueryLanguageConsole.this.isValid()) {
                        return;
                    }
                    AbstractQueryLanguageConsole.this.myDataConsumer.onRequestTakesTimeEDT(context);
                }, 1000L, ModalityState.any());
            }

            @Override
            public void fetchStarted(@NotNull DataRequest.Context context, int index) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/AbstractQueryLanguageConsole$3", "fetchStarted"));
                }
                AbstractQueryLanguageConsole.this.myAlarm.cancelAllRequests();
                super.fetchStarted(context, index);
            }

            @Override
            public void requestFinished(@NotNull DataRequest.Context context) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/AbstractQueryLanguageConsole$3", "requestFinished"));
                }
                AbstractQueryLanguageConsole.this.myAlarm.cancelAllRequests();
                super.requestFinished(context);
                DbUIUtil.invokeLaterIfNeeded(() -> {
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/AbstractQueryLanguageConsole$3", "lambda$requestFinished$2"));
                    }
                    if (!AbstractQueryLanguageConsole.this.isValid()) {
                        return;
                    }
                    AbstractQueryLanguageConsole.this.myDataConsumer.onRequestFinishedEDT(context);
                });
            }

            private boolean isLazySchemaSwitch(@NotNull DataRequest request) {
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/run/AbstractQueryLanguageConsole$3", "isLazySchemaSwitch"));
                }
                return request instanceof DataRequest.SchemaSwitchRequest && !((DataRequest.SchemaSwitchRequest)request).forced;
            }

            private void doShowConsole() {
                DbUIUtil.invokeLaterIfNeeded(() -> {
                    if (!AbstractQueryLanguageConsole.this.isValid()) {
                        return;
                    }
                    if (AbstractQueryLanguageConsole.this.myContent.getManager() == null) {
                        AbstractQueryLanguageConsole.this.showConsole(true, false);
                    }
                });
            }
        };
        Disposer.register((Disposable)this, (Disposable)this.myConsoleView);
        Disposer.register((Disposable)this.getProject(), (Disposable)this);
    }

    protected DataAuditor.ConsoleLogger createHistoryLogger() {
        return new DataAuditor.ConsoleLogger((ConsoleView)this.myConsoleView);
    }

    @Override
    public DataBus.Consuming getMessageBus() {
        return this.myMessageBus;
    }

    @Override
    @NotNull
    public DataRequest.TxMarker getCurrentTx() {
        DataRequest.TxMarker txMarker = this.myCurrentTx.get();
        if (txMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/AbstractQueryLanguageConsole", "getCurrentTx"));
        }
        return txMarker;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        this.setCurrentTx(autoCommit ? DataRequest.AUTO_COMMIT : DataRequest.START_NEW);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = "console:" + this.getTitle();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/AbstractQueryLanguageConsole", "getDisplayName"));
        }
        return string;
    }

    public void setCurrentTx(@NotNull DataRequest.TxMarker currentTx) {
        if (currentTx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentTx", "com/intellij/database/run/AbstractQueryLanguageConsole", "setCurrentTx"));
        }
        this.myCurrentTx.set(currentTx);
    }

    @NotNull
    public T getTarget() {
        T t = this.myTarget;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/AbstractQueryLanguageConsole", "getTarget"));
        }
        return t;
    }

    @NotNull
    public ScriptModel.PStorage getPStorage() {
        ScriptModel.PStorage pStorage = this.myPStorage;
        if (pStorage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/AbstractQueryLanguageConsole", "getPStorage"));
        }
        return pStorage;
    }

    @NotNull
    public DataAuditor.ConsoleLogger getHistoryLogger() {
        DataAuditor.ConsoleLogger consoleLogger = this.myHistoryLogger;
        if (consoleLogger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/AbstractQueryLanguageConsole", "getHistoryLogger"));
        }
        return consoleLogger;
    }

    private JComponent getEditorComponent() {
        return this.getLanguageConsole().getCurrentEditor().getContentComponent();
    }

    @NotNull
    public LanguageConsoleView getLanguageConsole() {
        LanguageConsoleView languageConsoleView = this.myConsoleView;
        if (languageConsoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/AbstractQueryLanguageConsole", "getLanguageConsole"));
        }
        return languageConsoleView;
    }

    public boolean isValid() {
        return !this.myDisposed && !this.myUi.isDisposed() && !this.myConsoleView.getHistoryViewer().isDisposed() && this.myConsoleView.getVirtualFile().isValid() && this.isTargetValid();
    }

    protected boolean isTargetValid() {
        return true;
    }

    public void checkValid() {
        if (this.myDisposed) {
            this.myTraceableDisposable.throwDisposalError("Console already disposed");
        }
        if (!this.isValid()) {
            throw new AssertionError();
        }
    }

    @NotNull
    public RunnerLayoutUi getUi() {
        RunnerLayoutUi runnerLayoutUi = this.myUi;
        if (runnerLayoutUi == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/AbstractQueryLanguageConsole", "getUi"));
        }
        return runnerLayoutUi;
    }

    @NotNull
    public Content getContent() {
        Content content = this.myContent;
        if (content == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/AbstractQueryLanguageConsole", "getContent"));
        }
        return content;
    }

    @NotNull
    public abstract String getToolWindowId();

    @NotNull
    public abstract Icon getToolWindowIcon();

    protected abstract void buildConsoleUi(boolean var1);

    @NotNull
    public Project getProject() {
        Project project = this.getLanguageConsole().getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/AbstractQueryLanguageConsole", "getProject"));
        }
        return project;
    }

    @NotNull
    public String getTitle() {
        String string = this.getLanguageConsole().getTitle();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/AbstractQueryLanguageConsole", "getTitle"));
        }
        return string;
    }

    @NotNull
    public abstract ScriptModel<?> getScriptModel();

    public void beforeTreeDispose() {
        this.myDisposed = true;
        this.myTraceableDisposable.kill(null);
    }

    public void dispose() {
        ContentManager manager;
        if (this.myParamPanelContent != null) {
            Disposer.dispose((Disposable)this.myParamPanelContent);
        }
        if ((manager = this.getContent().getManager()) != null) {
            manager.removeContent(this.getContent(), false);
        }
        Disposer.dispose((Disposable)this.getContent());
    }

    public void updateConsoleOnRequestStarted(@NotNull DataRequest.Context context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/AbstractQueryLanguageConsole", "updateConsoleOnRequestStarted"));
        }
    }

    public void updateConsoleOnRequestFinished(@NotNull DataRequest.Context context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/AbstractQueryLanguageConsole", "updateConsoleOnRequestFinished"));
        }
    }

    public void updateConsoleOnTxCompleted(@NotNull DataRequest.Context context, boolean commit) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/AbstractQueryLanguageConsole", "updateConsoleOnTxCompleted"));
        }
    }

    protected AnAction initParameterView() {
        this.myParamPanel = new ParametersPanel(this.getProject(), this.getScriptModel(), this.myPStorage, this){
            private final List<RangeHighlighter> myHighlighters;
            {
                this.myHighlighters = ContainerUtil.newArrayList();
            }

            @Override
            protected void selectRanges(Iterable<TextRange> ranges) {
                Editor[] editors;
                HighlightManager highlightManager = HighlightManager.getInstance((Project)AbstractQueryLanguageConsole.this.getProject());
                for (Editor editor : editors = EditorFactory.getInstance().getEditors(AbstractQueryLanguageConsole.this.getLanguageConsole().getEditorDocument(), AbstractQueryLanguageConsole.this.getProject())) {
                    editor.getSelectionModel().removeSelection();
                    for (RangeHighlighter highlighter : this.myHighlighters) {
                        highlightManager.removeSegmentHighlighter(editor, highlighter);
                    }
                }
                this.myHighlighters.clear();
                TextRange first = (TextRange)Iterables.getFirst(ranges, null);
                if (first != null) {
                    OpenFileDescriptor descriptor = new OpenFileDescriptor(AbstractQueryLanguageConsole.this.getProject(), AbstractQueryLanguageConsole.this.getLanguageConsole().getVirtualFile(), first.getStartOffset());
                    EditorColorsScheme colorScheme = AbstractQueryLanguageConsole.this.getLanguageConsole().getCurrentEditor().getColorsScheme();
                    TextAttributes attributes = colorScheme.getAttributes(DatabaseColors.CONSOLE_SELECTED_PARAMETER);
                    for (Editor editor : editors) {
                        for (TextRange range : ranges) {
                            highlightManager.addRangeHighlight(editor, range.getStartOffset(), range.getEndOffset(), attributes, true, this.myHighlighters);
                        }
                        descriptor.navigateIn(editor);
                    }
                }
            }
        };
        this.myUpdateAlarm.setActivationComponent((JComponent)this.myParamPanel);
        this.getLanguageConsole().getEditorDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                AbstractQueryLanguageConsole.this.myUpdateAlarm.cancelAllRequests();
                AbstractQueryLanguageConsole.this.myUpdateAlarm.addComponentRequest(() -> {
                    AbstractQueryLanguageConsole.this.myParamPanel.onModelUpdated();
                    AbstractQueryLanguageConsole.this.myParamPanel.caretPositionChanged(AbstractQueryLanguageConsole.this.getLanguageConsole().getCurrentEditor().getCaretModel().getOffset());
                }, 300);
            }
        }, (Disposable)this);
        this.myParamPanelContent = this.getUi().createContent(ID_PARAMETERS, (JComponent)this.myParamPanel, DatabaseMessages.message((String)"jdbc.console.tab.title.parameters", (Object[])new Object[0]), PlatformIcons.PARAMETER_ICON, this.myParamPanel.getPreferredFocusedComponent());
        this.myParamPanelContent.setCloseable(false);
        DumbAwareAction editParameterAction = new DumbAwareAction(){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/AbstractQueryLanguageConsole$6", "update"));
                }
                Component owner = FocusManager.getCurrentManager().getFocusOwner();
                EditorEx currentEditor = AbstractQueryLanguageConsole.this.getLanguageConsole().getCurrentEditor();
                if (owner != null && SwingUtilities.isDescendingFrom(owner, currentEditor.getComponent())) {
                    boolean enabled = !AbstractQueryLanguageConsole.this.getScriptModel().subModel(TextRange.from((int)currentEditor.getCaretModel().getOffset(), (int)0), true).parameters().isEmpty();
                    e.getPresentation().setEnabled(enabled);
                } else {
                    e.getPresentation().setEnabled(true);
                }
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/AbstractQueryLanguageConsole$6", "actionPerformed"));
                }
                Component owner = FocusManager.getCurrentManager().getFocusOwner();
                EditorEx currentEditor = AbstractQueryLanguageConsole.this.getLanguageConsole().getCurrentEditor();
                if (owner != null && SwingUtilities.isDescendingFrom(owner, currentEditor.getComponent())) {
                    int offset = currentEditor.getCaretModel().getOffset();
                    AbstractQueryLanguageConsole.this.showConsole(true, true).done(aVoid -> {
                        AbstractQueryLanguageConsole.this.toggleParamContent(true);
                        AbstractQueryLanguageConsole.this.myParamPanel.tryEditParameterValue(offset);
                    });
                } else if (currentEditor.getContentComponent().isShowing()) {
                    IdeFocusManager.getInstance((Project)AbstractQueryLanguageConsole.this.getProject()).requestFocus((Component)currentEditor.getContentComponent(), true);
                } else if (!AbstractQueryLanguageConsole.this.getLanguageConsole().isConsoleEditorEnabled()) {
                    int offset = AbstractQueryLanguageConsole.this.getLanguageConsole().getCurrentEditor().getCaretModel().getOffset();
                    OpenFileDescriptor descriptor = new OpenFileDescriptor(AbstractQueryLanguageConsole.this.getProject(), AbstractQueryLanguageConsole.this.getLanguageConsole().getVirtualFile(), offset);
                    FileEditorManager.getInstance((Project)AbstractQueryLanguageConsole.this.getProject()).openTextEditor(descriptor, true);
                }
            }
        };
        JComponent shortcutTarget = this.getLanguageConsole().getConsoleEditor().getComponent();
        editParameterAction.getTemplatePresentation().setVisible(false);
        editParameterAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(115, 0)), shortcutTarget);
        editParameterAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(115, 0)), (JComponent)this.myParamPanel);
        this.myUi.getOptions().setTabPopupActions(this.buildTabPopupGroup());
        return new ToggleAction("View Parameters", null, this.myParamPanelContent.getIcon()){

            public boolean isDumbAware() {
                return true;
            }

            public boolean isSelected(AnActionEvent e) {
                return AbstractQueryLanguageConsole.this.myParamPanelContent == null;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                AbstractQueryLanguageConsole.this.toggleParamContent(state);
            }
        };
    }

    private void toggleParamContent(boolean state) {
        if (state == (this.myParamPanelContent == null)) {
            return;
        }
        if (state) {
            this.myParamPanel.onModelUpdated();
            this.getUi().addContent(this.myParamPanelContent, 0, PlaceInGrid.right, false);
            this.myParamPanelContent = null;
            if (!this.getUi().getComponent().isShowing()) {
                this.showConsole(true, false);
            }
        } else {
            ((RunnerContentUi)RunnerContentUi.KEY.getData(DataManager.getInstance().getDataContext((Component)this.getUi().getComponent()))).saveUiState();
            ContentManager manager = this.getUi().getContentManager();
            this.myParamPanelContent = manager.findContent(ID_PARAMETERS);
            manager.removeContent(this.myParamPanelContent, false);
        }
    }

    protected ActionGroup buildTabPopupGroup() {
        return (ActionGroup)ActionManager.getInstance().getAction("Console.TabPopupGroup");
    }

    public static void addLeftToolbarConsoleActions(@NotNull DefaultActionGroup actionGroup, @NotNull ConsoleView consoleView) {
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/database/run/AbstractQueryLanguageConsole", "addLeftToolbarConsoleActions"));
        }
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/database/run/AbstractQueryLanguageConsole", "addLeftToolbarConsoleActions"));
        }
        for (AnAction action : consoleView.createConsoleActions()) {
            if (StringUtil.containsIgnoreCase((String)StringUtil.notNullize((String)action.getTemplatePresentation().getDescription()), (String)"occurrence")) continue;
            actionGroup.add(action);
        }
    }

    public static <T extends AbstractQueryLanguageConsole> List<T> getActiveConsoles(Project project, String toolwindowId) {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return Collections.emptyList();
        }
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(toolwindowId);
        if (window == null) {
            return Collections.emptyList();
        }
        SmartList result2 = new SmartList();
        for (Content content : window.getContentManager().getContents()) {
            ContainerUtil.addIfNotNull((Collection)result2, (Object)((AbstractQueryLanguageConsole)content.getUserData(QL_CONSOLE_KEY)));
        }
        return result2;
    }

    @NotNull
    public Promise<Void> showConsole(boolean focused) {
        Promise<Void> promise = this.showConsole(focused, focused);
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/AbstractQueryLanguageConsole", "showConsole"));
        }
        return promise;
    }

    public Promise<Void> showConsole(boolean activateToolWindow, boolean requestFocus) {
        ContentManager contentManager;
        if (!this.isValid()) {
            return Promises.rejectedPromise();
        }
        this.resetHighlighter();
        ToolWindow window = this.getOrCreateToolWindow();
        this.ensureContentInitialized(requestFocus);
        if (this.myContent.getManager() == null) {
            for (AbstractQueryLanguageConsole console : AbstractQueryLanguageConsole.getActiveConsoles(this.getProject(), this.getToolWindowId())) {
                if (console.getLanguageConsole().getFile() != this.getLanguageConsole().getFile()) continue;
                LOG.error("Console already created for " + this.getLanguageConsole().getFile().getName());
            }
            contentManager = window.getContentManager();
            window.setAvailable(true, null);
            this.myContent.getComponent().updateUI();
            contentManager.addContent(this.myContent);
        } else {
            contentManager = this.myContent.getManager();
        }
        if (activateToolWindow) {
            AsyncPromise callback = new AsyncPromise();
            window.activate(() -> {
                if (!this.myContent.isValid()) {
                    return;
                }
                contentManager.setSelectedContent(this.myContent, requestFocus, false);
                callback.setResult(null);
            }, false, requestFocus);
            return callback;
        }
        contentManager.setSelectedContent(this.myContent, requestFocus, false);
        return Promises.resolvedPromise();
    }

    protected void ensureContentInitialized(boolean focused) {
        if (this.myContent.getDisposer() != null) {
            return;
        }
        this.myContent.setDisposer(new Disposable(){

            public void dispose() {
                Disposer.dispose((Disposable)AbstractQueryLanguageConsole.this);
            }
        });
        this.buildConsoleUi(focused);
    }

    @NotNull
    private ToolWindow getOrCreateToolWindow() {
        Project project = this.getProject();
        String windowId = this.getToolWindowId();
        Icon icon = this.getToolWindowIcon();
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
        ToolWindowEx window = (ToolWindowEx)manager.getToolWindow(windowId);
        if (window == null) {
            window = (ToolWindowEx)manager.registerToolWindow(windowId, true, ToolWindowAnchor.BOTTOM, (Disposable)project, true);
            window.setIcon(icon);
            ToolWindowEx w = window;
            w.getContentManager().addContentManagerListener((ContentManagerListener)new ContentManagerAdapter((ToolWindow)w, manager, windowId){
                final /* synthetic */ ToolWindow val$w;
                final /* synthetic */ ToolWindowManager val$manager;
                final /* synthetic */ String val$windowId;
                {
                    this.val$w = toolWindow;
                    this.val$manager = toolWindowManager;
                    this.val$windowId = string;
                }

                public void contentRemoved(ContentManagerEvent event) {
                    if (this.val$w.getContentManager().getContentCount() == 0) {
                        this.val$w.hide(null);
                        this.val$manager.unregisterToolWindow(this.val$windowId);
                    }
                }
            });
            this.setupToolWindow(window);
        }
        ToolWindowEx toolWindowEx = window;
        if (toolWindowEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/AbstractQueryLanguageConsole", "getOrCreateToolWindow"));
        }
        return toolWindowEx;
    }

    protected void setupToolWindow(@NotNull ToolWindowEx toolWindow) {
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/database/run/AbstractQueryLanguageConsole", "setupToolWindow"));
        }
    }

    public boolean beforeExecuteQueries(@NotNull ScriptModel<?> model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/run/AbstractQueryLanguageConsole", "beforeExecuteQueries"));
        }
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        this.myParamPanel.commit();
        if (model.statements().isEmpty()) {
            return false;
        }
        Project project = this.getProject();
        boolean forceShowParams = !model.getVirtualFile().equals(this.getLanguageConsole().getVirtualFile()) || DatabaseSettings.getSettings().alwaysReviewParameters;
        ScriptModel.PStorage storage = this.myPStorage;
        if ((forceShowParams && !model.parameters().isEmpty() || ParametersPanel.hasUnassignedParameters(model, storage)) && !ParametersPanel.ensureAllParametersAreSet(project, ID_PARAMETERS, model, storage)) {
            return false;
        }
        this.resetHighlighter();
        return true;
    }

    private void resetHighlighter() {
        EditorHighlighter highlighter = this.myConsoleView.getCurrentEditor().getHighlighter();
        this.myHighlighter = highlighter instanceof LexerEditorHighlighter ? ((LexerEditorHighlighter)highlighter).getSyntaxHighlighter() : null;
    }

    public abstract void executeQueries(@NotNull Editor var1, @NotNull ScriptModel<?> var2);

    protected void addRequestToHistory(DataRequest.Context context) {
        Object params2;
        String prompt;
        String query = context.getQuery();
        if (StringUtil.isEmpty((String)query)) {
            return;
        }
        LanguageConsoleView console = this.getLanguageConsole();
        if (context.request instanceof ConsoleDataRequest) {
            ConsoleHistoryController.addToHistory((LanguageConsoleView)console, (String)query);
        }
        if (StringUtil.isNotEmpty((String)(prompt = console.getPrompt()))) {
            console.print(prompt, (ConsoleViewContentType)ObjectUtils.notNull((Object)console.getPromptAttributes(), (Object)ConsoleViewContentType.USER_INPUT));
        }
        if (this.myHighlighter != null) {
            ConsoleViewUtil.printWithHighlighting((ConsoleView)console, (String)query, (SyntaxHighlighter)this.myHighlighter);
        } else {
            console.print(query, ConsoleViewContentType.USER_INPUT);
        }
        console.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        Object object = params2 = context.request instanceof DataRequest.QueryRequest ? ((DataRequest.QueryRequest)context.request).params : null;
        if (params2 instanceof Map && !((Map)params2).isEmpty()) {
            StringBuilder sb = new StringBuilder("(");
            boolean first = true;
            for (Map.Entry e : ((Map)params2).entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(e.getKey()).append("=").append(e.getValue());
            }
            sb.append(")\n");
            this.getLanguageConsole().print(sb.toString(), ConsoleViewContentType.NORMAL_OUTPUT);
        }
    }

    public abstract GridDataHookUp<DataConsumer.Row, DataConsumer.Column> createGridDataHookUp(@NotNull Disposable var1);

    protected abstract String getHelpID();

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.getHelpID();
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return this.getLanguageConsole().getVirtualFile();
        }
        return null;
    }

    @NotNull
    protected PlaceInGrid getResultPlaceInGrid() {
        PlaceInGrid placeInGrid = PlaceInGrid.bottom;
        if (placeInGrid == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/AbstractQueryLanguageConsole", "getResultPlaceInGrid"));
        }
        return placeInGrid;
    }

    protected void updatePendingRequestsEDT() {
        JComponent component;
        Content content = this.getOutputContent();
        JComponent jComponent = component = content == null ? null : content.getComponent();
        if (component instanceof JBLoadingPanel) {
            JBLoadingPanel loadingPanel = (JBLoadingPanel)component;
            if (this.myBusyCount.getCount() > 0) {
                loadingPanel.startLoading();
            } else {
                loadingPanel.stopLoading();
            }
        }
    }

    public boolean isIdle() {
        return this.myBusyCount.getCount() == 0;
    }

    @Nullable
    Content getOutputContent() {
        return this.getUi().findContent(ID_CONSOLE);
    }
}

