/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.dataSource.DataSource;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseStep;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.RowsDnDSupport;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import icons.DatabaseIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseSchemaAction
extends AlignedIconWithTextAction
implements DumbAware {
    private static final Key<SchemasPopup> ACTIVE_POPUP = Key.create((String)"ACTIVE_SCHEMA_POPUP");
    private static final Comparator<ObjectPath> PATH_COMPARATOR = (o1, o2) -> StringUtil.naturalCompare((String)o1.getDisplayName(), (String)o2.getDisplayName());
    private static final FileAttribute SELECTED_SEARCH_PATH_ATTR = new FileAttribute("datasource_namespace", 2, true);

    public void actionPerformed(AnActionEvent e) {
        JdbcConsole console = JdbcConsole.findConsole(e);
        JComponent button = (JComponent)e.getPresentation().getClientProperty("customComponent");
        if (button == null || !button.isShowing() || console == null) {
            return;
        }
        ObjectKind kind = DbImplUtil.getDatabaseDialect(console).getSearchPathObjectKind();
        if (kind == null) {
            return;
        }
        JBPopup popup = ChooseSchemaAction.buildPopup(console);
        popup.setMinimumSize(button.getSize());
        popup.showUnderneathOf((Component)button);
    }

    public void update(AnActionEvent e) {
        String fullText;
        List<Object> schemas;
        ObjectKind kind;
        JdbcConsole console = JdbcConsole.findConsole(e);
        JComponent button = (JComponent)e.getPresentation().getClientProperty("customComponent");
        ObjectKind objectKind = kind = console == null ? null : DbImplUtil.getDatabaseDialect(console).getSearchPathObjectKind();
        if (kind == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        SchemasPopup schemasPopup = (SchemasPopup)((Object)ACTIVE_POPUP.get((UserDataHolder)console.getLanguageConsole().getFile()));
        if (schemasPopup != null) {
            schemas = schemasPopup.myContainer.getPathItems();
        } else {
            schemas = SearchPath.getElements(console.getSearchPath());
            if (schemas.isEmpty() || ((ObjectPath)schemas.get((int)0)).kind == ObjectKind.NONE) {
                schemas = JBIterable.from((Iterable)((Iterable)DatabaseDataKeys.SEARCH_PATH_KEY.get((UserDataHolder)console.getLanguageConsole().getFile()))).transform(ObjectPath::of).filter(Conditions.notNull()).toList();
            }
        }
        String string = fullText = !schemas.isEmpty() ? ChooseSchemaAction.buildText(schemas) : "";
        if (StringUtil.isEmpty((String)fullText)) {
            fullText = "<" + Case.LOWER.apply(kind.name()) + ">";
        }
        String text = fullText.length() <= 30 ? fullText : fullText.substring(0, 30) + "\u2026";
        boolean visible = StringUtil.isNotEmpty((String)text);
        String tooltipText = "Switch current schema or user";
        Icon icon = UIUtil.isUnderDarcula() ? AllIcons.General.ComboArrow : AllIcons.General.ComboBoxButtonArrow;
        e.getPresentation().setEnabled(true);
        e.getPresentation().setVisible(visible);
        e.getPresentation().setText(text, false);
        e.getPresentation().setDescription(fullText);
        e.getPresentation().setDisabledIcon(icon);
        e.getPresentation().setIcon(icon);
        if (button != null) {
            button.setToolTipText(tooltipText);
            ((ActionButtonWithText)button).setHorizontalTextPosition(2);
        }
    }

    @NotNull
    private static String buildText(List<ObjectPath> schemas) {
        StringBuilder res = new StringBuilder();
        int pos = 0;
        while (pos < schemas.size()) {
            if (res.length() != 0) {
                res.append("; ");
            }
            ObjectPath cur = schemas.get(pos);
            if (++pos < schemas.size() && ChooseSchemaAction.hasSameParent(cur, schemas.get(pos))) {
                res.append(StringUtil.join(ChooseSchemaAction.getParentPath(cur), (String)"."));
                res.append(": ");
                res.append(cur.getName()).append(", ").append(schemas.get(pos).getName());
                ++pos;
                while (pos < schemas.size() && ChooseSchemaAction.hasSameParent(cur, schemas.get(pos))) {
                    res.append(", ").append(schemas.get(pos).getName());
                    ++pos;
                }
                continue;
            }
            res.append(cur.getDisplayName());
        }
        String string = res.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseSchemaAction", "buildText"));
        }
        return string;
    }

    @NotNull
    private static List<String> getParentPath(@NotNull ObjectPath o1) {
        if (o1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/database/run/actions/ChooseSchemaAction", "getParentPath"));
        }
        List<String> list = o1.path.subList(0, o1.path.size() - 1);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseSchemaAction", "getParentPath"));
        }
        return list;
    }

    private static boolean hasSameParent(@NotNull ObjectPath o1, @NotNull ObjectPath o2) {
        if (o1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/database/run/actions/ChooseSchemaAction", "hasSameParent"));
        }
        if (o2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/database/run/actions/ChooseSchemaAction", "hasSameParent"));
        }
        if (o1.path.size() <= 1 || o2.path.size() <= 1) {
            return false;
        }
        return ChooseSchemaAction.getParentPath(o1).equals(ChooseSchemaAction.getParentPath(o2));
    }

    @NotNull
    private static JBPopup buildPopup(@NotNull JdbcConsole console) {
        ObjectKind boundKind;
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/run/actions/ChooseSchemaAction", "buildPopup"));
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(console);
        HashSet visited = ContainerUtil.newHashSet();
        LocalDataSource dataSource = console.getDataSource();
        JBIterable namespaces = DasUtil.getNamespaces((DataSource)dataSource);
        DatabaseDriver driver = dataSource.getDatabaseDriver();
        DatabaseDriver.Bounds bounds = driver == null ? null : driver.getConnectionBounds();
        ObjectKind objectKind = boundKind = bounds == null || bounds.inReadOnlyMode && !dataSource.isReadOnly() ? null : bounds.boundTo;
        if (!(dataSource.getModel() instanceof BasicModel)) {
            namespaces = JBIterable.from((Iterable)namespaces.transform(DasUtil.TO_PARENT).filter(DasNamespace.class).toSet()).append((Iterable)namespaces);
        }
        ArrayList paths = ContainerUtil.newArrayList();
        ArrayList bounded = ContainerUtil.newArrayList();
        ArrayList others = ContainerUtil.newArrayList();
        paths.addAll(SearchPath.getElements(console.getSearchPath()));
        visited.addAll(paths);
        ObjectPath bound = null;
        Iterator it = paths.iterator();
        while (it.hasNext()) {
            ObjectPath path = (ObjectPath)it.next();
            if (dialect.sqlSetSearchPath((DatabaseSystem)dataSource, SearchPath.of(path)) != null || path.kind != boundKind) continue;
            it.remove();
            bound = path;
            bounded.add(path);
        }
        for (DasObject namespace : namespaces) {
            ObjectPath path = ObjectPath.of(namespace);
            if (path == null || !visited.add(path)) continue;
            if (dialect.sqlSetSearchPath((DatabaseSystem)dataSource, SearchPath.of(path)) != null) {
                others.add(path);
                continue;
            }
            if (path.kind != boundKind) continue;
            bounded.add(path);
        }
        if (bound == null && boundKind != null && !paths.isEmpty() && !((ObjectPath)paths.get((int)0)).path.isEmpty()) {
            ObjectPath path = (ObjectPath)paths.get(0);
            List<String> list = path.path.subList(0, path.path.size() - 1);
            bound = (ObjectPath)ContainerUtil.find((Iterable)bounded, b -> b.path.equals(list));
        }
        SchemasPopup schemasPopup = new SchemasPopup(console, SchemaContainer.autoMultiMode(paths, others, bounded, bound, dialect.supportsSearchPath(), PATH_COMPARATOR), dialect.supportsSearchPath(), (UserDataHolder)console.getLanguageConsole().getFile());
        if (schemasPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseSchemaAction", "buildPopup"));
        }
        return schemasPopup;
    }

    public static void scheduleSavedSchemaSwitch(@NotNull JdbcConsole console) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/run/actions/ChooseSchemaAction", "scheduleSavedSchemaSwitch"));
        }
        List<DasNamespace> o = ChooseSchemaAction.getSchemaToSwitchToInner(console);
        if (o == null) {
            return;
        }
        SearchPath path = DbImplUtil.getAutoSwitchPath(DbImplUtil.getDatabaseDialect(console), SearchPath.of(o));
        if (path == null) {
            return;
        }
        console.switchSchema(path, false);
        DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)console.getLanguageConsole().getFile(), o);
    }

    @Nullable
    private static List<DasNamespace> getSchemaToSwitchToInner(final @NotNull JdbcConsole console) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/run/actions/ChooseSchemaAction", "getSchemaToSwitchToInner"));
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(console);
        SearchPath schemaPaths = ChooseSchemaAction.getSelectedSearchPath(console.getLanguageConsole().getVirtualFile(), dialect);
        if (schemaPaths != null && schemaPaths.getCurrent().kind != ObjectKind.NONE) {
            LocalDataSource localDataSource = console.getDataSource();
            if (localDataSource.isLoading()) {
                Project project = console.getProject();
                final Disposable listenerDisposable = Disposer.newDisposable();
                Disposer.register((Disposable)console, (Disposable)listenerDisposable);
                DbPsiFacade.getInstance((Project)project).addModificationTrackerListener((ModificationTrackerListener)new ModificationTrackerListener<DbPsiFacade>(){

                    public void modificationCountChanged(DbPsiFacade source) {
                        Disposer.dispose((Disposable)listenerDisposable);
                        ChooseSchemaAction.scheduleSavedSchemaSwitch(console);
                    }
                }, listenerDisposable);
            } else {
                List o = JBIterable.from(SearchPath.getElements(schemaPaths)).transform(x -> {
                    if (console == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/run/actions/ChooseSchemaAction", "lambda$getSchemaToSwitchToInner$2"));
                    }
                    return DatabaseEditorHelper.findNamespace(console.getProject(), (DatabaseSystem)localDataSource, x);
                }).filter(Conditions.notNull()).toList();
                DasNamespace item = (DasNamespace)ContainerUtil.getFirstItem((List)o);
                return item != null && (item.getKind() == ObjectKind.SCHEMA || item.getKind() == ObjectKind.DATABASE) ? o : null;
            }
        }
        return null;
    }

    public static void setSelectedSearchPath(@NotNull VirtualFile file, @Nullable SearchPath schemaPaths) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/run/actions/ChooseSchemaAction", "setSelectedSearchPath"));
        }
        DbImplUtil.writeVFSAttributeSafe(file, SELECTED_SEARCH_PATH_ATTR, SearchPath.serialize(schemaPaths));
    }

    @Nullable
    private static SearchPath getSelectedSearchPath(@NotNull VirtualFile file, @NotNull DatabaseDialectEx dialect) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/run/actions/ChooseSchemaAction", "getSelectedSearchPath"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/actions/ChooseSchemaAction", "getSelectedSearchPath"));
        }
        return SearchPath.deserializeList(DbImplUtil.readVFSAttributeSafe(file, SELECTED_SEARCH_PATH_ATTR), dialect.getMetaModel());
    }

    private static class SchemaContainer<T> {
        private final List<T> myPathItems;
        private final List<T> myItems;
        private final List<T> myBounds;
        private T myCurrentBound;
        private T myFirstNonCurrentBound;
        private List<T> myAllItems;
        private boolean myMultiMode;
        private final Comparator<T> myComp;

        public static <T> SchemaContainer<T> autoMultiMode(@NotNull List<T> path, @NotNull Collection<T> other, @NotNull List<T> bounds, @Nullable T currentBound, boolean supportMulti, Comparator<T> comp) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/run/actions/ChooseSchemaAction$SchemaContainer", "autoMultiMode"));
            }
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/database/run/actions/ChooseSchemaAction$SchemaContainer", "autoMultiMode"));
            }
            if (bounds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/database/run/actions/ChooseSchemaAction$SchemaContainer", "autoMultiMode"));
            }
            ArrayList res = ContainerUtil.newArrayList(path);
            res.addAll(other);
            res.addAll(bounds);
            return new SchemaContainer<T>(path, bounds, res, currentBound, supportMulti && path.size() > 1, comp);
        }

        public SchemaContainer(@NotNull List<T> pathItems, @NotNull List<T> bounds, @NotNull List<T> items, @Nullable T currentBound, boolean multiMode, Comparator<T> comp) {
            if (pathItems == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathItems", "com/intellij/database/run/actions/ChooseSchemaAction$SchemaContainer", "<init>"));
            }
            if (bounds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/database/run/actions/ChooseSchemaAction$SchemaContainer", "<init>"));
            }
            if (items == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/database/run/actions/ChooseSchemaAction$SchemaContainer", "<init>"));
            }
            this.myPathItems = pathItems;
            this.myItems = items;
            this.myBounds = bounds;
            this.myCurrentBound = currentBound;
            this.myMultiMode = true;
            this.myComp = comp;
            Collections.sort(this.myItems, this.myComp);
            Collections.sort(this.myBounds, this.myComp);
            Collections.sort(this.myPathItems, this.myComp);
            this.setMultiMode(multiMode);
        }

        public void setMultiMode(boolean multi) {
            if (this.myMultiMode == multi) {
                return;
            }
            this.myMultiMode = multi;
            this.updateAllItems();
        }

        public int getWorkingItemsCount() {
            TIntArrayList list = new TIntArrayList();
            list.add(0);
            for (T item : this.myItems) {
                int cur = list.get(list.size() - 1);
                if (this.myBounds.contains(item)) {
                    if (cur == 0) continue;
                    list.add(0);
                    continue;
                }
                list.set(list.size() - 1, cur + 1);
            }
            return list.max() + this.myBounds.size();
        }

        public boolean hasBounds() {
            return !this.myBounds.isEmpty();
        }

        public boolean isBound(@NotNull T value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/actions/ChooseSchemaAction$SchemaContainer", "isBound"));
            }
            return this.myBounds.contains(value);
        }

        public boolean isCurrentBound(@NotNull T value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/actions/ChooseSchemaAction$SchemaContainer", "isCurrentBound"));
            }
            return this.myCurrentBound == value;
        }

        public void setCurrentBound(@Nullable T item) {
            this.setMultiMode(true);
            this.myCurrentBound = item;
            this.updateAllItems();
        }

        @NotNull
        public List<T> getAllItems() {
            if (this.myAllItems == null) {
                if (this.myCurrentBound == null) {
                    if (!this.myBounds.isEmpty()) {
                        this.myPathItems.clear();
                        this.myAllItems = ContainerUtil.newArrayList(this.myBounds);
                    } else {
                        this.myAllItems = JBIterable.from(this.myPathItems).append(this.myItems).unique().toList();
                    }
                    this.myFirstNonCurrentBound = null;
                } else {
                    this.myFirstNonCurrentBound = this.myBounds.size() < 2 ? null : this.myBounds.get(0);
                    Object v0 = this.myFirstNonCurrentBound;
                    if (this.myFirstNonCurrentBound == this.myCurrentBound) {
                        this.myFirstNonCurrentBound = this.myBounds.get(1);
                    }
                    LinkedHashSet goodItems = ContainerUtil.newLinkedHashSet();
                    int state = 0;
                    for (T item : this.myItems) {
                        if (state == 0 && item == this.myCurrentBound) {
                            goodItems.add(item);
                            ++state;
                            continue;
                        }
                        if (state != true) continue;
                        if (this.myBounds.contains(item)) {
                            ++state;
                            continue;
                        }
                        goodItems.add(item);
                    }
                    this.myPathItems.removeIf(p -> !goodItems.contains(p));
                    this.myAllItems = this.myMultiMode ? JBIterable.from(this.myPathItems).append((Iterable)goodItems).append(this.myBounds).unique().toList() : JBIterable.from((Iterable)goodItems).append(this.myBounds).unique().toList();
                }
            }
            List<T> list = this.myAllItems;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseSchemaAction$SchemaContainer", "getAllItems"));
            }
            return list;
        }

        public void updateAllItems() {
            this.myAllItems = null;
        }

        public T get(int i2) {
            return this.isValid(i2) ? (T)this.getAllItems().get(i2) : null;
        }

        public int indexOf(@Nullable T item) {
            return item == null ? -1 : this.getAllItems().indexOf(item);
        }

        private boolean isValid(int i2) {
            return i2 >= 0 && i2 < this.myItems.size();
        }

        public int currentSize() {
            return this.myPathItems.size();
        }

        public void setInPath(int index, boolean append, boolean first) {
            if (!this.isValid(index) || this.isInPath(index)) {
                return;
            }
            T item = this.get(index);
            if (append) {
                if (!this.myMultiMode) {
                    this.setMultiMode(true);
                }
                this.myPathItems.add(first ? 0 : this.myPathItems.size(), item);
            } else {
                this.myPathItems.clear();
                this.myPathItems.add(item);
            }
            this.updateAllItems();
        }

        public void removeFromPath(int index) {
            if (!this.isValid(index) || !this.isInPath(index)) {
                return;
            }
            this.myPathItems.remove(this.get(index));
            this.updateAllItems();
        }

        public void moveInPath(int from, int to) {
            assert (this.myMultiMode);
            assert (from < this.myPathItems.size());
            assert (to <= this.myPathItems.size());
            if (from == to || from + 1 == to) {
                return;
            }
            if (from > to) {
                this.myPathItems.add(to, this.myPathItems.remove(from));
            } else {
                this.myPathItems.add(to - 1, this.myPathItems.remove(from));
            }
            this.updateAllItems();
        }

        public boolean isInPath(int index) {
            return this.myMultiMode ? index < this.myPathItems.size() : !this.myPathItems.isEmpty() && this.get(index) == this.myPathItems.get(0);
        }

        public boolean isInPath(T item) {
            return this.myPathItems.contains(item);
        }

        public boolean isMultiMode() {
            return this.myMultiMode;
        }

        public boolean isSeparator(int index) {
            return this.myMultiMode && index == this.myPathItems.size();
        }

        public boolean isBoundsSeparator(int index) {
            return this.myMultiMode && this.myFirstNonCurrentBound != null && this.get(index) == this.myFirstNonCurrentBound;
        }

        @NotNull
        public List<T> getItems() {
            List<T> list = this.getAllItems();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseSchemaAction$SchemaContainer", "getItems"));
            }
            return list;
        }

        @NotNull
        public List<T> getPathItems() {
            List<T> list = this.myPathItems.isEmpty() && this.myCurrentBound != null ? Collections.singletonList(this.myCurrentBound) : this.myPathItems;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseSchemaAction$SchemaContainer", "getPathItems"));
            }
            return list;
        }
    }

    private static class SchemasPopup
    extends ListPopupImpl {
        public static final int MAX_ROW_COUNT = 15;
        private final JdbcConsole myConsole;
        private final boolean mySupportsMulti;
        private final UserDataHolder myHolder;
        private final SchemaContainer<ObjectPath> myContainer;

        public SchemasPopup(final @NotNull JdbcConsole console, @NotNull SchemaContainer<ObjectPath> container, boolean supportsMulti, UserDataHolder dataHolder) {
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/run/actions/ChooseSchemaAction$SchemasPopup", "<init>"));
            }
            if (container == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/database/run/actions/ChooseSchemaAction$SchemasPopup", "<init>"));
            }
            super((ListPopupStep)new MyStep(container), 15);
            this.myConsole = console;
            this.mySupportsMulti = supportsMulti;
            this.myHolder = dataHolder;
            this.myContainer = container;
            MyStep step = (MyStep)((Object)ObjectUtils.tryCast((Object)this.getStep(), MyStep.class));
            assert (step != null);
            this.registerAction("Select schema", 10, 0, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!myContainer.isMultiMode()) {
                        this.selectItem(this.getSelectedIdx());
                    } else {
                        this.closeOk(null);
                    }
                }
            });
            this.registerAction("Toggle schema", 32, 0, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.toggleItem(this.getSelectedIdx());
                }
            });
            new AnAction("Move up"){

                public void actionPerformed(AnActionEvent e) {
                    this.moveItem(this.getSelectedIdx(), true);
                }

                public void update(AnActionEvent e) {
                    e.getPresentation().setEnabled(!myContainer.isBound(myContainer.get(this.getSelectedIdx())));
                }
            }.registerCustomShortcutSet(CommonShortcuts.MOVE_UP, this.getList());
            new AnAction("Move down"){

                public void actionPerformed(AnActionEvent e) {
                    this.moveItem(this.getSelectedIdx(), false);
                }

                public void update(AnActionEvent e) {
                    e.getPresentation().setEnabled(!myContainer.isBound(myContainer.get(this.getSelectedIdx())));
                }
            }.registerCustomShortcutSet(CommonShortcuts.MOVE_DOWN, this.getList());
            this.getList().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    boolean ctrl;
                    int listIdx = this.getList().locationToIndex(e.getPoint());
                    if (listIdx == -1) {
                        return;
                    }
                    int idx = this.toContainerIdx(listIdx);
                    ObjectPath item = (ObjectPath)myContainer.get(idx);
                    boolean bl = ctrl = (e.getModifiers() & 2) != 0 || this.isInControlZone(listIdx, e.getPoint());
                    if (!mySupportsMulti || !ctrl && (!myContainer.isMultiMode() || myContainer.isBound(item))) {
                        this.selectItem(idx);
                    } else if (!myContainer.isInPath(idx) || ctrl) {
                        this.toggleItem(idx);
                    }
                }
            });
            this.getList().addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    this.getList().repaint();
                }
            });
            if (this.mySupportsMulti) {
                RowsDnDSupport.install(this.getList(), (EditableModel)new EditableModel(){

                    public void addRow() {
                        throw new UnsupportedOperationException();
                    }

                    public void exchangeRows(int oldIndex, int newIndex) {
                        ObjectPath item = (ObjectPath)myContainer.get(oldIndex);
                        if (myContainer.isInPath(oldIndex)) {
                            if (myContainer.isInPath(newIndex)) {
                                myContainer.moveInPath(oldIndex, newIndex);
                            } else {
                                myContainer.removeFromPath(oldIndex);
                            }
                        } else if (myContainer.isInPath(newIndex)) {
                            myContainer.setInPath(oldIndex, true, false);
                        }
                        this.update(item);
                    }

                    public boolean canExchangeRows(int oldIndex, int newIndex) {
                        return !myContainer.isBound(myContainer.get(oldIndex)) && (myContainer.isInPath(oldIndex) || myContainer.isInPath(newIndex));
                    }

                    public void removeRow(int idx) {
                        throw new UnsupportedOperationException();
                    }
                });
            }
            this.addListener((JBPopupListener)new JBPopupListener.Adapter(){

                public void onClosed(LightweightWindowEvent event) {
                    if (!event.isOk()) {
                        return;
                    }
                    SearchPath p = SearchPath.of(myContainer.getPathItems());
                    if (p == null || p.equals(console.getSearchPath())) {
                        return;
                    }
                    console.switchSchema(p, true);
                }
            });
            this.updateAdvertisement();
            if (!supportsMulti) {
                int w = GuiUtils.getSizeByChars((int)"Schema".length(), this.getList()).width * 2;
                Dimension size = this.getContent().getPreferredSize();
                this.setSize(new Dimension(Math.max(size.width, w), size.height));
            } else {
                Dimension size = this.getContent().getPreferredSize();
                Dimension vSize = this.getList().getPreferredScrollableViewportSize();
                Dimension cellSize = this.getListElementRenderer().getListCellRendererComponent(this.getList(), new ObjectPath(ObjectKind.NONE, Collections.singletonList("A")), Integer.MAX_VALUE, false, false).getPreferredSize();
                double rows = Math.min(15, Math.max(3, this.myContainer.getWorkingItemsCount())) + 1;
                int h = size.height - vSize.height + (int)((double)cellSize.height * rows);
                this.setSize(new Dimension(size.width, h));
            }
            this.getList().getSelectionModel().addListSelectionListener(e -> this.updateAdvertisement());
            ACTIVE_POPUP.set(this.myHolder, (Object)this);
        }

        public void selectItem(int idx) {
            ObjectPath item = this.myContainer.get(idx);
            ObjectPath cur = this.myConsole.getCurrentNamespace();
            if (this.myContainer.isBound(item)) {
                this.myContainer.setCurrentBound(item);
                if (cur != null && item.getName().equals(JdbcUrlParserUtil.getObjectItem(cur, item.kind))) {
                    this.myConsole.getMessageBus().getDataProducer().processRequest(DataRequest.newRequest(this.myConsole, this.myConsole.getCurrentTx(), "set search_path to default"));
                    this.cancel();
                    return;
                }
            } else {
                this.myContainer.setInPath(idx, false, false);
            }
            this.update(item);
            this.closeOk(null);
        }

        public JList<ObjectPath> getList() {
            return super.getList();
        }

        private int getSelectedIdx() {
            return this.toContainerIdx(this.getSelectedIndex());
        }

        private int toContainerIdx(int idx) {
            return this.myContainer.indexOf((ObjectPath)ObjectUtils.tryCast((Object)this.getListModel().get(idx), ObjectPath.class));
        }

        private int toListIdx(int idx) {
            if (idx < 0 || idx >= this.myContainer.getItems().size()) {
                return -1;
            }
            ObjectPath item = this.myContainer.getItems().get(idx);
            int sz = this.getListModel().getSize();
            for (int i2 = 0; i2 < sz; ++i2) {
                if (this.getListModel().get(i2) != item) continue;
                return i2;
            }
            return -1;
        }

        private boolean isInControlZone(int index, Point pt) {
            Rectangle bounds = this.getList().getCellBounds(index, index);
            return bounds.contains(pt) && (double)pt.x > (double)(bounds.x + bounds.width) - (double)bounds.height * 1.2;
        }

        private void toggleItem(int idx) {
            if (!this.mySupportsMulti) {
                return;
            }
            ObjectPath item = this.myContainer.get(idx);
            if (this.myContainer.isBound(item)) {
                this.myContainer.setCurrentBound(item);
            } else {
                int newIdx;
                boolean inPath = this.myContainer.isInPath(idx);
                if (inPath && this.myContainer.currentSize() < 2) {
                    return;
                }
                if (inPath) {
                    this.myContainer.removeFromPath(idx);
                    newIdx = this.myContainer.isInPath(idx) ? idx : Math.max(idx - 1, 0);
                } else {
                    this.myContainer.setInPath(idx, true, false);
                    newIdx = Math.min(idx + 1, this.myContainer.getItems().size() - 1);
                }
                item = this.myContainer.get(newIdx);
            }
            this.update(item);
        }

        private void moveItem(int idx, boolean up) {
            if (!this.myContainer.isMultiMode()) {
                return;
            }
            ObjectPath item = this.myContainer.get(idx);
            if (this.myContainer.isInPath(idx)) {
                if (!up && idx + 1 == this.myContainer.currentSize() || up && idx == 0) {
                    if (this.myContainer.currentSize() < 2) {
                        return;
                    }
                    this.myContainer.removeFromPath(idx);
                } else {
                    this.myContainer.moveInPath(idx, idx + (up ? -1 : 2));
                }
            } else {
                this.myContainer.setInPath(idx, true, !up);
            }
            this.update(item);
        }

        private void updateAdvertisement() {
            if (this.mySupportsMulti) {
                if (!this.myContainer.isMultiMode()) {
                    this.setAdText("<html>Add schemas to search path<br>with Ctrl+Click or Space</html>");
                } else if (this.myContainer.isInPath(this.getSelectedIdx())) {
                    this.setAdText("<html>To reorder, drag or press<br>" + KeymapUtil.getShortcutsText((Shortcut[])CommonShortcuts.MOVE_UP.getShortcuts()) + " or " + KeymapUtil.getShortcutsText((Shortcut[])CommonShortcuts.MOVE_DOWN.getShortcuts()) + "</html>");
                } else {
                    this.setAdText("<html>To add, click or press Space.<br>Apply with Enter</html>");
                }
            }
        }

        public void dispose() {
            super.dispose();
            if (ACTIVE_POPUP.get(this.myHolder) == this) {
                ACTIVE_POPUP.set(this.myHolder, null);
            }
        }

        public void cancel(InputEvent e) {
            if (e instanceof MouseEvent) {
                this.setOk(true);
            }
            super.cancel(e);
        }

        protected boolean isActionClick(MouseEvent e) {
            return false;
        }

        private void update(ObjectPath item) {
            this.getListModel().updateOriginalList();
            if (item != null) {
                this.getList().setSelectedValue(item, true);
            }
            this.getList().validate();
            this.getList().repaint();
        }

        protected ListCellRenderer<ObjectPath> getListElementRenderer() {
            return new PopupListElementRenderer<ObjectPath>((ListPopupImpl)this){
                {
                    super(x0);
                    Font font = this.mySeparatorComponent.getFont();
                    this.mySeparatorComponent.setFont(font.deriveFont(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.MINI)));
                }

                protected void customizeComponent(JList<? extends ObjectPath> list, ObjectPath value, boolean isSelected) {
                    super.customizeComponent(list, (Object)value, isSelected);
                    this.myNextStepLabel.setVisible(true);
                    Icon icon = null;
                    if (isSelected && mySupportsMulti) {
                        int pos = myContainer.indexOf(value);
                        Point pt = MouseInfo.getPointerInfo().getLocation();
                        SwingUtilities.convertPointFromScreen(pt, this.getList());
                        boolean ctrl = this.isInControlZone(this.toListIdx(pos), pt);
                        if (myContainer.isCurrentBound(value)) {
                            icon = null;
                        } else if (myContainer.isBound(value)) {
                            icon = ctrl ? AllIcons.General.ComboArrowLeft : AllIcons.General.ComboArrowLeftPassive;
                        } else {
                            Icon del;
                            Icon add;
                            Icon icon2 = add = ctrl ? DatabaseIcons.Add_hover : DatabaseIcons.Add;
                            if (myContainer.isMultiMode()) {
                                add = null;
                            }
                            Icon icon3 = del = ctrl ? AllIcons.Welcome.Project.Remove_hover : AllIcons.Welcome.Project.Remove;
                            if (!myContainer.isMultiMode() || myContainer.currentSize() < 2) {
                                del = null;
                            }
                            icon = myContainer.isInPath(pos) ? del : add;
                        }
                    }
                    this.myNextStepLabel.setIcon(icon);
                }
            };
        }

        private static class MyStep
        extends BaseStep<ObjectPath>
        implements ListPopupStep<ObjectPath> {
            private final ListSeparator mySelectBoundSeparator = new ListSeparator("Select Database");
            private final ListSeparator myAvailSeparator = new ListSeparator("Add to Search Path");
            private final ListSeparator myCurSeparator = new ListSeparator("Search Path");
            private final SchemaContainer<ObjectPath> myContainer;

            private MyStep(SchemaContainer<ObjectPath> container) {
                this.myContainer = container;
            }

            @NotNull
            public String getTextFor(ObjectPath value) {
                if (value == null) {
                    if ("" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseSchemaAction$SchemasPopup$MyStep", "getTextFor"));
                    }
                    return "";
                }
                if (!this.myContainer.hasBounds() || this.myContainer.isInPath(value)) {
                    String string = value.getDisplayName();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseSchemaAction$SchemasPopup$MyStep", "getTextFor"));
                    }
                    return string;
                }
                String string = this.myContainer.isBound(value) ? value.getName() : "  " + value.getName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseSchemaAction$SchemasPopup$MyStep", "getTextFor"));
                }
                return string;
            }

            @Nullable
            public ListSeparator getSeparatorAbove(ObjectPath value) {
                int index = this.myContainer.getItems().indexOf(value);
                return this.myContainer.isBoundsSeparator(index) ? this.mySelectBoundSeparator : (this.myContainer.isSeparator(index) ? this.myAvailSeparator : (index == 0 && this.myContainer.isMultiMode() ? this.myCurSeparator : null));
            }

            public int getDefaultOptionIndex() {
                return 0;
            }

            @NotNull
            public List<ObjectPath> getValues() {
                List<ObjectPath> list = this.myContainer.getItems();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ChooseSchemaAction$SchemasPopup$MyStep", "getValues"));
                }
                return list;
            }

            public boolean isSelectable(ObjectPath value) {
                return value != null;
            }

            @Nullable
            public Icon getIconFor(ObjectPath aValue) {
                return null;
            }

            @Nullable
            public String getTitle() {
                return null;
            }

            @Nullable
            public PopupStep onChosen(ObjectPath selectedValue, boolean finalChoice) {
                return null;
            }

            public boolean hasSubstep(ObjectPath selectedValue) {
                return false;
            }

            public void canceled() {
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            public boolean canBeHidden(ObjectPath value) {
                return !this.myContainer.isMultiMode() || !this.myContainer.isInPath(this.myContainer.getItems().indexOf(value));
            }
        }
    }
}

