/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.run.actions.GridAction;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.actions.DeleteAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import icons.DatabaseIcons;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeleteActionBase
extends DeleteAction
implements DeleteProvider,
GridAction {
    protected DeleteActionBase() {
        super(null, null, DatabaseIcons.RemoveRow);
    }

    public void update(AnActionEvent event) {
        super.update(event);
        DataGrid grid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(event.getDataContext());
        if (grid == null) {
            event.getPresentation().setText(this.getTemplatePresentation().getText());
        } else {
            String itemName = this.itemName();
            int itemsCount = this.itemsCount(grid);
            String text = "Delete " + StringUtil.capitalizeWords((String)(itemsCount == 1 ? itemName : StringUtil.pluralize((String)itemName)), (boolean)true);
            event.getPresentation().setText(text);
        }
        event.getPresentation().setEnabled(grid != null && this.isEnabled(grid));
        event.getPresentation().setVisible(this.isVisible(grid));
    }

    @NotNull
    protected DeleteProvider getDeleteProvider(DataContext dataContext) {
        DeleteActionBase deleteActionBase = this;
        if (deleteActionBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/DeleteActionBase", "getDeleteProvider"));
        }
        return deleteActionBase;
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/run/actions/DeleteActionBase", "canDeleteElement"));
        }
        DataGrid grid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(dataContext);
        return this.isVisible(grid) && this.itemsCount(grid) > 0;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/run/actions/DeleteActionBase", "deleteElement"));
        }
        DataGrid grid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(dataContext);
        if (grid == null) {
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && grid.getDataSupport().isSubmitImmediately()) {
            int itemsCount = this.itemsCount(grid);
            String itemName = itemsCount == 1 ? this.itemName() : StringUtil.pluralize((String)this.itemName());
            String title = DatabaseMessages.message((String)"table.result.confirm.delete.title", (Object[])new Object[]{StringUtil.capitalizeWords((String)itemName, (boolean)true)});
            String message = DatabaseMessages.message((String)"table.result.confirm.delete.message", (Object[])new Object[]{itemsCount, itemName});
            if (Messages.showOkCancelDialog((Component)grid.getComponent(), (String)message, (String)title, (Icon)Messages.getQuestionIcon()) != 0) {
                return;
            }
        }
        this.doDelete(grid);
    }

    protected abstract boolean isEnabled(@NotNull DataGrid var1);

    protected abstract void doDelete(@NotNull DataGrid var1);

    protected abstract int itemsCount(@NotNull DataGrid var1);

    protected abstract String itemName();

    protected boolean isVisible(@Nullable DataGrid grid) {
        return grid != null && grid.isEditable() && grid.isReady();
    }
}

