/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.csv.ui.preview.TextCsvFormatPreview;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.settings.CsvFormatsComponent;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.settings.DatabaseSettingsConfigurable;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.PlatformIcons;
import org.jetbrains.annotations.NotNull;

public class ShowPropertiesAction
extends DumbAwareAction {
    public ShowPropertiesAction() {
        super(null, null, PlatformIcons.SHOW_SETTINGS_ICON);
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(ShowPropertiesAction.getEventProject((AnActionEvent)e) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        ShowSettingsUtilImpl.showSettingsDialog((Project)ShowPropertiesAction.getEventProject((AnActionEvent)e), (String)DatabaseSettingsConfigurable.CONFIGURABLE_ID, (String)"");
    }

    public static class CsvFormats
    extends ShowPropertiesAction {
        @Override
        public void update(AnActionEvent e) {
            e.getPresentation().setIcon(PlatformIcons.PROPERTIES_ICON);
            e.getPresentation().setEnabledAndVisible(true);
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            Pair<CsvFormatsComponent, Disposable> pair = CsvFormats.getFormatsEditorAndDisposable(e);
            CsvFormatsComponent component = (CsvFormatsComponent)pair.first;
            Disposable disposable = (Disposable)pair.second;
            DialogBuilder builder = new DialogBuilder(CsvFormats.getEventProject((AnActionEvent)e)).title("CSV Formats").dimensionKey(((Object)((Object)this)).getClass().getName()).centerPanel(component.getComponent());
            builder.setHelpId("Data_Extractors_dialog");
            builder.addDisposable(disposable);
            DatabaseSettings settings = DatabaseSettings.getSettings();
            component.reset(settings);
            if (builder.show() == 0) {
                component.apply(settings);
                DatabaseSettings.fireSettingsChanged();
            }
        }

        @NotNull
        private static Pair<CsvFormatsComponent, Disposable> getFormatsEditorAndDisposable(AnActionEvent e) {
            DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
            if (grid == null || grid.isEmpty()) {
                CsvFormatsComponent c = new CsvFormatsComponent();
                Pair pair = Pair.create((Object)c, (Object)c);
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ShowPropertiesAction$CsvFormats", "getFormatsEditorAndDisposable"));
                }
                return pair;
            }
            Disposable disposable = Disposer.newDisposable();
            CsvFormatsComponent c = new CsvFormatsComponent(new TextCsvFormatPreview(grid, disposable));
            Disposer.register((Disposable)disposable, (Disposable)c);
            Pair pair = Pair.create((Object)c, (Object)disposable);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ShowPropertiesAction$CsvFormats", "getFormatsEditorAndDisposable"));
            }
            return pair;
        }
    }
}

