/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridFilterPanel
extends EditorHeaderComponent {
    private final Project myProject;
    private final DataGrid myGrid;
    private final MyFilterEditorTextField myFilterField;
    private final JLabel myFilterHistoryLabel;
    private JBPopup myFilterHistoryPopup;

    public GridFilterPanel(@NotNull Project project, @NotNull DataGrid grid) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ui/grid/GridFilterPanel", "<init>"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/GridFilterPanel", "<init>"));
        }
        this.myProject = project;
        this.myGrid = grid;
        final GridFilteringModel filteringModel = this.myGrid.getDataHookup().getFilteringModel();
        Document document = filteringModel != null ? filteringModel.getFilterDocument() : EditorFactory.getInstance().createDocument((CharSequence)"");
        this.myFilterField = new MyFilterEditorTextField(document);
        if (filteringModel != null) {
            filteringModel.addListener(new GridFilteringModel.Listener(){

                @Override
                public void filterDocumentChanged(@NotNull GridFilteringModel filteringModel) {
                    if (filteringModel == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filteringModel", "com/intellij/database/run/ui/grid/GridFilterPanel$1", "filterDocumentChanged"));
                    }
                    GridFilterPanel.this.myFilterField.setDocument(filteringModel.getFilterDocument());
                }
            }, grid);
        }
        this.myFilterHistoryLabel = new JBLabel(AllIcons.Actions.Search);
        this.myFilterHistoryLabel.setOpaque(false);
        this.myFilterHistoryLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridFilterPanel$2", "mousePressed"));
                }
                GridFilterPanel.this.showFilterHistoryPopup();
            }
        });
        JBLabel clearFieldLabel = new JBLabel(UIUtil.isUnderDarcula() ? AllIcons.Actions.Clean : AllIcons.Actions.CleanLight);
        clearFieldLabel.setOpaque(false);
        clearFieldLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridFilterPanel$3", "mouseReleased"));
                }
                boolean wasApplied = filteringModel != null && filteringModel.isFilterApplied();
                GridFilterPanel.this.setFilterText("", -1);
                if (wasApplied) {
                    GridFilterPanel.this.myGrid.applyFilter();
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.setBorder(new CompoundBorder((Border)new CustomLineBorder(JBColor.border(), 1, 0, 0, 0), IdeBorderFactory.createEmptyBorder((int)2, (int)2, (int)2, (int)2)));
        this.add((Component)clearFieldLabel, "East");
        this.add(this.myFilterHistoryLabel, "West");
        this.add((Component)((Object)this.myFilterField), "Center");
    }

    protected Graphics getComponentGraphics(Graphics g) {
        return IdeBackgroundUtil.withEditorBackground((Graphics)g, (JComponent)((Object)this));
    }

    public Color getBackground() {
        EditorEx editor = this.myFilterField == null ? null : (EditorEx)this.myFilterField.getEditor();
        return editor == null ? super.getBackground() : editor.getBackgroundColor();
    }

    public void setFilterText(String filter, int caretPosition) {
        GridFilteringModel model = this.myGrid.getDataHookup().getFilteringModel();
        if (model == null) {
            return;
        }
        model.setFilterText(filter);
        if (caretPosition < 0) {
            return;
        }
        this.myFilterField.requestFocusInWindow();
        this.myFilterField.getCaretModel().moveToOffset(caretPosition);
    }

    public void onError(@NotNull Throwable error) {
        Editor editor;
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/database/run/ui/grid/GridFilterPanel", "onError"));
        }
        GridFilteringModel model = this.myGrid.getDataHookup().getFilteringModel();
        if (model != null) {
            model.onError();
        }
        if ((editor = this.myFilterField.getEditor()) == null) {
            return;
        }
        JComponent component = editor.getContentComponent();
        DataSourceUiUtil.showErrorBalloon(error, component, this.getFilterEditorCaretPoint(), true, false);
    }

    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this.myFilterField), true));
    }

    public boolean requestFocusInWindow() {
        return this.myFilterField.requestFocusInWindow();
    }

    private void showFilterHistoryPopup() {
        GridFilteringModel model;
        if (this.myFilterHistoryPopup != null) {
            this.myFilterHistoryPopup.cancel();
            this.myFilterHistoryPopup = null;
        }
        if ((model = this.myGrid.getDataHookup().getFilteringModel()) == null) {
            return;
        }
        JBList history = new JBList(model.getHistory());
        Runnable itemChosenCallback = () -> this.lambda$showFilterHistoryPopup$1((JList)history);
        this.myFilterHistoryPopup = JBPopupFactory.getInstance().createListPopupBuilder((JList)history).setMovable(false).setRequestFocus(true).setItemChoosenCallback(itemChosenCallback).createPopup();
        this.myFilterHistoryPopup.addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                GridFilterPanel.this.myFilterHistoryPopup = null;
            }
        });
        if (this.myGrid.getComponent().isShowing()) {
            this.myFilterHistoryPopup.showUnderneathOf((Component)this.myFilterHistoryLabel);
        }
    }

    @Nullable
    private Point getFilterEditorCaretPoint() {
        Editor editor = this.myFilterField.getEditor();
        if (editor == null) {
            return null;
        }
        VisualPosition caretPosition = editor.getCaretModel().getVisualPosition();
        Point point = editor.visualPositionToXY(caretPosition);
        point.translate(0, editor.getContentComponent().getHeight());
        return point;
    }

    private /* synthetic */ void lambda$showFilterHistoryPopup$1(JList history) {
        String selectedFilter = (String)history.getSelectedValue();
        if (selectedFilter != null) {
            this.myFilterField.setText(selectedFilter);
            this.myGrid.applyFilter();
        }
    }

    private class MyFilterEditorTextField
    extends EditorTextField
    implements EditorSettingsProvider,
    Disposable {
        private EditorEx myLastEditor;

        public MyFilterEditorTextField(Document document) {
            super(document, GridFilterPanel.this.myProject, (FileType)DbSqlUtil.getSqlDialect(DataGridUtil.getDatabaseDialect(GridFilterPanel.this.myGrid)).getAssociatedFileType(), false, true);
            this.setSupplementary(true);
            this.setOneLineMode(true);
            this.setFocusable(false);
            this.setPlaceholder("<Filter criteria>");
            this.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)0, (int)1, (int)0));
            this.addSettingsProvider(this);
            Disposer.register((Disposable)GridFilterPanel.this.myGrid, (Disposable)this);
        }

        protected void updateBorder(@NotNull EditorEx editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/run/ui/grid/GridFilterPanel$MyFilterEditorTextField", "updateBorder"));
            }
            editor.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)7, (int)0, (int)7));
        }

        protected boolean shouldHaveBorder() {
            return false;
        }

        public void customizeSettings(EditorEx editor) {
            SqlLanguageDialect dialect = DbSqlUtil.getSqlDialect(DataGridUtil.getDatabaseDialect(GridFilterPanel.this.myGrid));
            SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)dialect, (Project)this.getProject(), null);
            editor.setHighlighter((EditorHighlighter)new LexerEditorHighlighter(highlighter, editor.getColorsScheme()));
            editor.setEmbeddedIntoDialogWrapper(true);
            editor.getContentComponent().setOpaque(false);
            JComponent editorComp = editor.getComponent();
            new ApplyAction().registerCustomShortcutSet(CommonShortcuts.ENTER, editorComp);
            new CancelAction().registerCustomShortcutSet(CommonShortcuts.ESCAPE, editorComp);
            new ShowHistoryAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(40, 0)), editorComp);
            this.myLastEditor = editor;
        }

        public Object getData(String dataId) {
            Editor editor;
            if (PlatformDataKeys.FILE_EDITOR.is(dataId) && (editor = this.getEditor()) != null) {
                return TextEditorProvider.getInstance().getTextEditor(editor);
            }
            return super.getData(dataId);
        }

        public void dispose() {
            if (this.myLastEditor != null && !this.myLastEditor.isDisposed()) {
                EditorFactory.getInstance().releaseEditor((Editor)this.myLastEditor);
            }
        }

        private class ShowHistoryAction
        extends FilterFieldAction {
            public ShowHistoryAction() {
                super("Show filter history");
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridFilterPanel$MyFilterEditorTextField$ShowHistoryAction", "actionPerformed"));
                }
                GridFilterPanel.this.showFilterHistoryPopup();
            }
        }

        private class CancelAction
        extends FilterFieldAction {
            public CancelAction() {
                super("Cancel");
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridFilterPanel$MyFilterEditorTextField$CancelAction", "actionPerformed"));
                }
                IdeFocusManager.findInstanceByComponent((Component)GridFilterPanel.this.myGrid.getComponent()).requestFocus((Component)GridFilterPanel.this.myGrid.getPreferredFocusedComponent(), true);
            }
        }

        private class ApplyAction
        extends FilterFieldAction {
            public ApplyAction() {
                super("Apply");
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridFilterPanel$MyFilterEditorTextField$ApplyAction", "actionPerformed"));
                }
                if (this.isValidFilterEntered()) {
                    GridFilterPanel.this.myGrid.applyFilter();
                } else {
                    this.showInvalidFilterCriteriaBalloon();
                }
            }

            private boolean isValidFilterEntered() {
                if (StringUtil.isEmptyOrSpaces((String)GridFilterPanel.this.myFilterField.getText())) {
                    return true;
                }
                PsiFile psi = PsiDocumentManager.getInstance((Project)MyFilterEditorTextField.this.getProject()).getPsiFile(GridFilterPanel.this.myFilterField.getDocument());
                return psi == null || !PsiTreeUtil.hasErrorElements((PsiElement)psi);
            }

            private void showInvalidFilterCriteriaBalloon() {
                Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder("Invalid filter criteria.", MessageType.WARNING, null).setShowCallout(true).setHideOnAction(true).setHideOnClickOutside(true).createBalloon();
                Point point = GridFilterPanel.this.getFilterEditorCaretPoint();
                balloon.show(new RelativePoint((Component)GridFilterPanel.this.myFilterField.getComponent(), point), Balloon.Position.below);
            }
        }

        private abstract class FilterFieldAction
        extends DumbAwareAction {
            public FilterFieldAction(String text) {
                super(text);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridFilterPanel$MyFilterEditorTextField$FilterFieldAction", "update"));
                }
                e.getPresentation().setEnabled(LookupManager.getActiveLookup((Editor)GridFilterPanel.this.myFilterField.getEditor()) == null);
            }
        }
    }
}

