/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBAutoscroller;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBViewport;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridScrollPane
extends JBScrollPane {
    private final JTable myTable;

    public GridScrollPane(@NotNull JTable table, JComponent headerComponent, JComponent gutterComponent, JComponent topLeftCornerComponent, @Nullable JBAutoscroller.AutoscrollLocker locker) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/GridScrollPane", "<init>"));
        }
        this.myTable = table;
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setViewportView(table);
        this.setColumnHeaderView(headerComponent);
        this.setRowHeaderView(gutterComponent);
        this.setupColumnScroller(locker);
        this.setCorner("UPPER_LEADING_CORNER", topLeftCornerComponent);
        this.getViewport().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridScrollPane$1", "mousePressed"));
                }
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)GridScrollPane.this.myTable, true));
            }
        });
    }

    public void setFlipControls(boolean flip) {
        this.putClientProperty(JBScrollPane.Flip.class, flip ? JBScrollPane.Flip.HORIZONTAL : null);
    }

    public void setComponentOrientation(ComponentOrientation co) {
        super.setComponentOrientation(co);
        this.flipCorners("UPPER_LEFT_CORNER", "UPPER_RIGHT_CORNER");
        this.flipCorners("LOWER_LEFT_CORNER", "LOWER_RIGHT_CORNER");
    }

    protected JViewport createViewport() {
        return new JBViewport(){

            public Color getBackground() {
                return GridScrollPane.this.myTable != null ? GridScrollPane.this.myTable.getBackground() : super.getBackground();
            }
        };
    }

    private void flipCorners(String corner1, String corner2) {
        Component c1 = this.getCorner(corner1);
        Component c2 = this.getCorner(corner2);
        this.setCorner(corner1, c2);
        this.setCorner(corner2, c1);
    }

    private void setupColumnScroller(@Nullable JBAutoscroller.AutoscrollLocker locker) {
        JBAutoscroller.installOn((JComponent)this.myTable, (JBAutoscroller.AutoscrollLocker)locker);
        JBAutoscroller.installOn((JComponent)((JComponent)this.getRowHeader().getView()), (JBAutoscroller.ScrollDeltaProvider)new JBAutoscroller.DefaultScrollDeltaProvider(){

            public int getHorizontalScrollDelta(MouseEvent e) {
                return 0;
            }
        });
        JBAutoscroller.installOn((JComponent)this.myTable.getTableHeader(), (JBAutoscroller.ScrollDeltaProvider)new JBAutoscroller.DefaultScrollDeltaProvider(){

            public int getVerticalScrollDelta(MouseEvent e) {
                return 0;
            }

            public int getHorizontalScrollDelta(MouseEvent e) {
                JTableHeader header = GridScrollPane.this.myTable.getTableHeader();
                TableColumn draggedColumn = header.getDraggedColumn();
                if (draggedColumn != null) {
                    Rectangle visibleRect = header.getVisibleRect();
                    int leftmost = visibleRect.x;
                    int rightmost = visibleRect.x + visibleRect.width - 1;
                    Rectangle draggedRect = this.computeColumnHeaderRectangle(draggedColumn);
                    int left = draggedRect.x + header.getDraggedDistance();
                    int right = left + draggedRect.width - 1;
                    return right > rightmost ? right - rightmost : (left < leftmost ? left - leftmost : 0);
                }
                return super.getHorizontalScrollDelta(e);
            }

            private Rectangle computeColumnHeaderRectangle(TableColumn targetColumn) {
                TableColumn column;
                JTableHeader header = GridScrollPane.this.myTable.getTableHeader();
                TableColumnModel columnModel = GridScrollPane.this.myTable.getColumnModel();
                int targetColumnX = 0;
                for (int i2 = 0; i2 < GridScrollPane.this.myTable.getColumnCount() && (column = columnModel.getColumn(i2)) != targetColumn; ++i2) {
                    targetColumnX += column.getWidth();
                }
                return new Rectangle(targetColumnX, 0, targetColumn.getWidth(), header.getHeight());
            }
        });
    }

    public boolean isFlipped() {
        Object property = this.getClientProperty(JBScrollPane.Flip.class);
        return property == JBScrollPane.Flip.HORIZONTAL || property == JBScrollPane.Flip.BOTH;
    }
}

