/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.run.ui.grid.editors.Formatter;
import java.text.ParseException;
import java.text.ParsePosition;
import org.jetbrains.annotations.NotNull;

public class CompositeFormatter
implements Formatter {
    private final Formatter[] myFormatters;
    private final Formatter myBaseFormatter;

    public CompositeFormatter(@NotNull Formatter baseFormatter, Formatter ... formatters) {
        if (baseFormatter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFormatter", "com/intellij/database/run/ui/grid/editors/CompositeFormatter", "<init>"));
        }
        if (formatters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatters", "com/intellij/database/run/ui/grid/editors/CompositeFormatter", "<init>"));
        }
        if (formatters.length == 0) {
            throw new IllegalArgumentException("Formatters must contains at least one formatter");
        }
        this.myBaseFormatter = baseFormatter;
        this.myFormatters = formatters;
    }

    @Override
    public Object parse(@NotNull String value, @NotNull ParsePosition position) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/CompositeFormatter", "parse"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/database/run/ui/grid/editors/CompositeFormatter", "parse"));
        }
        ParsePosition internal = new ParsePosition(0);
        for (Formatter formatter : this.myFormatters) {
            internal.setIndex(0);
            internal.setErrorIndex(-1);
            Object result2 = formatter.parse(value, internal);
            if (internal.getErrorIndex() != -1) continue;
            position.setIndex(internal.getIndex());
            return result2;
        }
        position.setErrorIndex(internal.getErrorIndex());
        return null;
    }

    @Override
    public Object parse(@NotNull String value) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/CompositeFormatter", "parse"));
        }
        int errorOffset = 0;
        for (Formatter formatter : this.myFormatters) {
            try {
                return formatter.parse(value);
            }
            catch (ParseException e) {
                errorOffset = e.getErrorOffset();
            }
        }
        throw new ParseException(value, errorOffset);
    }

    @Override
    public String format(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/CompositeFormatter", "format"));
        }
        return this.myBaseFormatter.format(value);
    }

    public String toString() {
        return this.myBaseFormatter.toString();
    }
}

