/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditor;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.textCompletion.TextCompletionProvider;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FormatBasedGridCellEditorFactory
implements GridCellEditorFactory {
    @Override
    @NotNull
    public GridCellEditor createEditor(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column, @Nullable Object object, EventObject initiator) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory", "createEditor"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory", "createEditor"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory", "createEditor"));
        }
        Project project = DataGridUtil.getProject(grid);
        Formatter format = this.getFormat(grid, row, column);
        TextCompletionProvider provider = GridCellEditorsUtil.createCompletionProvider(grid, column);
        ReservedCellValue nullValue = DataGridUtil.getDefaultNullValue(grid, column);
        FormatBasedGridCellEditor formatBasedGridCellEditor = this.createEditorImpl(project, grid, format, object, nullValue, initiator, provider, column);
        if (formatBasedGridCellEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory", "createEditor"));
        }
        return formatBasedGridCellEditor;
    }

    @NotNull
    protected abstract Formatter getFormat(@NotNull DataGrid var1, @NotNull ModelIndex<DataConsumer.Row> var2, @NotNull ModelIndex<DataConsumer.Column> var3);

    @NotNull
    protected FormatBasedGridCellEditor createEditorImpl(@NotNull Project project, @NotNull DataGrid grid, @NotNull Formatter format, @Nullable Object value, @Nullable ReservedCellValue nullValue, EventObject initiator, @Nullable TextCompletionProvider provider, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory", "createEditorImpl"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory", "createEditorImpl"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory", "createEditorImpl"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory", "createEditorImpl"));
        }
        FormatBasedGridCellEditor formatBasedGridCellEditor = new FormatBasedGridCellEditor(project, grid, format, value, nullValue, initiator, provider);
        if (formatBasedGridCellEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory", "createEditorImpl"));
        }
        return formatBasedGridCellEditor;
    }
}

