/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.basic.BasicScriptable;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.scripting.AbortException;
import com.intellij.database.scripting.AbstractScriptingService;
import com.intellij.database.scripting.AbstractScriptingService$CreatingGenerator$WhenMappings;
import com.intellij.database.scripting.AbstractScriptingService$WhenMappings;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.DefaultScriptingOptions;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.NamingService;
import com.intellij.database.scripting.ScriptContext;
import com.intellij.database.scripting.ScriptingConstraintContext;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingOptions;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.database.scripting.SimpleCompositeText;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\u00020\u0007:\u0004klmnB\u0017\b\u0015\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\u0006\u0010\t\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\nJ\u0012\u0010F\u001a\u00020G2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006H\u0016J\u0006\u0010H\u001a\u00020GJ&\u0010I\u001a\u00180JR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u0010K\u001a\u00020LH$J&\u0010M\u001a\u00180JR\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u0010K\u001a\u00020LH\u0014J\b\u0010:\u001a\u000209H\u0016J\u0013\u0010N\u001a\b\u0012\u0004\u0012\u00020\u001a0OH\u0016\u00a2\u0006\u0002\u0010PJ\b\u0010Q\u001a\u00020\u001aH\u0016J\u0016\u0010R\u001a\b\u0012\u0004\u0012\u00020T0S2\u0006\u0010U\u001a\u00020TH\u0014J\u0016\u0010V\u001a\b\u0012\u0004\u0012\u00020W0S2\u0006\u0010U\u001a\u00020\u0006H\u0014J\r\u0010X\u001a\u00020GH\u0010\u00a2\u0006\u0002\bYJ\u001a\u0010Z\u001a\u00020G2\u0006\u0010K\u001a\u00020L2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006H\u0016J&\u0010Z\u001a\u00020G2\u0006\u0010K\u001a\u00020L2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020]0\\2\u0006\u0010^\u001a\u00020_H\u0016J\u001e\u0010Z\u001a\u00020G2\u0006\u0010K\u001a\u00020L2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020\u00060aH\u0016J\u0010\u00107\u001a\u00020\u001a2\u0006\u0010b\u001a\u00020cH\u0014J\u001e\u0010d\u001a\u00020G2\u0006\u0010K\u001a\u00020L2\f\u0010e\u001a\b\u0012\u0004\u0012\u00020]0SH\u0004J\u001c\u0010f\u001a\b\u0012\u0004\u0012\u00020]0\\2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020]0SH\u0004J\u001c\u0010g\u001a\b\u0012\u0004\u0012\u00020]0\\2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020]0\\H\u0002J\b\u0010h\u001a\u00020\u001aH\u0016J\u0010\u0010i\u001a\u00020G2\u0006\u0010\t\u001a\u00020\u0004H\u0016J\f\u0010j\u001a\u00020\u001a*\u00020TH\u0014R(\u0010\f\u001a\u0004\u0018\u00018\u00022\b\u0010\u000b\u001a\u0004\u0018\u00018\u00028V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u0004\u0018\u00018\u0002X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R&\u0010\t\u001a\u00028\u00012\u0006\u0010\t\u001a\u00028\u0001@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0013\u0010\b\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010%\u001a\u0004\b#\u0010$R$\u0010(\u001a\u00020'2\u0006\u0010&\u001a\u00020'@DX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020.X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0011\u00103\u001a\u0002048F\u00a2\u0006\u0006\u001a\u0004\b5\u00106R \u00107\u001a\b\u0012\u0004\u0012\u00020908X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u0014\u0010>\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0018\u0010A\u001a\u00020\u001a*\u00020\u001a8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u0018\u0010D\u001a\u00020\u001a*\u00020\u001a8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010C\u00a8\u0006o"}, d2={"Lcom/intellij/database/scripting/AbstractScriptingService;", "M", "Lcom/intellij/database/model/basic/BasicModel;", "D", "Lcom/intellij/database/model/basic/BasicDatabase;", "S", "Lcom/intellij/database/model/basic/BasicSchema;", "Lcom/intellij/database/scripting/ScriptingService;", "model", "database", "(Lcom/intellij/database/model/basic/BasicModel;Lcom/intellij/database/model/basic/BasicDatabase;)V", "schema", "currentSchema", "getCurrentSchema", "()Lcom/intellij/database/model/basic/BasicSchema;", "setCurrentSchema", "(Lcom/intellij/database/model/basic/BasicSchema;)V", "currentSchema_", "Lcom/intellij/database/model/basic/BasicSchema;", "getDatabase", "()Lcom/intellij/database/model/basic/BasicDatabase;", "setDatabase", "(Lcom/intellij/database/model/basic/BasicDatabase;)V", "Lcom/intellij/database/model/basic/BasicDatabase;", "defaultPrimitiveSizes", "", "", "Lcom/intellij/database/scripting/AbstractScriptingService$SizeAndScale;", "getDefaultPrimitiveSizes", "()Ljava/util/Map;", "generated", "", "Lcom/intellij/database/model/basic/BasicElement;", "getGenerated", "()Ljava/util/Set;", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "Lcom/intellij/database/model/basic/BasicModel;", "<set-?>", "Lcom/intellij/database/scripting/NamingService;", "naming", "getNaming", "()Lcom/intellij/database/scripting/NamingService;", "setNaming", "(Lcom/intellij/database/scripting/NamingService;)V", "options", "Lcom/intellij/database/scripting/ScriptingOptions;", "getOptions", "()Lcom/intellij/database/scripting/ScriptingOptions;", "setOptions", "(Lcom/intellij/database/scripting/ScriptingOptions;)V", "rdbms", "Lorg/jetbrains/dekaf/Rdbms;", "getRdbms", "()Lorg/jetbrains/dekaf/Rdbms;", "script", "", "Lcom/intellij/database/scripting/CompositeText;", "getScript", "()Ljava/util/List;", "setScript", "(Ljava/util/List;)V", "statementDelimiter", "getStatementDelimiter", "()Ljava/lang/String;", "scr", "getScr", "(Ljava/lang/String;)Ljava/lang/String;", "sqlString", "getSqlString", "assumeCurrentSchema", "", "clearScript", "createCreatingGenerator", "Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "createGenerator", "getScriptStatements", "", "()[Ljava/lang/String;", "getScriptText", "getScriptableChildren", "", "Lcom/intellij/database/model/basic/BasicSchemaObject;", "o", "getScriptableMajorObjects", "Lcom/intellij/database/model/basic/BasicMajorObject;", "init", "init$database_scripting", "makeScript", "objects", "", "Lcom/intellij/database/model/basic/BasicScriptable;", "recursive", "", "schemata", "", "d", "Lcom/intellij/database/model/DataType;", "sortAndGenerate", "unsortedObjects", "sortPreliminary", "sortTopologically", "toString", "useDatabase", "currentScopeName", "CodeGenerator", "CreatingGenerator", "SizeAndScale", "StupidGenerator", "database-scripting"})
public abstract class AbstractScriptingService<M extends BasicModel, D extends BasicDatabase, S extends BasicSchema>
implements ScriptingService {
    @NotNull
    private final M model;
    @NotNull
    private ScriptingOptions options;
    @NotNull
    protected NamingService naming;
    @NotNull
    private D database;
    private S currentSchema_;
    @NotNull
    private List<CompositeText> script;
    @NotNull
    private final Set<BasicElement> generated;
    @NotNull
    private final Map<String, SizeAndScale> defaultPrimitiveSizes;

    @NotNull
    public final M getModel() {
        return this.model;
    }

    @NotNull
    public final Rdbms getRdbms() {
        Rdbms rdbms = this.model.getRdbms();
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"model.rdbms");
        return rdbms;
    }

    @Override
    @NotNull
    public ScriptingOptions getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(@NotNull ScriptingOptions scriptingOptions) {
        Intrinsics.checkParameterIsNotNull((Object)scriptingOptions, (String)"<set-?>");
        this.options = scriptingOptions;
    }

    @NotNull
    public final NamingService getNaming() {
        NamingService namingService = this.naming;
        if (namingService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"naming");
        }
        return namingService;
    }

    protected final void setNaming(@NotNull NamingService namingService) {
        Intrinsics.checkParameterIsNotNull((Object)namingService, (String)"<set-?>");
        this.naming = namingService;
    }

    @NotNull
    public D getDatabase() {
        return this.database;
    }

    public void setDatabase(@NotNull D database) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(database, (String)"database");
        boolean bl2 = bl = database.getModel() == this.model;
        if (_Assertions.ENABLED && !bl) {
            String string = "Alien database";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (this.currentSchema_ != null && CollectionsKt.contains((Iterable)database.getSchemas(), this.currentSchema_) ^ true) {
            BasicSchema newCurrentSchema = ModelFun.getCurrentSchema(database);
            this.currentSchema_ = newCurrentSchema != null ? newCurrentSchema : (BasicSchema)null;
        }
    }

    @Nullable
    public S getCurrentSchema() {
        return this.currentSchema_;
    }

    public void setCurrentSchema(@Nullable S schema) {
        if (schema != null && this.getDatabase() != null) {
            boolean bl = CollectionsKt.contains((Iterable)this.getDatabase().getSchemas(), schema);
            if (_Assertions.ENABLED && !bl) {
                String string = "Alien schema " + schema.getName() + "; expected a schema of the database " + this.getDatabase().getName();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
        this.currentSchema_ = schema;
    }

    @NotNull
    protected final List<CompositeText> getScript() {
        return this.script;
    }

    protected final void setScript(@NotNull List<CompositeText> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.script = list;
    }

    @NotNull
    protected final Set<BasicElement> getGenerated() {
        return this.generated;
    }

    public void init$database_scripting() {
    }

    @Override
    public void useDatabase(@NotNull BasicDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        this.setDatabase(database);
    }

    @Override
    public void assumeCurrentSchema(@Nullable BasicSchema schema) {
        if (schema != null) {
            this.setCurrentSchema(schema);
        } else {
            this.setCurrentSchema(null);
        }
    }

    @Override
    public void makeScript(@NotNull ScriptingTask task, @Nullable BasicSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        BasicSchema basicSchema = schema;
        if (basicSchema == null) {
            basicSchema = this.getCurrentSchema();
        }
        if (basicSchema == null) {
            return;
        }
        BasicSchema s = basicSchema;
        ArrayList<BasicMajorObject> elements = new ArrayList<BasicMajorObject>();
        Iterable<BasicMajorObject> $receiver$iv = this.getScriptableMajorObjects(s);
        Iterator<BasicMajorObject> iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            BasicMajorObject element$iv;
            BasicMajorObject it = element$iv = iterator.next();
            elements.add(it);
        }
        this.sortAndGenerate(task, (Iterable<BasicScriptable>)elements);
    }

    @Override
    public void makeScript(@NotNull ScriptingTask task, @NotNull List<? extends BasicSchema> schemata) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        Intrinsics.checkParameterIsNotNull(schemata, (String)"schemata");
        ArrayList<BasicMajorObject> elements = new ArrayList<BasicMajorObject>();
        for (BasicSchema basicSchema : schemata) {
            Iterable<BasicMajorObject> $receiver$iv = this.getScriptableMajorObjects(basicSchema);
            Iterator<BasicMajorObject> iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                BasicMajorObject element$iv;
                BasicMajorObject it = element$iv = iterator.next();
                elements.add(it);
            }
        }
        this.sortAndGenerate(task, (Iterable<BasicScriptable>)elements);
    }

    @Override
    public void makeScript(@NotNull ScriptingTask task, @NotNull Collection<? extends BasicScriptable> objects, boolean recursive) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        Intrinsics.checkParameterIsNotNull(objects, (String)"objects");
        ArrayList<? extends BasicScriptable> elements = new ArrayList<BasicScriptable>(objects);
        this.sortAndGenerate(task, (Iterable<BasicScriptable>)elements);
    }

    @NotNull
    protected Iterable<BasicMajorObject> getScriptableMajorObjects(@NotNull BasicSchema o) {
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        JBIterable jBIterable = o.getDbChildren(BasicMajorObject.class, null).filter((Condition)getScriptableMajorObjects.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"o.getDbChildren(BasicMaj\u2026icTable || !it.isSystem})");
        return (Iterable)jBIterable;
    }

    @NotNull
    protected Iterable<BasicSchemaObject> getScriptableChildren(@NotNull BasicSchemaObject o) {
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        JBIterable<BasicSchemaObject> jBIterable = o.getDbChildren(BasicSchemaObject.class, null);
        Intrinsics.checkExpressionValueIsNotNull(jBIterable, (String)"o.getDbChildren(BasicSch\u2026Object::class.java, null)");
        return (Iterable)jBIterable;
    }

    protected final void sortAndGenerate(@NotNull ScriptingTask task, @NotNull Iterable<? extends BasicScriptable> unsortedObjects) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        Intrinsics.checkParameterIsNotNull(unsortedObjects, (String)"unsortedObjects");
        Collection<BasicScriptable> preliminarySortedObjects = this.sortPreliminary(unsortedObjects);
        Collection<BasicScriptable> topoSortedObjects = this.sortTopologically(preliminarySortedObjects);
        CodeGenerator generator = this.createGenerator(task);
        generator.setElementsToGenerate((Iterable<? extends BasicElement>)topoSortedObjects);
        generator.generate();
    }

    @NotNull
    protected CodeGenerator createGenerator(@NotNull ScriptingTask task) {
        CodeGenerator codeGenerator;
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        switch (AbstractScriptingService$WhenMappings.$EnumSwitchMapping$0[task.ordinal()]) {
            case 1: 
            case 2: {
                codeGenerator = this.createCreatingGenerator(task);
                break;
            }
            default: {
                codeGenerator = new StupidGenerator(task);
            }
        }
        return codeGenerator;
    }

    @NotNull
    protected abstract CodeGenerator createCreatingGenerator(@NotNull ScriptingTask var1);

    @NotNull
    protected final Collection<BasicScriptable> sortPreliminary(@NotNull Iterable<? extends BasicScriptable> objects) {
        Intrinsics.checkParameterIsNotNull(objects, (String)"objects");
        TreeMap<String, BasicScriptable> sortingTree = new TreeMap<String, BasicScriptable>();
        for (BasicScriptable basicScriptable : objects) {
            String order = ScriptingUtilsKt.scriptingPreliminaryOrder(basicScriptable);
            sortingTree.put(order, basicScriptable);
        }
        Collection<BasicScriptable> collection = sortingTree.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"sortingTree.values");
        return collection;
    }

    private final Collection<BasicScriptable> sortTopologically(Collection<? extends BasicScriptable> objects) {
        return objects;
    }

    @NotNull
    protected final String getScr(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        NamingService namingService = this.naming;
        if (namingService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"naming");
        }
        return namingService.nameToScript($receiver);
    }

    @NotNull
    protected String currentScopeName(@NotNull BasicSchemaObject $receiver) {
        BasicDatabase database;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        BasicSchema basicSchema = $receiver.getSchema();
        if (basicSchema == null) {
            return this.getScr($receiver.getName());
        }
        BasicSchema schema = basicSchema;
        BasicNamespaceOwner basicNamespaceOwner = schema.getDbParent();
        if (!(basicNamespaceOwner instanceof BasicDatabase)) {
            basicNamespaceOwner = null;
        }
        if ((database = (BasicDatabase)basicNamespaceOwner) == null || database.isCurrent()) {
            return schema.isCurrent() ? this.getScr($receiver.getName()) : this.getScr(schema.getName()) + "." + this.getScr($receiver.getName());
        }
        return this.getScr(database.getName()) + "." + this.getScr(schema.getName()) + "." + this.getScr($receiver.getName());
    }

    @NotNull
    protected final String getSqlString(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return "'" + StringsKt.replace$default((String)$receiver, (String)"'", (String)"''", (boolean)false, (int)4, null) + "'";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String[] getScriptStatements() {
        void var2_2;
        int size$iv = this.script.size();
        String[] result$iv = new String[size$iv];
        int n = 0;
        int n2 = size$iv - 1;
        if (n <= n2) {
            void i$iv;
            do {
                void i2;
                String string;
                void var5_5 = ++i$iv;
                void var9_7 = i$iv;
                String[] stringArray = result$iv;
                stringArray[var9_7] = string = ((Object)this.script.get((int)i2).getText()).toString();
            } while (i$iv != n2);
        }
        return var2_2;
    }

    @Override
    @NotNull
    public String getScriptText() {
        StringBuilder b = new StringBuilder();
        for (CompositeText stmt : this.script) {
            b.append(stmt.getText());
            b.append(this.getStatementDelimiter()).append('\n').append('\n');
        }
        String string = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompositeText getScript() {
        void $receiver$iv;
        int initial$iv;
        Iterable iterable = this.script;
        int accumulator$iv = initial$iv = 0;
        for (Object element$iv : $receiver$iv) {
            void t;
            CompositeText compositeText = (CompositeText)element$iv;
            int x = accumulator$iv;
            accumulator$iv = x + t.getText().length();
        }
        int capacity = accumulator$iv + 8 * this.script.size();
        CodeTextBuilder b = new CodeTextBuilder(capacity);
        for (CompositeText stmt : this.script) {
            for (CompositeText.Fragment f : stmt.getFragments()) {
                b.append(f, false);
            }
            b.ensureEoln();
            CodeTextBuilder.append$default(b, this.getStatementDelimiter() + "\n" + "\n", CompositeText.Kind.SQL_DELIMITER, false, 4, null);
        }
        return b;
    }

    @Override
    public final void clearScript() {
        this.script.clear();
    }

    @NotNull
    public String getStatementDelimiter() {
        return ";";
    }

    @NotNull
    protected Map<String, SizeAndScale> getDefaultPrimitiveSizes() {
        return this.defaultPrimitiveSizes;
    }

    @NotNull
    protected String script(@NotNull DataType d) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        String specification = null;
        if (!d.custom && !d.sizeUnitExplicit && d.size != -1) {
            String typeName = d.typeName;
            SizeAndScale defaults = this.getDefaultPrimitiveSizes().get(typeName);
            if (defaults != null && d.size == defaults.getSize() && d.scale == defaults.getScale()) {
                specification = typeName;
            }
        }
        if ((string = specification) == null) {
            String string2 = d.getSpecification();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"d.specification");
        }
        return string;
    }

    @NotNull
    public String toString() {
        return this.script.isEmpty() ? "ScriptingService for " + this.getRdbms() + ". Empty." : "ScriptingService for " + this.model.getRdbms() + "\n" + "Generated " + this.script.size() + " statements:" + "\n" + this.getScriptText();
    }

    protected AbstractScriptingService(@NotNull M model, @NotNull D database) {
        Intrinsics.checkParameterIsNotNull(model, (String)"model");
        Intrinsics.checkParameterIsNotNull(database, (String)"database");
        this.options = DefaultScriptingOptions.INSTANCE;
        this.script = new ArrayList();
        this.generated = new HashSet();
        this.defaultPrimitiveSizes = MapsKt.emptyMap();
        this.model = model;
        this.setDatabase(database);
        BasicSchema cs = ModelFun.getCurrentSchema(database);
        this.setCurrentSchema(cs != null ? cs : null);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/scripting/AbstractScriptingService$SizeAndScale;", "", "size", "", "scale", "(II)V", "getScale", "()I", "getSize", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "database-scripting"})
    public static final class SizeAndScale {
        private final int size;
        private final int scale;

        @NotNull
        public String toString() {
            return this.scale == 0 ? String.valueOf(this.size) : this.size + "," + this.scale;
        }

        public final int getSize() {
            return this.size;
        }

        public final int getScale() {
            return this.scale;
        }

        public SizeAndScale(int size, int scale) {
            this.size = size;
            this.scale = scale;
        }

        public /* synthetic */ SizeAndScale(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = -1;
            }
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            this(n, n2);
        }

        public SizeAndScale() {
            this(0, 0, 3, null);
        }

        public final int component1() {
            return this.size;
        }

        public final int component2() {
            return this.scale;
        }

        @NotNull
        public final SizeAndScale copy(int size, int scale) {
            return new SizeAndScale(size, scale);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ SizeAndScale copy$default(SizeAndScale sizeAndScale, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = sizeAndScale.size;
            }
            if ((n3 & 2) != 0) {
                n2 = sizeAndScale.scale;
            }
            return sizeAndScale.copy(n, n2);
        }

        public int hashCode() {
            return this.size * 31 + this.scale;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SizeAndScale)) break block3;
                    SizeAndScale sizeAndScale = (SizeAndScale)object;
                    if (!(this.size == sizeAndScale.size) || !(this.scale == sizeAndScale.scale)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0000\b\u00a4\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020 0$H\u0004J\u0006\u0010%\u001a\u00020 J\u0010\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\u0016H$J\b\u0010(\u001a\u00020 H\u0002J\u0010\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020*H\u0004J\u0010\u0010+\u001a\u00020 2\u0006\u0010'\u001a\u00020\u0016H\u0004J\u0010\u0010,\u001a\u00020 2\u0006\u0010'\u001a\u00020\u0016H\u0004J\u0014\u0010-\u001a\u00020 2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00160/R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R \u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00060"}, d2={"Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/AbstractScriptingService;Lcom/intellij/database/scripting/ScriptingTask;)V", "builder", "Lcom/intellij/database/scripting/CodeTextBuilder;", "getBuilder", "()Lcom/intellij/database/scripting/CodeTextBuilder;", "<set-?>", "Lcom/intellij/database/scripting/ScriptContext;", "context", "getContext", "()Lcom/intellij/database/scripting/ScriptContext;", "setContext", "(Lcom/intellij/database/scripting/ScriptContext;)V", "createOrReplace", "", "getCreateOrReplace", "()Ljava/lang/String;", "deck", "Ljava/util/Deque;", "Lcom/intellij/database/model/basic/BasicElement;", "getDeck", "()Ljava/util/Deque;", "postponed", "Lcom/intellij/util/containers/MultiMap;", "getPostponed", "()Lcom/intellij/util/containers/MultiMap;", "getTask", "()Lcom/intellij/database/scripting/ScriptingTask;", "coding", "", "indent", "", "block", "Lkotlin/Function0;", "generate", "generateElement", "element", "postStatement", "statement", "Lcom/intellij/database/scripting/CompositeText;", "process", "processElement", "setElementsToGenerate", "elements", "", "database-scripting"})
    protected abstract class CodeGenerator {
        @NotNull
        private final Deque<BasicElement> deck;
        @NotNull
        private final MultiMap<BasicElement, BasicElement> postponed;
        @NotNull
        private final CodeTextBuilder builder;
        @NotNull
        private ScriptContext context;
        @NotNull
        private final String createOrReplace;
        @NotNull
        private final ScriptingTask task;

        @NotNull
        protected final Deque<BasicElement> getDeck() {
            return this.deck;
        }

        @NotNull
        protected final MultiMap<BasicElement, BasicElement> getPostponed() {
            return this.postponed;
        }

        @NotNull
        protected final CodeTextBuilder getBuilder() {
            return this.builder;
        }

        @NotNull
        protected final ScriptContext getContext() {
            return this.context;
        }

        private final void setContext(ScriptContext scriptContext) {
            this.context = scriptContext;
        }

        @NotNull
        public final String getCreateOrReplace() {
            return this.createOrReplace;
        }

        public final void setElementsToGenerate(@NotNull Iterable<? extends BasicElement> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            for (BasicElement basicElement : elements) {
                this.deck.offer(basicElement);
            }
        }

        public final void generate() {
            while (this.deck.poll() != null) {
                BasicElement element;
                this.process(element);
            }
        }

        protected final void process(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            if (AbstractScriptingService.this.getGenerated().contains(element) ^ true) {
                Iterable<? extends BasicElement> predecessors = element.getPredecessors();
                boolean postpone = false;
                for (BasicElement basicElement : predecessors) {
                    if (!(AbstractScriptingService.this.getGenerated().contains(basicElement) ^ true) || !this.deck.contains(basicElement)) continue;
                    this.postponed.putValue((Object)basicElement, (Object)element);
                    postpone = true;
                }
                if (postpone) {
                    return;
                }
                this.processElement(element);
                if (AbstractScriptingService.this.getGenerated().contains(element) ^ true) {
                    return;
                }
            }
            if (Intrinsics.areEqual((Object)((Object)this.context), (Object)((Object)ScriptContext.IN_SCHEMA)) || Intrinsics.areEqual((Object)((Object)this.context), (Object)((Object)ScriptContext.OUTSIDE))) {
                Collection collection = this.postponed.get((Object)element);
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"postponed[element]");
                Iterable pendingElements = collection;
                for (BasicElement pendingElement : pendingElements) {
                    this.process(pendingElement);
                }
            }
        }

        protected final void processElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            try {
                this.generateElement(element);
                AbstractScriptingService.this.getGenerated().add(element);
            }
            catch (AbortException abortException) {
                // empty catch block
            }
        }

        protected abstract void generateElement(@NotNull BasicElement var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void coding(@Nullable ScriptContext context, boolean indent, @NotNull Function0<Unit> block) {
            boolean complete;
            Intrinsics.checkParameterIsNotNull(block, (String)"block");
            ScriptContext oldContext = this.context;
            ScriptContext scriptContext = context;
            if (scriptContext == null) {
                scriptContext = Intrinsics.areEqual((Object)((Object)oldContext), (Object)((Object)ScriptContext.OUTSIDE)) ? ScriptContext.IN_STATEMENT : oldContext;
            }
            ScriptContext newContext = scriptContext;
            CodeTextBuilder.IndentationState savedIndentation = this.builder.getCurrentIndentationState();
            try {
                this.context = newContext;
                if (indent) {
                    CodeTextBuilder.indent$default(this.builder, null, 1, null);
                }
                block.invoke();
                this.builder.returnToIndentation(savedIndentation);
                this.context = oldContext;
            }
            catch (Throwable throwable) {
                boolean complete2;
                this.builder.returnToIndentation(savedIndentation);
                this.context = oldContext;
                boolean bl = complete2 = Intrinsics.areEqual((Object)((Object)oldContext), (Object)((Object)ScriptContext.OUTSIDE)) && Intrinsics.areEqual((Object)((Object)newContext), (Object)((Object)ScriptContext.OUTSIDE)) ^ true && this.builder.isNotEmpty();
                if (complete2) {
                    this.postStatement();
                }
                throw throwable;
            }
            boolean bl = complete = Intrinsics.areEqual((Object)((Object)oldContext), (Object)((Object)ScriptContext.OUTSIDE)) && Intrinsics.areEqual((Object)((Object)newContext), (Object)((Object)ScriptContext.OUTSIDE)) ^ true && this.builder.isNotEmpty();
            if (complete) {
                this.postStatement();
            }
        }

        public static /* bridge */ /* synthetic */ void coding$default(CodeGenerator codeGenerator, ScriptContext scriptContext, boolean bl, Function0 function0, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: coding");
            }
            if ((n & 1) != 0) {
                scriptContext = null;
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            codeGenerator.coding(scriptContext, bl, (Function0<Unit>)function0);
        }

        private final void postStatement() {
            if (this.builder.isNotEmpty()) {
                this.postStatement(new SimpleCompositeText(this.builder));
            }
            this.builder.clearAll();
        }

        protected final void postStatement(@NotNull CompositeText statement) {
            Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
            AbstractScriptingService.this.getScript().add(statement);
        }

        @NotNull
        protected final ScriptingTask getTask() {
            return this.task;
        }

        public CodeGenerator(ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            this.task = task;
            this.deck = new ArrayDeque();
            this.postponed = new MultiMap();
            this.builder = new CodeTextBuilder(0, 1, null);
            this.createOrReplace = AbstractScriptingService.this.getOptions().get(ScriptingOptionStatic.getCREATE_OR_REPLACE()) != false && ScriptingOptionStatic.getCREATE_OR_REPLACE().getApplicableRdbms().contains(AbstractScriptingService.this.getRdbms()) ? "create or replace" : "create";
            this.context = ScriptContext.OUTSIDE;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0094\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0004J\u0012\u0010\u000f\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0014J\u0010\u0010#\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0014J\u0010\u0010$\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'H\u0014J\u0010\u0010(\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010)\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010*\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020-H\u0014J\u0010\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u000200H\u0014J\u0010\u00101\u001a\u00020\f2\u0006\u00102\u001a\u000203H\u0014J\u0010\u00104\u001a\u00020\f2\u0006\u00105\u001a\u000206H\u0014J\u0010\u00107\u001a\u00020\f2\u0006\u00105\u001a\u000208H\u0014J\u0010\u00109\u001a\u00020\f2\u0006\u00105\u001a\u000206H\u0014J\u0010\u0010:\u001a\u00020\f2\u0006\u0010;\u001a\u00020<H\u0014J\u001a\u0010=\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020>2\b\b\u0002\u0010?\u001a\u00020\u0011H\u0014J\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00130A2\u0006\u0010!\u001a\u00020\"H\u0014J\b\u0010B\u001a\u00020\u0011H\u0014J\u0014\u0010C\u001a\u0004\u0018\u00010\u000e2\b\u0010D\u001a\u0004\u0018\u00010EH\u0014J\u0012\u0010F\u001a\u0004\u0018\u00010\u000e2\u0006\u0010!\u001a\u00020\"H\u0014J\u0012\u0010G\u001a\u0004\u0018\u00010\u000e2\u0006\u0010!\u001a\u00020\"H\u0014J\u0012\u0010H\u001a\u0004\u0018\u00010\u000e2\u0006\u0010!\u001a\u00020\"H\u0014J\u0012\u0010I\u001a\u0004\u0018\u00010\u000e2\u0006\u0010&\u001a\u00020'H\u0014J\u0010\u0010J\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0012\u0010K\u001a\u0004\u0018\u00010\u000e2\u0006\u0010!\u001a\u00020\"H\u0014J\u0018\u0010L\u001a\b\u0012\u0004\u0012\u00020\u000e0M2\b\u0010N\u001a\u0004\u0018\u00010OH\u0014J\u0018\u0010L\u001a\b\u0012\u0004\u0012\u00020\u000e0M2\b\u0010/\u001a\u0004\u0018\u000100H\u0014J\u0012\u0010P\u001a\u0004\u0018\u00010\u000e2\u0006\u00102\u001a\u000203H\u0014J\u0010\u0010Q\u001a\u00020R2\u0006\u00105\u001a\u000206H\u0014J\u0010\u0010S\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0018\u0010T\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u000eH\u0014J\u0010\u0010U\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0004R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006V"}, d2={"Lcom/intellij/database/scripting/AbstractScriptingService$CreatingGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/AbstractScriptingService;Lcom/intellij/database/scripting/ScriptingTask;)V", "tableElementsApplicableInExactTask", "", "Lcom/intellij/database/model/ObjectKind;", "getTableElementsApplicableInExactTask", "()Ljava/util/Set;", "addInnerConstraintNameAndIndent", "", "name", "", "addOuterConstraintNameAndIndent", "canCreateInColumn", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "canCreateInTable", "canCreateIndexInCurrentContext", "index", "Lcom/intellij/database/model/basic/BasicIndex;", "canGenerateElementRightNow", "canGenerateInnerElement", "generateCascadeRules", "fk", "Lcom/intellij/database/model/basic/BasicForeignKey;", "generateCheck", "check", "Lcom/intellij/database/model/basic/BasicCheck;", "generateColumn", "column", "Lcom/intellij/database/model/basic/BasicColumn;", "generateColumnComment", "generateComment", "generateDeferrability", "constraint", "Lcom/intellij/database/model/basic/BasicConstraint;", "generateElement", "generateForeignKey", "generateIndex", "generateKey", "key", "Lcom/intellij/database/model/basic/BasicKey;", "generateSequence", "sequence", "Lcom/intellij/database/model/basic/BasicSequence;", "generateSynonym", "synonym", "Lcom/intellij/database/model/basic/BasicSynonym;", "generateTable", "table", "Lcom/intellij/database/model/basic/BasicTable;", "generateTableComment", "Lcom/intellij/database/model/basic/BasicLikeTable;", "generateTableOutsideStuff", "generateTrigger", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "generateUnspecificSourceAwareElement", "Lcom/intellij/database/model/basic/BasicSourceAware;", "processChildren", "getSingleColumnElements", "", "isNullExplicit", "makeCascadeRuleKeyword", "rule", "Lcom/intellij/database/model/properties/CascadeRule;", "makeColumnDefinition", "makeColumnSpecification", "makeComputedColumnSpecification", "makeDeferrability", "makeIndexWord", "makeNormalColumnSpecification", "makeSequenceIdentityOptions", "", "identity", "Lcom/intellij/database/model/SequenceIdentity;", "makeSynonymTargetSpec", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "processElementChildren", "scriptIndexColumn", "weDontKnowHowToGenerateThis", "database-scripting"})
    protected class CreatingGenerator
    extends CodeGenerator {
        @NotNull
        private final Set<ObjectKind> tableElementsApplicableInExactTask;

        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            BasicElement basicElement = element;
            if (basicElement instanceof BasicSequence) {
                this.generateSequence((BasicSequence)element);
            } else if (basicElement instanceof BasicTable) {
                this.generateTable((BasicTable)element);
            } else if (basicElement instanceof BasicColumn) {
                this.generateColumn((BasicColumn)element);
            } else if (basicElement instanceof BasicIndex) {
                this.generateIndex((BasicIndex)element);
            } else if (basicElement instanceof BasicKey) {
                this.generateKey((BasicKey)element);
            } else if (basicElement instanceof BasicForeignKey) {
                this.generateForeignKey((BasicForeignKey)element);
            } else if (basicElement instanceof BasicCheck) {
                this.generateCheck((BasicCheck)element);
            } else if (basicElement instanceof BasicTrigger) {
                this.generateTrigger((BasicTrigger)element);
            } else if (basicElement instanceof BasicSourceAware) {
                this.generateUnspecificSourceAwareElement((BasicSourceAware)element, true);
            } else if (basicElement instanceof BasicSynonym) {
                this.generateSynonym((BasicSynonym)element);
            } else {
                this.weDontKnowHowToGenerateThis(element);
            }
        }

        protected void generateSequence(@NotNull BasicSequence sequence) {
            Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
            if (sequence instanceof BasicNamedElement && ((BasicNamedElement)((Object)sequence)).isNameSurrogate()) {
                return;
            }
            String name = AbstractScriptingService.this.getScr(sequence.getName());
            List<String> q = this.makeSequenceIdentityOptions(sequence);
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, name, q){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ List $q;

                public final void invoke() {
                    String s = "create sequence " + this.$name;
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), s, null, false, 6, null);
                    Collection collection = this.$q;
                    if (!collection.isEmpty()) {
                        CodeGenerator.coding$default(this.this$0, null, true, (Function0)new Function0<Unit>(this){
                            final /* synthetic */ generateSequence.1 this$0;

                            public final void invoke() {
                                for (String o : this.this$0.$q) {
                                    CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), o, null, false, 6, null);
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        }, 1, null);
                    }
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$name = string;
                    this.$q = list;
                    super(0);
                }
            }, 3, null);
        }

        @NotNull
        protected List<String> makeSequenceIdentityOptions(@Nullable BasicSequence sequence) {
            Object object = sequence;
            if (object == null || (object = object.getSequenceIdentity()) == null) {
                return CollectionsKt.emptyList();
            }
            Object i2 = object;
            return this.makeSequenceIdentityOptions((SequenceIdentity)i2);
        }

        @NotNull
        protected List<String> makeSequenceIdentityOptions(@Nullable SequenceIdentity identity) {
            if (identity == null) {
                return CollectionsKt.emptyList();
            }
            ArrayList<String> r = new ArrayList<String>(4);
            if (identity.next != null && Intrinsics.areEqual((Object)identity.min, (Object)BigInteger.ONE) ^ true && AbstractScriptingService.this.getOptions().get(ScriptingOptionStatic.getCONSIDER_CURRENT_SEQUENCE_VALUE()).booleanValue()) {
                r.add("start with " + identity.next);
            }
            if (Intrinsics.areEqual((Object)identity.min, (Object)BigInteger.ONE) ^ true) {
                r.add("minvalue " + identity.min);
            }
            if (Intrinsics.areEqual((Object)identity.increment, (Object)BigInteger.ONE) ^ true) {
                r.add("increment by " + identity.increment);
            }
            if (identity.max != null) {
                r.add("maxvalue " + identity.max);
            }
            return r;
        }

        protected void generateTable(@NotNull BasicTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, table){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ BasicTable $table;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void footer2;
                    void header;
                    HeaderFooter headerFooter = this.this$0.makeTableHeaderFooter(this.$table);
                    String string = headerFooter.component1();
                    String string2 = headerFooter.component2();
                    headerFooter = null;
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), (CharSequence)header, null, false, 6, null);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "(", null, false, 6, null);
                    this.this$0.coding(ScriptContext.IN_TABLE, true, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ generateTable.1 this$0;

                        public final void invoke() {
                            for (BasicElement element : this.this$0.$table.getDbChildren()) {
                                CreatingGenerator creatingGenerator = this.this$0.this$0;
                                BasicElement basicElement = element;
                                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"element");
                                if (!creatingGenerator.canCreateInTable(basicElement) || this.this$0.this$0.AbstractScriptingService.this.getGenerated().contains(element)) continue;
                                CreatingGenerator creatingGenerator2 = this.this$0.this$0;
                                BasicElement basicElement2 = element;
                                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement2, (String)"element");
                                creatingGenerator2.process(basicElement2);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                    this.this$0.getBuilder().removeSuffixFromTheLastLine(',');
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), ")", null, false, 6, null);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), (CharSequence)footer2, null, false, 6, null);
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$table = basicTable;
                    super(0);
                }
            }, 3, null);
            if (Intrinsics.areEqual((Object)((Object)this.getContext()), (Object)((Object)ScriptContext.OUTSIDE)) || Intrinsics.areEqual((Object)((Object)this.getContext()), (Object)((Object)ScriptContext.IN_STATEMENT))) {
                this.generateTableOutsideStuff(table);
            }
        }

        @NotNull
        protected final Set<ObjectKind> getTableElementsApplicableInExactTask() {
            return this.tableElementsApplicableInExactTask;
        }

        protected void generateTableOutsideStuff(@NotNull BasicTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            for (BasicElement element : table.getDbChildren()) {
                if (element instanceof BasicColumn || AbstractScriptingService.this.getGenerated().contains(element) || Intrinsics.areEqual((Object)((Object)this.getTask()), (Object)((Object)ScriptingTask.CREATE_EXACT)) && this.tableElementsApplicableInExactTask.contains(element.getKind()) ^ true || element instanceof BasicConstraint && Intrinsics.areEqual((Object)((Object)AbstractScriptingService.this.getOptions().get(ScriptingOptionStatic.getSCRIPTING_CONSTRAINT_CONTEXT())), (Object)((Object)ScriptingConstraintContext.CONSTRAINT_AFTER_TABLE))) continue;
                BasicElement basicElement = element;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"element");
                this.process(basicElement);
            }
            if (table.getComment() != null) {
                this.generateComment(table);
            }
            for (BasicColumn column : table.getColumns()) {
                if (column.getComment() == null) continue;
                BasicColumn basicColumn = column;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicColumn, (String)"column");
                this.generateComment(basicColumn);
            }
        }

        @NotNull
        protected HeaderFooter makeTableHeaderFooter(@NotNull BasicTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            String name = AbstractScriptingService.this.currentScopeName(table);
            String h = table.isTemporary() ? "create temporary table " + name : "create table " + name;
            return new HeaderFooter(h, null);
        }

        protected boolean canCreateInColumn(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            return element instanceof BasicConstraint;
        }

        protected boolean canCreateInTable(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            return element instanceof BasicColumn || element instanceof BasicConstraint;
        }

        protected void generateColumn(@NotNull BasicColumn column) {
            List singleColumnElementsToGenerate;
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            if (Intrinsics.areEqual((Object)((Object)AbstractScriptingService.this.getOptions().get(ScriptingOptionStatic.getSCRIPTING_CONSTRAINT_CONTEXT())), (Object)((Object)ScriptingConstraintContext.CONSTRAINT_IN_COLUMN))) {
                singleColumnElementsToGenerate = new LinkedList();
                for (BasicElement e : this.getSingleColumnElements(column)) {
                    ((LinkedList)singleColumnElementsToGenerate).add(e);
                }
                ListIterator listIterator = ((LinkedList)singleColumnElementsToGenerate).listIterator();
                Intrinsics.checkExpressionValueIsNotNull(listIterator, (String)"singleColumnElementsToGenerate.listIterator()");
                ListIterator it = listIterator;
                while (it.hasNext()) {
                    BasicElement e = (BasicElement)it.next();
                    if (!AbstractScriptingService.this.getGenerated().contains(e) && this.canGenerateElementRightNow(e)) continue;
                    it.remove();
                }
            } else {
                singleColumnElementsToGenerate = CollectionsKt.emptyList();
            }
            String string = this.makeColumnDefinition(column);
            if (string == null) {
                return;
            }
            String line = string;
            CodeTextBuilder.append$default(this.getBuilder(), line, null, false, 6, null);
            Collection collection = singleColumnElementsToGenerate;
            if (!collection.isEmpty()) {
                this.coding(ScriptContext.IN_COLUMN, true, (Function0<Unit>)((Function0)new Function0<Unit>(this, singleColumnElementsToGenerate){
                    final /* synthetic */ CreatingGenerator this$0;
                    final /* synthetic */ List $singleColumnElementsToGenerate;

                    public final void invoke() {
                        for (BasicElement e : this.$singleColumnElementsToGenerate) {
                            this.this$0.process(e);
                        }
                    }
                    {
                        this.this$0 = creatingGenerator;
                        this.$singleColumnElementsToGenerate = list;
                        super(0);
                    }
                }));
            }
            this.getBuilder().addSuffixToTheListLine(',');
        }

        @Nullable
        protected String makeColumnDefinition(@NotNull BasicColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            String name = AbstractScriptingService.this.getScr(column.getName());
            String specification = this.makeColumnSpecification(column);
            return ScriptingUtilsKt.concatWithSpace(name, specification);
        }

        @Nullable
        protected String makeColumnSpecification(@NotNull BasicColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            return column.isComputed() ? this.makeComputedColumnSpecification(column) : this.makeNormalColumnSpecification(column);
        }

        @Nullable
        protected String makeNormalColumnSpecification(@NotNull BasicColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            DataType dataType = column.getDataType();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"column.dataType");
            String specification = AbstractScriptingService.this.script(dataType);
            if (column.getDefaultExpression() != null) {
                specification = specification + " default " + column.getDefaultExpression();
            }
            if (column.isNotNull() && !column.isAutoInc()) {
                specification = specification + " not null";
            }
            if (!column.isNotNull() && this.isNullExplicit() && !column.isAutoInc()) {
                specification = specification + " null";
            }
            return specification;
        }

        @Nullable
        protected String makeComputedColumnSpecification(@NotNull BasicColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            return "as " + column.getDefault();
        }

        protected boolean isNullExplicit() {
            return false;
        }

        @NotNull
        protected Iterable<BasicElement> getSingleColumnElements(@NotNull BasicColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            BasicLikeTable basicLikeTable = column.getTable();
            if (basicLikeTable == null) {
                return SetsKt.emptySet();
            }
            BasicLikeTable table = basicLikeTable;
            JBIterable jBIterable = table.getDbChildren(BasicConstraint.class, null).filter((Condition)new Condition<BasicConstraint>(this, column){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ BasicColumn $column;

                public final boolean value(BasicConstraint it) {
                    BasicConstraint basicConstraint = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)basicConstraint, (String)"it");
                    return this.this$0.canCreateInColumn(basicConstraint) && it.getColNames().size() == 1 && Intrinsics.areEqual((Object)((String)CollectionsKt.first(it.getColNames())), (Object)this.$column.getName());
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$column = basicColumn;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"table.getDbChildren(Basi\u2026s.first() == column.name}");
            return (Iterable)jBIterable;
        }

        protected void generateIndex(@NotNull BasicIndex index) {
            Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
            if (!this.canCreateIndexInCurrentContext(index)) {
                throw (Throwable)new AbortException();
            }
            String name = AbstractScriptingService.this.getScr(index.getName());
            String w = this.makeIndexWord(index);
            String condition = index.getCondition();
            StringBuilder b = new StringBuilder();
            for (String col : index.getColNames()) {
                CharSequence charSequence = b;
                if (charSequence.length() > 0) {
                    b.append(", ");
                }
                String string = col;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"col");
                b.append(this.scriptIndexColumn(index, string));
            }
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, w, index, name, b, condition){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ String $w;
                final /* synthetic */ BasicIndex $index;
                final /* synthetic */ String $name;
                final /* synthetic */ StringBuilder $b;
                final /* synthetic */ String $condition;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    switch (AbstractScriptingService$CreatingGenerator$WhenMappings.$EnumSwitchMapping$0[this.this$0.getContext().ordinal()]) {
                        case 1: {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$w, null, false, 6, null);
                            break;
                        }
                        case 2: {
                            String s = this.$index.getNaturalName() != null ? this.$w + " " + this.$name + " (" + this.$b + ")" : this.$w + " (" + this.$b + ")";
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), s, null, false, 6, null);
                            break;
                        }
                        default: {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "create " + this.$w + " " + this.$name, null, false, 6, null);
                            CodeTextBuilder this_$iv = this.this$0.getBuilder();
                            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                            try {
                                String string = this.$index.getTableName();
                                CodeTextBuilder.append$default(this.this$0.getBuilder(), "on " + (string != null ? this.this$0.AbstractScriptingService.this.getScr(string) : null) + " (" + this.$b + ")", null, false, 6, null);
                                if (this.$condition == null) break;
                                CodeTextBuilder.append$default(this.this$0.getBuilder(), "where " + this.$condition, null, false, 6, null);
                                break;
                            }
                            finally {
                                this_$iv.unindent();
                            }
                        }
                    }
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$w = string;
                    this.$index = basicIndex;
                    this.$name = string2;
                    this.$b = stringBuilder;
                    this.$condition = string3;
                    super(0);
                }
            }, 3, null);
        }

        @NotNull
        protected String scriptIndexColumn(@NotNull BasicIndex index, @NotNull String column) {
            String s;
            String string;
            boolean dirs;
            Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            CharSequence charSequence = column;
            if (charSequence.length() == 0) {
                return "???";
            }
            Set<String> descendants = index.getReverseColNames();
            Collection collection = descendants;
            boolean bl = dirs = !collection.isEmpty();
            if (column.charAt(0) == '\u001b') {
                String string2 = column;
                int n = 1;
                int n2 = column.length();
                String string3 = string2.substring(n, n2);
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string = s = AbstractScriptingService.this.getScr(column);
            }
            if (dirs) {
                s = s + (descendants.contains(column) ? " desc" : " asc");
            }
            return s;
        }

        @NotNull
        protected String makeIndexWord(@NotNull BasicIndex index) {
            Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
            return index.isUnique() ? "unique index" : "index";
        }

        protected boolean canCreateIndexInCurrentContext(@NotNull BasicIndex index) {
            Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
            return Intrinsics.areEqual((Object)((Object)this.getContext()), (Object)((Object)ScriptContext.IN_STATEMENT)) || Intrinsics.areEqual((Object)((Object)this.getContext()), (Object)((Object)ScriptContext.OUTSIDE));
        }

        protected void generateKey(@NotNull BasicKey key) {
            boolean indexIsExplicit;
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            String string = key.getNaturalName();
            String name = string != null ? AbstractScriptingService.this.getScr(string) : null;
            String w = key.isPrimary() ? "primary key" : "unique";
            BasicIndex index = null;
            if (key.getUnderlyingIndexName() != null) {
                BasicIndex basicIndex;
                BasicNode basicNode = key.getTable();
                if (basicNode != null && (basicNode = basicNode.getIndices()) != null) {
                    Object v2;
                    block8: {
                        Iterable $receiver$iv = (Iterable)((Object)basicNode);
                        for (Object element$iv : $receiver$iv) {
                            BasicIndex it = (BasicIndex)element$iv;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)key.getUnderlyingIndexName())) continue;
                            v2 = element$iv;
                            break block8;
                        }
                        v2 = null;
                    }
                    basicIndex = v2;
                } else {
                    basicIndex = null;
                }
                index = basicIndex;
            }
            boolean bl = indexIsExplicit = index != null && index.getNaturalName() != null && Intrinsics.areEqual((Object)index.getName(), (Object)key.getName()) ^ true;
            if (indexIsExplicit) {
                Set<BasicElement> set = AbstractScriptingService.this.getGenerated();
                BasicIndex basicIndex = index;
                if (basicIndex == null) {
                    Intrinsics.throwNpe();
                }
                if (set.contains(basicIndex) ^ true) {
                    this.getPostponed().putValue((Object)index, (Object)key);
                    throw (Throwable)new AbortException();
                }
            }
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, name, w, key){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ String $w;
                final /* synthetic */ BasicKey $key;

                public final void invoke() {
                    switch (AbstractScriptingService$CreatingGenerator$WhenMappings.$EnumSwitchMapping$1[this.this$0.getContext().ordinal()]) {
                        case 1: {
                            this.this$0.addInnerConstraintNameAndIndent(this.$name);
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$w, null, false, 6, null);
                            this.this$0.generateDeferrability(this.$key);
                            break;
                        }
                        case 2: {
                            this.this$0.addInnerConstraintNameAndIndent(this.$name);
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$w + " (" + CollectionsKt.joinToString$default((Iterable)this.$key.getColNames(), null, null, null, (int)0, null, null, (int)63, null) + ")", null, false, 6, null);
                            this.this$0.generateDeferrability(this.$key);
                            this.this$0.getBuilder().addSuffixToTheListLine(',');
                            break;
                        }
                        default: {
                            String string = this.$key.getTableName();
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "alter table " + (string != null ? this.this$0.AbstractScriptingService.this.getScr(string) : null), null, false, 6, null);
                            CodeTextBuilder.indent$default(this.this$0.getBuilder(), null, 1, null);
                            CreatingGenerator.access$addOuterConstraintNameAndIndent(this.this$0, this.$name);
                            String w1 = this.$name == null ? "add " : "";
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), w1 + this.$w + " (" + CollectionsKt.joinToString$default((Iterable)this.$key.getColNames(), null, null, null, (int)0, null, null, (int)63, null) + ")", null, false, 6, null);
                            this.this$0.generateDeferrability(this.$key);
                        }
                    }
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$name = string;
                    this.$w = string2;
                    this.$key = basicKey;
                    super(0);
                }
            }, 3, null);
            if (index != null) {
                AbstractScriptingService.this.getGenerated().add(index);
            }
        }

        protected void generateForeignKey(@NotNull BasicForeignKey fk) {
            PostgresTable refTable;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)fk, (String)"fk");
            String name = fk.getNaturalName();
            BasicLikeTable basicLikeTable = fk.getRefTable();
            if (!(basicLikeTable instanceof PostgresTable)) {
                basicLikeTable = null;
            }
            if ((object = (refTable = (PostgresTable)basicLikeTable)) == null || (object = AbstractScriptingService.this.currentScopeName((BasicSchemaObject)object)) == null) {
                if (fk.getRefSchemaName() != null) {
                    String string = fk.getRefSchemaName();
                    String string2 = fk.getRefTableName();
                    object = (string != null ? AbstractScriptingService.this.getScr(string) : null) + '.' + (string2 != null ? AbstractScriptingService.this.getScr(string2) : null);
                } else {
                    String string = fk.getRefTableName();
                    object = string != null ? AbstractScriptingService.this.getScr(string) : null;
                }
            }
            Object refTableName = object;
            String refKeyColNames = CollectionsKt.joinToString$default((Iterable)fk.getRefColNames(), null, null, null, (int)0, null, null, (int)63, null);
            BasicKey basicKey = fk.getRefKey();
            boolean refPrimary = basicKey != null ? basicKey.isPrimary() : false;
            String w = "references " + (String)refTableName + (!refPrimary ? " (" + refKeyColNames + ")" : "");
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, name, w, fk){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ String $w;
                final /* synthetic */ BasicForeignKey $fk;

                public final void invoke() {
                    switch (AbstractScriptingService$CreatingGenerator$WhenMappings.$EnumSwitchMapping$2[this.this$0.getContext().ordinal()]) {
                        case 1: {
                            this.this$0.addInnerConstraintNameAndIndent(this.$name);
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$w, null, false, 6, null);
                            this.this$0.generateCascadeRules(this.$fk);
                            this.this$0.generateDeferrability(this.$fk);
                            break;
                        }
                        case 2: {
                            this.this$0.addInnerConstraintNameAndIndent(this.$name);
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "foreign key (" + CollectionsKt.joinToString$default((Iterable)this.$fk.getColNames(), null, null, null, (int)0, null, null, (int)63, null) + ") " + this.$w, null, false, 6, null);
                            this.this$0.generateCascadeRules(this.$fk);
                            this.this$0.generateDeferrability(this.$fk);
                            this.this$0.getBuilder().addSuffixToTheListLine(',');
                            break;
                        }
                        default: {
                            PostgresTable table;
                            Object object;
                            BasicLikeTable basicLikeTable = this.$fk.getTable();
                            if (!(basicLikeTable instanceof PostgresTable)) {
                                basicLikeTable = null;
                            }
                            if ((object = (table = (PostgresTable)basicLikeTable)) == null || (object = this.this$0.AbstractScriptingService.this.currentScopeName((BasicSchemaObject)object)) == null) {
                                String string = this.$fk.getTableName();
                                object = string != null ? this.this$0.AbstractScriptingService.this.getScr(string) : null;
                            }
                            Object tableName = object;
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "alter table " + (String)tableName, null, false, 6, null);
                            CodeTextBuilder.indent$default(this.this$0.getBuilder(), null, 1, null);
                            CreatingGenerator.access$addOuterConstraintNameAndIndent(this.this$0, this.$name);
                            String w1 = this.$name == null ? "add " : "";
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), w1 + ("foreign key (" + CollectionsKt.joinToString$default((Iterable)this.$fk.getColNames(), null, null, null, (int)0, null, null, (int)63, null) + ") " + this.$w), null, false, 6, null);
                            this.this$0.generateCascadeRules(this.$fk);
                            this.this$0.generateDeferrability(this.$fk);
                        }
                    }
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$name = string;
                    this.$w = string2;
                    this.$fk = basicForeignKey;
                    super(0);
                }
            }, 3, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void generateCascadeRules(@NotNull BasicForeignKey fk) {
            Intrinsics.checkParameterIsNotNull((Object)fk, (String)"fk");
            String c1 = ScriptingUtilsKt.concatIfNotNull("on update ", this.makeCascadeRuleKeyword(fk.getOnUpdate()));
            String c2 = ScriptingUtilsKt.concatIfNotNull("on delete ", this.makeCascadeRuleKeyword(fk.getOnDelete()));
            String c = ScriptingUtilsKt.concatWithSpace(c1, c2);
            if (c != null) {
                CodeTextBuilder this_$iv = this.getBuilder();
                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                try {
                    CodeTextBuilder.append$default(this.getBuilder(), c, null, false, 6, null);
                }
                finally {
                    this_$iv.unindent();
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        protected String makeCascadeRuleKeyword(@Nullable CascadeRule rule) {
            CascadeRule cascadeRule = rule;
            if (cascadeRule == null) return null;
            switch (AbstractScriptingService$CreatingGenerator$WhenMappings.$EnumSwitchMapping$3[cascadeRule.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    String string = rule.keyWord;
                    return string;
                }
                default: {
                    return null;
                }
            }
        }

        protected void generateCheck(@NotNull BasicCheck check) {
            Object w1;
            Intrinsics.checkParameterIsNotNull((Object)check, (String)"check");
            String name = check.getNaturalName();
            String def = "check (" + check.getPredicate() + ")";
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = "";
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, name, check, (Ref.ObjectRef)w1, def){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ BasicCheck $check;
                final /* synthetic */ Ref.ObjectRef $w1;
                final /* synthetic */ String $def;

                public final void invoke() {
                    switch (AbstractScriptingService$CreatingGenerator$WhenMappings.$EnumSwitchMapping$4[this.this$0.getContext().ordinal()]) {
                        case 1: 
                        case 2: {
                            this.this$0.addInnerConstraintNameAndIndent(this.$name);
                            break;
                        }
                        default: {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "alter table " + this.$check.getTableName(), null, false, 6, null);
                            CodeTextBuilder.indent$default(this.this$0.getBuilder(), null, 1, null);
                            CreatingGenerator.access$addOuterConstraintNameAndIndent(this.this$0, this.$name);
                            if (this.$name != null) break;
                            this.$w1.element = "add ";
                        }
                    }
                    this.this$0.generateDeferrability(this.$check);
                    String text = (String)this.$w1.element + this.$def;
                    if (Intrinsics.areEqual((Object)((Object)this.this$0.getContext()), (Object)((Object)ScriptContext.IN_TABLE))) {
                        text = text + ',';
                    }
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), text, null, false, 6, null);
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$name = string;
                    this.$check = basicCheck;
                    this.$w1 = objectRef;
                    this.$def = string2;
                    super(0);
                }
            }, 3, null);
            w1 = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void generateDeferrability(@NotNull BasicConstraint constraint) {
            Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
            String dfr = this.makeDeferrability(constraint);
            if (dfr != null) {
                CodeTextBuilder this_$iv = this.getBuilder();
                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                try {
                    CodeTextBuilder.append$default(this.getBuilder(), dfr, null, false, 6, null);
                }
                finally {
                    this_$iv.unindent();
                }
            }
        }

        @Nullable
        protected String makeDeferrability(@NotNull BasicConstraint constraint) {
            Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
            return constraint.isDeferrable() ? (constraint.isInitiallyDeferred() ? "deferrable initially deferred" : "deferrable") : null;
        }

        protected final void addInnerConstraintNameAndIndent(@Nullable String name) {
            if (name != null) {
                CodeTextBuilder.append$default(this.getBuilder(), "constraint " + name, null, false, 6, null);
                CodeTextBuilder.indent$default(this.getBuilder(), null, 1, null);
            }
        }

        private final void addOuterConstraintNameAndIndent(String name) {
            if (name != null) {
                CodeTextBuilder.append$default(this.getBuilder(), "add constraint " + name, null, false, 6, null);
                CodeTextBuilder.indent$default(this.getBuilder(), null, 1, null);
            }
        }

        protected void generateTrigger(@NotNull BasicTrigger trigger2) {
            Intrinsics.checkParameterIsNotNull((Object)trigger2, (String)"trigger");
            if (trigger2 instanceof BasicSourceAware) {
                this.generateUnspecificSourceAwareElement((BasicSourceAware)((Object)trigger2), false);
            } else {
                CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, trigger2){
                    final /* synthetic */ CreatingGenerator this$0;
                    final /* synthetic */ BasicTrigger $trigger;

                    public final void invoke() {
                        String triggerName = this.$trigger instanceof BasicSchemaObject ? this.this$0.AbstractScriptingService.this.currentScopeName((BasicSchemaObject)((Object)this.$trigger)) : this.this$0.AbstractScriptingService.this.getScr(this.$trigger.getName());
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), "-- Unknown how to generate trigger " + triggerName, null, false, 6, null);
                    }
                    {
                        this.this$0 = creatingGenerator;
                        this.$trigger = basicTrigger;
                        super(0);
                    }
                }, 3, null);
            }
        }

        protected void generateUnspecificSourceAwareElement(@NotNull BasicSourceAware element, boolean processChildren) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            CompositeText st = element.getSourceText();
            if (st != null) {
                JBIterable jBIterable = JBIterable.from(st.getFragments()).split(JBIterable.Split.OFF, (Condition)generateUnspecificSourceAwareElement.statements.1.INSTANCE);
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(st.fragm\u2026eText.Kind.SQL_DELIMITER}");
                JBIterable statements2 = jBIterable;
                for (JBIterable statementFragments : statements2) {
                    CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, statementFragments){
                        final /* synthetic */ CreatingGenerator this$0;
                        final /* synthetic */ JBIterable $statementFragments;

                        public final void invoke() {
                            for (CompositeText.Fragment fragment : this.$statementFragments) {
                                CodeTextBuilder.append$default(this.this$0.getBuilder(), fragment, false, 2, null);
                            }
                            this.this$0.getBuilder().ensureEoln();
                        }
                        {
                            this.this$0 = creatingGenerator;
                            this.$statementFragments = jBIterable;
                            super(0);
                        }
                    }, 3, null);
                }
            }
            if (element.getComment() != null) {
                this.generateComment(element);
                if (element instanceof BasicView) {
                    NamingFamily columns = ((BasicView)element).getColumns();
                    Iterator iterator = columns.iterator();
                    while (iterator.hasNext()) {
                        BasicColumn column;
                        BasicColumn basicColumn = column = (BasicColumn)iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)basicColumn, (String)"column");
                        this.generateComment(basicColumn);
                    }
                }
            }
            if (processChildren) {
                this.processElementChildren(element);
            }
        }

        public static /* bridge */ /* synthetic */ void generateUnspecificSourceAwareElement$default(CreatingGenerator creatingGenerator, BasicSourceAware basicSourceAware, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateUnspecificSourceAwareElement");
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            creatingGenerator.generateUnspecificSourceAwareElement(basicSourceAware, bl);
        }

        protected void processElementChildren(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            JBIterable<? extends BasicElement> children = element.getDbChildren();
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                BasicElement child;
                BasicElement basicElement = child = (BasicElement)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"child");
                if (!this.canGenerateInnerElement(basicElement) || !(AbstractScriptingService.this.getGenerated().contains(child) ^ true) || !(this.getDeck().contains(child) ^ true)) continue;
                BasicElement basicElement2 = child;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement2, (String)"child");
                this.processElement(basicElement2);
            }
        }

        protected boolean canGenerateInnerElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            return element instanceof BasicSchemaObject || element instanceof BasicSourceAware;
        }

        protected void generateComment(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            BasicElement basicElement = element;
            if (basicElement instanceof BasicLikeTable) {
                this.generateTableComment((BasicLikeTable)element);
            } else if (basicElement instanceof BasicColumn) {
                this.generateColumnComment((BasicColumn)element);
            }
        }

        protected void generateTableComment(@NotNull BasicLikeTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            String string = table.getComment();
            if (string == null || (string = AbstractScriptingService.this.getSqlString(string)) == null) {
                return;
            }
            String comment = string;
            ObjectKind kind = table.getKind();
            String w = Intrinsics.areEqual((Object)kind, (Object)ObjectKind.MAT_VIEW) ? "materialized view" : kind.code();
            String name = table instanceof BasicSchemaObject ? AbstractScriptingService.this.currentScopeName((BasicSchemaObject)((Object)table)) : AbstractScriptingService.this.getScr(table.getName());
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, w, name, comment){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ String $w;
                final /* synthetic */ String $name;
                final /* synthetic */ String $comment;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "comment on " + this.$w + " " + this.$name + " is " + this.$comment, null, false, 6, null);
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$w = string;
                    this.$name = string2;
                    this.$comment = string3;
                    super(0);
                }
            }, 3, null);
        }

        protected void generateColumnComment(@NotNull BasicColumn column) {
            BasicSchemaObject table;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            BasicLikeTable basicLikeTable = column.getTable();
            if (!(basicLikeTable instanceof BasicSchemaObject)) {
                basicLikeTable = null;
            }
            if ((object = (table = (BasicSchemaObject)((Object)basicLikeTable))) == null || (object = AbstractScriptingService.this.currentScopeName((BasicSchemaObject)object)) == null) {
                object = AbstractScriptingService.this.getScr(column.getTableName());
            }
            Object tableName = object;
            String columnName = AbstractScriptingService.this.getScr(column.getName());
            String string = column.getComment();
            if (string == null || (string = AbstractScriptingService.this.getSqlString(string)) == null) {
                return;
            }
            String comment = string;
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, (String)tableName, columnName, comment){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ String $tableName;
                final /* synthetic */ String $columnName;
                final /* synthetic */ String $comment;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "comment on column " + this.$tableName + "." + this.$columnName + " is " + this.$comment, null, false, 6, null);
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$tableName = string;
                    this.$columnName = string2;
                    this.$comment = string3;
                    super(0);
                }
            }, 3, null);
        }

        protected boolean canGenerateElementRightNow(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            if (element instanceof BasicMinorObject && this.getContext().compareTo((Enum)ScriptContext.IN_TABLE) < 0) {
                BasicMajorObject majorObject = ((BasicMinorObject)element).getMajorObject();
                return majorObject == null || AbstractScriptingService.this.getGenerated().contains(majorObject);
            }
            return true;
        }

        protected void generateSynonym(@NotNull BasicSynonym synonym) {
            Intrinsics.checkParameterIsNotNull((Object)synonym, (String)"synonym");
            String targetSpec = this.makeSynonymTargetSpec(synonym);
            String name = AbstractScriptingService.this.currentScopeName(synonym);
            String text = targetSpec != null ? this.getCreateOrReplace() + " synonym " + name + " for " + targetSpec : "-- unknown what the synonym " + name + " references on :(";
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, text){
                final /* synthetic */ CreatingGenerator this$0;
                final /* synthetic */ String $text;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$text, null, false, 6, null);
                }
                {
                    this.this$0 = creatingGenerator;
                    this.$text = string;
                    super(0);
                }
            }, 3, null);
        }

        @Nullable
        protected String makeSynonymTargetSpec(@NotNull BasicSynonym synonym) {
            Intrinsics.checkParameterIsNotNull((Object)synonym, (String)"synonym");
            BasicMajorObject targetObject = synonym.getTargetObject();
            if (targetObject != null) {
                return AbstractScriptingService.this.currentScopeName(targetObject);
            }
            String schemaName = synonym.getTargetSchemaName();
            String string = synonym.getTargetObjectName();
            if (string == null) {
                return null;
            }
            String objectName = string;
            return schemaName == null ? AbstractScriptingService.this.getScr(objectName) : AbstractScriptingService.this.getScr(schemaName) + "." + AbstractScriptingService.this.getScr(objectName);
        }

        protected final void weDontKnowHowToGenerateThis(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            CodeTextBuilder codeTextBuilder = this.getBuilder();
            StringBuilder stringBuilder = new StringBuilder().append("-- we don't know how to generate ").append(element.getKind().code()).append(" ");
            String string = element.getRealName();
            if (string == null) {
                string = "<with-no-name>";
            }
            CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string).append(" (class ").append(element.getClass().getSimpleName()).append(") :( --").toString(), null, false, 6, null);
        }

        public CreatingGenerator(ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(task);
            this.tableElementsApplicableInExactTask = SetsKt.setOf((Object[])new ObjectKind[]{ObjectKind.INDEX, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.CHECK});
        }

        public static final /* synthetic */ void access$addOuterConstraintNameAndIndent(CreatingGenerator $this, @Nullable String name) {
            $this.addOuterConstraintNameAndIndent(name);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lcom/intellij/database/scripting/AbstractScriptingService$StupidGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/AbstractScriptingService;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateElement", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "database-scripting"})
    protected final class StupidGenerator
    extends CodeGenerator {
        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, element){
                final /* synthetic */ StupidGenerator this$0;
                final /* synthetic */ BasicElement $element;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "-- " + this.$element.getKind().code() + " " + this.$element.getName(), null, false, 6, null);
                }
                {
                    this.this$0 = stupidGenerator;
                    this.$element = basicElement;
                    super(0);
                }
            }, 3, null);
        }

        public StupidGenerator(ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(task);
            CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(){

                public final void invoke() {
                    CodeTextBuilder.append$default(this.getBuilder(), "-- We don't know how to generate " + this.getTask().name() + " :(", null, false, 6, null);
                }
            }, 3, null);
        }
    }
}

