/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.mssql.MsDatabase;
import com.intellij.database.model.mssql.MsModel;
import com.intellij.database.model.mysql.MysqlModel;
import com.intellij.database.model.oracle.OraModel;
import com.intellij.database.model.postgres.PostgresDatabase;
import com.intellij.database.model.postgres.PostgresModel;
import com.intellij.database.model.sqlite.SqliteModel;
import com.intellij.database.scripting.AbstractScriptingService;
import com.intellij.database.scripting.GenericScriptingService;
import com.intellij.database.scripting.MsScriptingService;
import com.intellij.database.scripting.MysqlScriptingService;
import com.intellij.database.scripting.OraScriptingService;
import com.intellij.database.scripting.PostgresScriptingService;
import com.intellij.database.scripting.ScriptingFactory;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.SqliteScriptingService;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Sqlite;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/scripting/ModernScriptingFactory;", "Lcom/intellij/database/scripting/ScriptingFactory;", "()V", "createScriptingService", "Lcom/intellij/database/scripting/ScriptingService;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "getCurrentScriptingVersion", "", "rdbms", "Lorg/jetbrains/dekaf/Rdbms;", "kind", "Lcom/intellij/database/model/ObjectKind;", "database-scripting"})
public final class ModernScriptingFactory
implements ScriptingFactory {
    @Override
    public int getCurrentScriptingVersion(@NotNull Rdbms rdbms, @NotNull ObjectKind kind) {
        Intrinsics.checkParameterIsNotNull((Object)rdbms, (String)"rdbms");
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        Rdbms rdbms2 = rdbms;
        return Intrinsics.areEqual((Object)rdbms2, (Object)Oracle.RDBMS) ? OraScriptingService.VERSION.INSTANCE.get(kind) : (Intrinsics.areEqual((Object)rdbms2, (Object)Postgres.RDBMS) ? PostgresScriptingService.VERSION.INSTANCE.get(kind) : (Intrinsics.areEqual((Object)rdbms2, (Object)Sqlite.RDBMS) ? SqliteScriptingService.VERSION.INSTANCE.get(kind) : (Intrinsics.areEqual((Object)rdbms2, (Object)Mssql.RDBMS) ? MsScriptingService.VERSION.INSTANCE.get(kind) : (Intrinsics.areEqual((Object)rdbms2, (Object)Mysql.RDBMS) ? MysqlScriptingService.VERSION.INSTANCE.get(kind) : GenericScriptingService.VERSION.INSTANCE.get(kind)))));
    }

    @Override
    @NotNull
    public ScriptingService createScriptingService(@NotNull BasicModel model, @Nullable BasicDatabase database) {
        AbstractScriptingService abstractScriptingService;
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        BasicDatabase basicDatabase = database;
        if (basicDatabase == null) {
            basicDatabase = model.getRoot().getCurrentDatabase();
        }
        if (basicDatabase == null) {
            throw (Throwable)new IllegalArgumentException("Database must be current or specified explicitly");
        }
        BasicDatabase db = basicDatabase;
        BasicModel basicModel = model;
        if (basicModel instanceof OraModel) {
            abstractScriptingService = new OraScriptingService((OraModel)model);
        } else if (basicModel instanceof PostgresModel) {
            BasicDatabase basicDatabase2 = db;
            if (basicDatabase2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.postgres.PostgresDatabase");
            }
            abstractScriptingService = new PostgresScriptingService((PostgresModel)model, (PostgresDatabase)basicDatabase2);
        } else if (basicModel instanceof MsModel) {
            BasicDatabase basicDatabase3 = db;
            if (basicDatabase3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.mssql.MsDatabase");
            }
            abstractScriptingService = new MsScriptingService((MsModel)model, (MsDatabase)basicDatabase3);
        } else {
            abstractScriptingService = basicModel instanceof MysqlModel ? (AbstractScriptingService)new MysqlScriptingService((MysqlModel)model) : (basicModel instanceof SqliteModel ? (AbstractScriptingService)new SqliteScriptingService((SqliteModel)model) : (AbstractScriptingService)new GenericScriptingService(model, db));
        }
        AbstractScriptingService service = abstractScriptingService;
        service.init$database_scripting();
        return service;
    }
}

