/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.DataType;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.postgres.PostgresDatabase;
import com.intellij.database.model.postgres.PostgresDefType;
import com.intellij.database.model.postgres.PostgresDefTypeAttribute;
import com.intellij.database.model.postgres.PostgresDefTypeCheck;
import com.intellij.database.model.postgres.PostgresModel;
import com.intellij.database.model.postgres.PostgresModelFun;
import com.intellij.database.model.postgres.PostgresOperator;
import com.intellij.database.model.postgres.PostgresRoutine;
import com.intellij.database.model.postgres.PostgresSchema;
import com.intellij.database.model.postgres.PostgresSequence;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.postgres.PostgresTableColumn;
import com.intellij.database.model.postgres.PostgresTrigger;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.database.scripting.AbstractScriptingService;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.PostgresNamingService;
import com.intellij.database.scripting.PostgresScriptingService;
import com.intellij.database.scripting.PostgresScriptingService$PgCreatingGenerator$WhenMappings;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0002\u0013\u0014B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J&\u0010\b\u001a\u00180\tR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0014J\r\u0010\f\u001a\u00020\rH\u0010\u00a2\u0006\u0002\b\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/scripting/PostgresScriptingService;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/postgres/PostgresModel;", "Lcom/intellij/database/model/postgres/PostgresDatabase;", "Lcom/intellij/database/model/postgres/PostgresSchema;", "model", "database", "(Lcom/intellij/database/model/postgres/PostgresModel;Lcom/intellij/database/model/postgres/PostgresDatabase;)V", "createCreatingGenerator", "Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "init", "", "init$database_scripting", "thinkOutFunDelimiter", "", "text", "", "PgCreatingGenerator", "VERSION", "database-scripting"})
public final class PostgresScriptingService
extends AbstractScriptingService<PostgresModel, PostgresDatabase, PostgresSchema> {
    @Override
    public void init$database_scripting() {
        super.init$database_scripting();
        this.setNaming(PostgresNamingService.INSTANCE);
    }

    @Override
    @NotNull
    protected AbstractScriptingService.CodeGenerator createCreatingGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new PgCreatingGenerator(task);
    }

    private final String thinkOutFunDelimiter(CharSequence text) {
        String string;
        StringBuilder stringBuilder;
        String string2;
        char c;
        String d = "$$";
        if (StringsKt.contains$default((CharSequence)text, (CharSequence)d, (boolean)false, (int)2, null)) {
            c = '$';
            string2 = "fun";
            stringBuilder = new StringBuilder();
            string = String.valueOf(c) + string2;
            d = stringBuilder.append(string).append('$').toString();
        }
        if (StringsKt.contains$default((CharSequence)text, (CharSequence)d, (boolean)false, (int)2, null)) {
            c = '$';
            string2 = "function";
            stringBuilder = new StringBuilder();
            string = String.valueOf(c) + string2;
            d = stringBuilder.append(string).append('$').toString();
        }
        return d;
    }

    public PostgresScriptingService(@NotNull PostgresModel model, @NotNull PostgresDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        super((BasicModel)model, (BasicDatabase)database);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020'H\u0014J\u0010\u0010(\u001a\u00020\n2\u0006\u0010#\u001a\u00020)H\u0014J\u0014\u0010*\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010-H\u0014J\u0012\u0010.\u001a\u0004\u0018\u00010+2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0012\u0010/\u001a\u0004\u0018\u00010+2\u0006\u0010\u000b\u001a\u000200H\u0002J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0014\u00a8\u00065"}, d2={"Lcom/intellij/database/scripting/PostgresScriptingService$PgCreatingGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService$CreatingGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/postgres/PostgresModel;", "Lcom/intellij/database/model/postgres/PostgresDatabase;", "Lcom/intellij/database/model/postgres/PostgresSchema;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/PostgresScriptingService;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateColumn", "", "column", "Lcom/intellij/database/model/basic/BasicColumn;", "generateComposite", "struct", "Lcom/intellij/database/model/postgres/PostgresDefType;", "generateDefType", "dt", "generateDomain", "d", "generateElement", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateEnum", "e", "generateFunction", "f", "Lcom/intellij/database/model/postgres/PostgresRoutine;", "generateOperator", "op", "Lcom/intellij/database/model/postgres/PostgresOperator;", "generatePostgresDefTypeCheck", "check", "Lcom/intellij/database/model/postgres/PostgresDefTypeCheck;", "generatePostgresTrigger", "trigger", "Lcom/intellij/database/model/postgres/PostgresTrigger;", "generateSequence", "sequence", "Lcom/intellij/database/model/basic/BasicSequence;", "generateTrigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "makeCascadeRuleKeyword", "", "rule", "Lcom/intellij/database/model/properties/CascadeRule;", "makeNormalColumnSpecification", "makeSerialColumnSpecification", "Lcom/intellij/database/model/postgres/PostgresTableColumn;", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "table", "Lcom/intellij/database/model/basic/BasicTable;", "database-scripting"})
    private final class PgCreatingGenerator
    extends AbstractScriptingService.CreatingGenerator {
        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            BasicElement basicElement = element;
            if (basicElement instanceof PostgresDefType) {
                this.generateDefType((PostgresDefType)element);
            } else if (basicElement instanceof PostgresRoutine) {
                this.generateFunction((PostgresRoutine)element);
            } else if (basicElement instanceof PostgresOperator) {
                this.generateOperator((PostgresOperator)element);
            } else if (basicElement instanceof PostgresDefTypeCheck) {
                this.generatePostgresDefTypeCheck((PostgresDefTypeCheck)element);
            } else {
                super.generateElement(element);
            }
        }

        @Override
        protected void generateSequence(@NotNull BasicSequence sequence) {
            Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
            if (!(sequence instanceof PostgresSequence) || !((PostgresSequence)sequence).isBelongsToColumn()) {
                super.generateSequence(sequence);
            }
        }

        @Override
        @NotNull
        protected HeaderFooter makeTableHeaderFooter(@NotNull BasicTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            HeaderFooter hf = super.makeTableHeaderFooter(table);
            BasicTable basicTable = table;
            if (!(basicTable instanceof PostgresTable)) {
                basicTable = null;
            }
            PostgresTable postgresTable = (PostgresTable)basicTable;
            if (postgresTable == null) {
                return hf;
            }
            PostgresTable t = postgresTable;
            Collection collection = t.getAncestorIds();
            if (!collection.isEmpty()) {
                List<PostgresTable> ancestors = PostgresModelFun.getAncestors(t);
                String footer2 = "inherits (" + CollectionsKt.joinToString$default((Iterable)ancestors, null, null, null, (int)0, null, (Function1)((Function1)new Function1<PostgresTable, String>(this){
                    final /* synthetic */ PgCreatingGenerator this$0;

                    @NotNull
                    public final String invoke(@NotNull PostgresTable it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return this.this$0.PostgresScriptingService.this.currentScopeName(it);
                    }
                    {
                        this.this$0 = pgCreatingGenerator;
                        super(1);
                    }
                }), (int)31, null) + ")";
                hf = new HeaderFooter(hf.getHeader(), footer2);
            }
            return hf;
        }

        @Override
        protected void generateColumn(@NotNull BasicColumn column) {
            PostgresSchema schema;
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            if (column instanceof PostgresTableColumn && ((PostgresTableColumn)column).isInherited()) {
                return;
            }
            super.generateColumn(column);
            if (column instanceof PostgresTableColumn && ((PostgresTableColumn)column).getSequenceName() != null && (schema = ((PostgresTableColumn)column).getSchema()) != null) {
                PostgresSequence sequence;
                NamingIdentifyingFamily<? extends PostgresSequence> namingIdentifyingFamily = schema.getSequences();
                String string = ((PostgresTableColumn)column).getSequenceName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                if ((sequence = (PostgresSequence)namingIdentifyingFamily.get(string)) != null) {
                    PostgresScriptingService.this.getGenerated().add(sequence);
                }
            }
        }

        @Override
        @Nullable
        protected String makeNormalColumnSpecification(@NotNull BasicColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            return column instanceof PostgresTableColumn && ((PostgresTableColumn)column).getSequenceName() != null ? this.makeSerialColumnSpecification((PostgresTableColumn)column) : super.makeNormalColumnSpecification(column);
        }

        private final String makeSerialColumnSpecification(PostgresTableColumn column) {
            String specification;
            DataType dt = column.getDataType();
            SequenceIdentity sq = column.getSequenceIdentity();
            String string = StringsKt.startsWith$default((String)dt.typeName, (String)"small", (boolean)false, (int)2, null) ? "smallserial" : (specification = StringsKt.startsWith$default((String)dt.typeName, (String)"big", (boolean)false, (int)2, null) ? "bigserial" : "serial");
            if (column.isNotNull()) {
                specification = specification + " not null";
            }
            return specification;
        }

        private final void generateFunction(PostgresRoutine f) {
            CharSequence text;
            String name = PostgresScriptingService.this.currentScopeName(f);
            String string = f.getArgumentsDefinition();
            if (string == null) {
                string = "";
            }
            String ad = string;
            String rd = f.getResultsDefinition();
            String language = f.getLanguageName();
            CharSequence charSequence = f.getOriginalSourceText();
            if (charSequence == null) {
                return;
            }
            CharSequence charSequence2 = text = charSequence;
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence2, (String)"text");
            String d = PostgresScriptingService.this.thinkOutFunDelimiter(charSequence2);
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, name, rd, ad, language, d, text){
                final /* synthetic */ PgCreatingGenerator this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ String $rd;
                final /* synthetic */ String $ad;
                final /* synthetic */ String $language;
                final /* synthetic */ String $d;
                final /* synthetic */ CharSequence $text;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    String prefix = "create function " + this.$name + "(";
                    String suffix = ")";
                    if (this.$rd != null) {
                        suffix = suffix + (" returns " + this.$rd);
                    }
                    this.this$0.getBuilder().append(prefix, CompositeText.Kind.FIXED_TEXT, false);
                    this.this$0.getBuilder().append(this.$ad, CompositeText.Kind.SPECIFICATION_TEXT, false);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), suffix, CompositeText.Kind.FIXED_TEXT, false, 4, null);
                    if (this.$language != null) {
                        CodeTextBuilder this_$iv = this.this$0.getBuilder();
                        CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                        try {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "language " + this.$language, null, false, 6, null);
                        }
                        finally {
                            this_$iv.unindent();
                        }
                    }
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "as " + this.$d, null, false, 6, null);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), ScriptingUtilsKt.removeHeadingEmptyLines(this.$text), CompositeText.Kind.ORIGINAL_TEXT, false, 4, null);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$d, null, false, 6, null);
                }
                {
                    this.this$0 = pgCreatingGenerator;
                    this.$name = string;
                    this.$rd = string2;
                    this.$ad = string3;
                    this.$language = string4;
                    this.$d = string5;
                    this.$text = charSequence;
                    super(0);
                }
            }, 3, null);
        }

        @Override
        protected void generateTrigger(@NotNull BasicTrigger trigger2) {
            Intrinsics.checkParameterIsNotNull((Object)trigger2, (String)"trigger");
            if (trigger2 instanceof PostgresTrigger) {
                this.generatePostgresTrigger((PostgresTrigger)trigger2);
            } else if (trigger2 instanceof BasicSourceAware) {
                this.generateUnspecificSourceAwareElement((BasicSourceAware)((Object)trigger2), false);
            }
        }

        private final void generatePostgresTrigger(PostgresTrigger trigger2) {
            PostgresRoutine postgresRoutine = PostgresModelFun.getCallRoutine(trigger2);
            if (postgresRoutine == null) {
                return;
            }
            PostgresRoutine routine2 = postgresRoutine;
            if (Intrinsics.areEqual((Object)((Object)this.getTask()), (Object)((Object)ScriptingTask.CREATE_EXACT)) ^ true && (this.getDeck().contains(routine2) || PostgresScriptingService.this.getGenerated().contains(routine2) ^ true)) {
                this.process(routine2);
            }
            String triggerName = PostgresScriptingService.this.getScr(trigger2.getName());
            String string = trigger2.getTableName();
            if (string == null || (string = PostgresScriptingService.this.getScr(string)) == null) {
                return;
            }
            String tableName = string;
            String routineName = PostgresScriptingService.this.currentScopeName(routine2);
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, triggerName, trigger2, tableName, routineName){
                final /* synthetic */ PgCreatingGenerator this$0;
                final /* synthetic */ String $triggerName;
                final /* synthetic */ PostgresTrigger $trigger;
                final /* synthetic */ String $tableName;
                final /* synthetic */ String $routineName;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "create trigger " + this.$triggerName, null, false, 6, null);
                    CodeTextBuilder this_$iv = this.this$0.getBuilder();
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        String ev = ScriptingUtilsKt.makeTriggerEventString(this.$trigger);
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), ev, null, false, 6, null);
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), "on " + this.$tableName, null, false, 6, null);
                        TrigTurn turn = this.$trigger.getTurn();
                        if (Intrinsics.areEqual((Object)((Object)turn), (Object)((Object)TrigTurn.BEFORE_ROW)) || Intrinsics.areEqual((Object)((Object)turn), (Object)((Object)TrigTurn.AFTER_ROW)) || Intrinsics.areEqual((Object)((Object)turn), (Object)((Object)TrigTurn.INSTEAD_OF))) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "for each row", null, false, 6, null);
                        }
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), "execute procedure " + this.$routineName + "()", null, false, 6, null);
                    }
                    finally {
                        this_$iv.unindent();
                    }
                }
                {
                    this.this$0 = pgCreatingGenerator;
                    this.$triggerName = string;
                    this.$trigger = postgresTrigger;
                    this.$tableName = string2;
                    this.$routineName = string3;
                    super(0);
                }
            }, 3, null);
        }

        @Override
        @Nullable
        protected String makeCascadeRuleKeyword(@Nullable CascadeRule rule) {
            return rule != null && Intrinsics.areEqual((Object)((Object)rule), (Object)((Object)CascadeRule.no_action)) ^ true ? rule.keyWord : null;
        }

        private final void generateDefType(PostgresDefType dt) {
            switch (PostgresScriptingService$PgCreatingGenerator$WhenMappings.$EnumSwitchMapping$0[dt.getSubKind().ordinal()]) {
                case 1: {
                    this.generateEnum(dt);
                    break;
                }
                case 2: {
                    this.generateDomain(dt);
                    break;
                }
                case 3: {
                    this.generateComposite(dt);
                }
            }
        }

        private final void generateEnum(PostgresDefType e) {
            String name = PostgresScriptingService.this.currentScopeName(e);
            String labels2 = CollectionsKt.joinToString$default((Iterable)e.getLabels(), null, null, null, (int)0, null, (Function1)generateEnum.labels.1.INSTANCE, (int)31, null);
            String cmd = "create type " + name + " as enum (" + labels2 + ")";
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, cmd){
                final /* synthetic */ PgCreatingGenerator this$0;
                final /* synthetic */ String $cmd;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$cmd, null, false, 6, null);
                }
                {
                    this.this$0 = pgCreatingGenerator;
                    this.$cmd = string;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateDomain(PostgresDefType d) {
            String name = PostgresScriptingService.this.currentScopeName(d);
            String def = d.getDefinition();
            String cmd = "create domain " + name + " as " + def + (d.isNotNull() ? " not null" : "");
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, cmd, d){
                final /* synthetic */ PgCreatingGenerator this$0;
                final /* synthetic */ String $cmd;
                final /* synthetic */ PostgresDefType $d;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$cmd, null, false, 6, null);
                    AbstractScriptingService.CodeGenerator.coding$default(this.this$0, null, true, (Function0)new Function0<Unit>(this){
                        final /* synthetic */ generateDomain.1 this$0;

                        public final void invoke() {
                            if (this.this$0.$d.getDefaultExpression() != null) {
                                CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), "default " + this.this$0.$d.getDefaultExpression(), null, false, 6, null);
                            }
                            for (PostgresDefTypeCheck postgresDefTypeCheck : this.this$0.$d.getChecks()) {
                                PgCreatingGenerator pgCreatingGenerator = this.this$0.this$0;
                                PostgresDefTypeCheck postgresDefTypeCheck2 = postgresDefTypeCheck;
                                Intrinsics.checkExpressionValueIsNotNull((Object)postgresDefTypeCheck2, (String)"check");
                                PgCreatingGenerator.access$generatePostgresDefTypeCheck(pgCreatingGenerator, postgresDefTypeCheck2);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }, 1, null);
                }
                {
                    this.this$0 = pgCreatingGenerator;
                    this.$cmd = string;
                    this.$d = postgresDefType;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateComposite(PostgresDefType struct) {
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, struct){
                final /* synthetic */ PgCreatingGenerator this$0;
                final /* synthetic */ PostgresDefType $struct;

                public final void invoke() {
                    String name = this.this$0.PostgresScriptingService.this.currentScopeName(this.$struct);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "create type " + name + " as", null, false, 6, null);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "(", null, false, 6, null);
                    CodeTextBuilder.indent$default(this.this$0.getBuilder(), null, 1, null);
                    for (PostgresDefTypeAttribute postgresDefTypeAttribute : this.$struct.getAttributes()) {
                        String n = this.this$0.PostgresScriptingService.this.getScr(postgresDefTypeAttribute.getName());
                        DataType t = postgresDefTypeAttribute.getDataType();
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), n + " " + t + ",", null, false, 6, null);
                    }
                    this.this$0.getBuilder().removeSuffixFromTheLastLine(',');
                    this.this$0.getBuilder().unindent();
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), ")", null, false, 6, null);
                }
                {
                    this.this$0 = pgCreatingGenerator;
                    this.$struct = postgresDefType;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateOperator(PostgresOperator op) {
            ArrayList<String> props = new ArrayList<String>(4);
            if (op.getCallRoutineName() != null) {
                StringBuilder stringBuilder = new StringBuilder().append("procedure = ");
                String string = op.getCallRoutineName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                props.add(stringBuilder.append(PostgresScriptingService.this.getScr(string)).toString());
            }
            if (Intrinsics.areEqual((Object)op.getLeftType(), (Object)DataType.UNKNOWN) ^ true) {
                props.add("leftarg = " + op.getLeftType().getSpecification());
            }
            if (Intrinsics.areEqual((Object)op.getRightType(), (Object)DataType.UNKNOWN) ^ true) {
                props.add("rightarg = " + op.getRightType().getSpecification());
            }
            String specification = CollectionsKt.joinToString$default((Iterable)props, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            String cmd = "create operator " + op.getName() + " (" + specification + ")";
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, cmd){
                final /* synthetic */ PgCreatingGenerator this$0;
                final /* synthetic */ String $cmd;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$cmd, null, false, 6, null);
                }
                {
                    this.this$0 = pgCreatingGenerator;
                    this.$cmd = string;
                    super(0);
                }
            }, 3, null);
        }

        private final void generatePostgresDefTypeCheck(PostgresDefTypeCheck check) {
            String string = check.getNaturalName();
            String name = string != null ? PostgresScriptingService.this.getScr(string) : null;
            String string2 = check.getPredicate();
            if (string2 == null) {
                return;
            }
            String predicate = string2;
            String txt = (name != null ? "constraint " + name + " " : "") + "check " + predicate;
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, txt){
                final /* synthetic */ PgCreatingGenerator this$0;
                final /* synthetic */ String $txt;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$txt, null, false, 6, null);
                }
                {
                    this.this$0 = pgCreatingGenerator;
                    this.$txt = string;
                    super(0);
                }
            }, 3, null);
            PostgresScriptingService.this.getGenerated().add(check);
        }

        public PgCreatingGenerator(ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(task);
        }

        public static final /* synthetic */ void access$generatePostgresDefTypeCheck(PgCreatingGenerator $this, @NotNull PostgresDefTypeCheck check) {
            $this.generatePostgresDefTypeCheck(check);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/scripting/PostgresScriptingService$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "database-scripting"})
    public static final class VERSION
    extends PerObjectVersion {
        public static final VERSION INSTANCE;

        private VERSION() {
            INSTANCE = this;
        }

        static {
            new VERSION();
        }
    }
}

