/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.DataType;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.sqlite.SqliteModel;
import com.intellij.database.model.sqlite.SqliteRoot;
import com.intellij.database.model.sqlite.SqliteSchema;
import com.intellij.database.model.sqlite.SqliteVirtualTable;
import com.intellij.database.scripting.AbortException;
import com.intellij.database.scripting.AbstractScriptingService;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.ScriptContext;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.SqliteNamingService;
import com.intellij.database.scripting.SqliteScriptingService$SqliteCreatingGenerator$WhenMappings;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0002\u000e\u000fB\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0007\u001a\u00180\bR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\t\u001a\u00020\nH\u0014J\r\u0010\u000b\u001a\u00020\fH\u0010\u00a2\u0006\u0002\b\r\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/scripting/SqliteScriptingService;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/sqlite/SqliteModel;", "Lcom/intellij/database/model/sqlite/SqliteRoot;", "Lcom/intellij/database/model/sqlite/SqliteSchema;", "model", "(Lcom/intellij/database/model/sqlite/SqliteModel;)V", "createCreatingGenerator", "Lcom/intellij/database/scripting/AbstractScriptingService$CodeGenerator;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "init", "", "init$database_scripting", "SqliteCreatingGenerator", "VERSION", "database-scripting"})
public final class SqliteScriptingService
extends AbstractScriptingService<SqliteModel, SqliteRoot, SqliteSchema> {
    @Override
    public void init$database_scripting() {
        super.init$database_scripting();
        this.setNaming(SqliteNamingService.INSTANCE);
    }

    @Override
    @NotNull
    protected AbstractScriptingService.CodeGenerator createCreatingGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new SqliteCreatingGenerator(task);
    }

    public SqliteScriptingService(@NotNull SqliteModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        BasicModel basicModel = model;
        SqliteRoot sqliteRoot = model.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)sqliteRoot, (String)"model.root");
        super(basicModel, (BasicDatabase)sqliteRoot);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/scripting/SqliteScriptingService$SqliteCreatingGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService$CreatingGenerator;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/sqlite/SqliteModel;", "Lcom/intellij/database/model/sqlite/SqliteRoot;", "Lcom/intellij/database/model/sqlite/SqliteSchema;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/SqliteScriptingService;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateElement", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateKey", "key", "Lcom/intellij/database/model/basic/BasicKey;", "generateVirtualTable", "table", "Lcom/intellij/database/model/sqlite/SqliteVirtualTable;", "makeNormalColumnSpecification", "", "column", "Lcom/intellij/database/model/basic/BasicColumn;", "shouldAddAutoIncToKey", "", "database-scripting"})
    private final class SqliteCreatingGenerator
    extends AbstractScriptingService.CreatingGenerator {
        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            if (element instanceof SqliteVirtualTable) {
                this.generateVirtualTable((SqliteVirtualTable)element);
            } else {
                super.generateElement(element);
            }
        }

        private final void generateVirtualTable(SqliteVirtualTable table) {
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, table){
                final /* synthetic */ SqliteCreatingGenerator this$0;
                final /* synthetic */ SqliteVirtualTable $table;

                public final void invoke() {
                    String name = this.this$0.SqliteScriptingService.this.currentScopeName(this.$table);
                    String module = this.$table.getModule();
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "create virtual table " + name + " using " + module + "(", null, false, 6, null);
                    for (String argument : this.$table.getArguments()) {
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), argument, CompositeText.Kind.FIXED_TEXT, false, 4, null);
                        this.this$0.getBuilder().addSuffixToTheListLine(',');
                    }
                    this.this$0.getBuilder().removeSuffixFromTheLastLine(',');
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), ")", null, false, 6, null);
                }
                {
                    this.this$0 = sqliteCreatingGenerator;
                    this.$table = sqliteVirtualTable;
                    super(0);
                }
            }, 3, null);
        }

        @Override
        protected void generateKey(@NotNull BasicKey key) {
            boolean indexIsExplicit;
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            String string = key.getNaturalName();
            String name = string != null ? SqliteScriptingService.this.getScr(string) : null;
            String w = key.isPrimary() ? "primary key" : "unique";
            BasicIndex index = null;
            if (key.getUnderlyingIndexName() != null) {
                BasicIndex basicIndex;
                BasicNode basicNode = key.getTable();
                if (basicNode != null && (basicNode = basicNode.getIndices()) != null) {
                    Object v2;
                    block8: {
                        Iterable $receiver$iv = (Iterable)((Object)basicNode);
                        for (Object element$iv : $receiver$iv) {
                            BasicIndex it = (BasicIndex)element$iv;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)key.getUnderlyingIndexName())) continue;
                            v2 = element$iv;
                            break block8;
                        }
                        v2 = null;
                    }
                    basicIndex = v2;
                } else {
                    basicIndex = null;
                }
                index = basicIndex;
            }
            boolean bl = indexIsExplicit = index != null && index.getNaturalName() != null && Intrinsics.areEqual((Object)index.getName(), (Object)key.getName()) ^ true;
            if (indexIsExplicit) {
                Set<BasicElement> set = SqliteScriptingService.this.getGenerated();
                BasicIndex basicIndex = index;
                if (basicIndex == null) {
                    Intrinsics.throwNpe();
                }
                if (set.contains(basicIndex) ^ true) {
                    this.getPostponed().putValue((Object)index, (Object)key);
                    throw (Throwable)new AbortException();
                }
            }
            AbstractScriptingService.CodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, key, name, w){
                final /* synthetic */ SqliteCreatingGenerator this$0;
                final /* synthetic */ BasicKey $key;
                final /* synthetic */ String $name;
                final /* synthetic */ String $w;

                public final void invoke() {
                    boolean autoinc = SqliteCreatingGenerator.access$shouldAddAutoIncToKey(this.this$0, this.$key);
                    switch (SqliteScriptingService$SqliteCreatingGenerator$WhenMappings.$EnumSwitchMapping$0[SqliteCreatingGenerator.access$getContext$p$s526720334(this.this$0).ordinal()]) {
                        case 1: {
                            this.this$0.addInnerConstraintNameAndIndent(this.$name);
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$w, null, false, 6, null);
                            if (autoinc) {
                                CodeTextBuilder.append$default(this.this$0.getBuilder(), " autoincrement", null, false, 6, null);
                            }
                            this.this$0.generateDeferrability(this.$key);
                            break;
                        }
                        case 2: {
                            this.this$0.addInnerConstraintNameAndIndent(this.$name);
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$w + " (" + CollectionsKt.joinToString$default((Iterable)this.$key.getColNames(), null, null, null, (int)0, null, null, (int)63, null) + (autoinc ? " autoincrement" : "") + ")", null, false, 6, null);
                            this.this$0.generateDeferrability(this.$key);
                            this.this$0.getBuilder().addSuffixToTheListLine(',');
                            break;
                        }
                        default: {
                            throw (Throwable)new AbortException();
                        }
                    }
                }
                {
                    this.this$0 = sqliteCreatingGenerator;
                    this.$key = basicKey;
                    this.$name = string;
                    this.$w = string2;
                    super(0);
                }
            }, 3, null);
            if (index != null) {
                SqliteScriptingService.this.getGenerated().add(index);
            }
        }

        @Override
        @Nullable
        protected String makeNormalColumnSpecification(@NotNull BasicColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            DataType dataType = column.getDataType();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"column.dataType");
            String specification = SqliteScriptingService.this.script(dataType);
            if (column.getDefaultExpression() != null) {
                specification = specification + " default " + column.getDefaultExpression();
            }
            if (column.isNotNull()) {
                specification = specification + " not null";
            }
            if (!column.isNotNull() && this.isNullExplicit()) {
                specification = specification + " null";
            }
            return specification;
        }

        private final boolean shouldAddAutoIncToKey(BasicKey key) {
            BasicNode basicNode;
            return key.isPrimary() && key.getColNames().size() == 1 && ((basicNode = key.getTable()) != null && (basicNode = basicNode.getColumns()) != null && (basicNode = (BasicColumn)basicNode.get((String)CollectionsKt.first(key.getColNames()))) != null ? basicNode.isAutoInc() : false);
        }

        public SqliteCreatingGenerator(ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(task);
        }

        public static final /* synthetic */ boolean access$shouldAddAutoIncToKey(SqliteCreatingGenerator $this, @NotNull BasicKey key) {
            return $this.shouldAddAutoIncToKey(key);
        }

        @NotNull
        public static final /* synthetic */ ScriptContext access$getContext$p$s526720334(SqliteCreatingGenerator $this) {
            return super.getContext();
        }

        public static final /* synthetic */ void access$setContext$p$s526720334(SqliteCreatingGenerator $this, @NotNull ScriptContext scriptContext) {
            super.setContext(scriptContext);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/scripting/SqliteScriptingService$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "database-scripting"})
    public static final class VERSION
    extends PerObjectVersion {
        public static final VERSION INSTANCE;

        private VERSION() {
            INSTANCE = this;
        }

        static {
            new VERSION();
        }
    }
}

