/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.serialization;

import com.google.common.collect.ImmutableList;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.serialization.ExportException;
import com.intellij.database.serialization.ModelElementMem;
import com.intellij.database.serialization.ModelMem;
import com.intellij.database.serialization.ModelSerializationVersions;
import com.intellij.database.serialization.MutableNameAndValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ModelExporter {
    private static final Logger LOG = Logger.getInstance(ModelExporter.class);

    public void saveModel(@NotNull BasicModel model, @NotNull HierarchicalStreamWriter writer) throws ExportException {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/serialization/ModelExporter", "saveModel"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/database/serialization/ModelExporter", "saveModel"));
        }
        ModelMem modelMem = model.read(this::exportModel);
        ModelExporter.serializeModel(modelMem, writer);
    }

    public ModelMem exportModel(@NotNull BasicModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/serialization/ModelExporter", "exportModel"));
        }
        ModelMem mm = new ModelMem();
        mm.setRdbms(model.getRdbms());
        mm.setVersion(ModelSerializationVersions.CURRENT_VERSION);
        LinkedHashMap<BasicElement, Integer> nodes2 = ModelExporter.orderNodes(model.getRoot());
        for (BasicElement node : nodes2.keySet()) {
            ModelElementMem om = this.exportElement(node, nodes2);
            mm.getNodes().add(om);
        }
        return mm;
    }

    private static LinkedHashMap<BasicElement, Integer> orderNodes(BasicRoot root2) {
        int counter = 0;
        JBTreeTraverser traverser = (JBTreeTraverser)((JBTreeTraverser)new JBTreeTraverser(BasicElement::getDbChildren).withRoot((Object)root2)).expand(e -> e instanceof BasicNamespace ? ((BasicNamespace)e).isVisible() : true);
        LinkedHashMap nodes2 = ContainerUtil.newLinkedHashMap();
        for (BasicElement object : traverser.bfsTraversal()) {
            Integer id = ++counter;
            nodes2.put(object, id);
        }
        return nodes2;
    }

    private ModelElementMem exportElement(BasicElement element, Map<BasicElement, Integer> nodes2) {
        Integer parentId;
        Integer id = nodes2.get(element);
        assert (id != null) : "Each node must be counted and ordered before exporting";
        BasicElement parentElement = element.getDbParent();
        Integer n = parentId = parentElement != null ? nodes2.get(parentElement) : null;
        assert (element instanceof BasicRoot == (parentElement == null));
        ImmutableList<MutableNameAndValue> properties = this.exportElementProperties(element);
        String elementName = element instanceof BasicNamedElement ? element.getRealName() : null;
        return new ModelElementMem(id, parentId, element.getKind().code(), elementName, (List<MutableNameAndValue>)properties);
    }

    private ImmutableList<MutableNameAndValue> exportElementProperties(BasicElement element) {
        ImmutableList.Builder b = new ImmutableList.Builder();
        element.exportProperties((name, value) -> {
            if (value != null) {
                b.add((Object)new MutableNameAndValue(name, (String)value));
            } else {
                LOG.warn("Attempted to export null property " + name + " when exporting element " + element.identity());
            }
        });
        return b.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void serializeModel(@NotNull ModelMem mem, @NotNull HierarchicalStreamWriter writer) {
        if (mem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mem", "com/intellij/database/serialization/ModelExporter", "serializeModel"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/database/serialization/ModelExporter", "serializeModel"));
        }
        writer.startNode("database-model");
        try {
            writer.addAttribute("serializer", "dbm");
            writer.addAttribute("rdbms", mem.getRdbms().code);
            writer.addAttribute("format-version", ModelSerializationVersions.CURRENT_VERSION.toString());
            for (Map.Entry<String, String> property : mem.getProperties().entrySet()) {
                writer.addAttribute(property.getKey(), property.getValue());
            }
            for (ModelElementMem object : mem.getNodes()) {
                ModelExporter.serializeNode(object, writer);
            }
        }
        finally {
            writer.endNode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void serializeNode(ModelElementMem node, HierarchicalStreamWriter writer) {
        writer.startNode(node.getKind());
        try {
            writer.addAttribute("id", Integer.toString(node.getId()));
            if (node.getParentId() != null) {
                writer.addAttribute("parent", node.getParentId().toString());
            }
            if (node.getName() != null) {
                writer.addAttribute("name", node.getName());
            }
            for (MutableNameAndValue property : node.getProperties()) {
                if (property.getName().equalsIgnoreCase("name")) continue;
                ModelExporter.serializeProperty(property, writer);
            }
        }
        finally {
            writer.endNode();
        }
    }

    private static void serializeProperty(MutableNameAndValue property, HierarchicalStreamWriter writer) {
        writer.startNode(property.getName());
        try {
            writer.setValue(property.getValue());
        }
        finally {
            writer.endNode();
        }
    }
}

