/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.intellij.openapi.util.Couple;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public abstract class CollectionUtils {
    @NotNull
    public static <T> ImmutableList<T> concat(@NotNull ImmutableList<T> listA, @NotNull ImmutableList<T> listB) {
        if (listA == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listA", "com/intellij/database/util/CollectionUtils", "concat"));
        }
        if (listB == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listB", "com/intellij/database/util/CollectionUtils", "concat"));
        }
        int nA = listA.size();
        int nB = listB.size();
        if (nB == 0) {
            ImmutableList<T> immutableList = listA;
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/CollectionUtils", "concat"));
            }
            return immutableList;
        }
        if (nA == 0) {
            ImmutableList<T> immutableList = listB;
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/CollectionUtils", "concat"));
            }
            return immutableList;
        }
        ImmutableList.Builder b = ImmutableList.builder();
        b.addAll(listA);
        b.addAll(listB);
        ImmutableList immutableList = b.build();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/CollectionUtils", "concat"));
        }
        return immutableList;
    }

    @NotNull
    public static <T> ImmutableList<T> concat(List<T> ... lists) {
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "com/intellij/database/util/CollectionUtils", "concat"));
        }
        switch (lists.length) {
            case 0: {
                ImmutableList immutableList = ImmutableList.of();
                if (immutableList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/CollectionUtils", "concat"));
                }
                return immutableList;
            }
            case 1: {
                ImmutableList immutableList = ImmutableList.copyOf(lists[0]);
                if (immutableList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/CollectionUtils", "concat"));
                }
                return immutableList;
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (List<T> list : lists) {
            builder.addAll(list);
        }
        ImmutableList immutableList = builder.build();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/CollectionUtils", "concat"));
        }
        return immutableList;
    }

    @NotNull
    public static <K extends Comparable<K>, T> ImmutableSortedMap<K, Couple<T>> sortingMerge(@NotNull Iterable<T> collectionA, @NotNull Iterable<T> collectionB, @NotNull Function<T, K> keyFunction) {
        Comparable k;
        if (collectionA == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collectionA", "com/intellij/database/util/CollectionUtils", "sortingMerge"));
        }
        if (collectionB == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collectionB", "com/intellij/database/util/CollectionUtils", "sortingMerge"));
        }
        if (keyFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyFunction", "com/intellij/database/util/CollectionUtils", "sortingMerge"));
        }
        TreeMap<Comparable, T> mapA = new TreeMap<Comparable, T>();
        TreeMap<Comparable, T> mapB = new TreeMap<Comparable, T>();
        for (T a : collectionA) {
            k = (Comparable)keyFunction.apply(a);
            mapA.put(k, a);
        }
        for (T b : collectionB) {
            k = (Comparable)keyFunction.apply(b);
            mapB.put(k, b);
        }
        ImmutableSortedSet keys = CollectionUtils.union(mapA.navigableKeySet(), mapB.navigableKeySet());
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (Comparable key : keys) {
            Object a = mapA.get(key);
            Object b = mapB.get(key);
            builder.put((Object)key, (Object)Couple.of(a, b));
        }
        ImmutableSortedMap immutableSortedMap = builder.build();
        if (immutableSortedMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/CollectionUtils", "sortingMerge"));
        }
        return immutableSortedMap;
    }

    public static <T extends Comparable<T>> ImmutableSortedSet<T> union(SortedSet<T> setA, SortedSet<T> setB) {
        int nB;
        int nA = setA == null ? 0 : setA.size();
        int n = nB = setB == null ? 0 : setB.size();
        if (nA == 0 && nB == 0) {
            return ImmutableSortedSet.of();
        }
        if (nB == 0) {
            return ImmutableSortedSet.copyOf(setA);
        }
        if (nA == 0) {
            return ImmutableSortedSet.copyOf(setB);
        }
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        if (nA >= nB) {
            builder.addAll(setA);
            for (Comparable b : setB) {
                if (setA.contains(b)) continue;
                builder.add((Object)b);
            }
        } else {
            builder.addAll(setB);
            for (Comparable a : setA) {
                if (setB.contains(a)) continue;
                builder.add((Object)a);
            }
        }
        return builder.build();
    }
}

