/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbUIUtil {
    public static final JBColor WARNING = new JBColor(15111424, 10322434);

    private DbUIUtil() {
    }

    public static void configureDataSourceComboBox(JComboBox comboBox, Iterable<DbDataSource> dataSources, boolean allowNull) {
        ArrayList copy = ContainerUtil.newArrayList(dataSources);
        Collections.sort(copy, (o1, o2) -> Comparing.compare((Comparable)((Object)StringUtil.toLowerCase((String)o1.getName())), (Comparable)((Object)StringUtil.toLowerCase((String)o2.getName()))));
        if (allowNull) {
            copy.add(0, null);
        }
        comboBox.setModel(new CollectionComboBoxModel((List)copy));
        comboBox.setRenderer(new ListCellRendererWrapper<DatabaseSystem>(){

            public void customize(JList list, DatabaseSystem element, int index, boolean selected, boolean hasFocus) {
                this.setIcon(element instanceof DbDataSource ? ((DbDataSource)element).getIcon() : null);
                String name = element == null ? "<none>" : element.getName();
                this.setText(StringUtil.notNullize((String)name));
            }
        });
        comboBox.setEditable(false);
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/util/DbUIUtil", "invokeLaterIfNeeded"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)runnable);
    }

    public static void invokeLater(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/util/DbUIUtil", "invokeLater"));
        }
        SwingUtilities.invokeLater(runnable);
    }

    public static Color softHighlightOf(Color c1) {
        if (c1 == null) {
            return null;
        }
        int i2 = 16;
        return new JBColor(new Color(Math.max(0, c1.getRed() - i2), Math.max(0, c1.getGreen() - i2), Math.max(0, c1.getBlue() - i2)), new Color(Math.min(255, c1.getRed() + i2), Math.min(255, c1.getGreen() + i2), Math.min(255, c1.getBlue() + i2)));
    }

    public static boolean isIntervalModifierSet(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/util/DbUIUtil", "isIntervalModifierSet"));
        }
        return 0 != (e.getModifiersEx() & 0x40);
    }

    public static boolean isExclusiveModifierSet(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/util/DbUIUtil", "isExclusiveModifierSet"));
        }
        return 0 != (e.getModifiersEx() & 0x180);
    }

    @Nullable
    public static VirtualFile openInConsole(@Nullable DbElement o, @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/util/DbUIUtil", "openInConsole"));
        }
        return o == null ? null : DbUIUtil.openInConsole(o.getDataSource(), o, text, false);
    }

    @Nullable
    public static VirtualFile openInConsole(@NotNull DbDataSource dataSource, @Nullable DbElement o, @NotNull String text, boolean existing) {
        VirtualFile file;
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/util/DbUIUtil", "openInConsole"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/util/DbUIUtil", "openInConsole"));
        }
        LocalDataSource localDataSource = (LocalDataSource)ObjectUtils.tryCast((Object)dataSource.getDelegate(), LocalDataSource.class);
        if (localDataSource == null) {
            return null;
        }
        VirtualFile virtualFile = file = existing ? DatabaseEditorHelper.getConsoleVirtualFile((DatabaseSystem)localDataSource) : DatabaseEditorHelper.createNewConsoleVirtualFile((DatabaseSystem)localDataSource);
        if (file == null) {
            return null;
        }
        DbUIUtil.openInConsole(dataSource.getProject(), file, text, (DasObject)o);
        return file;
    }

    public static void openInConsole(@NotNull Project project, @NotNull VirtualFile file, @NotNull String text, @Nullable DasObject o) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbUIUtil", "openInConsole"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/util/DbUIUtil", "openInConsole"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/util/DbUIUtil", "openInConsole"));
        }
        Document doc = FileDocumentManager.getInstance().getDocument(file);
        if (doc != null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbUIUtil", "lambda$openInConsole$2"));
                }
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/util/DbUIUtil", "lambda$openInConsole$2"));
                }
                CommandProcessor.getInstance().executeCommand(project, () -> {
                    int length;
                    if (text == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/util/DbUIUtil", "lambda$null$1"));
                    }
                    doc.insertString(length, (CharSequence)((length = doc.getTextLength()) == 0 ? text : "\n" + text));
                }, "Open query in console", null);
            });
            FileEditorManager.getInstance((Project)project).openFile(file, true);
            DatabaseEditorHelper.openConsoleForFile(project, (DasNamespace)DasUtil.getParentOfClass((DasObject)o, DasNamespace.class, (boolean)false), file);
        }
    }

    @NotNull
    public static Notification createNotification(@NotNull DatabaseSystem system, @NotNull String content, @NotNull NotificationType type) {
        if (system == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/util/DbUIUtil", "createNotification"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/database/util/DbUIUtil", "createNotification"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/util/DbUIUtil", "createNotification"));
        }
        Notification notification = DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(system.getName(), content, type, null);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbUIUtil", "createNotification"));
        }
        return notification;
    }

    @NotNull
    public static Notification createFileLinkNotification(@NotNull Project project, @NotNull DatabaseSystem system, @NotNull String content, @NotNull NotificationType type, @NotNull String path) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbUIUtil", "createFileLinkNotification"));
        }
        if (system == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/util/DbUIUtil", "createFileLinkNotification"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/database/util/DbUIUtil", "createFileLinkNotification"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/util/DbUIUtil", "createFileLinkNotification"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/util/DbUIUtil", "createFileLinkNotification"));
        }
        Notification notification = DbUIUtil.createFileLinkNotification(project, system.getName(), content, type, path);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbUIUtil", "createFileLinkNotification"));
        }
        return notification;
    }

    @NotNull
    public static Notification createFileLinkNotification(@NotNull Project project, @NotNull String title, @NotNull String content, @NotNull NotificationType type, @NotNull String path) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbUIUtil", "createFileLinkNotification"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/util/DbUIUtil", "createFileLinkNotification"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/database/util/DbUIUtil", "createFileLinkNotification"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/util/DbUIUtil", "createFileLinkNotification"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/util/DbUIUtil", "createFileLinkNotification"));
        }
        Notification notification = DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(title, DbUIUtil.getContent(content, path), type, (NotificationListener)new FileNotificationListener(project, path));
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbUIUtil", "createFileLinkNotification"));
        }
        return notification;
    }

    @NotNull
    private static String getContent(@NotNull String content, @NotNull String path) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/database/util/DbUIUtil", "getContent"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/util/DbUIUtil", "getContent"));
        }
        String string = content + (StringUtil.isEmpty((String)content) ? "" : " ") + DbUIUtil.getLink(path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbUIUtil", "getContent"));
        }
        return string;
    }

    @NotNull
    private static String getLink(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/util/DbUIUtil", "getLink"));
        }
        String string = String.format("<a href=\"Open file\">%s</a>", PathUtil.getFileName((String)path));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbUIUtil", "getLink"));
        }
        return string;
    }

    private static class FileNotificationListener
    implements NotificationListener {
        private final String myPath;
        private final Project myProject;

        FileNotificationListener(@NotNull Project project, @NotNull String path) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbUIUtil$FileNotificationListener", "<init>"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/util/DbUIUtil$FileNotificationListener", "<init>"));
            }
            this.myPath = path;
            this.myProject = project;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/database/util/DbUIUtil$FileNotificationListener", "hyperlinkUpdate"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/util/DbUIUtil$FileNotificationListener", "hyperlinkUpdate"));
            }
            File file = new File(this.myPath);
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            if (virtualFile == null) {
                DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(String.format("Can't access file: %s", this.myPath), NotificationType.WARNING).notify(this.myProject);
                return;
            }
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{virtualFile});
            FileNotificationListener.showFile(this.myProject, virtualFile);
        }

        private static void showFile(@NotNull Project project, @NotNull VirtualFile virtualFile) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbUIUtil$FileNotificationListener", "showFile"));
            }
            if (virtualFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/util/DbUIUtil$FileNotificationListener", "showFile"));
            }
            if (virtualFile.isDirectory()) {
                ShowFilePathAction.openDirectory((File)VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile));
                return;
            }
            if (SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)virtualFile)) {
                ShowFilePathAction.openFile((File)VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile));
                return;
            }
            FileEditorManager.getInstance((Project)project).openEditor(new OpenFileDescriptor(project, virtualFile), true);
        }
    }
}

