/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.google.common.collect.Iterables;
import com.intellij.database.dialects.AbstractDatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.ui.ColorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DdlBuilder {
    private final List<String> myResults = ContainerUtil.newSmartList();
    private final CharOut myOut;
    private boolean mySortElements;
    private boolean mySplitStatements;
    private DatabaseDialectEx myDialect = GenericDialect.INSTANCE;
    private CasingProvider myCasing = DasUtil.NO_CASING_PROVIDER;
    private Case myKeywordCase = Case.MIXED;
    private Case myTypeCase = Case.MIXED;
    private Casing myIdentCase = DasUtil.CASING_MIXED;
    private boolean myQuoteIdentifiers;
    private boolean myQualifyReferences;
    private boolean mySuppressQuoteIdentifiers;
    private boolean mySuppressQuoteConstraints;
    private boolean myJdbcOdbc;
    private final Deque<DasNamespace> myDefaultSchemas = ContainerUtil.newLinkedList();
    private final Map<DasObject, String> myRenames = ContainerUtil.newHashMap();
    private boolean mySkipExternalReferences;
    private boolean myNewName;
    private boolean myAddNewLineBeforeNewText = false;
    private Marker myMarker = null;

    public DdlBuilder(CharOut out) {
        this.myOut = out;
    }

    public DdlBuilder(StringBuilder out) {
        this(CharOut.Util.newSink(out));
    }

    public DdlBuilder() {
        this(new StringBuilder());
    }

    public DdlBuilder configureBuilder(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DdlBuilder", "configureBuilder"));
        }
        SqlCodeStyleSettings settings = (SqlCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(SqlCodeStyleSettings.class);
        if (settings == null) {
            settings = new SqlCodeStyleSettings(CodeStyleSettingsManager.getSettings((Project)project));
        }
        this.keywordCase(SqlCodeStyleSettings.getCaseMode((int)settings.KEYWORD_CASE));
        this.typeCase(settings.getCaseModeExt(settings.TYPE_CASE));
        this.identifierCase(Casing.create((Case)SqlCodeStyleSettings.getCaseMode((int)settings.IDENTIFIER_CASE), (Case)SqlCodeStyleSettings.getCaseMode((int)settings.QUOTED_IDENTIFIER_CASE)));
        this.quoteIdentifiers(settings.QUOTE_IDENTIFIER == 0);
        return this;
    }

    @NotNull
    public DdlBuilder applyCodeStyle(@Nullable Project project) {
        if (project != null) {
            this.configureBuilder(project);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "applyCodeStyle"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder renameObject(@NotNull DasObject obj, @Nullable String name) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/util/DdlBuilder", "renameObject"));
        }
        if (name == null) {
            this.myRenames.remove(obj);
        } else {
            this.myRenames.put(obj, name);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "renameObject"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder configureFrom(@NotNull DdlBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/util/DdlBuilder", "configureFrom"));
        }
        this.myDialect = builder.myDialect;
        this.myCasing = builder.myCasing;
        this.myKeywordCase = builder.myKeywordCase;
        this.myTypeCase = builder.myTypeCase;
        this.myIdentCase = builder.myIdentCase;
        this.myQuoteIdentifiers = builder.myQuoteIdentifiers;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "configureFrom"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder copied() {
        DdlBuilder builder = new DdlBuilder().configureFrom(this);
        builder.myQualifyReferences = this.myQualifyReferences;
        builder.mySuppressQuoteConstraints = this.mySuppressQuoteConstraints;
        builder.mySuppressQuoteIdentifiers = this.mySuppressQuoteIdentifiers;
        builder.myDefaultSchemas.addAll(this.myDefaultSchemas);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "copied"));
        }
        return ddlBuilder;
    }

    public DdlBuilder configureFor(@NotNull DbElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/util/DdlBuilder", "configureFor"));
        }
        this.applyCodeStyle(element.getProject());
        this.myDialect = DbImplUtil.getDatabaseDialect(element);
        return this.withCasingFor(element);
    }

    public DdlBuilder withCasingFor(@NotNull DbElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/util/DdlBuilder", "withCasingFor"));
        }
        this.myCasing = element.getDataSource().getModel();
        return this;
    }

    public int length() {
        return (int)this.myOut.length() + (this.myMarker == null ? 0 : this.myMarker.length());
    }

    <T> T cast(Class<T> c) {
        T t = this.myOut.tryCast(c);
        if (t == null) {
            throw new UnsupportedOperationException("failed to cast " + this.myOut.getClass() + " to " + c);
        }
        return t;
    }

    public DdlBuilder withCasing(@NotNull CasingProvider casing) {
        if (casing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casing", "com/intellij/database/util/DdlBuilder", "withCasing"));
        }
        this.myCasing = casing;
        return this;
    }

    public DdlBuilder withDialect(@NotNull DatabaseDialectEx dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DdlBuilder", "withDialect"));
        }
        this.myDialect = dialect;
        this.myCasing = this.myCasing == DasUtil.NO_CASING_PROVIDER ? this.myDialect : this.myCasing;
        return this;
    }

    @NotNull
    public DatabaseDialectEx getDialect() {
        DatabaseDialectEx databaseDialectEx = this.myDialect;
        if (databaseDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "getDialect"));
        }
        return databaseDialectEx;
    }

    public boolean isEmpty() {
        return this.length() == 0 && this.myResults.isEmpty();
    }

    @NotNull
    public DdlBuilder sort(boolean flag) {
        this.mySortElements = flag;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "sort"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder keywordCase(Case mode) {
        this.myKeywordCase = mode;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "keywordCase"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder typeCase(Case mode) {
        this.myTypeCase = mode;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "typeCase"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder identifierCase(@NotNull Casing casing) {
        if (casing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casing", "com/intellij/database/util/DdlBuilder", "identifierCase"));
        }
        this.myIdentCase = casing;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "identifierCase"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder splitStatements(boolean flag) {
        this.mySplitStatements = flag;
        if (this.mySplitStatements) {
            this.cast(StringBuilder.class);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "splitStatements"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder qualifyReferences(boolean flag) {
        this.myQualifyReferences = flag;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "qualifyReferences"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder newStatement() {
        if (this.length() != 0) {
            if (this.mySplitStatements) {
                StringBuilder builder = this.cast(StringBuilder.class);
                this.myResults.add(builder.toString());
                builder.setLength(0);
            } else {
                this.symbol(";");
                this.myAddNewLineBeforeNewText = true;
            }
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "newStatement"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder clear() {
        StringBuilder sb = this.myOut.tryCast(StringBuilder.class);
        if (sb != null) {
            this.myAddNewLineBeforeNewText = false;
            sb.setLength(0);
        }
        this.myResults.clear();
        this.myMarker = null;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "clear"));
        }
        return ddlBuilder;
    }

    @NotNull
    public String getStatement() {
        String string = this.myMarker == null ? this.myOut.toString() : this.myMarker.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "getStatement"));
        }
        return string;
    }

    @NotNull
    public List<String> getStatements() {
        if ((this.mySplitStatements || this.myResults.isEmpty()) && this.length() > 0) {
            this.newStatement();
        }
        List<String> list = this.myResults;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "getStatements"));
        }
        return list;
    }

    @NotNull
    public DdlBuilder jdbcOdbc(boolean flag) {
        this.myJdbcOdbc = flag;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "jdbcOdbc"));
        }
        return ddlBuilder;
    }

    public boolean isJdbcOdbc() {
        return this.myJdbcOdbc;
    }

    @NotNull
    public DdlBuilder skipExternalReferences(boolean flag) {
        this.mySkipExternalReferences = flag;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "skipExternalReferences"));
        }
        return ddlBuilder;
    }

    public boolean skipExternalReferences() {
        return this.mySkipExternalReferences;
    }

    @NotNull
    public DdlBuilder quoteIdentifiers(boolean quoteIdentifiers) {
        this.myQuoteIdentifiers = quoteIdentifiers;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "quoteIdentifiers"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder suppressQuoteIdentifiers(boolean flag) {
        this.mySuppressQuoteIdentifiers = flag;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "suppressQuoteIdentifiers"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder pushDefaultSchema(@Nullable DasNamespace namespace) {
        this.myDefaultSchemas.push(namespace);
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "pushDefaultSchema"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder popDefaultSchema() {
        this.myDefaultSchemas.pop();
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "popDefaultSchema"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder suppressQuoteConstraints(boolean flag) {
        this.mySuppressQuoteConstraints = flag;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "suppressQuoteConstraints"));
        }
        return ddlBuilder;
    }

    @NotNull
    public Marker mark() {
        StringBuilder builder = this.myOut.tryCast(StringBuilder.class);
        if (builder != null) {
            Marker marker = new Marker(builder);
            if (marker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "mark"));
            }
            return marker;
        }
        Marker marker = new Marker(new StringBuilder());
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "mark"));
        }
        return marker;
    }

    @NotNull
    public DdlBuilder plain(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/util/DdlBuilder", "plain"));
        }
        DdlBuilder ddlBuilder = this.append(text);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "plain"));
        }
        return ddlBuilder;
    }

    @NotNull
    protected DdlBuilder append(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/util/DdlBuilder", "append"));
        }
        if (!text.isEmpty() && this.myAddNewLineBeforeNewText) {
            this.myAddNewLineBeforeNewText = false;
            this.newLine();
        }
        if (this.myMarker == null) {
            this.myOut.append(text);
        } else {
            this.myMarker.builder.append(text);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "append"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder keyword(@NotNull String keyword) {
        if (keyword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyword", "com/intellij/database/util/DdlBuilder", "keyword"));
        }
        DdlBuilder ddlBuilder = this.plain(this.myKeywordCase.apply(keyword));
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "keyword"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder keywords(String ... keywords) {
        if (keywords == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keywords", "com/intellij/database/util/DdlBuilder", "keywords"));
        }
        boolean first = true;
        for (String s : keywords) {
            if (first) {
                first = false;
            } else {
                this.space();
            }
            this.keyword(s);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "keywords"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder elements(@NotNull Iterable<? extends DasObject> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/util/DdlBuilder", "elements"));
        }
        for (DasObject dasObject : elements) {
            int length = this.length();
            this.element(dasObject);
            if (this.length() <= length) continue;
            this.newStatement();
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "elements"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder element(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/util/DdlBuilder", "element"));
        }
        boolean prevValue = this.mySuppressQuoteIdentifiers;
        DasObject delegate = element instanceof DbElement ? ((DbElement)element).getDelegate() : element;
        this.mySuppressQuoteIdentifiers = delegate instanceof PsiElement;
        if (element instanceof DasTable) {
            this.table((DasTable)element);
        } else if (element instanceof DasColumn) {
            this.column((DasColumn)element);
        } else if (element instanceof DasForeignKey) {
            this.foreignKey((DasForeignKey)element);
        } else if (element instanceof DasTableKey) {
            this.key((DasTableKey)element);
        } else if (element instanceof DasRoutine) {
            this.procedure((DasRoutine)element);
        } else {
            this.other(element);
        }
        this.mySuppressQuoteIdentifiers = prevValue;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "element"));
        }
        return ddlBuilder;
    }

    @NotNull
    private DdlBuilder procedure(@NotNull DasRoutine element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/util/DdlBuilder", "procedure"));
        }
        DdlBuilder ddlBuilder = this.myDialect.sqlDefineProcedure(this, element);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "procedure"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder other(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/util/DdlBuilder", "other"));
        }
        int length = this.length();
        for (DasObject o : ((JBTreeTraverser)DasUtil.dasTraverser().regard(Conditions.not((Condition)DasUtil.byClass(DasNamespace.class)))).children((Object)element)) {
            if (this.length() > length) {
                length = this.newStatement().length();
            }
            this.element(o);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "other"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder key(@NotNull DasTableKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/util/DdlBuilder", "key"));
        }
        if (key.isPrimary()) {
            DdlBuilder ddlBuilder = this.myDialect.sqlDefinePrimaryKey(this, key);
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "key"));
            }
            return ddlBuilder;
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "key"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder index(@NotNull DasIndex o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/util/DdlBuilder", "index"));
        }
        DdlBuilder ddlBuilder = this.myDialect.sqlCreateIndex(this, o, "", "", "");
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "index"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder foreignKey(@NotNull DasForeignKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/util/DdlBuilder", "foreignKey"));
        }
        DdlBuilder ddlBuilder = this.myDialect.sqlDefineForeignKey(this, key, false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "foreignKey"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder type(@NotNull String type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/util/DdlBuilder", "type"));
        }
        DdlBuilder ddlBuilder = this.typeInner(type);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "type"));
        }
        return ddlBuilder;
    }

    @NotNull
    private DdlBuilder typeInner(@NotNull String type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/util/DdlBuilder", "typeInner"));
        }
        boolean quoted = this.myDialect.isQuotedIdentifier(type);
        Casing casing = this.myCasing.getCasing(ObjectKind.OBJECT_TYPE, null);
        Case styleMode = quoted ? this.myIdentCase.choose(false) : this.myTypeCase;
        Case caseMode = quoted ? casing.choose(false) : Case.MIXED;
        DdlBuilder ddlBuilder = this.plain(caseMode == Case.EXACT ? type : styleMode.apply(type));
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "typeInner"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder type(@NotNull DasTypedObject typedInfo) {
        if (typedInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typedInfo", "com/intellij/database/util/DdlBuilder", "type"));
        }
        if (typedInfo instanceof DasColumn) {
            DataType type;
            try {
                type = typedInfo.getDataType();
            }
            catch (UnsupportedOperationException e) {
                if (typedInfo instanceof DeColumn) {
                    DdlBuilder ddlBuilder = this.plain(((DeColumn)typedInfo).dataType);
                    if (ddlBuilder == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "type"));
                    }
                    return ddlBuilder;
                }
                throw e;
            }
            String specification = type.getSpecification();
            if (type.jdbcType == 0 && StringUtil.isNotEmpty((String)specification)) {
                DdlBuilder ddlBuilder = this.type(type);
                if (ddlBuilder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "type"));
                }
                return ddlBuilder;
            }
            DdlBuilder ddlBuilder = this.typeInner(this.myDialect.getTypeName(type));
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "type"));
            }
            return ddlBuilder;
        }
        DataType type = typedInfo.getDataType();
        String typeName = type.getSpecification();
        typeName = StringUtil.isEmpty((String)typeName) ? this.myDialect.getTypeName(type) : typeName;
        int index = typeName.indexOf(40);
        typeName = index < 0 ? typeName : typeName.substring(0, index).trim();
        DdlBuilder ddlBuilder = this.typeInner(typeName);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "type"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder type(@NotNull DataType dataType) {
        if (dataType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/util/DdlBuilder", "type"));
        }
        if (dataType.schemaName != null) {
            this.ref(null, dataType.schemaName).symbol(".");
        }
        this.typeInner(dataType.typeName);
        if (dataType.vagueArg != null) {
            this.symbol("(").plain(dataType.vagueArg).symbol(")");
        } else if (dataType.enumValues != null) {
            this.symbol("(");
            this.plain(StringUtil.join((Collection)dataType.enumValues, (String)", "));
            this.symbol(")");
        } else if (dataType.size >= 0) {
            this.symbol("(");
            if (dataType.size == 0x7FFFFFFE) {
                this.symbol("*");
            } else if (dataType.size == Integer.MAX_VALUE) {
                this.keyword("max");
            } else {
                this.number(dataType.size);
            }
            if (dataType.scale != 0) {
                this.symbol(",").number(dataType.scale);
            }
            if (dataType.sizeUnit != LengthUnit.NONE && dataType.sizeUnitExplicit) {
                this.space().keyword(dataType.sizeUnit.suffix);
            }
            this.symbol(")");
        }
        if (dataType.suffix != null) {
            this.space().plain(dataType.suffix);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "type"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder number(int n) {
        DdlBuilder ddlBuilder = this.plain(String.valueOf(n));
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "number"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder column(@NotNull DasColumn column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/util/DdlBuilder", "column"));
        }
        DdlBuilder ddlBuilder = this.myDialect.sqlDefineColumn(this, column, false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "column"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder literal(@NotNull String def) {
        if (def == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "def", "com/intellij/database/util/DdlBuilder", "literal"));
        }
        DdlBuilder ddlBuilder = this.plain(def);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "literal"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder ref(@Nullable DasObject object, String name) {
        if (StringUtil.isEmpty((String)name)) {
            DdlBuilder ddlBuilder = this;
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "ref"));
            }
            return ddlBuilder;
        }
        boolean quoted = this.myDialect.isQuotedIdentifier(name);
        Casing casing = this.myCasing.getCasing(object == null ? ObjectKind.TABLE : object.getKind(), object);
        Case styleMode = this.myIdentCase.choose(!quoted);
        Case caseMode = casing.choose(!quoted);
        DdlBuilder ddlBuilder = this.plain(caseMode == Case.EXACT ? name : styleMode.apply(name));
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "ref"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder space(int count) {
        DdlBuilder ddlBuilder = this.plain(StringUtil.repeat((String)" ", (int)count));
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "space"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder space() {
        DdlBuilder ddlBuilder = this.space(1);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "space"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder tab() {
        DdlBuilder ddlBuilder = this.space(4);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "tab"));
        }
        return ddlBuilder;
    }

    public DdlBuilder newLine() {
        return this.plain("\n");
    }

    @NotNull
    public DdlBuilder symbol(@NotNull String symbol) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/intellij/database/util/DdlBuilder", "symbol"));
        }
        DdlBuilder ddlBuilder = this.plain(symbol);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "symbol"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder comment(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/util/DdlBuilder", "comment"));
        }
        for (String commentLine : StringUtil.splitByLinesKeepSeparators((String)s)) {
            this.plain("-- ").plain(commentLine);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "comment"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder inlineComment(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/util/DdlBuilder", "inlineComment"));
        }
        DdlBuilder ddlBuilder = this.plain("/*").plain(s).plain("*/");
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "inlineComment"));
        }
        return ddlBuilder;
    }

    private String quoteIdentifier(@NotNull String name, boolean force, boolean suppress, @NotNull Casing casing) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/util/DdlBuilder", "quoteIdentifier"));
        }
        if (casing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casing", "com/intellij/database/util/DdlBuilder", "quoteIdentifier"));
        }
        boolean suppressFlag = suppress || this.mySuppressQuoteIdentifiers;
        return ((AbstractDatabaseDialect)this.myDialect).quoteIdentifier(name, force && !suppressFlag, suppressFlag, casing);
    }

    @NotNull
    public DdlBuilder identifier(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/util/DdlBuilder", "identifier"));
        }
        DdlBuilder ddlBuilder = this.identifier(null, name);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "identifier"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder identifier(@Nullable DasObject object, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/util/DdlBuilder", "identifier"));
        }
        Casing casing = this.myCasing.getCasing(object == null ? ObjectKind.TABLE : object.getKind(), object);
        DdlBuilder ddlBuilder = this.ref(object, this.quoteIdentifier(name, this.myQuoteIdentifiers, false, casing));
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "identifier"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder alias(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/util/DdlBuilder", "alias"));
        }
        DdlBuilder ddlBuilder = this.ref(null, name);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "alias"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder newName(@NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/database/util/DdlBuilder", "newName"));
        }
        DdlBuilder ddlBuilder = this.identifier(newName);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "newName"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder newName(@NotNull String name, @Nullable DasObject info) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/util/DdlBuilder", "newName"));
        }
        this.myNewName = true;
        this.qualifiedRefOpt(info, name);
        this.myNewName = false;
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "newName"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder formatQualification(@NotNull DasObject object, ObjectKind ... kinds) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/util/DdlBuilder", "formatQualification"));
        }
        if (kinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/database/util/DdlBuilder", "formatQualification"));
        }
        boolean first = true;
        for (ObjectKind kind : kinds) {
            DasObject item = DasUtil.getParentOfKind((DasObject)object, (ObjectKind)kind, (boolean)false);
            if (item == null || StringUtil.isEmpty((String)item.getName())) continue;
            if (!first) {
                this.symbol(".");
            }
            first = false;
            this.identifier(item, item.getName());
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "formatQualification"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder columnRef(@NotNull DasObject info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/util/DdlBuilder", "columnRef"));
        }
        DdlBuilder ddlBuilder = this.identifier(info, this.getName(info));
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "columnRef"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder columnRef(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/util/DdlBuilder", "columnRef"));
        }
        DdlBuilder ddlBuilder = this.identifier(null, name);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "columnRef"));
        }
        return ddlBuilder;
    }

    @NotNull
    public String getName(@NotNull DasObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/util/DdlBuilder", "getName"));
        }
        String string = StringUtil.notNullize((String)this.myRenames.get(object), (String)object.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "getName"));
        }
        return string;
    }

    @NotNull
    public DdlBuilder constraintRef(@NotNull DasObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/util/DdlBuilder", "constraintRef"));
        }
        DdlBuilder ddlBuilder = this.constraintRef(object, object.getName());
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "constraintRef"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder constraintRef(@Nullable DasObject object, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/util/DdlBuilder", "constraintRef"));
        }
        Casing casing = this.myCasing.getCasing(ObjectKind.KEY, object);
        DdlBuilder ddlBuilder = this.ref(object, this.quoteIdentifier(name, this.myQuoteIdentifiers, this.mySuppressQuoteConstraints, casing));
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "constraintRef"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder qualifiedRef(@NotNull DasObject info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/util/DdlBuilder", "qualifiedRef"));
        }
        if (this.myQualifyReferences && !this.inCurrentNamespace(info)) {
            this.myDialect.qualifiedIdentifier(this, this.getName(info), info, info);
        } else if (info instanceof DasRoutine) {
            this.qualifiedRef(info, this.getName(info), null, null, null, null, null, ((DasRoutine)info).getPackageName());
        } else {
            this.qualifiedRefLast(info, this.getName(info));
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "qualifiedRef"));
        }
        return ddlBuilder;
    }

    protected boolean inCurrentNamespace(@NotNull DasObject info) {
        DasObject parent;
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/util/DdlBuilder", "inCurrentNamespace"));
        }
        DasNamespace current = this.myDefaultSchemas.peek();
        if (current == (parent = info.getDbParent())) {
            return true;
        }
        if (current == null) {
            return false;
        }
        return QNameUtil.getQualifiedName((DasObject)current).equals(QNameUtil.getQualifiedName(parent));
    }

    @NotNull
    public DdlBuilder qualifiedRefOpt(@Nullable DasObject object, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/util/DdlBuilder", "qualifiedRefOpt"));
        }
        DdlBuilder ddlBuilder = this.qualifiedRefOpt(object, object, name);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "qualifiedRefOpt"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder qualifiedRefOpt(@Nullable DasObject object, @Nullable DasObject qualifier, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/util/DdlBuilder", "qualifiedRefOpt"));
        }
        boolean explicitSchema = qualifier != null && this.myQualifyReferences ? !this.inCurrentNamespace(qualifier) : false;
        if (explicitSchema) {
            this.myDialect.qualifiedIdentifier(this, name, object, qualifier);
        } else {
            this.qualifiedRefLast(object, name);
        }
        DdlBuilder ddlBuilder = this;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "qualifiedRefOpt"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder qualifiedRef(@Nullable DasObject object, @NotNull String name, @Nullable DasObject schemaObject, @Nullable String schema, @Nullable DasObject catalogObject, @Nullable String catalog, @Nullable DasObject packageObject, @Nullable String packageName) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/util/DdlBuilder", "qualifiedRef"));
        }
        if (StringUtil.isNotEmpty((String)catalog) && (object == null || object != catalogObject)) {
            this.identifier(catalogObject, catalog).symbol(".");
        }
        if (StringUtil.isNotEmpty((String)schema) && (object == null || object != schemaObject)) {
            this.identifier(schemaObject, schema).symbol(".");
        }
        if (StringUtil.isNotEmpty((String)packageName) && (object == null || object != packageObject)) {
            this.identifier(packageObject, packageName).symbol(".");
        }
        DdlBuilder ddlBuilder = this.qualifiedRefLast(object, name);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "qualifiedRef"));
        }
        return ddlBuilder;
    }

    @NotNull
    protected DdlBuilder qualifiedRefLast(@Nullable DasObject element, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/util/DdlBuilder", "qualifiedRefLast"));
        }
        DdlBuilder ddlBuilder = this.myNewName ? this.newName(name) : this.identifier(element, name);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "qualifiedRefLast"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder table(@NotNull DasTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/util/DdlBuilder", "table"));
        }
        DdlBuilder ddlBuilder = this.tables(Collections.singletonList(table));
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "table"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder tables(@NotNull Iterable<? extends DasTable> table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/util/DdlBuilder", "tables"));
        }
        if (Iterables.isEmpty(table)) {
            DdlBuilder ddlBuilder = this;
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "tables"));
            }
            return ddlBuilder;
        }
        DdlBuilder ddlBuilder = this.myDialect.sqlCreateTable(this, ContainerUtil.newArrayList(table), true, null);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder", "tables"));
        }
        return ddlBuilder;
    }

    public <T extends DasObject> Iterable<T> sortKeysIfNeeded(Iterable<T> elements) {
        if (!this.mySortElements) {
            return elements;
        }
        ArrayList result2 = new ArrayList();
        Iterables.addAll(result2, elements);
        Collections.sort(result2, (o1, o2) -> Comparing.compare((Comparable)((Object)this.getName((DasObject)o1)), (Comparable)((Object)this.getName((DasObject)o2))));
        return result2;
    }

    public String toString() {
        return super.toString() + ": " + (this.myMarker == null ? this.myOut : this.myMarker);
    }

    public static class Colored
    extends DdlBuilder {
        protected EditorColorsScheme scheme = EditorColorsUtil.getGlobalOrDefaultColorScheme();
        protected final LinkedList<TextAttributes> myStack = new LinkedList();
        protected boolean myQuoteState;

        public Colored(StringBuilder sb) {
            super(sb);
        }

        public Colored() {
        }

        @NotNull
        public Colored pushStyle(TextAttributesKey key) {
            Colored colored = this.pushStyle(this.scheme.getAttributes(key));
            if (colored == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder$Colored", "pushStyle"));
            }
            return colored;
        }

        @NotNull
        public Colored pushStyle(@Nullable TextAttributes attributes) {
            this.myStack.addLast(attributes);
            if (attributes != null) {
                this.setAttributes(attributes, true);
            }
            Colored colored = this;
            if (colored == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder$Colored", "pushStyle"));
            }
            return colored;
        }

        @NotNull
        public Colored popStyle() {
            TextAttributes attributes = this.myStack.removeLast();
            if (attributes != null) {
                this.setAttributes(attributes, false);
            }
            Colored colored = this;
            if (colored == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder$Colored", "popStyle"));
            }
            return colored;
        }

        protected void setAttributes(@Nullable TextAttributes attributes, boolean enabled) {
            if (attributes == null) {
                return;
            }
            int fontType = attributes.getFontType();
            Color fg = attributes.getForegroundColor();
            if (enabled) {
                if (fg != null) {
                    this.append("<font").append(" color=\"#").append(ColorUtil.toHex((Color)fg)).append("\"");
                    Color bg = attributes.getBackgroundColor();
                    if (bg != null) {
                        this.append(" bgcolor=\"#").append(ColorUtil.toHex((Color)bg)).append("\"");
                    }
                    this.append(">");
                }
                if ((fontType & 2) != 0) {
                    this.append("<i>");
                }
                if ((fontType & 1) != 0) {
                    this.append("<b>");
                }
            } else {
                if ((fontType & 1) != 0) {
                    this.append("</b>");
                }
                if ((fontType & 2) != 0) {
                    this.append("</i>");
                }
                if (fg != null) {
                    this.append("</font>");
                }
            }
        }

        @Override
        @NotNull
        public Colored plain(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/util/DdlBuilder$Colored", "plain"));
            }
            Colored colored = (Colored)super.plain(text);
            if (colored == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder$Colored", "plain"));
            }
            return colored;
        }

        @NotNull
        public Colored plain(@NotNull String text, @Nullable TextAttributesKey key) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/util/DdlBuilder$Colored", "plain"));
            }
            Colored colored = this.pushStyle(key).plain(text).popStyle();
            if (colored == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder$Colored", "plain"));
            }
            return colored;
        }

        @Override
        public DdlBuilder newLine() {
            return super.newLine();
        }

        @Override
        @NotNull
        public DdlBuilder newStatement() {
            DdlBuilder ddlBuilder = super.newStatement();
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder$Colored", "newStatement"));
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        protected Colored append(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/util/DdlBuilder$Colored", "append"));
            }
            Colored colored = (Colored)super.append(text);
            if (colored == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder$Colored", "append"));
            }
            return colored;
        }

        @Override
        @NotNull
        public Colored keyword(@NotNull String keyword) {
            if (keyword == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyword", "com/intellij/database/util/DdlBuilder$Colored", "keyword"));
            }
            this.pushStyle(DefaultLanguageHighlighterColors.KEYWORD);
            super.keyword(keyword);
            Colored colored = this.popStyle();
            if (colored == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder$Colored", "keyword"));
            }
            return colored;
        }

        @Override
        @NotNull
        public Colored symbol(@NotNull String symbol) {
            if (symbol == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/intellij/database/util/DdlBuilder$Colored", "symbol"));
            }
            if ("'".equals(symbol)) {
                boolean bl = this.myQuoteState = !this.myQuoteState;
                if (this.myQuoteState) {
                    this.pushStyle(DefaultLanguageHighlighterColors.STRING);
                }
                super.symbol(symbol);
                if (!this.myQuoteState) {
                    this.popStyle();
                }
                Colored colored = this;
                if (colored == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder$Colored", "symbol"));
                }
                return colored;
            }
            Object key = ".".equals(symbol) ? DefaultLanguageHighlighterColors.DOT : (",".equals(symbol) ? DefaultLanguageHighlighterColors.COMMA : ("(".equals(symbol) || ")".equals(symbol) ? DefaultLanguageHighlighterColors.PARENTHESES : (";".equals(symbol) ? DefaultLanguageHighlighterColors.SEMICOLON : null)));
            this.pushStyle((TextAttributesKey)key);
            super.symbol(symbol);
            Colored colored = this.popStyle();
            if (colored == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder$Colored", "symbol"));
            }
            return colored;
        }

        @Override
        @NotNull
        public Colored comment(@NotNull String s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/util/DdlBuilder$Colored", "comment"));
            }
            this.pushStyle(DefaultLanguageHighlighterColors.LINE_COMMENT);
            super.comment(s);
            Colored colored = this.popStyle();
            if (colored == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder$Colored", "comment"));
            }
            return colored;
        }

        @Override
        @NotNull
        public Colored type(@NotNull String type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/util/DdlBuilder$Colored", "type"));
            }
            this.pushStyle(DefaultLanguageHighlighterColors.KEYWORD);
            super.type(type);
            Colored colored = this.popStyle();
            if (colored == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder$Colored", "type"));
            }
            return colored;
        }

        @Override
        @NotNull
        public Colored type(@NotNull DasTypedObject typedInfo) {
            if (typedInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typedInfo", "com/intellij/database/util/DdlBuilder$Colored", "type"));
            }
            this.pushStyle(DefaultLanguageHighlighterColors.KEYWORD);
            super.type(typedInfo);
            Colored colored = this.popStyle();
            if (colored == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder$Colored", "type"));
            }
            return colored;
        }

        @Override
        @NotNull
        public Colored literal(@NotNull String literal) {
            if (literal == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/database/util/DdlBuilder$Colored", "literal"));
            }
            TextAttributesKey key = literal.indexOf(39) > -1 || literal.indexOf(34) > -1 ? DefaultLanguageHighlighterColors.STRING : DefaultLanguageHighlighterColors.NUMBER;
            this.pushStyle(key);
            super.literal(literal);
            Colored colored = this.popStyle();
            if (colored == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder$Colored", "literal"));
            }
            return colored;
        }

        @Override
        @NotNull
        public Colored ref(@Nullable DasObject object, String name) {
            Colored colored = (Colored)super.ref(object, name);
            if (colored == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder$Colored", "ref"));
            }
            return colored;
        }
    }

    public class Marker {
        private final int position;
        private final StringBuilder builder;

        private Marker(StringBuilder builder) {
            this.builder = builder;
            this.position = builder.length();
            if (DdlBuilder.this.myMarker != null) {
                throw new AssertionError((Object)"Marker already exists");
            }
            DdlBuilder.this.myMarker = this;
        }

        @NotNull
        public String extract() {
            if (DdlBuilder.this.myMarker != this) {
                throw new AssertionError((Object)"Accessing invalid marker");
            }
            String string = this.builder.subSequence(this.position, this.builder.length()).toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DdlBuilder$Marker", "extract"));
            }
            return string;
        }

        public void replace(@NotNull String replacement) {
            if (replacement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacement", "com/intellij/database/util/DdlBuilder$Marker", "replace"));
            }
            if (DdlBuilder.this.myMarker != this) {
                throw new AssertionError((Object)"Accessing invalid marker");
            }
            this.builder.replace(this.position, this.builder.length(), replacement);
        }

        public void finish() {
            if (DdlBuilder.this.myMarker != this) {
                throw new AssertionError((Object)"Finishing invalid marker");
            }
            if (DdlBuilder.this.myOut.tryCast(StringBuilder.class) != this.builder) {
                DdlBuilder.this.myOut.append(this.builder);
            }
            DdlBuilder.this.myMarker = null;
        }

        public String toString() {
            if (DdlBuilder.this.myOut.tryCast(StringBuilder.class) != this.builder) {
                return DdlBuilder.this.myOut + this.builder.toString();
            }
            return this.builder.toString();
        }

        private int length() {
            return this.builder.length() - this.position;
        }
    }
}

