/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QNameUtil {
    public static final Condition<String> NOT_EMPTY = s -> StringUtil.isNotEmpty((String)s);

    private QNameUtil() {
    }

    @Deprecated
    public static String getQualifiedName(String catalog, String schema, String name) {
        ImmutableList parts = ContainerUtil.immutableList((Object[])new String[]{StringUtil.nullize((String)catalog), StringUtil.nullize((String)schema), StringUtil.nullize((String)name)});
        return StringUtil.join((Collection)parts, (String)".");
    }

    @NotNull
    public static String getQualifiedName(@Nullable DbElement element) {
        if (element instanceof DatabaseSystem) {
            String string = element.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/QNameUtil", "getQualifiedName"));
            }
            return string;
        }
        String string = QNameUtil.getQualifiedName((DasObject)element);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/QNameUtil", "getQualifiedName"));
        }
        return string;
    }

    @NotNull
    public static String getQualifiedName(@Nullable DasObject element) {
        String string = QNameUtil.getQualifiedName(element, (Function<DasObject, String>)DasUtil.TO_NAME);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/QNameUtil", "getQualifiedName"));
        }
        return string;
    }

    @NotNull
    public static String getQualifiedName(@Nullable DasObject element, DatabaseDialect dialect) {
        String string = QNameUtil.getQualifiedName(element, (Function<DasObject, String>)((Function)object -> dialect.quoteIdentifier(object.getName(), false, true)));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/QNameUtil", "getQualifiedName"));
        }
        return string;
    }

    @NotNull
    public static String getQualifiedName(@Nullable DasObject element, @NotNull Function<DasObject, String> namer) {
        if (namer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namer", "com/intellij/database/util/QNameUtil", "getQualifiedName"));
        }
        List parents = DasUtil.dasParents((DasObject)element).toList();
        String string = StringUtil.join((Collection)ContainerUtil.reverse((List)parents), namer, (String)".");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/QNameUtil", "getQualifiedName"));
        }
        return string;
    }

    @Nullable
    public static <T extends DasObject> T findByName(String name, Iterable<T> elements) {
        return (T)((DasObject)ContainerUtil.find(elements, (Condition)DasUtil.byName((String)name)));
    }

    @Deprecated
    @Nullable
    public static DasTable findTable(DatabaseSystem dataSourceInfo, String table, String schema, String catalog) {
        if (dataSourceInfo == null) {
            return null;
        }
        JBIterable tables = DasUtil.getTables((DatabaseSystem)dataSourceInfo);
        return (DasTable)QNameUtil.findElement(table, schema, catalog, tables);
    }

    @Deprecated
    @Nullable
    public static <T extends DasObject> T findElement(String name, String schema, String catalog, Iterable<? extends T> elements) {
        T caseSensitive = QNameUtil.findElement(name, schema, catalog, elements, true);
        return caseSensitive != null ? caseSensitive : QNameUtil.findElement(name, schema, catalog, elements, false);
    }

    @Nullable
    private static <T extends DasObject> T findElement(String name, String schema, String catalog, Iterable<? extends T> elements, boolean caseSensitive) {
        return (T)(name == null ? null : (DasObject)ContainerUtil.find(elements, object -> !(!Comparing.strEqual((String)name, (String)object.getName(), (boolean)caseSensitive) || !StringUtil.isEmpty((String)schema) && !Comparing.strEqual((String)schema, (String)DasUtil.getSchema((DasObject)object), (boolean)caseSensitive) || !StringUtil.isEmpty((String)catalog) && !Comparing.strEqual((String)catalog, (String)DasUtil.getCatalog((DasObject)object), (boolean)caseSensitive))));
    }

    @NotNull
    public static JBIterable<DasObject> findByQName(@NotNull DasModel model, @NotNull String fqn, @NotNull Function<DasObject, String> namer) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/util/QNameUtil", "findByQName"));
        }
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "com/intellij/database/util/QNameUtil", "findByQName"));
        }
        if (namer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namer", "com/intellij/database/util/QNameUtil", "findByQName"));
        }
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)model.traverser().expand(object -> {
            if (namer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namer", "com/intellij/database/util/QNameUtil", "lambda$findByQName$3"));
            }
            if (fqn == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "com/intellij/database/util/QNameUtil", "lambda$findByQName$3"));
            }
            String name = (String)namer.fun(object);
            return name.isEmpty() || fqn.contains(name) && fqn.startsWith(QNameUtil.getQualifiedName(object, namer) + ".");
        })).filter(object -> {
            if (namer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namer", "com/intellij/database/util/QNameUtil", "lambda$findByQName$4"));
            }
            if (fqn == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "com/intellij/database/util/QNameUtil", "lambda$findByQName$4"));
            }
            String name = (String)namer.fun(object);
            return fqn.endsWith(name) && fqn.equals(QNameUtil.getQualifiedName(object, namer));
        })).traverse();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/QNameUtil", "findByQName"));
        }
        return jBIterable;
    }

    @Contract(value="null->false")
    public static boolean isFakeName(@Nullable String name) {
        return name != null && StringUtil.startsWith((CharSequence)name, (CharSequence)"#FAKE_");
    }
}

