/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.oracle;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vendors.oracle.OracleConsoleUtils;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.content.Content;
import java.sql.CallableStatement;
import java.sql.Statement;
import org.jetbrains.annotations.NotNull;

public class OracleProcessDbmsOutputAction
extends ToggleAction {
    private static final Key<MyDataAuditor> DBMS_LISTENER = Key.create((String)"DBMS_LISTENER");
    private static final int BYTES_TO_LOAD = 0x100000;

    public OracleProcessDbmsOutputAction() {
        this.getTemplatePresentation().setIcon(AllIcons.Toolwindows.ToolWindowMessages);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/vendors/oracle/OracleProcessDbmsOutputAction", "update"));
        }
        JdbcConsole console = OracleConsoleUtils.getOracleConsole(e);
        e.getPresentation().setEnabledAndVisible(console != null);
        if (console != null) {
            super.update(e);
        }
    }

    public boolean isSelected(AnActionEvent e) {
        JdbcConsole console = OracleConsoleUtils.getOracleConsole(e);
        Content content = console == null ? null : console.getContent();
        return content != null && content.getUserData(DBMS_LISTENER) != null;
    }

    public void setSelected(AnActionEvent e, boolean state) {
        Content content;
        JdbcConsole console = OracleConsoleUtils.getOracleConsole(e);
        Content content2 = content = console == null ? null : console.getContent();
        if (content == null) {
            return;
        }
        if (state) {
            MyDataAuditor listener = new MyDataAuditor(console);
            Disposer.register((Disposable)console, (Disposable)listener);
            console.getMessageBus().addAuditor(listener);
            content.putUserData(DBMS_LISTENER, (Object)listener);
        } else {
            MyDataAuditor listener = (MyDataAuditor)content.getUserData(DBMS_LISTENER);
            if (listener != null) {
                content.putUserData(DBMS_LISTENER, null);
                Disposer.dispose((Disposable)listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executePrepareStatement(@NotNull DatabaseConnection connection, @NotNull String sql, @NotNull DataRequest.Context context) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/vendors/oracle/OracleProcessDbmsOutputAction", "executePrepareStatement"));
        }
        if (sql == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sql", "com/intellij/database/vendors/oracle/OracleProcessDbmsOutputAction", "executePrepareStatement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/vendors/oracle/OracleProcessDbmsOutputAction", "executePrepareStatement"));
        }
        CallableStatement statement = null;
        try {
            statement = connection.prepareCall(sql);
            statement.execute();
        }
        catch (Exception e) {
            context.reportException(e, sql);
        }
        finally {
            JdbcUtil.closeStatementSafe((Statement)statement);
        }
    }

    private static class MyDataAuditor
    extends DataAuditor.Adapter
    implements Disposable {
        private final JdbcConsole myConsole;

        public MyDataAuditor(JdbcConsole console) {
            this.myConsole = console;
        }

        @Override
        public void requestStarted(@NotNull DataRequest.Context context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/vendors/oracle/OracleProcessDbmsOutputAction$MyDataAuditor", "requestStarted"));
            }
            DatabaseConnection connection = OracleConsoleUtils.getConnection(context);
            if (connection == null) {
                return;
            }
            OracleProcessDbmsOutputAction.executePrepareStatement(connection, "{call sys.dbms_output.enable(1048576)}", context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestFinished(@NotNull DataRequest.Context context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/vendors/oracle/OracleProcessDbmsOutputAction$MyDataAuditor", "requestFinished"));
            }
            DatabaseConnection connection = OracleConsoleUtils.getConnection(context);
            if (connection == null) {
                return;
            }
            String sql = "{call sys.dbms_output.get_line(?, ?)}";
            CallableStatement statement = null;
            try {
                int status;
                statement = connection.prepareCall(sql);
                statement.registerOutParameter(1, 12);
                statement.registerOutParameter(2, 2);
                do {
                    statement.execute();
                    String string = statement.getString(1);
                    if (string == null) continue;
                    this.myConsole.getHistoryLogger().warn(context, string);
                } while ((status = statement.getInt(2)) == 0);
            }
            catch (Exception e) {
                context.reportException(e, sql);
            }
            finally {
                JdbcUtil.closeStatementSafe((Statement)statement);
                OracleProcessDbmsOutputAction.executePrepareStatement(connection, "{call sys.dbms_output.disable()}", context);
            }
        }

        public void dispose() {
        }
    }
}

