/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs;

import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.vfs.DatabaseVirtualFileSystem;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.sql.SqlFileType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(provider=ElementPresentation.class)
public class DatabaseElementVirtualFileImpl
extends VirtualFile
implements VirtualFilePathWrapper {
    public static final Function<String, String> ESCAPER = DatabaseElementVirtualFileImpl::escape;
    public static final Function<DasObject, String> NAMER = Functions.compose((Function)DasUtil.TO_NAME, ESCAPER);
    private final String myProjectId;
    private final String myDataSourceId;
    private String myName;
    private final ObjectKind myKind;
    private boolean myWritable;
    private volatile boolean myBusy;
    private volatile String myContent;

    protected DatabaseElementVirtualFileImpl(String projectId, String dataSourceId, String name, @NotNull ObjectKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/vfs/DatabaseElementVirtualFileImpl", "<init>"));
        }
        this.myWritable = true;
        this.myProjectId = projectId;
        this.myDataSourceId = dataSourceId;
        this.myName = name;
        this.myKind = kind;
    }

    @NotNull
    public Project getProject() {
        Project project = DatabaseVirtualFileSystem.getDatabaseFileSystem().getProjectOrFail(this.myProjectId);
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/DatabaseElementVirtualFileImpl", "getProject"));
        }
        return project;
    }

    @NotNull
    public String getPath() {
        String string = DatabaseVirtualFileSystem.getPath(this.myProjectId, this.myDataSourceId, this.myName, this.myKind);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/DatabaseElementVirtualFileImpl", "getPath"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = DatabaseElementVirtualFileImpl.unescape(this.myName.substring(this.myName.lastIndexOf(46) + 1));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/DatabaseElementVirtualFileImpl", "getName"));
        }
        return string;
    }

    @NotNull
    public String getNameWithoutExtension() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/DatabaseElementVirtualFileImpl", "getNameWithoutExtension"));
        }
        return string;
    }

    public String getDataSourceId() {
        return this.myDataSourceId;
    }

    public String getEncodedName() {
        return this.myName;
    }

    @Nullable
    public DbDataSource findDataSource() {
        return DbPsiFacade.getInstance((Project)this.getProject()).findDataSource(this.myDataSourceId);
    }

    @NotNull
    public ObjectKind getObjectKind() {
        ObjectKind objectKind = this.myKind;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/DatabaseElementVirtualFileImpl", "getObjectKind"));
        }
        return objectKind;
    }

    @Nullable
    public DbElement findElement() {
        return this.findElementInner(this.findDataSource());
    }

    @Nullable
    private DbElement findElementInner(@Nullable DbDataSource dataSource) {
        if (dataSource == null) {
            return null;
        }
        return ((DbDataSourceImpl)dataSource).findElement(this.myName, this.myKind);
    }

    @NotNull
    public FileType getFileType() {
        if (DatabaseEditorHelper.isDefinitionAvailable(this.findElement())) {
            SqlFileType sqlFileType = SqlFileType.INSTANCE;
            if (sqlFileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/DatabaseElementVirtualFileImpl", "getFileType"));
            }
            return sqlFileType;
        }
        FileType fileType = super.getFileType();
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/DatabaseElementVirtualFileImpl", "getFileType"));
        }
        return fileType;
    }

    @NotNull
    public DatabaseVirtualFileSystem getFileSystem() {
        DatabaseVirtualFileSystem databaseVirtualFileSystem = DatabaseVirtualFileSystem.getDatabaseFileSystem();
        if (databaseVirtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/DatabaseElementVirtualFileImpl", "getFileSystem"));
        }
        return databaseVirtualFileSystem;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public boolean isWritable() {
        return this.myWritable;
    }

    public void setWritable(boolean writable) {
        boolean prev = this.myWritable;
        DbDataSource dataSource = !writable ? null : this.findDataSource();
        boolean bl = this.myWritable = dataSource != null && dataSource.isWritable();
        if (prev != this.myWritable) {
            BulkFileListener publisher = (BulkFileListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
            List<VFilePropertyChangeEvent> events = Collections.singletonList(new VFilePropertyChangeEvent((Object)this, (VirtualFile)this, "writable", (Object)prev, (Object)this.myWritable, false));
            publisher.before(events);
            publisher.after(events);
        }
    }

    public final void setWritableInner(boolean writable) {
        this.myWritable = writable;
    }

    public boolean isDirectory() {
        return false;
    }

    public VirtualFile getParent() {
        return null;
    }

    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    public InputStream getInputStream() throws IOException {
        return null;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        if (!this.getFileType().isBinary()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(){

                @Override
                public void close() throws IOException {
                    DatabaseElementVirtualFileImpl.this.myContent = new String(this.buf, 0, this.count, DatabaseElementVirtualFileImpl.this.getCharset());
                    FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{DatabaseElementVirtualFileImpl.this});
                }
            };
            if (byteArrayOutputStream == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/DatabaseElementVirtualFileImpl", "getOutputStream"));
            }
            return byteArrayOutputStream;
        }
        throw new IOException("Unsupported operation");
    }

    public void setContent(@NotNull String content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/database/vfs/DatabaseElementVirtualFileImpl", "setContent"));
        }
        this.myContent = content;
    }

    public String getContent() {
        return this.myContent;
    }

    public boolean isBusy() {
        return this.myBusy;
    }

    public void setBusy(boolean busy) {
        this.myBusy = busy;
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        byte[] byArray = this.myContent != null ? this.myContent.getBytes(this.getCharset()) : ArrayUtil.EMPTY_BYTE_ARRAY;
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/DatabaseElementVirtualFileImpl", "contentsToByteArray"));
        }
        return byArray;
    }

    public long getModificationStamp() {
        return 0L;
    }

    public long getTimeStamp() {
        return 0L;
    }

    public long getLength() {
        return 0L;
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    public boolean isValid() {
        Project project = DatabaseVirtualFileSystem.getDatabaseFileSystem().getProject(this.myProjectId);
        if (project == null || project.isDisposed()) {
            return false;
        }
        DbDataSource dataSource = this.findDataSource();
        if (dataSource == null) {
            return false;
        }
        DasModel model = DbImplUtil.getModelNoCancel(dataSource);
        if (model == DasUtil.loadingModel()) {
            return true;
        }
        return this.findElementInner(dataSource) != null;
    }

    @Nullable
    public static DatabaseElementVirtualFileImpl findFile(@Nullable DbElement element) {
        if (element == null || !element.isValid()) {
            return null;
        }
        String path = DatabaseElementVirtualFileImpl.getPath(element);
        DatabaseElementVirtualFileImpl file = (DatabaseElementVirtualFileImpl)DatabaseVirtualFileSystem.getDatabaseFileSystem().findFileByPath(path);
        if (ApplicationManager.getApplication().isUnitTestMode() && file != null && file.findElement() != element) {
            throw new AssertionError((Object)path);
        }
        return file;
    }

    @Nullable
    public static DatabaseElementVirtualFileImpl findFile(@Nullable Project project, @Nullable DatabaseSystem dataSource, @Nullable ObjectPath objectPath) {
        DbDataSource dbDataSource;
        if (project == null || dataSource == null) {
            return null;
        }
        String name = objectPath == null ? "" : StringUtil.join(objectPath.path, ESCAPER, (String)".");
        ObjectKind kind = objectPath == null ? ObjectKind.NONE : objectPath.kind;
        String path = DatabaseVirtualFileSystem.getPath(project, dataSource.getUniqueId(), name, kind);
        DatabaseElementVirtualFileImpl file = (DatabaseElementVirtualFileImpl)DatabaseVirtualFileSystem.getDatabaseFileSystem().findFileByPath(path);
        if (ApplicationManager.getApplication().isUnitTestMode() && file != null && ((dbDataSource = file.findDataSource()) == null || DbImplUtil.getBaseDataSource((DatabaseSystem)dbDataSource) != DbImplUtil.getBaseDataSource(dataSource))) {
            throw new AssertionError((Object)path);
        }
        return file;
    }

    public static String getPath(Project project, DatabaseSystem dataSource, DasObject elementInfo, ObjectKind kind) {
        return DatabaseVirtualFileSystem.getPath(project, dataSource.getUniqueId(), DatabaseElementVirtualFileImpl.encodeQName(elementInfo), kind);
    }

    private static String getPath(DbElement element) {
        return DatabaseVirtualFileSystem.getPath(element.getProject(), element.getDataSource().getUniqueId(), DatabaseElementVirtualFileImpl.encodeQName((DasObject)element), element.getKind());
    }

    private static String encodeQName(DasObject obj) {
        return QNameUtil.getQualifiedName(obj, NAMER);
    }

    static String[] decodeQName(String name) {
        return DatabaseElementVirtualFileImpl.decodeQName(name, false);
    }

    private static String[] decodeQName(String name, boolean presentableName) {
        String[] strings = ArrayUtil.toStringArray((Collection)StringUtil.split((String)name, (String)".", (boolean)true, (boolean)presentableName));
        int stringsLength = strings.length;
        for (int i2 = 0; i2 < stringsLength; ++i2) {
            strings[i2] = DatabaseElementVirtualFileImpl.unescape(strings[i2]);
        }
        return strings;
    }

    public static String escape(String name) {
        return name == null ? "" : StringUtil.replace((String)name, (String[])new String[]{"/", "&", "."}, (String[])new String[]{"&eslash;", "&amp;", "&dot;"});
    }

    public static String unescape(String name) {
        return name == null ? "" : StringUtil.replace((String)name, (String[])new String[]{"&eslash;", "&amp;", "&dot;"}, (String[])new String[]{"/", "&", "."});
    }

    public Language getLanguage() {
        return DbImplUtil.getSqlDialect(this.getProject(), (DatabaseSystem)this.findDataSource());
    }

    @NotNull
    public String getPresentablePath() {
        String string = this.getPresentableUrl();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/DatabaseElementVirtualFileImpl", "getPresentablePath"));
        }
        return string;
    }

    public boolean enforcePresentableName() {
        return false;
    }

    public String toString() {
        return "DB VirtualFile: " + this.myKind + ", " + this.getPresentableUrl();
    }

    @Nullable
    public static String getEditorTabTitleImpl(Project project, VirtualFile file) {
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings == null || DumbService.isDumb((Project)project)) {
            return null;
        }
        return uiSettings.getEditorTabPlacement() == 0 ? UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project, file) : UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePathWithinOpenedFileEditors(project, file);
    }

    public static class ElementPresentation
    extends PresentationProvider<DatabaseElementVirtualFileImpl>
    implements EditorTabTitleProvider {
        public Icon getIcon(DatabaseElementVirtualFileImpl file) {
            DbElement element = file.findElement();
            return element == null ? null : element.getIcon();
        }

        @Nullable
        public String getEditorTabTitle(Project project, VirtualFile file) {
            if (!(file instanceof DatabaseElementVirtualFileImpl)) {
                return null;
            }
            return DatabaseElementVirtualFileImpl.getEditorTabTitleImpl(project, file);
        }
    }
}

