/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import java.sql.Statement;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDatabaseModifier {
    @Nullable
    private final LocalDataSource myLocalDataSource;
    @NotNull
    protected DbDataSource myDataSource;
    @NotNull
    private LoaderContext myContext;
    @NotNull
    private final String myTitle;
    @Nullable
    private final DasNamespace myDefaultNs;
    private final ErrorHandler myErrorHandler;

    protected AbstractDatabaseModifier(@NotNull DbDataSource dataSource, @Nullable DasNamespace defaultNs, @NotNull String title) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/view/AbstractDatabaseModifier", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/view/AbstractDatabaseModifier", "<init>"));
        }
        this.myErrorHandler = new ErrorHandler();
        this.myDataSource = dataSource;
        this.myDefaultNs = defaultNs;
        this.myTitle = title;
        DatabaseSystem delegate = dataSource.getDelegate();
        this.myLocalDataSource = (LocalDataSource)ObjectUtils.tryCast((Object)delegate, LocalDataSource.class);
        this.myContext = new LoaderContext(dataSource.getProject(), this.myLocalDataSource == null ? new LocalDataSource() : this.myLocalDataSource);
    }

    @NotNull
    public DbDataSource getDataSource() {
        DbDataSource dbDataSource = this.myDataSource;
        if (dbDataSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/AbstractDatabaseModifier", "getDataSource"));
        }
        return dbDataSource;
    }

    @NotNull
    public LoaderContext getContext() {
        LoaderContext loaderContext = this.myContext;
        if (loaderContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/AbstractDatabaseModifier", "getContext"));
        }
        return loaderContext;
    }

    @NotNull
    public ErrorHandler getErrorHandler() {
        ErrorHandler errorHandler = this.myErrorHandler;
        if (errorHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/AbstractDatabaseModifier", "getErrorHandler"));
        }
        return errorHandler;
    }

    @Nullable
    private String getDefaultPathQuery() {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)this.myDataSource);
        if (!DbImplUtil.autoSwitchSchema(dialect)) {
            return null;
        }
        DasNamespace object = DbImplUtil.getSearchPathObject(dialect, (DasObject)this.myDefaultNs);
        return object == null ? null : dialect.sqlSetSearchPath((DatabaseSystem)this.myDataSource, SearchPath.of(ObjectPath.of((DasObject)object)));
    }

    @NotNull
    public CompletionStage<Void> runStatements(boolean nonModalSync) {
        Project project = this.myDataSource.getProject();
        if (this.myLocalDataSource == null) {
            CompletableFuture<Void> completableFuture = AsyncUtil.cancelled();
            if (completableFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/AbstractDatabaseModifier", "runStatements"));
            }
            return completableFuture;
        }
        CompletionStage<Void> callback = AsyncUtil.runTask(() -> AsyncUtil.supplyAsync(() -> DatabaseConnectionManager.getInstance().build(project, this.myLocalDataSource).setDestination(ObjectPath.of((DasObject)this.myDefaultNs)).async(connection -> {
            Statement searchPathStatement;
            boolean done;
            block8: {
                done = false;
                searchPathStatement = null;
                ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
                if (indicator == null) {
                    indicator = new EmptyProgressIndicator();
                }
                try {
                    indicator.checkCanceled();
                    indicator.setText("Updating database...");
                    searchPathStatement = connection.createStatement();
                    String searchPathQuery = this.getDefaultPathQuery();
                    if (searchPathQuery != null) {
                        searchPathStatement.execute(searchPathQuery);
                    }
                    done = this.getExecutor().execute(indicator, connection, project, this.myErrorHandler);
                    if (nonModalSync) {
                        ApplicationManager.getApplication().invokeLater(() -> this.runSync(), ModalityState.NON_MODAL);
                        break block8;
                    }
                    this.runSync();
                }
                catch (UnsupportedOperationException e) {
                    try {
                        this.myErrorHandler.addError(e.getMessage(), null);
                    }
                    catch (Throwable throwable) {
                        JdbcUtil.closeStatementSafe(searchPathStatement);
                        throw throwable;
                    }
                    JdbcUtil.closeStatementSafe((Statement)searchPathStatement);
                }
            }
            JdbcUtil.closeStatementSafe((Statement)searchPathStatement);
            if (!done || this.myErrorHandler.hasErrors()) {
                throw new ProcessCanceledException();
            }
            return null;
        }, this.myErrorHandler), AsyncUtil.POOL_EXECUTOR), AsyncUtil.createBackgroundIndicator(project, this.myTitle));
        callback.handleAsync((res, th) -> {
            AsyncUtil.addUnhandledError(this.myErrorHandler, th, this.myDataSource.getName(), DbImplUtil.getDatabaseDialect((DbElement)this.myDataSource).getFamilyId());
            if (!this.myErrorHandler.getSummary().isEmpty()) {
                DataSourceUiUtil.showNotification(project, "", this.myErrorHandler.getSummary(), true);
            }
            if (th != null) {
                throw new ProcessCanceledException();
            }
            return res;
        }, AsyncUtil.EDT_EXECUTOR);
        CompletionStage<Void> completionStage = callback;
        if (completionStage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/AbstractDatabaseModifier", "runStatements"));
        }
        return completionStage;
    }

    public void runSync() {
        Project project = this.myDataSource.getProject();
        DataSourceUiUtil.performManualSyncTask(this.myContext).whenCompleteAsync((r, e) -> {
            DatabaseView view2 = DatabaseView.getDatabaseView(project);
            view2.selectElements(this.getElement(project));
        }, AsyncUtil.EDT_EXECUTOR);
    }

    @Nullable
    private DbElement getElement(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/AbstractDatabaseModifier", "getElement"));
        }
        DasObject info = AbstractDatabaseModifier.getDasObject(this.myContext.getElementToFocus());
        if (info == null) {
            return null;
        }
        DatabaseElementVirtualFileImpl file = DatabaseElementVirtualFileImpl.findFile(project, (DatabaseSystem)this.myDataSource, ObjectPath.of(info));
        return file == null ? null : file.findElement();
    }

    @Nullable
    private static DasObject getDasObject(@Nullable Object object) {
        return object instanceof DasSchemaChild ? (DasObject)object : (object instanceof DasColumn ? ((DasColumn)object).getTable() : (object instanceof DasTableKey ? ((DasTableKey)object).getTable() : null));
    }

    @NotNull
    protected abstract QueryExecutor getExecutor();

    protected static interface QueryExecutor {
        public boolean execute(ProgressIndicator var1, DatabaseConnection var2, Project var3, ErrorHandler var4) throws Exception;
    }
}

