/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.DatabaseOpenFileDescriptor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.impl.ModelDescribing;
import com.intellij.database.model.postgres.PostgresModelFun;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.postgres.PostgresTrigger;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.database.model.sqlite.SqliteVirtualTable;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbCustomType;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementImpl;
import com.intellij.database.psi.DbForeignKey;
import com.intellij.database.psi.DbIndex;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.psi.DbSynonymImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableKey;
import com.intellij.database.psi.DbTrigger;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.util.ui.update.ComparableObjectCheck;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbNodeDescriptor
extends PresentableNodeDescriptor
implements DataProvider,
ComparableObject {
    public static final DbNodeDescriptor[] EMPTY_ARRAY = new DbNodeDescriptor[0];
    private final DbElement myElement;

    public DbNodeDescriptor(DbElement element, NodeDescriptor parent) {
        super(element.getProject(), parent);
        this.myElement = element;
    }

    public DbElement getElement() {
        return this.myElement;
    }

    protected void update(PresentationData presentation) {
        DbElement element = this.getElement();
        if (!element.isValid()) {
            return;
        }
        presentation.setChanged(true);
        this.updatePresentation(presentation, element);
    }

    private void updatePresentation(PresentationData presentation, DbElement element) {
        this.updateIcon(presentation, element);
        String nodeText = DbPresentation.getPresentableName((DasObject)element, false);
        presentation.setPresentableText(nodeText);
        SimpleTextAttributes style = this.handleErrors(presentation, element);
        presentation.addText(StringUtil.isEmpty((String)nodeText) ? "<unnamed>" : nodeText, style);
        Object delegate = element.getDelegate();
        if (element instanceof DbDataSource) {
            this.describeDataSource(presentation, (DbDataSource)element);
        }
        if (element instanceof DbNamespaceImpl) {
            this.describeNamespace(presentation, (DbNamespaceImpl)element);
        } else if (element instanceof DbCustomType) {
            this.describeCustomType(presentation, (DbCustomType)element);
        } else if (element instanceof DbColumn) {
            this.describeColumn(presentation, (DbColumn)element);
        } else if (element instanceof DbTable) {
            this.describeTable(presentation, (DbTable)element);
        } else if (element instanceof DbRoutine) {
            this.describeRoutine(presentation, (DbRoutine)element);
        } else if (element instanceof DbTableKey) {
            this.describeTableKey(presentation, (DbTableKey)element);
        } else if (element instanceof DbForeignKey) {
            this.describeForeignKey(presentation, (DbForeignKey)element);
        } else if (element instanceof DbIndex) {
            this.describeIndex(presentation, (DbIndex)element);
        } else if (element instanceof DbSynonymImpl) {
            this.describeSynonym(presentation, (DbSynonymImpl)element);
        } else {
            this.describeByDelegate(presentation, delegate);
        }
    }

    protected void describeByDelegate(PresentationData presentation, Object delegate) {
        if (delegate instanceof DasTypedObject) {
            this.describeTyped(presentation, (DasTypedObject)delegate);
        } else if (delegate instanceof BasicSequence) {
            this.describeSequence(presentation, (BasicSequence)delegate);
        } else if (delegate instanceof DasOperator) {
            this.describeOperator(presentation, (DasOperator)delegate);
        } else if (delegate instanceof BasicTrigger) {
            this.describeTrigger(presentation, (BasicTrigger)delegate);
        } else if (delegate instanceof BasicCheck) {
            this.describeCheck(presentation, (BasicCheck)delegate);
        }
    }

    protected void describeCheck(PresentationData presentation, BasicCheck delegate) {
        String predicate = delegate.getPredicate();
        if (predicate != null) {
            if (!predicate.startsWith("(")) {
                predicate = "(" + predicate + ")";
            }
            predicate = StringUtil.shortenTextWithEllipsis((String)predicate, (int)20, (int)1, (boolean)true);
            presentation.addText(" " + predicate, DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected void describeTrigger(PresentationData presentation, BasicTrigger delegate) {
        String condition;
        Set<TrigEvent> events;
        TrigTurn turn = delegate.getTurn();
        if (turn != null) {
            String turnText = StringUtil.join((Iterable)JBIterable.of((Object[])StringUtil.toLowerCase((String)turn.toString()).split("_")).filter(w -> !w.equals("stmt") && !w.equals("row")), (String)" ");
            presentation.addText(" " + turnText, DbNodeDescriptor.getGrayAttrs());
        }
        if (!(events = delegate.getEvents()).isEmpty()) {
            String eventsText = StringUtil.join((Iterable)JBIterable.from(events).transform(e -> {
                List<String> cols3 = delegate.getColNames();
                if (e == TrigEvent.UPDATE && !cols3.isEmpty()) {
                    return "update of " + StringUtil.join(cols3, (String)", ");
                }
                return StringUtil.toLowerCase((String)e.toString());
            }), (String)", ");
            presentation.addText(" " + eventsText, DbNodeDescriptor.getGrayAttrs());
        }
        if ((condition = delegate.getCondition()) != null) {
            if (!condition.startsWith("(")) {
                condition = "(" + condition + ")";
            }
            condition = StringUtil.shortenTextWithEllipsis((String)condition, (int)20, (int)1, (boolean)true);
            presentation.addText(" " + condition, DbNodeDescriptor.getGrayAttrs());
        }
        if (delegate instanceof PostgresTrigger) {
            String routineName = PostgresModelFun.getCallRoutineName((PostgresTrigger)delegate);
            presentation.addText(' ' + DbNodeDescriptor.arrow() + ' ' + routineName, DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected void describeOperator(PresentationData presentation, DasOperator delegate) {
        DasOperator.OperatorNotation notation = delegate.getOperatorNotation();
        StringBuilder res = new StringBuilder();
        List args = delegate.getArgumentTypes();
        String resType = delegate.getResultType().getSpecification();
        if (notation == DasOperator.OperatorNotation.INFIX) {
            res.append(StringUtil.join((Collection)args, t -> t.getSpecification(), (String)(" " + delegate.getName() + " ")));
        } else {
            if (notation == DasOperator.OperatorNotation.PREFIX) {
                res.append(delegate.getName());
            }
            if (args.size() != 1) {
                res.append("(");
            }
            res.append(StringUtil.join((Collection)args, t -> t.getSpecification(), (String)", "));
            if (args.size() != 1) {
                res.append(")");
            }
            if (notation == DasOperator.OperatorNotation.POSTFIX) {
                res.append(delegate.getName());
            }
        }
        presentation.addText("    " + res + " " + DbNodeDescriptor.arrow() + " " + resType, DbNodeDescriptor.getGrayAttrs());
    }

    protected void describeSequence(PresentationData presentation, BasicSequence delegate) {
        SequenceIdentity si = delegate.getSequenceIdentity();
        if (si != null) {
            String specification = si.getSpecification();
            presentation.addText(" " + specification, DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected void describeTyped(PresentationData presentation, DasTypedObject delegate) {
        String type = delegate.getDataType().getSpecification();
        presentation.addText(" " + type, DbNodeDescriptor.getGrayAttrs());
    }

    protected void describeSynonym(PresentationData presentation, DbSynonymImpl element) {
        Iterable<String> path = element.getTargetPath();
        String pathString = StringUtil.join(path, (String)".");
        if (pathString.length() > 0) {
            String text = " " + DbNodeDescriptor.arrow() + " " + pathString;
            presentation.addText(text, DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected void describeIndex(PresentationData presentation, DbIndex element) {
        String unique = element.isUnique() ? " UNIQUE" : "";
        BasicIndex basicIndex = (BasicIndex)ObjectUtils.tryCast((Object)element.getDelegate(), BasicIndex.class);
        if (basicIndex != null) {
            String indexingItems = ModelDescribing.describeIndexingItems(basicIndex);
            presentation.addText(" (" + indexingItems + ")" + unique, DbNodeDescriptor.getGrayAttrs());
            String condition = basicIndex.getCondition();
            if (condition != null) {
                presentation.addText(" where " + condition, DbNodeDescriptor.getGrayAttrs());
            }
        } else {
            String columns = DbNodeDescriptor.multiRef((MultiRef<? extends DasTypedObject>)element.getColumnsRef());
            presentation.addText(" " + columns + unique, DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected void describeForeignKey(PresentationData presentation, DbForeignKey element) {
        String referencingColumns = DbNodeDescriptor.multiRef((MultiRef<? extends DasTypedObject>)element.getColumnsRef());
        String arrowToReferenced = DbNodeDescriptor.arrowToColumns(element.getRefTableName(), (MultiRef<? extends DasTypedObject>)element.getRefColumns());
        presentation.addText(" " + referencingColumns + " " + arrowToReferenced, DbNodeDescriptor.getGrayAttrs());
    }

    protected void describeTableKey(PresentationData presentation, DbTableKey element) {
        presentation.addText(" " + DbNodeDescriptor.multiRef((MultiRef<? extends DasTypedObject>)element.getColumnsRef()), DbNodeDescriptor.getGrayAttrs());
    }

    protected void describeRoutine(PresentationData presentation, DbRoutine procedure) {
        StringBuilder sb = new StringBuilder();
        DdlBuilder builder = new DdlBuilder(sb).configureFor((DbElement)procedure);
        DbImplUtil.getDatabaseDialect((DbElement)procedure).sqlDefinePrototype(builder, (DasRoutine)procedure, false, true);
        presentation.addText(sb.toString(), DbNodeDescriptor.getGrayAttrs());
    }

    protected void describeTable(PresentationData presentation, DbTable element) {
        Object delegate = element.getDelegate();
        ObjectKind type = element.getKind();
        if (!DbImplUtil.isDataTable(type)) {
            presentation.addText(" " + element.getTypeName(), DbNodeDescriptor.getGrayAttrs());
        }
        if (delegate instanceof PostgresTable) {
            PostgresTable pt = (PostgresTable)delegate;
            boolean hasAncestors = !pt.getAncestorIds().isEmpty();
            boolean hasSuccessors = !pt.getSuccessorIds().isEmpty();
            String s = "";
            if (hasAncestors) {
                s = " based on (" + ModelFun.namesAsString(PostgresModelFun.getAncestors(pt)) + ')';
            }
            if (hasAncestors && hasSuccessors) {
                s = s + " and";
            }
            if (hasSuccessors) {
                s = s + " the base for {" + ModelFun.namesAsString(PostgresModelFun.getSuccessors(pt)) + '}';
            }
            if (hasAncestors || hasSuccessors) {
                presentation.addText(" " + s, DbNodeDescriptor.getGrayAttrs());
            }
        } else if (delegate instanceof SqliteVirtualTable) {
            SqliteVirtualTable vt = (SqliteVirtualTable)delegate;
            String module = vt.getModule();
            List<String> args = vt.getArguments();
            StringBuilder spec = new StringBuilder();
            spec.append(" ");
            if (module != null) {
                spec.append(module);
            }
            spec.append("(");
            StringUtil.join(args, (String)",", (StringBuilder)spec);
            spec.append(")");
            presentation.addText(spec.toString(), DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected void describeColumn(PresentationData presentation, DbColumn column) {
        String d = column.getDataType().getSpecification();
        if (d.length() > 0) {
            presentation.addText(" " + d, DbNodeDescriptor.getGrayAttrs());
        }
        if (DasUtil.isAutoVal((DasColumn)column)) {
            presentation.addText(" (auto increment)", DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected void describeCustomType(PresentationData presentation, DbCustomType element) {
        String description = DbImplUtil.getCustomTypeShortDescription(element.getDelegate());
        if (description != null) {
            presentation.addText(' ' + description, DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected void describeNamespace(PresentationData presentation, DbNamespaceImpl element) {
        this.appendCollapsedNamespaces(presentation, element);
    }

    protected void describeDataSource(PresentationData presentation, DbDataSource element) {
        this.appendCollapsedNamespaces(presentation, (DbElement)element);
    }

    private void appendCollapsedNamespaces(PresentationData presentation, DbElement element) {
        String textExt;
        DbElement root2;
        DatabaseViewOptions options = DatabaseView.getDatabaseView(this.getProject()).getViewOptions();
        DbElement dbElement = root2 = options.SHOW_INTERMEDIATE ? element : DatabaseStructure.getTopSingleRoot(element);
        if (root2 != element && StringUtil.isNotEmpty((String)(textExt = QNameUtil.getQualifiedName(root2)))) {
            presentation.addText(" (" + textExt + ")", DbNodeDescriptor.getGrayAttrs());
        }
    }

    private SimpleTextAttributes handleErrors(PresentationData presentation, DbElement element) {
        SimpleTextAttributes style;
        Object delegate = element.getDelegate();
        boolean hasErrors = false;
        boolean hasWarnings = false;
        if (!this.isValid()) {
            hasErrors = true;
        } else if (element instanceof DbDataSource && delegate instanceof LocalDataSource) {
            hasErrors = !DbImplUtil.canConnectTo(element);
            hasWarnings = hasErrors;
            if (!hasErrors) {
                for (DataSourceProblem problem : DatabaseConfigValidator.getProblems(delegate, null)) {
                    DataSourceProblem.Level level = problem.getLevel();
                    if (level == DataSourceProblem.Level.WARNING) {
                        hasWarnings = true;
                        continue;
                    }
                    if (level != DataSourceProblem.Level.ERROR) continue;
                    hasErrors = true;
                    hasWarnings = true;
                }
            }
        } else if (delegate instanceof BasicSourceAware) {
            hasErrors = ((BasicSourceAware)delegate).isInvalid();
        }
        SimpleTextAttributes simpleTextAttributes = style = DbPresentation.isUnnamed((DasObject)element) ? DbNodeDescriptor.getGrayAttrs() : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (hasErrors || hasWarnings) {
            SimpleTextAttributes waved = new SimpleTextAttributes(8, null, (Color)(hasErrors ? JBColor.RED : JBColor.ORANGE));
            style = SimpleTextAttributes.merge((SimpleTextAttributes)style, (SimpleTextAttributes)waved);
        }
        if (hasErrors && delegate instanceof LocalDataSource && !DbImplUtil.hasDriverFiles((LocalDataSource)delegate)) {
            presentation.setTooltip("Can't find the driver, open preferences to download");
        }
        if (DbImplUtil.isConnected(element)) {
            style = SimpleTextAttributes.merge((SimpleTextAttributes)style, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            presentation.setTooltip("Connected");
        }
        return style;
    }

    private static SimpleTextAttributes getGrayAttrs() {
        return UIUtil.isUnderDarcula() ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
    }

    protected void updateIcon(PresentationData presentation, DbElement element) {
        final Icon icon = element.getIcon();
        presentation.setIcon(icon == null ? null : new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                icon.paintIcon(c, g, x, y);
            }

            @Override
            public int getIconWidth() {
                return icon.getIconWidth() + 3;
            }

            @Override
            public int getIconHeight() {
                return icon.getIconHeight();
            }
        });
    }

    public PresentableNodeDescriptor getChildToHighlightAt(int index) {
        return null;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        return DbNodeDescriptor.getData(dataId, this.getElement());
    }

    static Object getData(@NonNls String dataId, DbElement element) {
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            final Project project = element.getProject();
            final Object delegate = ContainerUtil.getFirstItem(((DbElementImpl)element).getDelegates());
            if (delegate instanceof Navigatable) {
                return delegate;
            }
            if (delegate instanceof DatabaseSystem) {
                VirtualFile virtualFile = delegate instanceof SqlDataSource ? (VirtualFile)ContainerUtil.getFirstItem((List)((SqlDataSource)delegate).getFiles()) : DatabaseEditorHelper.findExistingConsoleVirtualFile((DatabaseSystem)delegate);
                if (virtualFile == null && DbImplUtil.canConnectTo(element)) {
                    return new NavigatableAdapter(){

                        public void navigate(boolean requestFocus) {
                            VirtualFile file = DatabaseEditorHelper.getConsoleVirtualFile((DatabaseSystem)delegate);
                            if (file == null) {
                                return;
                            }
                            new OpenFileDescriptor(project, file).navigate(requestFocus);
                        }
                    };
                }
                return virtualFile == null ? element : new OpenFileDescriptor(project, virtualFile);
            }
            if (delegate instanceof DasNamespace && element.getKind() == ObjectKind.SCHEMA) {
                if (DbImplUtil.canConnectTo(element)) {
                    final DatabaseSystem dataSourceInfo = (DatabaseSystem)ObjectUtils.assertNotNull((Object)element.getDataSource().getDelegate());
                    return new NavigatableAdapter(){

                        public void navigate(boolean requestFocus) {
                            DatabaseEditorHelper.openConsoleFile(project, dataSourceInfo, (DasNamespace)delegate, false);
                        }
                    };
                }
                return element;
            }
            return DbNodeDescriptor.getNavigatableImpl(project, element);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return element;
        }
        return null;
    }

    @NotNull
    public static Object getNavigatableImpl(Project project, DbElement element) {
        DatabaseFamilyId familyId;
        boolean isTrigger = element instanceof DbTrigger;
        DbElement parent = element.getDbParent();
        DbElement adjusted = element;
        if (parent instanceof DbTable) {
            if (!isTrigger) {
                adjusted = parent;
            }
        } else if (parent instanceof DbPackage && !(familyId = DbImplUtil.getDatabaseDialect(element).getFamilyId()).isSybase()) {
            DbElement body = (DbElement)parent.getDbChildren(DbElement.class, ObjectKind.BODY).first();
            adjusted = (DbElement)ObjectUtils.chooseNotNull((Object)body, (Object)parent);
        }
        DbElementNavigatable dbElementNavigatable = new DbElementNavigatable(adjusted, element);
        if (dbElementNavigatable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "getNavigatableImpl"));
        }
        return dbElementNavigatable;
    }

    public boolean expandOnDoubleClick() {
        return !(this.getElement() instanceof DbTable);
    }

    public boolean isValid() {
        return this.getElement().isValid();
    }

    public int getWeight() {
        DbElement element = this.getElement();
        if (element == null || !element.isValid()) {
            return super.getWeight();
        }
        return element.getWeight();
    }

    public String toString() {
        return super.toString();
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myElement};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "getEqualityObjects"));
        }
        return objectArray;
    }

    public final boolean equals(Object o) {
        return ComparableObjectCheck.equals((ComparableObject)this, (Object)o);
    }

    public final int hashCode() {
        return ComparableObjectCheck.hashCode((ComparableObject)this, (int)super.hashCode());
    }

    @NotNull
    public static String arrowToColumns(@Nullable String tableName, @NotNull Collection<String> columnNames) {
        if (columnNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnNames", "com/intellij/database/view/DbNodeDescriptor", "arrowToColumns"));
        }
        String string = StringUtil.isEmpty((String)tableName) ? "" : DbNodeDescriptor.arrow() + " " + tableName + " " + DbNodeDescriptor.multiRef(columnNames);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "arrowToColumns"));
        }
        return string;
    }

    @NotNull
    public static String arrowToColumns(@Nullable String tableName, @NotNull MultiRef<? extends DasTypedObject> columnsRef) {
        if (columnsRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnsRef", "com/intellij/database/view/DbNodeDescriptor", "arrowToColumns"));
        }
        String string = StringUtil.isEmpty((String)tableName) ? "" : DbNodeDescriptor.arrow() + " " + tableName + " " + DbNodeDescriptor.multiRef(columnsRef);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "arrowToColumns"));
        }
        return string;
    }

    @NotNull
    public static String multiRef(@NotNull Collection<String> names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/database/view/DbNodeDescriptor", "multiRef"));
        }
        String string = names.size() == 0 ? "" : "(" + StringUtil.join(names, (String)", ") + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "multiRef"));
        }
        return string;
    }

    @NotNull
    public static String multiRef(@NotNull MultiRef<? extends DasTypedObject> ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/database/view/DbNodeDescriptor", "multiRef"));
        }
        String string = ref.size() == 0 ? "" : "(" + StringUtil.join((Iterable)JBIterable.from((Iterable)ref.names()).filter(n -> n != null), (String)", ") + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "multiRef"));
        }
        return string;
    }

    @NotNull
    public static String arrow() {
        String string = ApplicationManager.getApplication().isUnitTestMode() ? "->" : UIUtil.rightArrow();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "arrow"));
        }
        return string;
    }

    public static class DbElementNavigatable
    extends NavigatableAdapter {
        private final DbElement myAdjusted;
        private final DbElement myElement;

        public DbElementNavigatable(DbElement adjusted, DbElement element) {
            this.myAdjusted = adjusted;
            this.myElement = element;
        }

        public DbElement getElement() {
            return this.myAdjusted;
        }

        public void navigate(boolean requestFocus) {
            VirtualFile virtualFile = DbImplUtil.findVirtualFile(this.myAdjusted, true);
            if (virtualFile != null && virtualFile.isValid()) {
                int offset;
                boolean isTrigger = this.myElement instanceof DbTrigger;
                boolean isTable = DatabaseEditorHelper.isTableDataAvailable(this.myAdjusted) || DatabaseEditorHelper.isDefinitionAvailable(this.myAdjusted);
                int n = offset = this.myAdjusted == this.myElement ? -1 : DatabaseOpenFileDescriptor.calcTargetOffset(this.myAdjusted.getProject(), virtualFile, (DasObject)this.myElement);
                if (isTable || isTrigger) {
                    new DatabaseOpenFileDescriptor(this.myAdjusted.getProject(), virtualFile, offset).navigate(requestFocus);
                    return;
                }
            }
            this.myAdjusted.navigate(requestFocus);
        }
    }
}

