/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.view.models.MergedDasModel;
import com.intellij.database.view.models.SqlFileModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseEditorContext {
    @Nullable
    private Project myProject;
    @NotNull
    private DatabaseDialectEx myDialect;
    @NotNull
    private DasModel myModel;
    @Nullable
    private DbDataSource myDataSource;
    @Nullable
    private DasNamespace myCurrentNamespace;
    @Nullable
    private VirtualFile myVirtualFile;

    public DatabaseEditorContext(@NotNull DbElement element, @Nullable VirtualFile virtualFile) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/editors/DatabaseEditorContext", "<init>"));
        }
        this(element.getDataSource(), DbImplUtil.getSearchPathObjectForSwitch(element), virtualFile);
    }

    public DatabaseEditorContext(@NotNull DbDataSource dataSource, @Nullable DasNamespace namespace, @Nullable VirtualFile virtualFile) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/view/editors/DatabaseEditorContext", "<init>"));
        }
        this(dataSource.getProject(), DbImplUtil.getDatabaseDialect((DbElement)dataSource), dataSource.getModel(), dataSource, namespace, virtualFile);
    }

    public DatabaseEditorContext(@NotNull SqlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/view/editors/DatabaseEditorContext", "<init>"));
        }
        this(file, DbImplUtil.getForcedDataSource((PsiFile)file), new SqlFileModel(file));
    }

    public DatabaseEditorContext(@NotNull SqlFile file, @Nullable DbDataSource dataSource, @NotNull DasModel model) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/view/editors/DatabaseEditorContext", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/editors/DatabaseEditorContext", "<init>"));
        }
        this(file.getProject(), (DatabaseDialectEx)file.getSqlLanguage().getDatabaseDialect(), model, dataSource, (DasNamespace)ContainerUtil.getFirstItem(DatabaseEditorHelper.getSearchPath((PsiFile)file)), file.getVirtualFile().isWritable() ? file.getVirtualFile() : null);
    }

    @NotNull
    public static DatabaseEditorContext forFile(@NotNull SqlFile file) {
        DbDataSource dataSource2;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/view/editors/DatabaseEditorContext", "forFile"));
        }
        DbDataSource forced = DbImplUtil.getForcedDataSource((PsiFile)file);
        JBIterable<DbDataSource> dataSources = forced == null ? DbSqlUtil.getAppropriateDataSources((PsiFile)file, false, true) : JBIterable.of((Object)forced);
        for (DbDataSource dataSource2 : dataSources) {
            SqlDataSource sqlSource = (SqlDataSource)ObjectUtils.tryCast((Object)dataSource2.getDelegate(), SqlDataSource.class);
            if (sqlSource == null || !sqlSource.getSqlFiles().contains((Object)file)) continue;
            DatabaseEditorContext databaseEditorContext = new DatabaseEditorContext((DbElement)dataSource2, file.getVirtualFile());
            if (databaseEditorContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorContext", "forFile"));
            }
            return databaseEditorContext;
        }
        if (dataSources.isEmpty()) {
            DatabaseEditorContext databaseEditorContext = new DatabaseEditorContext(file);
            if (databaseEditorContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorContext", "forFile"));
            }
            return databaseEditorContext;
        }
        MergedDasModel model = new MergedDasModel((Iterable<? extends DasModel>)dataSources.transform(DbDataSource::getModel).append((Object)new SqlFileModel(file)));
        dataSource2 = dataSources.size() == 1 ? (DbDataSource)dataSources.first() : null;
        DatabaseEditorContext databaseEditorContext = new DatabaseEditorContext(file, dataSource2, model);
        if (databaseEditorContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorContext", "forFile"));
        }
        return databaseEditorContext;
    }

    public DatabaseEditorContext(@Nullable Project project, @NotNull DatabaseDialectEx dialect, @NotNull DasModel model, @Nullable DbDataSource dataSource, @Nullable DasNamespace currentNamespace, @Nullable VirtualFile virtualFile) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/view/editors/DatabaseEditorContext", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/editors/DatabaseEditorContext", "<init>"));
        }
        this.myProject = project;
        this.myDialect = dialect;
        this.myModel = model;
        this.myDataSource = dataSource;
        this.myCurrentNamespace = currentNamespace;
        this.myVirtualFile = virtualFile;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public DatabaseDialectEx getDialect() {
        DatabaseDialectEx databaseDialectEx = this.myDialect;
        if (databaseDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorContext", "getDialect"));
        }
        return databaseDialectEx;
    }

    @NotNull
    public DasModel getModel() {
        DasModel dasModel = this.myModel;
        if (dasModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorContext", "getModel"));
        }
        return dasModel;
    }

    @Nullable
    public DbDataSource getDataSource() {
        return this.myDataSource;
    }

    @Nullable
    public DasNamespace getCurrentNamespace() {
        return this.myCurrentNamespace;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @Nullable
    public VirtualFile getOrCreateVirtualFile() {
        if (this.myVirtualFile != null) {
            return this.myVirtualFile;
        }
        if (this.myDataSource != null) {
            return DatabaseEditorHelper.getConsoleVirtualFile((DatabaseSystem)this.myDataSource);
        }
        return null;
    }
}

