/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.DdlPreview;
import com.intellij.database.view.editors.ShutSplitter;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectEditorWithPreview {
    protected DatabaseEditorBaseEx myEditor;
    private final JComponent myPanel;
    private DdlPreview myDdlPreview;
    private boolean myInvalid;
    private EventDispatcher<PreviewListener> myPreviewListener = EventDispatcher.create(PreviewListener.class);
    private DdlPreview.ModelTraverser myTraverser = null;
    private JComponent myTrailWidget;

    public JComponent getPreferredFocusedComponent() {
        return this.myEditor == null ? null : this.myEditor.getPreferredFocusedComponent();
    }

    public ObjectEditorWithPreview() {
        this.myPanel = new JPanel(new BorderLayout());
    }

    public void subscribePreviewChanged(@NotNull PreviewListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/view/editors/ObjectEditorWithPreview", "subscribePreviewChanged"));
        }
        this.myPreviewListener.addListener((EventListener)listener);
    }

    public void setTrailWidget(@Nullable JComponent widget) {
        this.myTrailWidget = widget;
    }

    public void setEditor(@NotNull DatabaseEditorBaseEx editor, @NotNull DdlPreview.ModelTraverser traverser) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/view/editors/ObjectEditorWithPreview", "setEditor"));
        }
        if (traverser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traverser", "com/intellij/database/view/editors/ObjectEditorWithPreview", "setEditor"));
        }
        assert (this.myEditor == null);
        this.myEditor = editor;
        this.myTraverser = traverser;
        this.myDdlPreview = new DdlPreview(editor.getContext(), DatabaseDialogsHelper.createAsyncProcessor(this.myEditor.getProject(), "Fetching DDL", () -> this.updatePreview()));
        this.myDdlPreview.getComponent().setMinimumSize((Dimension)JBUI.size((int)100));
        this.myEditor.addListener(new EditorModelBase.Listener(){

            @Override
            public void changed() {
                ObjectEditorWithPreview.this.updatePreview();
            }
        }, editor);
        this.myPanel.removeAll();
        final ShutSplitter splitter = DatabaseEditorUtil.createHideableSplitter("SQL &Script", this.myEditor.getComponent(), this.myDdlPreview.getComponent(), ObjectEditorWithPreview.class.getName());
        splitter.setTrailWidged(this.myTrailWidget);
        splitter.setTitleLabelFor(this.myDdlPreview.getPreferredFocusedComponent());
        Shortcut[] shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)"QuickImplementations").getShortcuts();
        new DumbAwareAction("Toggle SQL Script Preview", "Toggle SQL script preview", null){

            public void actionPerformed(AnActionEvent e) {
                splitter.setShut(!splitter.isShut());
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), (JComponent)((Object)splitter));
        String tooltip = "Toggle SQL script preview";
        if (shortcuts.length != 0) {
            tooltip = tooltip + " (" + KeymapUtil.getShortcutsText((Shortcut[])shortcuts) + ")";
        }
        splitter.setDividerToolTipText(tooltip);
        this.myPanel.add((Component)((Object)splitter), "Center");
        this.updatePreview();
    }

    public void updatePreview() {
        if (this.myEditor == null) {
            return;
        }
        if (this.myTraverser == null) {
            this.myTraverser = new DdlPreview.ModelTraverser(this.myEditor.getModel().getModel());
        }
        this.myInvalid = !this.myDdlPreview.updatePreview(this.myTraverser);
        ((PreviewListener)this.myPreviewListener.getMulticaster()).changed();
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/ObjectEditorWithPreview", "getComponent"));
        }
        return jComponent;
    }

    public boolean isInvalid() {
        return this.myInvalid;
    }

    @NotNull
    public String getStatement() {
        String string = this.myDdlPreview == null ? "" : this.myDdlPreview.getPreviewText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/ObjectEditorWithPreview", "getStatement"));
        }
        return string;
    }

    public static interface PreviewListener
    extends EventListener {
        public void changed();
    }
}

