/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.view.ui.FilteringTree;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.util.Conditions;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbCheckBoxTree<N extends MyNode<N>>
extends CheckboxTree {
    public DbCheckBoxTree(@NotNull CheckedTreeNode root2, @NotNull CheckboxTree.CheckboxTreeCellRenderer renderer) {
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/view/ui/DbCheckBoxTree", "<init>"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/database/view/ui/DbCheckBoxTree", "<init>"));
        }
        super(renderer, root2, new CheckboxTreeBase.CheckPolicy(false, true, true, false));
    }

    protected void installSpeedSearch() {
    }

    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401 && e.getKeyCode() == 32 && e.getModifiers() == 0) {
            TreePath path = this.getLeadSelectionPath();
            CheckedTreeNode node = path == null ? null : (CheckedTreeNode)ObjectUtils.tryCast((Object)path.getLastPathComponent(), CheckedTreeNode.class);
            boolean state = node != null && node.isChecked();
            CheckedTreeNode[] sel = (CheckedTreeNode[])this.getSelectedNodes(CheckedTreeNode.class, CheckedTreeNode::isEnabled);
            if (sel.length != 0) {
                for (CheckedTreeNode treeNode : sel) {
                    this.setNodeState(treeNode, !state);
                }
                this.updateFromNodes();
                e.consume();
            }
            return;
        }
        super.processKeyEvent(e);
    }

    public void updateFromNodes() {
        DbCheckBoxTree.updateEnabled((Tree)this, null);
    }

    @NotNull
    public FilteringTree.SearchTreeModel<CheckedTreeNode, N> getSearchModel() {
        FilteringTree.SearchTreeModel searchTreeModel = (FilteringTree.SearchTreeModel)this.getModel();
        if (searchTreeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbCheckBoxTree", "getSearchModel"));
        }
        return searchTreeModel;
    }

    protected void onNodeStateChanged(CheckedTreeNode treeNode) {
        super.onNodeStateChanged(treeNode);
        FilteringTree.SearchTreeModel<CheckedTreeNode, CheckedTreeNode> model = this.getSearchModel();
        MyNode node = (MyNode)model.getUserObject(treeNode);
        if (node != null) {
            DbCheckBoxTree.updateEnabled((Tree)this, node.getObject() == "*" ? node.getParent() : node);
        }
    }

    private static <N extends MyNode<N>> void updateEnabled(Tree tree, N root2) {
        FilteringTree.SearchTreeModel searchModel = (FilteringTree.SearchTreeModel)tree.getModel();
        JBTreeTraverser traverser = new JBTreeTraverser(n -> n.getChildNodes());
        if (root2 == null) {
            root2 = (MyNode)searchModel.getRootObject();
        }
        root2 = (MyNode)ObjectUtils.chooseNotNull((Object)JBIterable.generate(root2, n -> n.getParent()).filter(n -> !DbCheckBoxTree.isSubtreeEnabled(n)).last(), root2);
        for (MyNode enabledNode : (JBTreeTraverser)((JBTreeTraverser)traverser.withRoot(root2)).expand(n -> DbCheckBoxTree.isSubtreeEnabled(n))) {
            DbCheckBoxTree.setEnabled(searchModel, enabledNode, true);
            if (DbCheckBoxTree.isSubtreeEnabled(enabledNode)) continue;
            DbCheckBoxTree.setEnabled(searchModel, enabledNode.getAllNode(), true);
            for (MyNode disabledNode : (JBTreeTraverser)((JBTreeTraverser)traverser.withRoots(enabledNode.getSimpleChildNodes())).expand(Conditions.alwaysTrue())) {
                DbCheckBoxTree.setEnabled(searchModel, disabledNode, false);
            }
        }
        tree.repaint();
        tree.revalidate();
    }

    private static boolean isSubtreeEnabled(MyNode n) {
        return n.getAllNodeState() != ThreeState.YES;
    }

    private static <N extends MyNode<N>> void setEnabled(@NotNull FilteringTree.SearchTreeModel<CheckedTreeNode, N> m, @Nullable N n, boolean e) {
        if (m == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/intellij/database/view/ui/DbCheckBoxTree", "setEnabled"));
        }
        CheckedTreeNode node = m.getCachedNode(n);
        if (node != null) {
            node.setEnabled(e);
        }
    }

    @Nullable
    public static <T extends DbCheckBoxTree> T getTree(@NotNull DataContext dataContext, @NotNull Class<T> clazz) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/view/ui/DbCheckBoxTree", "getTree"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/view/ui/DbCheckBoxTree", "getTree"));
        }
        return (T)((Object)((DbCheckBoxTree)((Object)ObjectUtils.tryCast((Object)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext), clazz))));
    }

    protected static abstract class CellWithUnderlinedAllRenderer<N extends MyNode<N>>
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private final Color SEP_COLOR = UIManager.getColor("Label.disabledForeground");
        private final Border OVERLINE = JBUI.Borders.customLine((Color)this.SEP_COLOR, (int)1, (int)0, (int)0, (int)0);
        private final Border UNDERLINE = JBUI.Borders.customLine((Color)this.SEP_COLOR, (int)0, (int)0, (int)1, (int)0);

        public CellWithUnderlinedAllRenderer() {
            super(true, false);
        }

        public void customizeRenderer(JTree baseTree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DbCheckBoxTree tree = (DbCheckBoxTree)((Object)ObjectUtils.tryCast((Object)baseTree, DbCheckBoxTree.class));
            CheckedTreeNode treeNode = (CheckedTreeNode)ObjectUtils.tryCast((Object)value, CheckedTreeNode.class);
            if (tree == null || !(tree.getModel() instanceof FilteringTree.SearchTreeModel) || treeNode == null) {
                return;
            }
            ColoredTreeCellRenderer renderer = this.getTextRenderer();
            MyNode node = (MyNode)tree.getSearchModel().getUserObject(treeNode);
            if (node != null) {
                this.customizeCheckboxRenderer(node);
                if (UIUtil.isClientPropertyTrue((Object)baseTree, (Object)ExpandableItemsHandler.EXPANDED_RENDERER)) {
                    this.setBorder(null);
                } else {
                    this.updateBorder((TreeNode)treeNode, node);
                }
            }
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)((Object)tree), (SimpleColoredComponent)renderer, (boolean)true, (boolean)selected);
        }

        protected void updateBorder(@NotNull TreeNode treeNode, @NotNull N node) {
            int idx;
            N c1;
            if (treeNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeNode", "com/intellij/database/view/ui/DbCheckBoxTree$CellWithUnderlinedAllRenderer", "updateBorder"));
            }
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/view/ui/DbCheckBoxTree$CellWithUnderlinedAllRenderer", "updateBorder"));
            }
            TreeNode parent = treeNode.getParent();
            N c0 = this.getChild(parent, 0);
            N n = c1 = c0 == null ? null : (N)this.getChild(parent, 1);
            int n2 = node == c0 ? 0 : (idx = node == c1 ? 1 : -1);
            if (idx != -1 && c1 != null && ((MyNode)c0).getObject() == "*") {
                boolean isFirst;
                SimpleColoredText text = new SimpleColoredText();
                this.renderText(c0, (ColoredTextContainer)text);
                String t0 = text.toString();
                text.clear();
                this.renderText(c1, (ColoredTextContainer)text);
                String t1 = text.toString();
                boolean useFirst = t0.length() > t1.length();
                boolean bl = isFirst = idx == 0;
                this.setBorder(useFirst == isFirst ? (isFirst ? this.UNDERLINE : this.OVERLINE) : null);
            } else {
                this.setBorder(null);
            }
        }

        @Nullable
        protected N getChild(@Nullable TreeNode parent, int idx) {
            if (parent == null || idx >= parent.getChildCount()) {
                return null;
            }
            CheckedTreeNode treeNode = (CheckedTreeNode)ObjectUtils.tryCast((Object)parent.getChildAt(idx), CheckedTreeNode.class);
            return (N)(treeNode == null ? null : (MyNode)treeNode.getUserObject());
        }

        protected abstract void customizeCheckboxRenderer(N var1);

        protected abstract void renderText(N var1, ColoredTextContainer var2);
    }

    public static abstract class MyNode<Self extends MyNode<Self>> {
        private Self myAllNode;
        private List<Self> myChildren = null;
        private List<Self> myShadowChildren = null;
        private Self myParent = null;
        private boolean myChecked;
        private final String myName;
        private final ObjectKind myKind;
        private Object myObject;

        public MyNode(String name, ObjectKind kind, Object object) {
            this.myName = name;
            this.myKind = kind;
            this.myObject = object;
        }

        @NotNull
        public List<Self> getChildren() {
            List list = (List)ObjectUtils.chooseNotNull(this.myChildren, Collections.emptyList());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbCheckBoxTree$MyNode", "getChildren"));
            }
            return list;
        }

        @NotNull
        public List<Self> getShadowChildren() {
            List list = (List)ObjectUtils.chooseNotNull(this.myShadowChildren, Collections.emptyList());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbCheckBoxTree$MyNode", "getShadowChildren"));
            }
            return list;
        }

        public void setChildren(@Nullable Collection<Self> children) {
            this.myChildren = ContainerUtil.isEmpty(children) ? null : new SmartList(children);
            this.reparent((Collection<Self>)this.myChildren);
        }

        public void setShadowChildren(@Nullable Collection<Self> children) {
            this.myShadowChildren = ContainerUtil.isEmpty(children) ? null : new SmartList(children);
            this.reparent((Collection<Self>)this.myShadowChildren);
        }

        public void setHasAll(boolean has) {
            if (has == (this.myAllNode != null)) {
                return;
            }
            if (has) {
                this.myAllNode = this.createAll();
                this.reparent(Collections.singletonList(this.myAllNode));
            } else {
                this.myAllNode = null;
            }
        }

        @Nullable
        public Self getAllNode() {
            return this.myAllNode;
        }

        @NotNull
        public ThreeState getAllNodeState() {
            Self node = this.getAllNode();
            ThreeState threeState = node == null ? ThreeState.UNSURE : ThreeState.fromBoolean((boolean)((MyNode)node).isChecked());
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbCheckBoxTree$MyNode", "getAllNodeState"));
            }
            return threeState;
        }

        public void setObject(Object object) {
            this.myObject = object;
        }

        public String getName() {
            return this.myName;
        }

        public ObjectKind getKind() {
            return this.myKind;
        }

        public Object getObject() {
            return this.myObject;
        }

        public boolean isChecked() {
            return this.myChecked;
        }

        public void setChecked(boolean checked) {
            this.myChecked = checked;
        }

        public void purgeShadow() {
            this.setShadowChildren(null);
            for (MyNode node : this.getChildren()) {
                node.purgeShadow();
            }
        }

        @Nullable
        public ObjectKind getChildKind() {
            return this.getKind() == ObjectKind.DATABASE ? ObjectKind.SCHEMA : null;
        }

        protected void reparent(@Nullable Collection<Self> children) {
            if (children == null) {
                return;
            }
            for (MyNode child : children) {
                if (child.myParent != null && child.myParent != this) {
                    throw new AssertionError((Object)"Already has parent");
                }
                child.myParent = this;
            }
        }

        @NotNull
        public JBIterable<Self> getChildNodes() {
            JBIterable jBIterable = this.myAllNode == null ? JBIterable.from(this.getSimpleChildNodes()) : JBIterable.of(this.myAllNode).append(this.getSimpleChildNodes());
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbCheckBoxTree$MyNode", "getChildNodes"));
            }
            return jBIterable;
        }

        @NotNull
        public Iterable<Self> getSimpleChildNodes() {
            if (this.myChildren == null) {
                List<Self> list = this.getShadowChildren();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbCheckBoxTree$MyNode", "getSimpleChildNodes"));
                }
                return list;
            }
            if (this.myShadowChildren == null) {
                List<Self> list = this.getChildren();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbCheckBoxTree$MyNode", "getSimpleChildNodes"));
                }
                return list;
            }
            JBIterable jBIterable = JBIterable.from(this.myChildren).append(this.myShadowChildren);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbCheckBoxTree$MyNode", "getSimpleChildNodes"));
            }
            return jBIterable;
        }

        @Nullable
        public Self getParent() {
            return this.myParent;
        }

        @NotNull
        protected abstract Self createAll();
    }
}

