/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.editors.DatabaseColumnRefEditor;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.editors.DatabaseTableColumnEditor;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.database.view.ui.DbObjectDialog;
import com.intellij.database.view.ui.DbTableDialog;
import com.intellij.openapi.util.Computable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbRefactoringDialogHelper {
    @NotNull
    public static DbTableDialog newAddTableDialog(@NotNull DatabaseEditorContext context, @Nullable DasNamespace schema, @NotNull String tabName, @NotNull Collection<String> colNames) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newAddTableDialog"));
        }
        if (tabName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabName", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newAddTableDialog"));
        }
        if (colNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colNames", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newAddTableDialog"));
        }
        DbTableDialog dialog = new DbTableDialog(context);
        dialog.setTable(dialog.createTable(schema, tabName, colNames), false);
        DbTableDialog dbTableDialog = dialog;
        if (dbTableDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newAddTableDialog"));
        }
        return dbTableDialog;
    }

    @NotNull
    public static DbTableDialog newModifyTableDialog(@NotNull DatabaseEditorContext context, @NotNull DasTable table, boolean forceCreate) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newModifyTableDialog"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newModifyTableDialog"));
        }
        DbTableDialog dialog = new DbTableDialog(context);
        dialog.configureForModification((DasObject)table, forceCreate);
        DbTableDialog dbTableDialog = dialog;
        if (dbTableDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newModifyTableDialog"));
        }
        return dbTableDialog;
    }

    @NotNull
    public static DbTableDialog newModifyTableDialog(@NotNull DatabaseEditorContext context, @NotNull DasTable table) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newModifyTableDialog"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newModifyTableDialog"));
        }
        DbTableDialog dbTableDialog = DbRefactoringDialogHelper.newModifyTableDialog(context, table, false);
        if (dbTableDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newModifyTableDialog"));
        }
        return dbTableDialog;
    }

    @NotNull
    public static DbTableDialog newAddColumnDialog(@NotNull DatabaseEditorContext context, @NotNull DasTable table, @NotNull String colName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newAddColumnDialog"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newAddColumnDialog"));
        }
        if (colName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colName", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newAddColumnDialog"));
        }
        DbTableDialog dialog = new DbTableDialog(context);
        dialog.configureForModification(DbRefactoringDialogHelper.createColumn(dialog, table, colName), false);
        DbTableDialog dbTableDialog = dialog;
        if (dbTableDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newAddColumnDialog"));
        }
        return dbTableDialog;
    }

    @NotNull
    public static DbTableDialog newModifyColumnDialog(@NotNull DatabaseEditorContext context, @NotNull DasColumn column, boolean forceCreate) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newModifyColumnDialog"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newModifyColumnDialog"));
        }
        DbTableDialog dialog = new DbTableDialog(context);
        dialog.configureForModification((DasObject)column, forceCreate);
        DbTableDialog dbTableDialog = dialog;
        if (dbTableDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newModifyColumnDialog"));
        }
        return dbTableDialog;
    }

    public static DbTableDialog newAddForeignKeyDialog(@NotNull DatabaseEditorContext context, @NotNull DasTable table, @NotNull String fkName, @NotNull List<? extends DasColumn> columns) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newAddForeignKeyDialog"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newAddForeignKeyDialog"));
        }
        if (fkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fkName", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newAddForeignKeyDialog"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newAddForeignKeyDialog"));
        }
        DbTableDialog dialog = new DbTableDialog(context);
        dialog.configureForModification(DbRefactoringDialogHelper.createForeignKey(dialog, table, fkName, columns), false);
        return dialog;
    }

    @NotNull
    public static DbTableDialog newModifyForeignKeyDialog(@NotNull DatabaseEditorContext context, @NotNull DasForeignKey fk, boolean forceCreate) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newModifyForeignKeyDialog"));
        }
        if (fk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fk", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newModifyForeignKeyDialog"));
        }
        DbTableDialog dialog = new DbTableDialog(context);
        dialog.configureForModification((DasObject)fk, forceCreate);
        DbTableDialog dbTableDialog = dialog;
        if (dbTableDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newModifyForeignKeyDialog"));
        }
        return dbTableDialog;
    }

    @NotNull
    public static DbTableDialog newAddIndexDialog(@NotNull DatabaseEditorContext context, @NotNull DasTable table, @NotNull String idxName, @NotNull List<? extends DasColumn> columns) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newAddIndexDialog"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newAddIndexDialog"));
        }
        if (idxName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idxName", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newAddIndexDialog"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newAddIndexDialog"));
        }
        DbTableDialog dialog = new DbTableDialog(context);
        dialog.configureForModification(DbRefactoringDialogHelper.createIndex(dialog, table, idxName, columns), false);
        DbTableDialog dbTableDialog = dialog;
        if (dbTableDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newAddIndexDialog"));
        }
        return dbTableDialog;
    }

    @NotNull
    public static DbTableDialog newModifyIndexDialog(@NotNull DatabaseEditorContext context, @NotNull DasIndex index, boolean forceCreate) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newModifyIndexDialog"));
        }
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newModifyIndexDialog"));
        }
        DbTableDialog dialog = new DbTableDialog(context);
        dialog.configureForModification((DasObject)index, forceCreate);
        DbTableDialog dbTableDialog = dialog;
        if (dbTableDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newModifyIndexDialog"));
        }
        return dbTableDialog;
    }

    @NotNull
    public static DbObjectDialog newAddObjectDialog(@NotNull DatabaseEditorContext context, @Nullable DasNamespace parent, @NotNull String name, @NotNull ObjectKind kind) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newAddObjectDialog"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newAddObjectDialog"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newAddObjectDialog"));
        }
        DbObjectDialog dialog = new DbObjectDialog(context, kind);
        DeObject object = dialog.createEmptyTemplate((DasObject)parent, kind);
        object.name = name;
        dialog.configureForCreation(object, false);
        DbObjectDialog dbObjectDialog = dialog;
        if (dbObjectDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "newAddObjectDialog"));
        }
        return dbObjectDialog;
    }

    @NotNull
    public static DeIndex createIndex(@NotNull AbstractDbRefactoringDialog<?> dialog, @NotNull DasTable table, @NotNull String idxName, @NotNull List<? extends DasColumn> columns) {
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "createIndex"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "createIndex"));
        }
        if (idxName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idxName", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "createIndex"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "createIndex"));
        }
        dialog.checkObjectInContext((DasObject)table);
        DeTable tab = (DeTable)dialog.export((DasObject)table, true);
        ArrayList items = ContainerUtil.newArrayListWithCapacity((int)columns.size());
        for (DasColumn dasColumn : columns) {
            items.add(new DeIndex.Item((DeColumn)dialog.export((DasObject)dasColumn, false), DasIndex.Sorting.NONE));
        }
        DeIndex index = new DeIndex(idxName, tab, dialog.myModel);
        index.items.addAll(items);
        tab.indices.add(index);
        DeIndex deIndex = index;
        if (deIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "createIndex"));
        }
        return deIndex;
    }

    @NotNull
    public static DeForeignKey createForeignKey(@NotNull AbstractDbRefactoringDialog<?> dialog, @NotNull DasTable table, @NotNull String fkName, @NotNull List<? extends DasColumn> columns) {
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "createForeignKey"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "createForeignKey"));
        }
        if (fkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fkName", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "createForeignKey"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "createForeignKey"));
        }
        dialog.checkObjectInContext((DasObject)table);
        DeTable tab = (DeTable)dialog.export((DasObject)table, true);
        ArrayList refs = ContainerUtil.newArrayListWithCapacity((int)columns.size());
        for (DasColumn dasColumn : columns) {
            refs.add(new DeForeignKey.Ref((DeColumn)dialog.export((DasObject)dasColumn, true), DatabaseColumnRefEditor.createStub("", tab)));
        }
        DeForeignKey fk = new DeForeignKey(fkName, tab, dialog.myModel);
        fk.refs.addAll(refs);
        tab.foreignKeys.add(fk);
        DeForeignKey deForeignKey = fk;
        if (deForeignKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "createForeignKey"));
        }
        return deForeignKey;
    }

    @NotNull
    public static DeColumn createColumn(@NotNull AbstractDbRefactoringDialog<?> dialog, @NotNull DasTable table, @NotNull String colName) {
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "createColumn"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "createColumn"));
        }
        if (colName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colName", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "createColumn"));
        }
        dialog.checkObjectInContext((DasObject)table);
        DeTable tab = (DeTable)dialog.export((DasObject)table, true);
        DeColumn column = new DeColumn(colName, tab, dialog.myModel);
        tab.columns.add(column);
        DeColumn deColumn = column;
        if (deColumn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "createColumn"));
        }
        return deColumn;
    }

    public static void runOnceValid(final @NotNull DatabaseEditorState state, final @NotNull Runnable r) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "runOnceValid"));
        }
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "runOnceValid"));
        }
        if (state.areAllEditorsValid()) {
            r.run();
        } else {
            state.validationTopic.addListener((EventListener)new EditorModelBase.Listener(){

                @Override
                public void changed() {
                    try {
                        r.run();
                    }
                    finally {
                        state.validationTopic.removeListener((EventListener)this);
                    }
                }
            });
        }
    }

    public static void runOnceValid(@NotNull AbstractDbRefactoringDialog<?> dialog, @NotNull Runnable r) {
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "runOnceValid"));
        }
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "runOnceValid"));
        }
        DbRefactoringDialogHelper.runOnceValid(dialog.getState(), r);
    }

    public static DbTableDialog bootstrap(@NotNull DbTableDialog dialog, @NotNull Computable<DeObject> comp) {
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "bootstrap"));
        }
        if (comp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comp", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "bootstrap"));
        }
        DbRefactoringDialogHelper.runOnceValid(dialog, () -> {
            if (comp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comp", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "lambda$bootstrap$1"));
            }
            if (dialog == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "lambda$bootstrap$1"));
            }
            DeObject toModify = (DeObject)comp.compute();
            DbRefactoringDialogHelper.runOnceValid(dialog, () -> {
                if (dialog == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "lambda$null$0"));
                }
                dialog.startItemEditing(toModify);
            });
        });
        return dialog;
    }

    public static <T extends DeObject> JBIterable<T> export(@NotNull DbTableDialog dialog, @NotNull Iterable<? extends DasObject> objects) {
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "export"));
        }
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "export"));
        }
        return JBIterable.from(objects).transform(object -> {
            if (dialog == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "lambda$export$2"));
            }
            return dialog.export((DasObject)object, true);
        });
    }

    public static boolean canAddIndex(@NotNull DatabaseEditorContext context, @NotNull DasTable table) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "canAddIndex"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "canAddIndex"));
        }
        DatabaseDialectEx dialect = context.getDialect();
        return table.getKind() == ObjectKind.TABLE && dialect.getSchemaEditor().getDbEditorCaps().getTableEditorCaps(true).getIndexCaps(false).canDoAnything();
    }

    public static boolean canModifyIndex(@NotNull DatabaseEditorContext context, @NotNull DasIndex index) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "canModifyIndex"));
        }
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "canModifyIndex"));
        }
        DatabaseDialectEx dialect = context.getDialect();
        return dialect.getSchemaEditor().getDbEditorCaps().getTableEditorCaps(true).getIndexCaps(true).canDoAnything();
    }

    public static boolean canAddForeignKey(@NotNull DatabaseEditorContext context, @NotNull DasTable table) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "canAddForeignKey"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "canAddForeignKey"));
        }
        DatabaseDialectEx dialect = context.getDialect();
        return table.getKind() == ObjectKind.TABLE && dialect.getSchemaEditor().getDbEditorCaps().getTableEditorCaps(true).getForeignKeyCaps(false).canDoAnything();
    }

    public static boolean canModifyForeignKey(@NotNull DatabaseEditorContext context, @NotNull DasForeignKey fk) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "canModifyForeignKey"));
        }
        if (fk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fk", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "canModifyForeignKey"));
        }
        DatabaseDialectEx dialect = context.getDialect();
        return dialect.getSchemaEditor().getDbEditorCaps().getTableEditorCaps(true).getForeignKeyCaps(true).canDoAnything();
    }

    public static boolean canModifyColumn(@NotNull DatabaseEditorContext context, @NotNull DasColumn columnElement) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "canModifyColumn"));
        }
        if (columnElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnElement", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "canModifyColumn"));
        }
        DatabaseDialectEx dialect = context.getDialect();
        return DbRefactoringDialogHelper.getColumnCaps(dialect, columnElement).canDoAnything();
    }

    @NotNull
    public static DatabaseEditorCapabilities.TableColumnEditorCaps getColumnCaps(@NotNull DatabaseDialectEx dialect, @NotNull DasColumn column) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "getColumnCaps"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "getColumnCaps"));
        }
        DatabaseEditorCapabilities.TableColumnEditorCaps tableColumnEditorCaps = DatabaseTableColumnEditor.getTableColumnCaps(dialect.getSchemaEditor().getDbEditorCaps().getTableEditorCaps(true), column.getTable(), column);
        if (tableColumnEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbRefactoringDialogHelper", "getColumnCaps"));
        }
        return tableColumnEditorCaps;
    }
}

