/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlInfoElementType;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlTokenType;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlProcedureParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<SqlExpressionList, SqlFunctionsUtil.ExpressionList, PsiElement> {
    private static final Set<? extends Class> ourStopSearch = Collections.singleton(SqlStatement.class);
    private static final Set<Class> ourAllowedParents = Collections.singleton(SqlFunctionCallExpression.class);

    public boolean couldShowInLookup() {
        return true;
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        return null;
    }

    public Object[] getParametersForDocumentation(SqlFunctionsUtil.ExpressionList p, ParameterInfoContext context) {
        return new Object[]{p};
    }

    public SqlExpressionList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/SqlProcedureParameterInfoHandler", "findElementForParameterInfo"));
        }
        SqlExpressionList result2 = SqlProcedureParameterInfoHandler.findExpressions((ParameterInfoContext)context);
        if (result2 != null) {
            SqlFunctionCallExpression callExpression = (SqlFunctionCallExpression)result2.getParent();
            context.setItemsToShow((Object[])SqlFunctionsUtil.getOverloads(callExpression));
        }
        return result2;
    }

    public void showParameterInfo(@NotNull SqlExpressionList element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlProcedureParameterInfoHandler", "showParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/SqlProcedureParameterInfoHandler", "showParameterInfo"));
        }
        context.showHint((PsiElement)element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    public SqlExpressionList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/SqlProcedureParameterInfoHandler", "findElementForUpdatingParameterInfo"));
        }
        return SqlProcedureParameterInfoHandler.findExpressions((ParameterInfoContext)context);
    }

    public void updateParameterInfo(@NotNull SqlExpressionList element, @NotNull UpdateParameterInfoContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlProcedureParameterInfoHandler", "updateParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/SqlProcedureParameterInfoHandler", "updateParameterInfo"));
        }
        SqlFunctionCallExpression callExpression = (SqlFunctionCallExpression)element.getParent();
        SqlFunctionDefinition definition = (SqlFunctionDefinition)((Object)ObjectUtils.tryCast((Object)callExpression.getFunctionDefinition(), SqlFunctionDefinition.class));
        if (definition == null) {
            context.setCurrentParameter(ParameterInfoUtils.getCurrentParameterIndex((ASTNode)element.getNode(), (int)context.getOffset(), (IElementType)this.getActualParameterDelimiterType()));
        } else {
            int curOffset;
            ASTNode argList = element.getNode();
            int offset = context.getEditor().getCaretModel().getOffset();
            if (offset < (curOffset = argList.getTextRange().getStartOffset())) {
                context.setCurrentParameter(-1);
            } else {
                ASTNode[] children = argList.getChildren(null);
                boolean nonInfo = true;
                int index = 0;
                for (ASTNode child : children) {
                    if (offset < (curOffset += child.getTextLength())) break;
                    if (SqlInfoElementType.getValue(child) instanceof SqlFunctionDefinition.Parameter) {
                        if (nonInfo && offset != curOffset) {
                            ++index;
                        }
                        nonInfo = false;
                        continue;
                    }
                    nonInfo = true;
                }
                context.setCurrentParameter(index);
            }
        }
    }

    public String getParameterCloseChars() {
        return ",);";
    }

    public boolean tracksParameterIndex() {
        return true;
    }

    public void updateUI(SqlFunctionsUtil.ExpressionList proto, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/SqlProcedureParameterInfoHandler", "updateUI"));
        }
        PsiElement element = context.getParameterOwner();
        if (!element.isValid() || !proto.isValid()) {
            return;
        }
        boolean deprecated = false;
        StringBuilder sb = new StringBuilder();
        int[] highlight = new int[]{-1, -1};
        boolean applicable = proto.buildText(sb, context.getCurrentParameterIndex(), highlight);
        if (sb.length() == 0) {
            sb.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        }
        context.setupUIComponentPresentation(sb.toString(), highlight[0], highlight[1], !applicable, false, false, context.getDefaultParameterColor());
    }

    @NotNull
    public SqlExpression[] getActualParameters(@NotNull SqlExpressionList o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/SqlProcedureParameterInfoHandler", "getActualParameters"));
        }
        List list = o.getExpressionList();
        SqlExpression[] sqlExpressionArray = list.toArray(new SqlExpression[list.size()]);
        if (sqlExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlProcedureParameterInfoHandler", "getActualParameters"));
        }
        return sqlExpressionArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        SqlTokenType sqlTokenType = SqlTokens.SQL_COMMA;
        if (sqlTokenType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlProcedureParameterInfoHandler", "getActualParameterDelimiterType"));
        }
        return sqlTokenType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        SqlTokenType sqlTokenType = SqlTokens.SQL_RIGHT_PAREN;
        if (sqlTokenType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlProcedureParameterInfoHandler", "getActualParametersRBraceType"));
        }
        return sqlTokenType;
    }

    @NotNull
    public Set<Class> getArgumentListAllowedParentClasses() {
        Set<Class> set = ourAllowedParents;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlProcedureParameterInfoHandler", "getArgumentListAllowedParentClasses"));
        }
        return set;
    }

    @NotNull
    public Set<? extends Class> getArgListStopSearchClasses() {
        Set<? extends Class> set = ourStopSearch;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlProcedureParameterInfoHandler", "getArgListStopSearchClasses"));
        }
        return set;
    }

    @NotNull
    public Class<SqlExpressionList> getArgumentListClass() {
        if (SqlExpressionList.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlProcedureParameterInfoHandler", "getArgumentListClass"));
        }
        return SqlExpressionList.class;
    }

    @Nullable
    private static SqlExpressionList findExpressions(ParameterInfoContext context) {
        SqlExpressionList list;
        PsiFile file = context.getFile();
        if (!(file instanceof SqlFile)) {
            return null;
        }
        int offset = context.getOffset();
        PsiElement elementAt = file.findElementAt(offset - 1);
        while (elementAt != null && StringUtil.isEmptyOrSpaces((String)elementAt.getText())) {
            elementAt = PsiTreeUtil.prevVisibleLeaf((PsiElement)elementAt);
        }
        SqlFunctionCallExpression callExpression = (SqlFunctionCallExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, SqlFunctionCallExpression.class);
        SqlExpressionList sqlExpressionList = list = callExpression == null ? null : callExpression.getParameterList();
        if (list == null) {
            return null;
        }
        return SqlProcedureParameterInfoHandler.getExpandedTextRange((PsiElement)list).containsOffset(offset) ? list : null;
    }

    private static TextRange getExpandedTextRange(PsiElement element) {
        PsiElement end = (PsiElement)ObjectUtils.notNull((Object)PsiTreeUtil.nextVisibleLeaf((PsiElement)element), (Object)PsiTreeUtil.getDeepestLast((PsiElement)element.getContainingFile()));
        int endOffset = PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)end, (boolean)false) || StringUtil.isEmptyOrSpaces((String)end.getText()) ? end.getTextRange().getEndOffset() : end.getTextRange().getStartOffset();
        PsiElement start = (PsiElement)ObjectUtils.notNull((Object)PsiTreeUtil.prevVisibleLeaf((PsiElement)element), (Object)element);
        int startOffset = start == element ? element.getTextRange().getStartOffset() : start.getTextRange().getEndOffset();
        return TextRange.create((int)startOffset, (int)endOffset);
    }
}

