/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.ide.SelectInContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlDocumentationProvider;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nullable;

public class SqlSelectInDbView
implements NullableFunction<SelectInContext, DbElement> {
    @Nullable
    private static DbDataSource findDataSource(Project project, VirtualFile vFile) {
        for (DbDataSource element : DbPsiFacade.getInstance((Project)project).getDataSources()) {
            SqlDataSource sqlDataSource;
            if (!(element.getDelegate() instanceof SqlDataSource) || ContainerUtil.find((Iterable)(sqlDataSource = (SqlDataSource)element.getDelegate()).getFiles(), (Object)vFile) == null) continue;
            return element;
        }
        return null;
    }

    public DbElement fun(SelectInContext context) {
        Object o = context.getSelectorInFile();
        if (o instanceof PsiElement) {
            DbElement result2;
            SqlReferenceExpression ref = (SqlReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)o), SqlReferenceExpression.class, (boolean)false);
            if (ref != null && (result2 = (DbElement)SqlDocumentationProvider.findRelatedViewElements((PsiReference)ref.getReference(), null).first()) != null) {
                return result2;
            }
            SqlDefinition definition = (SqlDefinition)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)o), SqlDefinition.class, (boolean)false);
            while (definition != null) {
                DbElement result3 = (DbElement)SqlDocumentationProvider.findRelatedViewElements(null, definition).first();
                if (result3 != null) {
                    return result3;
                }
                definition = (SqlDefinition)PsiTreeUtil.getParentOfType((PsiElement)definition, SqlDefinition.class, (boolean)true);
            }
        }
        return SqlSelectInDbView.findDataSource(context.getProject(), context.getVirtualFile());
    }
}

