/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.ui.ErrorNotificationPanel;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.view.ui.DbCheckBoxTree;
import com.intellij.database.view.ui.FilteringTree;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.database.SqlDataSourceImpl;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlResolveTree;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.TreePatternUtils;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.ui.treeStructure.actions.ExpandAllAction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlResolveEditor {
    private static final Key<SqlResolveEditor> EDITOR_KEY = Key.create((String)"SqlResolveEditor");
    private final Project myProject;
    private final MyTree myTree;
    private final JComponent myPanel;
    protected final Map<DatabaseSystem, DasModel> myModels;
    protected TreePattern mySelectedScope;
    protected TreePattern myPermStructure;

    public SqlResolveEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/dialects/SqlResolveEditor", "<init>"));
        }
        this.myModels = ContainerUtil.newConcurrentMap();
        this.mySelectedScope = TreePattern.EMPTY;
        this.myPermStructure = TreePattern.EMPTY;
        this.myProject = project;
        for (DbDataSource dataSource : DbPsiFacade.getInstance((Project)project).getDataSources()) {
            DatabaseSystem delegate = dataSource.getDelegate();
            if (delegate instanceof LocalDataSource) {
                this.myModels.put(delegate, delegate.getModel());
                continue;
            }
            this.myModels.put(delegate, dataSource.getModel());
        }
        this.myTree = new MyTree(this, project, new SqlResolveTree.MyNode(null, ObjectKind.NONE, null){

            @Override
            public ObjectKind getChildKind() {
                return SqlImportUtil.DATA_SOURCE;
            }
        });
        UIUtil.putClientProperty((JComponent)this.getTree(), EDITOR_KEY, (Object)this);
        this.myPanel = new JPanel(new BorderLayout());
        JComponent northPanel = this.createNorthPanel();
        northPanel.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)1, (int)0));
        this.myPanel.add((Component)northPanel, "North");
        this.myPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree.getComponent(), (boolean)true), "Center");
    }

    @NotNull
    protected JComponent createNorthPanel() {
        this.myTree.installSimple();
        JPanel res = new JPanel(new BorderLayout());
        ActionToolbar actionsToolbar = ActionManager.getInstance().createActionToolbar("SqlResolveEditor", (ActionGroup)this.getTreeActions(), true);
        actionsToolbar.setTargetComponent((JComponent)this.getTree());
        res.add((Component)actionsToolbar.getComponent(), "East");
        JPanel jPanel = res;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlResolveEditor", "createNorthPanel"));
        }
        return jPanel;
    }

    public void setPatterns(@Nullable TreePattern selection, @Nullable TreePattern structure) {
        boolean structChanged;
        boolean permStructChanged;
        if (selection == null && structure == null) {
            return;
        }
        boolean selChanged = selection != null && !selection.equals(this.mySelectedScope);
        if (selChanged) {
            this.mySelectedScope = selection;
        }
        if (permStructChanged = structure != null && !structure.equals(this.myPermStructure)) {
            this.myPermStructure = structure;
        }
        boolean bl = structChanged = permStructChanged || selChanged;
        if (selChanged) {
            this.myTree.recheck(this.mySelectedScope);
        }
        DbUIUtil.invokeLater(() -> {
            if (structChanged) {
                TreePattern tempStructure = TreePatternUtils.union(this.myPermStructure, this.mySelectedScope);
                if (permStructChanged || tempStructure != this.myPermStructure) {
                    this.myTree.createShadowStructure((SqlResolveTree.MyNode)this.myTree.getSearchModel().getRootObject(), tempStructure);
                    this.myTree.getSearchModel().updateStructure();
                }
            }
            this.myTree.recheck(this.mySelectedScope);
            this.onSetPatternReady();
        });
    }

    protected void onSetPatternReady() {
    }

    @NotNull
    protected Map<String, MultiMap<String, String>> getEditorState() {
        SqlResolveTree.MyNode root2 = (SqlResolveTree.MyNode)this.myTree.getSearchModel().getRootObject();
        LinkedHashMap res = ContainerUtil.newLinkedHashMap();
        for (SqlResolveTree.MyNode node : root2.getChildNodes()) {
            String name = SqlResolveEditor.getNodeName(node);
            if (name == null || !node.isChecked()) continue;
            res.put(name, this.getEditorState(node));
        }
        LinkedHashMap linkedHashMap = res;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlResolveEditor", "getEditorState"));
        }
        return linkedHashMap;
    }

    @NotNull
    protected MultiMap<String, String> getEditorState(@NotNull SqlResolveTree.MyNode root2) {
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/sql/dialects/SqlResolveEditor", "getEditorState"));
        }
        MultiMap state = MultiMap.createLinkedSet();
        if (root2.getChildKind() == ObjectKind.SCHEMA) {
            Collection schemas = state.getModifiable((Object)"*");
            SqlResolveEditor.getNodeNames(root2.getChildNodes()).addAllTo(schemas);
        } else {
            for (SqlResolveTree.MyNode node : root2.getChildNodes()) {
                String name = SqlResolveEditor.getNodeName(node);
                if (name == null || !node.isChecked()) continue;
                SqlResolveEditor.getNodeNames(node.getChildNodes()).addAllTo(state.getModifiable((Object)name));
            }
        }
        MultiMap multiMap = state;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlResolveEditor", "getEditorState"));
        }
        return multiMap;
    }

    public boolean hasSpeedSearchActive() {
        return SpeedSearchSupply.getSupply((JComponent)this.getTree()) != null;
    }

    @NotNull
    private static JBIterable<String> getNodeNames(Iterable<SqlResolveTree.MyNode> nodes2) {
        JBIterable jBIterable = JBIterable.from(nodes2).filter(DbCheckBoxTree.MyNode::isChecked).transform(n -> SqlResolveEditor.getNodeName(n)).filter(Conditions.notNull());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlResolveEditor", "getNodeNames"));
        }
        return jBIterable;
    }

    @Nullable
    protected static String getNodeName(SqlResolveTree.MyNode n) {
        if (n.getObject() == "*") {
            return "*";
        }
        if (n.getObject() instanceof DatabaseSystem) {
            return ((DatabaseSystem)n.getObject()).getUniqueId();
        }
        return n.getName();
    }

    protected SqlResolveTree.MyNode getRoot() {
        return (SqlResolveTree.MyNode)this.myTree.getSearchModel().getRootObject();
    }

    private static boolean canReintrospect(@NotNull List<LocalDataSource> dataSources) {
        if (dataSources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "com/intellij/sql/dialects/SqlResolveEditor", "canReintrospect"));
        }
        for (LocalDataSource dataSource : dataSources) {
            if (!SqlResolveEditor.canReintrospect(dataSource)) continue;
            return true;
        }
        return false;
    }

    private static boolean canReintrospect(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/sql/dialects/SqlResolveEditor", "canReintrospect"));
        }
        return DbImplUtil.canConnectTo(dataSource) && DataSourceSyncManager.getInstance().isAbleToPerform(dataSource);
    }

    public void reintrospect(@NotNull MultiMap<LocalDataSource, DasObject> objects) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/sql/dialects/SqlResolveEditor", "reintrospect"));
        }
        while (objects.size() != 0) {
            CompletionStage<DataSourceSyncManager.SyncResult> promise;
            LocalDataSource dataSource = (LocalDataSource)ContainerUtil.getFirstItem((Collection)objects.keySet());
            Collection namespaces = objects.remove((Object)dataSource);
            if (dataSource == null || !SqlResolveEditor.canReintrospect(dataSource)) continue;
            LoaderContext context = new LoaderContext(this.myProject, dataSource).setNamespacesOnly(true);
            if (namespaces != null) {
                context.getSelection().addAll(namespaces);
            }
            if ((promise = DataSourceSyncManager.getInstance().tryPerform(context, false)) == null) continue;
            promise.whenCompleteAsync((res, e) -> {
                if (objects == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/sql/dialects/SqlResolveEditor", "lambda$reintrospect$2"));
                }
                AsyncUtil.addUnhandledError(context.getErrorHandler(), e, context.getDataSource().getName(), DbImplUtil.getDatabaseDialect(context.getDataSource()).getFamilyId());
                this.handleIntrospectionError(StringUtil.nullize((String)context.getErrorHandler().getSummary()));
                if (res != null) {
                    this.myModels.put((DatabaseSystem)dataSource, dataSource.getModel());
                    this.myTree.update();
                }
                if (e == null) {
                    this.reintrospect(objects);
                }
            }, AsyncUtil.EDT_EXECUTOR);
            break;
        }
    }

    protected void handleIntrospectionError(@Nullable String msg) {
        Component component = ((BorderLayout)this.myPanel.getLayout()).getLayoutComponent("South");
        if (component != null) {
            this.myPanel.remove(component);
        }
        if (msg != null) {
            ErrorNotificationPanel panel = ErrorNotificationPanel.create(msg, null, this.myPanel).addDetailsButton().addCloseButton(() -> this.handleIntrospectionError(null)).build();
            this.myPanel.add((Component)panel, "South");
        }
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    private static boolean isSingleRoot(@NotNull DatabaseSystem dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/sql/dialects/SqlResolveEditor", "isSingleRoot"));
        }
        DatabaseFamilyId familyId = SqlResolveEditor.getDatabaseDialect(dataSource).getFamilyId();
        return familyId.isPostgres() || familyId.isH2() || familyId.isHsqldb();
    }

    @NotNull
    private static DatabaseDialectEx getDatabaseDialect(@NotNull DatabaseSystem dataSource) {
        RawConnectionConfig config;
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/sql/dialects/SqlResolveEditor", "getDatabaseDialect"));
        }
        DatabaseDialectEx dialect = dataSource instanceof SqlDataSourceImpl ? ((SqlDataSourceImpl)dataSource).getDatabaseDialect() : ((config = dataSource.getConnectionConfig()) == null ? null : DbImplUtil.getDatabaseDialect(config));
        DatabaseDialectEx databaseDialectEx = dialect == null ? GenericDialect.INSTANCE : dialect;
        if (databaseDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlResolveEditor", "getDatabaseDialect"));
        }
        return databaseDialectEx;
    }

    protected boolean isSchemaRoot(@NotNull DatabaseSystem dataSource, @Nullable DasModel tempModel) {
        DasObject rootNamespace;
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/sql/dialects/SqlResolveEditor", "isSchemaRoot"));
        }
        DasObject dasObject = rootNamespace = tempModel == null ? null : (DasObject)tempModel.getModelRoots().first();
        return rootNamespace == null ? SqlResolveEditor.getDatabaseDialect(dataSource).getMetaModel().getRootNamespaceKinds().contains((Object)ObjectKind.SCHEMA) : rootNamespace.getKind() == ObjectKind.SCHEMA;
    }

    @NotNull
    public Tree getTree() {
        SqlResolveTree sqlResolveTree = this.myTree.getTree();
        if (sqlResolveTree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlResolveEditor", "getTree"));
        }
        return sqlResolveTree;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlResolveEditor", "getComponent"));
        }
        return jComponent;
    }

    @NotNull
    private DefaultActionGroup getTreeActions() {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(new AnAction[]{new RefreshAction(), new ExpandAllAction((JTree)this.getTree()), new CollapseAllAction((JTree)this.getTree())});
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlResolveEditor", "getTreeActions"));
        }
        return defaultActionGroup;
    }

    @Nullable
    private static DatabaseSystem getDatabaseSystem(@Nullable SqlResolveTree.MyNode n) {
        return n == null ? null : (DatabaseSystem)JBIterable.generate((Object)n, x -> (SqlResolveTree.MyNode)x.getParent()).transform(x -> x.getObject()).filter(DatabaseSystem.class).first();
    }

    @Nullable
    public Boolean isSchemaRoot(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/sql/dialects/SqlResolveEditor", "isSchemaRoot"));
        }
        for (Map.Entry<DatabaseSystem, DasModel> e : this.myModels.entrySet()) {
            if (!id.equals(e.getKey().getUniqueId())) continue;
            return this.isSchemaRoot(e.getKey(), e.getValue());
        }
        return null;
    }

    @NotNull
    public TreePattern getPattern(@NotNull Map<String, MultiMap<String, String>> state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/dialects/SqlResolveEditor", "getPattern"));
        }
        if (state.containsKey("*")) {
            TreePattern treePattern = new TreePattern(TreePatternUtils.create((ObjectName)null, SqlImportUtil.DATA_SOURCE, TreePatternNode.NO_GROUPS));
            if (treePattern == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlResolveEditor", "getPattern"));
            }
            return treePattern;
        }
        ArrayList dsGroups = ContainerUtil.newArrayList();
        for (Map.Entry<String, MultiMap<String, String>> entry : state.entrySet()) {
            String id = entry.getKey();
            Boolean schema = this.isSchemaRoot(id);
            if (schema == null) continue;
            TreePatternNode.Group g = SqlImportUtil.getRootGroup(schema, entry.getValue(), false);
            dsGroups.add(TreePatternUtils.create(ObjectName.quoted((String)id), SqlImportUtil.DATA_SOURCE, SqlImportUtil.optAr(g)));
        }
        TreePattern treePattern = TreePatternUtils.sorted(new TreePattern(TreePatternUtils.UNION_PROCESSOR.mergeGroups(SqlImportUtil.DATA_SOURCE, dsGroups)));
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlResolveEditor", "getPattern"));
        }
        return treePattern;
    }

    private class MyTree
    extends FilteringTree<CheckedTreeNode, SqlResolveTree.MyNode> {
        final /* synthetic */ SqlResolveEditor this$0;

        public MyTree(@NotNull SqlResolveEditor sqlResolveEditor, Project project, SqlResolveTree.MyNode root2) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/dialects/SqlResolveEditor$MyTree", "<init>"));
            }
            this(sqlResolveEditor, project, SqlResolveTree.createNode(root2));
        }

        private MyTree(@NotNull SqlResolveEditor sqlResolveEditor, Project project, CheckedTreeNode root2) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/dialects/SqlResolveEditor$MyTree", "<init>"));
            }
            this.this$0 = sqlResolveEditor;
            super(project, (Tree)new SqlResolveTree(root2), root2);
        }

        @Override
        protected Class<? extends CheckedTreeNode> getNodeClass() {
            return CheckedTreeNode.class;
        }

        @Override
        @NotNull
        protected CheckedTreeNode createNode(@Nullable SqlResolveTree.MyNode obj) {
            CheckedTreeNode checkedTreeNode = SqlResolveTree.createNode(obj);
            if (checkedTreeNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlResolveEditor$MyTree", "createNode"));
            }
            return checkedTreeNode;
        }

        @Override
        @NotNull
        protected Iterable<SqlResolveTree.MyNode> getChildren(@NotNull SqlResolveTree.MyNode obj) {
            if (obj == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/sql/dialects/SqlResolveEditor$MyTree", "getChildren"));
            }
            JBIterable jBIterable = obj.getChildNodes();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlResolveEditor$MyTree", "getChildren"));
            }
            return jBIterable;
        }

        @Override
        @Nullable
        protected String getText(@Nullable SqlResolveTree.MyNode object) {
            return object == null ? null : object.getName();
        }

        @NotNull
        public SqlResolveTree getTree() {
            SqlResolveTree sqlResolveTree = (SqlResolveTree)super.getTree();
            if (sqlResolveTree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlResolveEditor$MyTree", "getTree"));
            }
            return sqlResolveTree;
        }

        @Override
        protected void rebuildTree() {
            SqlResolveTree.MyNode root2 = (SqlResolveTree.MyNode)this.getSearchModel().getRootObject();
            root2.setHasAll(true);
            Map<String, SqlResolveTree.MyNode> cache = this.fillNodesCache(root2.getChildren(), root2.getChildKind());
            ArrayList dataSources = ContainerUtil.newArrayList();
            List sorted = ContainerUtil.sorted(this.this$0.myModels.entrySet(), (a, b) -> StringUtil.naturalCompare((String)((DatabaseSystem)a.getKey()).getName(), (String)((DatabaseSystem)b.getKey()).getName()));
            for (Map.Entry entry : sorted) {
                final DatabaseSystem ds = (DatabaseSystem)entry.getKey();
                DasModel model = (DasModel)entry.getValue();
                SqlResolveTree.MyNode node = cache.get(ds.getUniqueId());
                if (node == null) {
                    node = new SqlResolveTree.MyNode(ds.getName(), SqlImportUtil.DATA_SOURCE, ds){

                        @Override
                        @Nullable
                        public ObjectKind getChildKind() {
                            return MyTree.this.this$0.isSchemaRoot(ds, MyTree.this.this$0.myModels.get(ds)) ? ObjectKind.SCHEMA : ObjectKind.DATABASE;
                        }
                    };
                }
                dataSources.add(node);
                this.addNodes(node, this.sorted((Iterable<DasNamespace>)model.getModelRoots().filter(DasNamespace.class)), !SqlResolveEditor.isSingleRoot(ds));
            }
            root2.setChildren(dataSources);
            root2.setShadowChildren(null);
            this.createShadowStructure(root2, TreePatternUtils.union(this.this$0.myPermStructure, this.this$0.mySelectedScope));
            this.getSearchModel().updateStructure();
        }

        private void addNodes(@NotNull SqlResolveTree.MyNode p, @NotNull Iterable<DasNamespace> objects, boolean hasAll) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/sql/dialects/SqlResolveEditor$MyTree", "addNodes"));
            }
            if (objects == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/sql/dialects/SqlResolveEditor$MyTree", "addNodes"));
            }
            ObjectKind childKind = p.getChildKind();
            Map<String, SqlResolveTree.MyNode> oldCache = this.fillNodesCache((Iterable<SqlResolveTree.MyNode>)p.getChildNodes(), childKind);
            ArrayList children = ContainerUtil.newArrayList();
            for (DasObject dasObject : objects) {
                if (StringUtil.isEmpty((String)dasObject.getName())) continue;
                SqlResolveTree.MyNode node = oldCache.remove(dasObject.getName());
                if (node != null) {
                    node.setObject(dasObject);
                } else {
                    node = new SqlResolveTree.MyNode(dasObject.getName(), dasObject.getKind(), dasObject);
                }
                children.add(node);
                if (dasObject.getKind() == ObjectKind.SCHEMA) continue;
                this.addNodes(node, this.sorted((Iterable<DasNamespace>)dasObject.getDbChildren(DasNamespace.class, ObjectKind.NONE)), true);
            }
            oldCache.values().forEach(o -> o.setObject(o.getName()));
            p.setHasAll(hasAll);
            p.setChildren(children);
            p.setShadowChildren(oldCache.values());
        }

        private Iterable<DasNamespace> sorted(Iterable<DasNamespace> children) {
            ArrayList namespaces = ContainerUtil.newArrayList(children);
            Collections.sort(namespaces, (n1, n2) -> StringUtil.naturalCompare((String)n1.getName(), (String)n2.getName()));
            return namespaces;
        }

        private void createShadowStructure(@NotNull SqlResolveTree.MyNode root2, @NotNull TreePattern pattern) {
            if (root2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/sql/dialects/SqlResolveEditor$MyTree", "createShadowStructure"));
            }
            if (pattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/sql/dialects/SqlResolveEditor$MyTree", "createShadowStructure"));
            }
            TreePatternNode.Group group2 = pattern.root.getGroup(SqlImportUtil.DATA_SOURCE);
            if (group2 == null) {
                root2.purgeShadow();
                return;
            }
            this.fillShadowChildren(root2, group2);
        }

        private void fillShadowChildren(@NotNull SqlResolveTree.MyNode root2, TreePatternNode.Group group2) {
            if (root2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/sql/dialects/SqlResolveEditor$MyTree", "fillShadowChildren"));
            }
            List nodes2 = ContainerUtil.newSmartList();
            for (SqlResolveTree.MyNode node : root2.getChildNodes()) {
                nodes2.clear();
                if (group2.matchedChildren(ObjectName.quoted((String)SqlResolveEditor.getNodeName(node)), Casing.EXACT, nodes2)) {
                    this.fillShadowObjects(node, ((TreePatternNode)nodes2.get(0)).getGroup(node.getChildKind()));
                    continue;
                }
                node.purgeShadow();
            }
        }

        private void fillShadowObjects(@NotNull SqlResolveTree.MyNode p, @Nullable TreePatternNode.Group group2) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/sql/dialects/SqlResolveEditor$MyTree", "fillShadowObjects"));
            }
            if (group2 == null) {
                p.purgeShadow();
                return;
            }
            ArrayList dbShadow = ContainerUtil.newArrayList();
            Map<String, SqlResolveTree.MyNode> schemaObjects = this.fillNodesCache(p.getChildren(), p.getChildKind());
            Map<String, SqlResolveTree.MyNode> oldSchemasCache = this.fillNodesCache(p.getShadowChildren(), p.getChildKind());
            for (ObjectName n2 : JBIterable.of((Object[])group2.positiveChildren).append(group2.negativeChild).flatten(n -> JBIterable.of((Object[])((TreePatternNode.BaseNaming)n.naming).names))) {
                if (schemaObjects.containsKey(n2.name)) continue;
                SqlResolveTree.MyNode schema = oldSchemasCache.get(n2.name);
                if (schema == null) {
                    schema = new SqlResolveTree.MyNode(n2.name, group2.kind, n2.name);
                    schemaObjects.put(n2.name, schema);
                }
                dbShadow.add(schema);
            }
            p.setShadowChildren(dbShadow);
            this.fillShadowChildren(p, group2);
        }

        private Map<String, SqlResolveTree.MyNode> fillNodesCache(Iterable<SqlResolveTree.MyNode> children, ObjectKind childKind) {
            HashMap oldCache = ContainerUtil.newHashMap();
            for (SqlResolveTree.MyNode node : children) {
                if (node.getKind() != childKind || node.getObject() == "*") continue;
                oldCache.put(SqlResolveEditor.getNodeName(node), node);
            }
            return oldCache;
        }

        private void recheck(@NotNull TreePattern pattern) {
            if (pattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/sql/dialects/SqlResolveEditor$MyTree", "recheck"));
            }
            FilteringTree.SearchTreeModel model = this.this$0.myTree.getSearchModel();
            SqlResolveTree.MyNode root2 = (SqlResolveTree.MyNode)model.getRootObject();
            ObjectKind childKind = root2.getChildKind();
            root2.setChecked(true);
            this.recheck(root2, childKind == null ? null : pattern.root.getGroup(childKind));
            this.getTree().updateFromNodes();
        }

        private void recheck(@NotNull SqlResolveTree.MyNode node, @Nullable TreePatternNode.Group group2) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/dialects/SqlResolveEditor$MyTree", "recheck"));
            }
            List nodes2 = ContainerUtil.newSmartList();
            SqlResolveTree.MyNode allNode = (SqlResolveTree.MyNode)node.getAllNode();
            if (allNode != null) {
                allNode.setChecked(group2 != null && group2.negativeChild != null);
            }
            for (SqlResolveTree.MyNode child : node.getSimpleChildNodes()) {
                nodes2.clear();
                if (group2 != null && node.getAllNodeState() != ThreeState.YES && group2.matchedChildren(ObjectName.quoted((String)SqlResolveEditor.getNodeName(child)), Casing.EXACT, nodes2)) {
                    child.setChecked(true);
                    ObjectKind childKind = child.getChildKind();
                    this.recheck(child, childKind == null ? null : ((TreePatternNode)nodes2.get(0)).getGroup(childKind));
                    continue;
                }
                child.setChecked(false);
                this.recheck(child, null);
            }
        }
    }

    private static class RefreshAction
    extends DumbAwareAction {
        public RefreshAction() {
            super("Refresh", "Refresh schemas list", AllIcons.Actions.Refresh);
        }

        public void update(AnActionEvent e) {
            SqlResolveEditor editor = (SqlResolveEditor)UIUtil.getClientProperty((Object)((Object)DbCheckBoxTree.getTree(e.getDataContext(), SqlResolveTree.class)), (Key)EDITOR_KEY);
            boolean enabled = false;
            if (editor != null) {
                List dataSources = JBIterable.of((Object[])editor.getTree().getSelectedNodes(CheckedTreeNode.class, null)).transform(n -> SqlResolveEditor.getDatabaseSystem((SqlResolveTree.MyNode)editor.myTree.getUserObject((TreeNode)n))).filter(LocalDataSource.class).unique().toList();
                enabled = !dataSources.isEmpty() && SqlResolveEditor.canReintrospect(dataSources);
            }
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setDescription("Refresh schemas list" + (enabled ? "" : " (already running)"));
        }

        public void actionPerformed(AnActionEvent e) {
            SqlResolveEditor editor = (SqlResolveEditor)UIUtil.getClientProperty((Object)((Object)DbCheckBoxTree.getTree(e.getDataContext(), SqlResolveTree.class)), (Key)EDITOR_KEY);
            if (editor != null) {
                MultiMap objects = MultiMap.createLinked();
                JBIterable nodes2 = JBIterable.of((Object[])editor.getTree().getSelectedNodes(CheckedTreeNode.class, null)).transform(n -> (SqlResolveTree.MyNode)editor.myTree.getUserObject((TreeNode)n)).filter(Conditions.notNull());
                for (SqlResolveTree.MyNode node : nodes2) {
                    LocalDataSource ds = (LocalDataSource)ObjectUtils.tryCast((Object)SqlResolveEditor.getDatabaseSystem(node), LocalDataSource.class);
                    if (ds == null) continue;
                    ContainerUtil.addIfNotNull((Collection)objects.getModifiable((Object)ds), (Object)ObjectUtils.tryCast((Object)node.getObject(), DasObject.class));
                }
                editor.reintrospect((MultiMap<LocalDataSource, DasObject>)objects);
            }
        }
    }
}

